/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import com.nexacro.xeni.extend.XeniDateUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class XeniDataFormatter {
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern localePatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private static final String invalidDateTimeString;
    private final DecimalFormatSymbols decimalSymbols;
    private final DateFormatSymbols dateSymbols;
    private final Format generalWholeNumFormat;
    private final Format generalDecimalNumFormat;
    private final Format xeniDecimalNumFormat;
    private Format defaultNumFormat;
    private final Map<String, Format> formats;
    private boolean emulateCsv = false;

    public XeniDataFormatter() {
        this(false);
    }

    public XeniDataFormatter(boolean bl) {
        this(Locale.getDefault());
        this.emulateCsv = bl;
    }

    public XeniDataFormatter(Locale locale, boolean bl) {
        this(locale);
        this.emulateCsv = bl;
    }

    public XeniDataFormatter(Locale locale) {
        this.dateSymbols = new DateFormatSymbols(locale);
        this.decimalSymbols = new DecimalFormatSymbols(locale);
        this.generalWholeNumFormat = new DecimalFormat("#", this.decimalSymbols);
        this.generalDecimalNumFormat = new DecimalFormat("#.##########", this.decimalSymbols);
        this.xeniDecimalNumFormat = new DecimalFormat("#.######################", this.decimalSymbols);
        this.formats = new HashMap<String, Format>();
        Format format = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", format);
        this.addFormat("00000-0000", format);
        Format format2 = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", format2);
        this.addFormat("[<=9999999]###-####;(###) ###-####", format2);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", format2);
        this.addFormat("###-####;(###) ###-####", format2);
        Format format3 = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", format3);
        this.addFormat("000-00-0000", format3);
    }

    private Format getFormat(Cell cell) {
        if (cell.getCellStyle() == null) {
            return null;
        }
        short s = cell.getCellStyle().getDataFormat();
        String string = cell.getCellStyle().getDataFormatString();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return this.getFormat(cell.getNumericCellValue(), s, string);
    }

    private Format getFormat(double d, int n, String string) {
        Format format;
        String string2 = string;
        int n2 = string2.indexOf(59);
        int n3 = string2.lastIndexOf(59);
        if (n2 != -1 && n2 != n3) {
            int n4 = string2.indexOf(59, n2 + 1);
            string2 = n4 == n3 ? (d == 0.0 ? string2.substring(n3 + 1) : string2.substring(0, n3)) : (d == 0.0 ? string2.substring(n4 + 1, n3) : string2.substring(0, n4));
        }
        if (this.emulateCsv && d == 0.0 && string2.contains("#") && !string2.contains("0")) {
            string2 = string2.replaceAll("#", "");
        }
        if ((format = this.formats.get(string2)) != null) {
            return format;
        }
        if ("General".equalsIgnoreCase(string2) || "@".equals(string2)) {
            if (XeniDataFormatter.isWholeNumber(d)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        format = this.createFormat(d, n, string2);
        this.formats.put(string2, format);
        return format;
    }

    public Format createFormat(Cell cell) {
        short s = cell.getCellStyle().getDataFormat();
        String string = cell.getCellStyle().getDataFormatString();
        return this.createFormat(cell.getNumericCellValue(), s, string);
    }

    private Format createFormat(double d, int n, String string) {
        String string2;
        Object object;
        int n2;
        String string3 = string;
        Matcher matcher = colorPattern.matcher(string3);
        while (matcher.find() && (n2 = string3.indexOf((String)(object = matcher.group()))) != -1 && !(string2 = string3.substring(0, n2) + string3.substring(n2 + ((String)object).length())).equals(string3)) {
            string3 = string2;
            matcher = colorPattern.matcher(string3);
        }
        object = localePatternGroup.matcher(string3);
        while (((Matcher)object).find()) {
            String string4 = ((Matcher)object).group();
            string2 = string4.substring(string4.indexOf(36) + 1, string4.indexOf(45));
            if (string2.indexOf(36) > -1) {
                String[] stringArray = new StringBuffer();
                stringArray.append(string2.substring(0, string2.indexOf(36)));
                stringArray.append('\\');
                stringArray.append(string2.substring(string2.indexOf(36), string2.length()));
                string2 = stringArray.toString();
            }
            string3 = ((Matcher)object).replaceAll(string2);
            object = localePatternGroup.matcher(string3);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return this.getDefaultFormat(d);
        }
        if ("General".equalsIgnoreCase(string3) || "@".equals(string3)) {
            if (XeniDataFormatter.isWholeNumber(d)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        if (XeniDateUtil.isADateFormat(n, string3) && XeniDateUtil.isValidExcelDate(d)) {
            return this.createDateFormat(string3, d);
        }
        if (string3.indexOf("#/#") >= 0 || string3.indexOf("?/?") >= 0) {
            String string5 = string3.replaceAll("\\\\ ", " ").replaceAll("\\\\.", "").replaceAll("\"[^\"]*\"", " ");
            boolean bl = true;
            for (String string6 : string5.split(";")) {
                int n3 = this.indexOfFraction(string6);
                if (n3 != -1 && n3 == this.lastIndexOfFraction(string6)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return new FractionFormat(string5);
            }
        }
        if (numPattern.matcher(string3).find()) {
            return this.createNumberFormat(string3, d);
        }
        if (this.emulateCsv) {
            return new ConstantStringFormat(this.cleanFormatForNumber(string3));
        }
        return null;
    }

    private int indexOfFraction(String string) {
        int n = string.indexOf("#/#");
        int n2 = string.indexOf("?/?");
        return n == -1 ? n2 : (n2 == -1 ? n : Math.min(n, n2));
    }

    private int lastIndexOfFraction(String string) {
        int n = string.lastIndexOf("#/#");
        int n2 = string.lastIndexOf("?/?");
        return n == -1 ? n2 : (n2 == -1 ? n : Math.max(n, n2));
    }

    private Format createDateFormat(String string, double d) {
        CharSequence charSequence;
        String string2 = string;
        string2 = string2.replaceAll("\\\\-", "-");
        string2 = string2.replaceAll("\\\\,", ",");
        string2 = string2.replaceAll("\\\\\\.", ".");
        string2 = string2.replaceAll("\\\\ ", " ");
        string2 = string2.replaceAll("\\\\/", "/");
        string2 = string2.replaceAll(";@", "");
        string2 = string2.replaceAll("\"/\"", "/");
        boolean bl = false;
        Matcher matcher = amPmPattern.matcher(string2);
        while (matcher.find()) {
            string2 = matcher.replaceAll("@");
            bl = true;
            matcher = amPmPattern.matcher(string2);
        }
        Matcher matcher2 = daysAsText.matcher(string2 = string2.replaceAll("@", "a"));
        if (matcher2.find()) {
            charSequence = matcher2.group(0);
            string2 = matcher2.replaceAll(((String)charSequence).toUpperCase().replaceAll("D", "E"));
        }
        charSequence = new StringBuffer();
        char[] cArray = string2.toCharArray();
        boolean bl2 = true;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl3 = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '[' && !bl3) {
                bl3 = true;
                bl2 = false;
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (c == ']' && bl3) {
                bl3 = false;
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (bl3) {
                if (c == 'h' || c == 'H') {
                    ((StringBuffer)charSequence).append('H');
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    ((StringBuffer)charSequence).append('m');
                    continue;
                }
                if (c == 's' || c == 'S') {
                    ((StringBuffer)charSequence).append('s');
                    continue;
                }
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            if (c == 'h' || c == 'H') {
                bl2 = false;
                if (bl) {
                    ((StringBuffer)charSequence).append('h');
                    continue;
                }
                ((StringBuffer)charSequence).append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (bl2) {
                    ((StringBuffer)charSequence).append('M');
                    arrayList.add(((StringBuffer)charSequence).length() - 1);
                    continue;
                }
                ((StringBuffer)charSequence).append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                ((StringBuffer)charSequence).append('s');
                for (int j = 0; j < arrayList.size(); ++j) {
                    int n = (Integer)arrayList.get(j);
                    if (((StringBuffer)charSequence).charAt(n) != 'M') continue;
                    ((StringBuffer)charSequence).replace(n, n + 1, "m");
                }
                bl2 = true;
                arrayList.clear();
                continue;
            }
            if (Character.isLetter(c)) {
                bl2 = true;
                arrayList.clear();
                if (c == 'y' || c == 'Y') {
                    ((StringBuffer)charSequence).append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    ((StringBuffer)charSequence).append('d');
                    continue;
                }
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            ((StringBuffer)charSequence).append(c);
        }
        string2 = ((StringBuffer)charSequence).toString();
        try {
            return new ExcelStyleDateFormatter(string2, this.dateSymbols);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(d);
        }
    }

    private String cleanFormatForNumber(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.emulateCsv) {
            for (n = 0; n < stringBuffer.length(); ++n) {
                c = stringBuffer.charAt(n);
                if (c != '_' && c != '*' && c != '?' || n > 0 && stringBuffer.charAt(n - 1) == '\\') continue;
                if (c == '?') {
                    stringBuffer.setCharAt(n, ' ');
                    continue;
                }
                if (n >= stringBuffer.length() - 1) continue;
                if (c == '_') {
                    stringBuffer.setCharAt(n + 1, ' ');
                } else {
                    stringBuffer.deleteCharAt(n + 1);
                }
                stringBuffer.deleteCharAt(n);
            }
        } else {
            for (n = 0; n < stringBuffer.length(); ++n) {
                c = stringBuffer.charAt(n);
                if (c != '_' && c != '*' || n > 0 && stringBuffer.charAt(n - 1) == '\\') continue;
                if (n < stringBuffer.length() - 1) {
                    stringBuffer.deleteCharAt(n + 1);
                }
                stringBuffer.deleteCharAt(n);
            }
        }
        for (n = 0; n < stringBuffer.length(); ++n) {
            c = stringBuffer.charAt(n);
            if (c == '\\' || c == '\"') {
                stringBuffer.deleteCharAt(n);
                --n;
                continue;
            }
            if (c != '+' || n <= 0 || stringBuffer.charAt(n - 1) != 'E') continue;
            stringBuffer.deleteCharAt(n);
            --n;
        }
        return stringBuffer.toString();
    }

    private Format createNumberFormat(String string, double d) {
        String string2 = this.cleanFormatForNumber(string);
        try {
            DecimalFormat decimalFormat = new DecimalFormat(string2, this.decimalSymbols);
            XeniDataFormatter.setExcelStyleRoundingMode(decimalFormat);
            return decimalFormat;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(d);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    public Format getDefaultFormat(Cell cell) {
        return this.getDefaultFormat(cell.getNumericCellValue());
    }

    private Format getDefaultFormat(double d) {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (XeniDataFormatter.isWholeNumber(d)) {
            return this.generalWholeNumFormat;
        }
        return this.generalDecimalNumFormat;
    }

    private String performDateFormatting(Date date, Format format) {
        if (format != null) {
            return format.format(date);
        }
        return date.toString();
    }

    private String getFormattedDateString(Cell cell) {
        Format format = this.getFormat(cell);
        if (format instanceof ExcelStyleDateFormatter) {
            ((ExcelStyleDateFormatter)format).setDateToBeFormatted(cell.getNumericCellValue());
        }
        Date date = cell.getDateCellValue();
        return this.performDateFormatting(date, format);
    }

    private String getFormattedNumberString(Cell cell) {
        Format format = this.getFormat(cell);
        double d = cell.getNumericCellValue();
        if (format == null) {
            return String.valueOf(d);
        }
        return format.format(new Double(d));
    }

    public String formatRawCellContents(double d, int n, String string) {
        return this.formatRawCellContents(d, n, string, false, false, true);
    }

    public String formatRawCellContents(double d, int n, String string, boolean bl, boolean bl2, boolean bl3) {
        if (XeniDateUtil.isADateFormat(n, string = this.getCustomFormatString(n, string))) {
            if (XeniDateUtil.isValidExcelDate(d)) {
                if (!bl2) {
                    Format format = this.getFormat(d, n, string);
                    if (format instanceof ExcelStyleDateFormatter) {
                        ((ExcelStyleDateFormatter)format).setDateToBeFormatted(d);
                    }
                    Date date = XeniDateUtil.getJavaDate(d, bl);
                    return this.performDateFormatting(date, format);
                }
                return this.generalIntegerNumberFormat(d);
            }
            if (this.emulateCsv) {
                return invalidDateTimeString;
            }
        }
        if (string != null && !bl3) {
            return this.formatNumberString(d, n, string);
        }
        return this.generalIntegerNumberFormat(d);
    }

    public String getCustomFormatString(int n, String string) {
        switch (n) {
            case 55: {
                string = "yyyy/mm/dd";
                break;
            }
            case 57: {
                string = "yyyy\"\u5e74\" mm\"\u6708\" dd\"\u65e5\";@";
                break;
            }
            case 58: {
                string = "mm-dd";
                break;
            }
            case 31: {
                string = "yyyy\"\ub144\" mm\"\uc6d4\" dd\"\uc77c\";@";
                break;
            }
            case 30: {
                string = "mm-dd-yy";
                break;
            }
            case 32: {
                string = "h\"\uc2dc\" mm\"\ubd84\";@";
                break;
            }
            case 33: {
                string = "h\"\uc2dc\" mm\"\ubd84\" ss\"\ucd08\";@";
            }
        }
        return string;
    }

    public String formatCellValue(Cell cell) {
        return this.formatCellValue(cell, null);
    }

    public String formatNumberString(double d, int n, String string) {
        String string2;
        Format format = this.getFormat(d, n, string);
        if (format == null) {
            return String.valueOf(d);
        }
        if (string.indexOf("%") > -1) {
            return this.generalIntegerNumberFormat(d *= 100.0);
        }
        Format format2 = format;
        if (format instanceof DecimalFormat && ("General".equalsIgnoreCase(string) || "@".equalsIgnoreCase(string))) {
            string2 = this.xeniDecimalNumFormat.format(d);
            int n2 = 11;
            if (string2.startsWith("-")) {
                ++n2;
            }
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2);
                String string3 = "#.#";
                int n3 = string2.indexOf(46);
                if (n3 > 0) {
                    String string4 = string2.substring(n3 + 1);
                    n3 = string4.length();
                    for (int i = 1; i < n3; ++i) {
                        string3 = string3 + "#";
                    }
                }
                format2 = new DecimalFormat(string3, this.decimalSymbols);
            }
        }
        if ((string2 = format2.format(new Double(d))).contains("E") && !string2.contains("E-")) {
            string2 = string2.replaceFirst("E", "E+");
        }
        return string2;
    }

    public String generalIntegerNumberFormat(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#.######################");
        String string = decimalFormat.format(d);
        return string;
    }

    public String formatCellValue(Cell cell, FormulaEvaluator formulaEvaluator) {
        if (cell == null) {
            return "";
        }
        int n = cell.getCellType();
        if (n == 2) {
            if (formulaEvaluator == null) {
                return cell.getCellFormula();
            }
            n = formulaEvaluator.evaluateFormulaCell(cell);
        }
        switch (n) {
            case 0: {
                if (XeniDateUtil.isCellDateFormatted(cell)) {
                    return this.getFormattedDateString(cell);
                }
                return this.getFormattedNumberString(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected celltype (" + n + ")");
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry<String, Format> entry : this.formats.entrySet()) {
            if (entry.getValue() != this.generalDecimalNumFormat && entry.getValue() != this.generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String string, Format format) {
        this.formats.put(string, format);
    }

    static DecimalFormat createIntegerOnlyFormat(String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setParseIntegerOnly(true);
        return decimalFormat;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat decimalFormat) {
        XeniDataFormatter.setExcelStyleRoundingMode(decimalFormat, RoundingMode.HALF_UP);
    }

    public static void setExcelStyleRoundingMode(DecimalFormat decimalFormat, RoundingMode roundingMode) {
        try {
            Method method = decimalFormat.getClass().getMethod("setRoundingMode", RoundingMode.class);
            method.invoke((Object)decimalFormat, new Object[]{roundingMode});
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to set rounding mode", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Unable to set rounding mode", invocationTargetException);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            stringBuilder.append('#');
        }
        invalidDateTimeString = stringBuilder.toString();
    }

    private static final class ConstantStringFormat
    extends Format {
        private static final DecimalFormat df = XeniDataFormatter.createIntegerOnlyFormat("##########");
        private final String str;

        public ConstantStringFormat(String string) {
            this.str = string;
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(this.str);
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class FractionFormat
    extends Format {
        private final String str;

        public FractionFormat(String string) {
            this.str = string;
        }

        public String format(Number number) {
            int n;
            String[] stringArray;
            double d;
            double d2 = number.doubleValue();
            String[] stringArray2 = this.str.split(";");
            int n2 = d2 > 0.0 ? 0 : (d2 < 0.0 ? 1 : 2);
            String string = n2 < stringArray2.length ? stringArray2[n2] : stringArray2[0];
            double d3 = Math.floor(Math.abs(d2));
            if (d3 + (d = Math.abs(d2) - d3) == 0.0) {
                return "0";
            }
            if (d2 < 0.0) {
                d3 *= -1.0;
            }
            String[] stringArray3 = (stringArray = string.replaceAll("  *", " ").split(" ")).length == 2 ? stringArray[1].split("/") : string.split("/");
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray3[n] = stringArray3[n].replace('?', '#');
            }
            if (stringArray3.length == 2) {
                n = Math.min(this.countHashes(stringArray3[1]), 4);
                double d4 = 1.0;
                double d5 = Math.pow(10.0, n) - 1.0;
                double d6 = 0.0;
                for (int i = (int)(Math.pow(10.0, n) - 1.0); i > 0; --i) {
                    for (int j = (int)(Math.pow(10.0, n) - 1.0); j > 0; --j) {
                        if (!(d4 >= Math.abs((double)j / (double)i - d))) continue;
                        d5 = i;
                        d6 = j;
                        d4 = Math.abs((double)j / (double)i - d);
                    }
                }
                DecimalFormat decimalFormat = new DecimalFormat(stringArray3[0]);
                DecimalFormat decimalFormat2 = new DecimalFormat(stringArray3[1]);
                if (stringArray.length == 2) {
                    DecimalFormat decimalFormat3 = new DecimalFormat(stringArray[0]);
                    String string2 = decimalFormat3.format(d3) + " " + decimalFormat.format(d6) + "/" + decimalFormat2.format(d5);
                    return string2;
                }
                String string3 = decimalFormat.format(d6 + d5 * d3) + "/" + decimalFormat2.format(d5);
                return string3;
            }
            throw new IllegalArgumentException("Fraction must have 2 parts, found " + stringArray3.length + " for fraction format " + this.str);
        }

        private int countHashes(String string) {
            int n = 0;
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) != '#') continue;
                ++n;
            }
            return n;
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(this.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new NotImplementedException("Reverse parsing not supported");
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = XeniDataFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            if (n <= 4) {
                return string;
            }
            String string2 = string.substring(n - 4, n);
            String string3 = string.substring(Math.max(0, n - 7), n - 4);
            String string4 = string.substring(Math.max(0, n - 10), Math.max(0, n - 7));
            if (string4 != null && string4.trim().length() > 0) {
                stringBuffer.append('(').append(string4).append(") ");
            }
            if (string3 != null && string3.trim().length() > 0) {
                stringBuffer.append(string3).append('-');
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(PhoneFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = XeniDataFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, 5)).append('-');
            stringBuffer.append(string.substring(5, 9));
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(ZipPlusFourFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = XeniDataFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number number) {
            String string = df.format(number);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, 3)).append('-');
            stringBuffer.append(string.substring(3, 5)).append('-');
            stringBuffer.append(string.substring(5, 9));
            return stringBuffer.toString();
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(SSNFormat.format((Number)object));
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            return df.parseObject(string, parsePosition);
        }
    }
}

