/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XeniReadOnlySharedStringsTable
extends DefaultHandler {
    private int count;
    private int uniqueCount;
    public List<String> strings;
    private StringBuffer characters;
    private boolean tIsOpen;
    private boolean isPhonetic = false;

    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(String string) {
        this.strings.add(string);
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setUniqueCount(int n) {
        this.uniqueCount = n;
    }

    public XeniReadOnlySharedStringsTable(OPCPackage oPCPackage) throws IOException, SAXException {
        ArrayList arrayList = oPCPackage.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (arrayList.size() > 0) {
            PackagePart packagePart = (PackagePart)arrayList.get(0);
            this.readFrom(packagePart.getInputStream());
        }
    }

    public XeniReadOnlySharedStringsTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, SAXException {
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException, SAXException {
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("SAX parser appears to be broken - " + parserConfigurationException.getMessage());
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public String getEntryAt(int n) {
        return this.strings.get(n);
    }

    public List<String> getItems() {
        return this.strings;
    }

    public StringBuffer getCharacters() {
        return this.characters;
    }

    public void setCharacters(StringBuffer stringBuffer) {
        this.characters = stringBuffer;
    }

    public boolean istIsOpen() {
        return this.tIsOpen;
    }

    public void settIsOpen(boolean bl) {
        this.tIsOpen = bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = string3.indexOf(":");
        if (n > -1) {
            string3 = string3.substring(n + 1, string3.length());
        }
        if ("sst".equals(string3)) {
            String string4;
            String string5 = attributes.getValue("count");
            if (string5 != null) {
                this.count = Integer.parseInt(string5);
            }
            if ((string4 = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(string4);
            }
            this.strings = new ArrayList<String>(this.uniqueCount);
            this.characters = new StringBuffer();
        } else if ("si".equals(string3)) {
            this.characters.setLength(0);
        } else if ("t".equals(string3)) {
            this.tIsOpen = true;
        } else if ("rPh".equals(string3)) {
            this.isPhonetic = true;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = string3.indexOf(":");
        if (n > -1) {
            string3 = string3.substring(n + 1, string3.length());
        }
        if ("si".equals(string3)) {
            this.strings.add(this.characters.toString());
        } else if ("t".equals(string3)) {
            this.tIsOpen = false;
        } else if ("rPh".equals(string3)) {
            this.isPhonetic = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.tIsOpen && !this.isPhonetic) {
            this.characters.append(cArray, n, n2);
        }
    }
}

