/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import com.nexacro.xeni.extend.XeniCTXf;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XeniStylesTable
extends DefaultHandler {
    private Boolean bIsCTXF = false;
    private final List<XeniCTXf> styleXfs = new ArrayList<XeniCTXf>();
    private final List<XeniCTXf> xfs = new ArrayList<XeniCTXf>();
    private XeniCTXf ctXf = null;
    private XeniCTXf styleCtXf = null;

    public XeniStylesTable(OPCPackage oPCPackage) throws IOException, SAXException, XmlException {
        ArrayList arrayList = oPCPackage.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (arrayList.size() > 0) {
            PackagePart packagePart = (PackagePart)arrayList.get(0);
            this.readFrom(packagePart.getInputStream());
        }
    }

    public void readFrom(InputStream inputStream) throws IOException, SAXException {
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("SAX parser appears to be broken - " + parserConfigurationException.getMessage());
        }
    }

    public List<XeniCTXf> getArrCtxf() {
        return this.xfs;
    }

    public short getDataFormat(int n) {
        return this.xfs.get(n).getNumFmtId();
    }

    public String getDataFormatString(Short s) {
        String string = null;
        List<XeniCTXf> list = this.styleXfs;
        for (XeniCTXf xeniCTXf : list) {
            if (xeniCTXf.getNumFmtId() != s.shortValue()) continue;
            string = xeniCTXf.getFormatCode();
            break;
        }
        return string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("x:numFmt") || string3.equals("numFmt")) {
            this.styleCtXf = new XeniCTXf();
            this.styleCtXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
            this.styleCtXf.setFormatCode(attributes.getValue("formatCode"));
        } else if (string3.equals("x:cellXfs") || string3.equals("cellXfs")) {
            this.bIsCTXF = true;
        } else if (string3.equals("mc:Choice") || string3.equals("Choice")) {
            this.bIsCTXF = false;
        } else if (string3.equals("mc:Fallback") || string3.equals("Fallback")) {
            this.bIsCTXF = true;
        } else if (this.bIsCTXF.booleanValue() && (string3.equals("x:xf") || string3.equals("xf"))) {
            this.ctXf = new XeniCTXf();
            this.ctXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("x:cellXfs") || string3.equals("cellXfs")) {
            this.bIsCTXF = false;
        } else if (string3.equals("x:numFmt") || string3.equals("numFmt")) {
            this.styleXfs.add(this.styleCtXf);
        } else if (this.bIsCTXF.booleanValue() && (string3.equals("x:xf") || string3.equals("xf"))) {
            this.xfs.add(this.ctXf);
        }
    }
}

