/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.ximport.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xeni.data.importformats.ImportFormat;
import com.nexacro.xeni.data.importformats.ImportSheet;
import com.nexacro.xeni.extend.XeniCSVReader;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.ximport.GridImportBase;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridImportCSV
implements GridImportBase {
    private String sErrMessage = "";
    private String sImportPath = "";
    private String sServicePath = "";
    private String sPassWord = "";
    private String sNumberFmtLang = "";
    private ImportFormat objFmtImport = null;
    private boolean bIsSvrMode = false;
    private boolean bEnableManage = true;
    private boolean bSetPassWord = false;
    private boolean bSetRawDateValue = false;
    private boolean bSetRawNumValue = true;
    private boolean bMinRange = false;
    private String[] keywords = null;
    private static final Log objLogger = LogFactory.getLog(GridImportCSV.class);
    private int nErrCode = 0;
    private InputStream inputStream = null;

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (objLogger.isInfoEnabled()) {
            objLogger.info((Object)string);
        }
        if (!this.bIsSvrMode && this.bEnableManage) {
            this.deleteImportFile();
        }
    }

    public int getErrorCode() {
        return this.nErrCode;
    }

    public void setErrorCode(int n) {
        this.nErrCode = n;
    }

    public void setImportType(int n) {
    }

    public void setIsSheets(boolean bl) {
    }

    public void setImportFormat(ImportFormat importFormat) {
        this.objFmtImport = importFormat;
    }

    public void setImportFilePath(String string, String string2) {
        this.sServicePath = string;
        this.sImportPath = string2;
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    public void setImportFileMode(String string) {
        if (string.equals("server")) {
            this.bIsSvrMode = true;
        }
    }

    public void setPassWord(String string) {
        if (string != null && string.length() > 0) {
            this.bSetPassWord = true;
            this.sPassWord = string;
        }
    }

    public String getPassWord() {
        return this.sPassWord;
    }

    public void setRawDateValue(boolean bl) {
        this.bSetRawDateValue = bl;
    }

    public void setNumberFmtLnag(String string) {
        if (string != null && string.length() > 0) {
            this.sNumberFmtLang = string;
        }
    }

    public void setRawNumberValue(boolean bl) {
        this.bSetRawNumValue = bl;
    }

    public void setMinRangeMode(boolean bl) {
        this.bMinRange = bl;
    }

    public void setSecurityKeyword(String string) {
        this.keywords = string != null ? string.split("\\,") : null;
    }

    public int executeImport(boolean bl, PlatformData platformData) {
        this.nErrCode = 0;
        this.bEnableManage = bl;
        DataSetList dataSetList = platformData.getDataSetList();
        if (this.sImportPath == null || "".equals(this.sImportPath)) {
            this.setErrorMessage("Import file path is empty.");
            return -1;
        }
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.sImportPath);
        dataSetList.add(dataSet);
        for (int i = 0; i < this.objFmtImport.getSheetCount(); ++i) {
            DataSet dataSet2;
            ImportSheet importSheet = this.objFmtImport.getSheet(i);
            if (importSheet == null || "getsheetlist".equals(importSheet.getCommand()) || (dataSet2 = this.getCsvData(importSheet)) == null) continue;
            dataSetList.add(dataSet2);
        }
        if (!this.bIsSvrMode && this.bEnableManage) {
            this.deleteImportFile();
        }
        return this.nErrCode;
    }

    private void setImportFilePath() {
        if (this.bIsSvrMode) {
            if (this.sImportPath.startsWith("http")) {
                URL uRL = null;
                try {
                    uRL = new URL(this.sImportPath);
                }
                catch (MalformedURLException malformedURLException) {
                    this.nErrCode = -2018;
                    this.setErrorMessage(malformedURLException.getMessage());
                    return;
                }
                this.sImportPath = this.sServicePath + uRL.getPath().substring(1);
            } else if (this.sImportPath.startsWith("/")) {
                this.sImportPath = this.sServicePath + this.sImportPath.substring(1);
            }
        }
        if (objLogger.isDebugEnabled()) {
            objLogger.debug((Object)("Import file path : " + this.sImportPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getCsvData(ImportSheet importSheet) {
        int n = 0;
        String string = "";
        String string2 = importSheet.getOutput();
        if (string2 == null || "".equals(string2)) {
            string2 = "CSVDATA";
        }
        DataSet dataSet = new DataSet(string2);
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            String[] stringArray;
            inputStream = this.inputStream;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            XeniCSVReader xeniCSVReader = new XeniCSVReader(bufferedReader);
            while ((stringArray = xeniCSVReader.readNext()) != null) {
                int n2;
                if (n == 0) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        dataSet.addColumn("Column" + n2, 2, 256);
                    }
                }
                dataSet.newRow();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (this.keywords != null) {
                        for (int i = 0; i < this.keywords.length; ++i) {
                            if (!stringArray[n2].contains(this.keywords[i])) continue;
                            this.nErrCode = -2001;
                            this.setErrorMessage("Invalid value [ row : " + n + ", col : " + n2 + " ]");
                            DataSet dataSet2 = null;
                            return dataSet2;
                        }
                    }
                    dataSet.set(n, n2, stringArray[n2]);
                }
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.nErrCode = -2018;
            this.setErrorMessage(malformedURLException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.nErrCode = -2020;
            this.setErrorMessage("No such file or directory");
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            this.nErrCode = -2003;
        }
        catch (Exception exception) {
            this.nErrCode = -2001;
            this.setErrorMessage(exception + "");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    if (inputStream != null) {
                        inputStream.close();
                        inputStream = null;
                    }
                }
                catch (IOException iOException) {
                    this.nErrCode = -2003;
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        }
        return dataSet;
    }

    private void deleteImportFile() {
        CommUtil.deleteDir(this.sServicePath + this.sImportPath);
    }
}

