/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.ximport.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xeni.data.importformats.ImportFormat;
import com.nexacro.xeni.data.importformats.ImportSheet;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.util.XeniExtendBase;
import com.nexacro.xeni.util.XeniExtendFactory;
import com.nexacro.xeni.ximport.GridImportBase;
import com.nexacro.xeni.ximport.impl.HSSFEventModelHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportExcelHSSFEvent
implements GridImportBase {
    private int nErrCode = 0;
    private String sErrMessage = "SUCCESS";
    private String sImportPath = "";
    private String sServicePath = "";
    private String sPassWord = "";
    private String sNumberFmtLang = "";
    private ImportFormat importFormat = null;
    private boolean bIsSvrMode = false;
    private boolean bEnableManage = true;
    private boolean bSetPassWord = false;
    private boolean bSetRawDateValue = false;
    private boolean bSetRawNumValue = true;
    private boolean bMinRange = false;
    private String[] keywords = null;
    private static final Log logger = LogFactory.getLog(GridImportExcelHSSFEvent.class);
    private NPOIFSFileSystem poifs = null;

    public void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (logger.isInfoEnabled()) {
            logger.info((Object)string);
        }
        if (!this.bIsSvrMode && this.bEnableManage) {
            this.deleteImportFile();
        }
    }

    private void deleteImportFile() {
        CommUtil.deleteDir(this.sServicePath + this.sImportPath);
    }

    public void setImportType(int n) {
    }

    public void setImportFormat(ImportFormat importFormat) {
        this.importFormat = importFormat;
    }

    public void setImportFilePath(String string, String string2) {
        this.sServicePath = string;
        this.sImportPath = string2;
    }

    public int getErrorCode() {
        return this.nErrCode;
    }

    public void setErrorCode(int n) {
        this.nErrCode = n;
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    public void setImportFileMode(String string) {
        this.bIsSvrMode = "server".equals(string);
    }

    public void setPassWord(String string) {
        if (string != null && string.length() > 0) {
            this.bSetPassWord = true;
            this.sPassWord = string;
        }
    }

    public String getPassWord() {
        return this.sPassWord;
    }

    public void setNumberFmtLnag(String string) {
        if (string != null && string.length() > 0) {
            this.sNumberFmtLang = string;
        }
    }

    public void setRawDateValue(boolean bl) {
        this.bSetRawDateValue = bl;
    }

    public void setRawNumberValue(boolean bl) {
        this.bSetRawNumValue = bl;
    }

    public void setMinRangeMode(boolean bl) {
        this.bMinRange = bl;
    }

    public void setSecurityKeyword(String string) {
        this.keywords = string != null ? string.split("\\,") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeImport(boolean bl, PlatformData platformData) {
        if (this.sImportPath == null || "".equals(this.sImportPath)) {
            this.setErrorMessage("Import file path is empty...");
            return -2001;
        }
        this.nErrCode = 0;
        this.bEnableManage = bl;
        DataSetList dataSetList = platformData.getDataSetList();
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.sImportPath);
        dataSetList.add(dataSet);
        NPOIFSFileSystem nPOIFSFileSystem = null;
        try {
            nPOIFSFileSystem = this.poifs;
            for (int i = 0; i < this.importFormat.getSheetCount(); ++i) {
                ImportSheet importSheet = this.importFormat.getSheet(i);
                if (importSheet == null) continue;
                DataSet dataSet2 = null;
                dataSet2 = "getsheetlist".equals(importSheet.getCommand()) ? this.getSheetList(importSheet, nPOIFSFileSystem) : this.getSheetData(importSheet, nPOIFSFileSystem);
                if (dataSet2 == null) continue;
                dataSetList.add(dataSet2);
            }
            if (!this.bIsSvrMode && this.bEnableManage) {
                this.deleteImportFile();
            }
            if (this.nErrCode == 0 && this.bSetPassWord) {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            this.nErrCode = -2019;
            this.setErrorMessage(invalidFormatException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.nErrCode = -2018;
            this.setErrorMessage(malformedURLException.getMessage());
        }
        catch (PlatformException platformException) {
            this.nErrCode = -3101;
            this.setErrorMessage(platformException.getMessage());
        }
        catch (IOException iOException) {
            this.nErrCode = -2003;
            this.setErrorMessage(iOException.getMessage());
        }
        catch (Exception exception) {
            this.nErrCode = -2001;
            this.setErrorMessage(exception + "");
        }
        finally {
            if (nPOIFSFileSystem != null) {
                try {
                    nPOIFSFileSystem.close();
                }
                catch (IOException iOException) {
                    this.nErrCode = -2003;
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        }
        return this.nErrCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private POIFSFileSystem getExcelData() throws MalformedURLException, IOException, Exception {
        InputStream inputStream = null;
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            Object object;
            if (this.sImportPath.startsWith("http")) {
                object = new URL(this.sImportPath);
                inputStream = new BufferedInputStream(((URL)object).openStream());
            } else {
                object = this.sImportPath;
                if (((String)object).startsWith("/")) {
                    object = this.sServicePath + this.sImportPath;
                }
                XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
                inputStream = xeniExtendBase.loadTargetStream((String)object);
            }
            if (this.bSetPassWord) {
                Biff8EncryptionKey.setCurrentUserPassword((String)this.sPassWord);
            }
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.nErrCode = -2003;
                this.setErrorMessage(iOException.getMessage());
            }
        }
        return pOIFSFileSystem;
    }

    private DataSet getSheetList(ImportSheet importSheet, NPOIFSFileSystem nPOIFSFileSystem) throws Exception {
        String string = importSheet.getOutput();
        if (string == null || "".equals(string)) {
            string = "SHEETS";
        }
        DataSet dataSet = new DataSet(string);
        dataSet.addColumn("number", 3);
        dataSet.addColumn("sheetname", 2);
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords((HSSFListener)new HSSFEventModelHandler(dataSet, null, null, null, HSSFEventModelHandler.commandType.SHEETLIST, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords));
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        DocumentInputStream documentInputStream = nPOIFSFileSystem.createDocumentInputStream("Workbook");
        hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        if (documentInputStream != null) {
            documentInputStream.close();
        }
        return dataSet;
    }

    private DataSet getSheetData(ImportSheet importSheet, NPOIFSFileSystem nPOIFSFileSystem) throws Exception {
        String string = importSheet.getOutput();
        if (string == null || "".equals(string)) {
            string = "SHEETDATA";
        }
        DataSet dataSet = new DataSet(string);
        int[] nArray = new int[]{-1, -1};
        int[] nArray2 = new int[]{-1, -1};
        String string2 = null;
        String string3 = importSheet.getHead();
        if (string3 != null && string3.length() > 0) {
            string2 = CommUtil.getDataRange(string3, nArray, nArray2);
        }
        HSSFEventModelHandler hSSFEventModelHandler = new HSSFEventModelHandler(dataSet, string2, nArray, nArray2, HSSFEventModelHandler.commandType.HEAD, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords);
        hSSFEventModelHandler.excute(nPOIFSFileSystem);
        if (!hSSFEventModelHandler.isFoundSheet()) {
            this.setErrorMessage("Unable to process: Not found '" + string2 + "' sheet.");
            throw new IOException(this.sErrMessage);
        }
        int[] nArray3 = new int[]{-1, -1};
        int[] nArray4 = new int[]{-1, -1};
        string3 = importSheet.getBody();
        if (string3 != null && string3.length() > 0) {
            string2 = CommUtil.getDataRange(string3, nArray3, nArray4);
        }
        HSSFEventModelHandler hSSFEventModelHandler2 = new HSSFEventModelHandler(dataSet, string2, nArray3, nArray4, HSSFEventModelHandler.commandType.BODY, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords);
        hSSFEventModelHandler2.excute(nPOIFSFileSystem);
        if (!hSSFEventModelHandler2.isFoundSheet()) {
            this.setErrorMessage("Unable to process: Not found '" + string2 + "' sheet.");
            throw new IOException(this.sErrMessage);
        }
        return dataSet;
    }

    public void setPOIFileSystem(NPOIFSFileSystem nPOIFSFileSystem) {
        this.poifs = nPOIFSFileSystem;
    }
}

