/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.ximport.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xeni.data.importformats.ImportFormat;
import com.nexacro.xeni.data.importformats.ImportSheet;
import com.nexacro.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.xeni.extend.XeniStylesTable;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.util.XeniExtendBase;
import com.nexacro.xeni.util.XeniExtendFactory;
import com.nexacro.xeni.ximport.GridImportBase;
import com.nexacro.xeni.ximport.POIEventModelException;
import com.nexacro.xeni.ximport.impl.XSSFEventModelHandler;
import com.nexacro.xeni.ximport.impl.XSSFEventModelHandler2;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GridImportExcelXSSFEvent
implements GridImportBase {
    private int nErrCode = 0;
    private String sErrMessage = "SUCCESS";
    private String sImportPath = "";
    private String sServicePath = "";
    private String sPassWord = "";
    private String sNumberFmtLang = "";
    private ImportFormat importFormat = null;
    private boolean bIsSvrMode = false;
    private boolean bEnableManage = true;
    private boolean bSetPassWord = false;
    private boolean bIsHancell = false;
    private boolean bSetRawDateValue = false;
    private boolean bSetRawNumValue = true;
    private boolean bMinRange = false;
    private String[] keywords = null;
    private static final Log logger = LogFactory.getLog(GridImportExcelXSSFEvent.class);
    private OPCPackage opcPackage = null;

    public void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (logger.isInfoEnabled()) {
            logger.info((Object)string);
        }
        if (!this.bIsSvrMode && this.bEnableManage) {
            this.deleteImportFile();
        }
    }

    private void deleteImportFile() {
        CommUtil.deleteDir(this.sServicePath + this.sImportPath);
    }

    public void setImportType(int n) {
        if (1040 == n || 1056 == n) {
            this.bIsHancell = true;
        }
    }

    public void setImportFormat(ImportFormat importFormat) {
        this.importFormat = importFormat;
    }

    public void setImportFilePath(String string, String string2) {
        this.sServicePath = string;
        this.sImportPath = string2;
    }

    public int getErrorCode() {
        return this.nErrCode;
    }

    public void setErrorCode(int n) {
        this.nErrCode = n;
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    public void setPassWord(String string) {
        if (string != null && string.length() > 0) {
            this.sPassWord = string;
        }
    }

    public String getPassWord() {
        return this.sPassWord;
    }

    public void setRawDateValue(boolean bl) {
        this.bSetRawDateValue = bl;
    }

    public void setNumberFmtLnag(String string) {
        if (string != null && string.length() > 0) {
            this.sNumberFmtLang = string;
        }
    }

    public void setRawNumberValue(boolean bl) {
        this.bSetRawNumValue = bl;
    }

    public void setMinRangeMode(boolean bl) {
        this.bMinRange = bl;
    }

    public void setSecurityKeyword(String string) {
        this.keywords = string != null ? string.split("\\,") : null;
    }

    public void setImportFileMode(String string) {
        this.bIsSvrMode = "server".equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeImport(boolean bl, PlatformData platformData) {
        if (this.sImportPath == null || "".equals(this.sImportPath)) {
            this.setErrorMessage("Import file path is empty...");
            return -2001;
        }
        this.nErrCode = 0;
        this.bEnableManage = bl;
        DataSetList dataSetList = platformData.getDataSetList();
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.sImportPath);
        dataSetList.add(dataSet);
        OPCPackage oPCPackage = null;
        try {
            oPCPackage = this.opcPackage;
            XeniStylesTable xeniStylesTable = null;
            if (this.bIsHancell) {
                xeniStylesTable = new XeniStylesTable(oPCPackage);
            }
            if (this.nErrCode != 0) {
                int n = this.nErrCode;
                return n;
            }
            this.nErrCode = 0;
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable = new XeniReadOnlySharedStringsTable(oPCPackage);
            for (int i = 0; i < this.importFormat.getSheetCount(); ++i) {
                ImportSheet importSheet = this.importFormat.getSheet(i);
                if (importSheet == null) continue;
                DataSet dataSet2 = null;
                dataSet2 = "getsheetlist".equals(importSheet.getCommand()) ? this.getSheetList(importSheet, xSSFReader) : this.getSheetData(xSSFReader, importSheet, xeniReadOnlySharedStringsTable, xeniStylesTable);
                if (dataSet2 == null) continue;
                dataSetList.add(dataSet2);
            }
            if (!this.bIsSvrMode && this.bEnableManage) {
                this.deleteImportFile();
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            this.nErrCode = -2019;
            this.setErrorMessage(invalidFormatException.getMessage());
        }
        catch (OpenXML4JException openXML4JException) {
            this.nErrCode = -2001;
            this.setErrorMessage(openXML4JException.getMessage());
        }
        catch (SAXException sAXException) {
            this.nErrCode = -2001;
            this.setErrorMessage(sAXException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.nErrCode = -2018;
            this.setErrorMessage(malformedURLException.getMessage());
        }
        catch (PlatformException platformException) {
            this.nErrCode = -3101;
            this.setErrorMessage(platformException.getMessage());
        }
        catch (IOException iOException) {
            this.nErrCode = -2003;
            this.setErrorMessage(iOException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.nErrCode = -2021;
            this.setErrorMessage(generalSecurityException.getMessage());
        }
        catch (Exception exception) {
            this.nErrCode = -2001;
            this.setErrorMessage(exception + "");
        }
        finally {
            if (oPCPackage != null) {
                try {
                    oPCPackage.close();
                }
                catch (IOException iOException) {
                    this.nErrCode = -2003;
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        }
        return this.nErrCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OPCPackage getExcelData() throws GeneralSecurityException, MalformedURLException, InvalidFormatException, IOException, Exception {
        InputStream inputStream = null;
        OPCPackage oPCPackage = null;
        try {
            XeniExtendBase xeniExtendBase;
            Object object;
            if (this.sImportPath.startsWith("http")) {
                object = new URL(this.sImportPath);
                inputStream = new BufferedInputStream(((URL)object).openStream());
            } else {
                object = this.sImportPath;
                if (((String)object).startsWith("/")) {
                    object = this.sServicePath + this.sImportPath;
                }
                xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
                inputStream = xeniExtendBase.loadTargetStream((String)object);
            }
            inputStream = this.isPassWord(inputStream);
            if (this.bSetPassWord) {
                Decryptor decryptor;
                block22: {
                    object = new NPOIFSFileSystem(inputStream);
                    xeniExtendBase = new EncryptionInfo((NPOIFSFileSystem)object);
                    decryptor = Decryptor.getInstance((EncryptionInfo)xeniExtendBase);
                    try {
                        if (decryptor.verifyPassword(this.sPassWord)) break block22;
                        this.nErrCode = -2021;
                        this.setErrorMessage("Unable to process: document is encrypted");
                        OPCPackage oPCPackage2 = null;
                        return oPCPackage2;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        this.nErrCode = -2021;
                        this.setErrorMessage("Unable to process encrypted document");
                        OPCPackage oPCPackage3 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            this.nErrCode = -2003;
                            this.setErrorMessage(iOException.getMessage());
                        }
                        return oPCPackage3;
                    }
                }
                inputStream = decryptor.getDataStream((NPOIFSFileSystem)object);
            }
            oPCPackage = OPCPackage.open((InputStream)inputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.nErrCode = -2003;
                this.setErrorMessage(iOException.getMessage());
            }
        }
        return oPCPackage;
    }

    private InputStream isPassWord(InputStream inputStream) throws IOException {
        SequenceInputStream sequenceInputStream = null;
        byte[] byArray = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
        byte[] byArray2 = new byte[8];
        inputStream.read(byArray2);
        boolean bl = Arrays.equals(byArray, byArray2);
        if (bl) {
            this.bSetPassWord = true;
        }
        sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byArray2), inputStream);
        return sequenceInputStream;
    }

    private DataSet getSheetList(ImportSheet importSheet, XSSFReader xSSFReader) throws Exception {
        String string = importSheet.getOutput();
        if (string == null || "".equals(string)) {
            string = "SHEETS";
        }
        DataSet dataSet = new DataSet(string);
        dataSet.addColumn("number", 3);
        dataSet.addColumn("sheetname", 2);
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            InputStream inputStream = sheetIterator.next();
            int n = dataSet.newRow();
            dataSet.set(n, "number", n + 1);
            dataSet.set(n, "sheetname", sheetIterator.getSheetName());
            inputStream.close();
        }
        return dataSet;
    }

    private DataSet getSheetData(XSSFReader xSSFReader, ImportSheet importSheet, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, XeniStylesTable xeniStylesTable) throws OpenXML4JException, SAXException, Exception {
        DataSet dataSet;
        block8: {
            StylesTable stylesTable;
            XMLReader xMLReader;
            DefaultHandler defaultHandler;
            InputSource inputSource;
            block7: {
                String string = importSheet.getOutput();
                if (string == null || "".equals(string)) {
                    string = "SHEETDATA";
                }
                dataSet = new DataSet(string);
                inputSource = null;
                defaultHandler = null;
                xMLReader = XMLReaderFactory.createXMLReader();
                int[] nArray = new int[]{-1, -1};
                int[] nArray2 = new int[]{-1, -1};
                inputSource = this.getSheetSource(xSSFReader, importSheet.getHead(), nArray, nArray2);
                stylesTable = null;
                if (this.bIsHancell) {
                    defaultHandler = new XSSFEventModelHandler2(dataSet, nArray, nArray2, true, xeniStylesTable, xeniReadOnlySharedStringsTable, false, null, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords);
                } else {
                    stylesTable = xSSFReader.getStylesTable();
                    defaultHandler = new XSSFEventModelHandler(dataSet, nArray, nArray2, true, stylesTable, xeniReadOnlySharedStringsTable, false, null, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords);
                }
                xMLReader.setContentHandler(defaultHandler);
                try {
                    xMLReader.parse(inputSource);
                }
                catch (SAXException sAXException) {
                    if (sAXException.getException() instanceof POIEventModelException) break block7;
                    throw sAXException;
                }
            }
            int[] nArray = new int[]{-1, -1};
            int[] nArray3 = new int[]{-1, -1};
            inputSource = this.getSheetSource(xSSFReader, importSheet.getBody(), nArray, nArray3);
            defaultHandler = this.bIsHancell ? new XSSFEventModelHandler2(dataSet, nArray, nArray3, false, xeniStylesTable, xeniReadOnlySharedStringsTable, false, null, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords) : new XSSFEventModelHandler(dataSet, nArray, nArray3, false, stylesTable, xeniReadOnlySharedStringsTable, false, null, this.sNumberFmtLang, this.bSetRawDateValue, this.bSetRawNumValue, this.bMinRange, this.keywords);
            xMLReader.setContentHandler(defaultHandler);
            try {
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                if (sAXException.getException() instanceof POIEventModelException) break block8;
                throw sAXException;
            }
        }
        return dataSet;
    }

    public InputSource getSheetSource(XSSFReader xSSFReader, String string, int[] nArray, int[] nArray2) throws OpenXML4JException, SAXException, InvalidFormatException, IOException {
        InputStream inputStream = null;
        InputSource inputSource = null;
        if (string != null && string.length() > 0) {
            String string2 = CommUtil.getDataRange(string, nArray, nArray2);
            if (string2 == null || "".equals(string2)) {
                inputStream = this.getSheetStream(xSSFReader, null);
            } else {
                inputStream = this.getSheetStream(xSSFReader, string2);
                if (inputStream == null) {
                    this.setErrorMessage("Unable to process: Not found '" + string2 + "' sheet.");
                    throw new IOException(this.sErrMessage);
                }
            }
        } else {
            inputStream = this.getSheetStream(xSSFReader, null);
        }
        inputSource = new InputSource(inputStream);
        inputStream.close();
        return inputSource;
    }

    private InputStream getSheetStream(XSSFReader xSSFReader, String string) throws InvalidFormatException, IOException {
        InputStream inputStream = null;
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            if (string == null) {
                inputStream = sheetIterator.next();
                break;
            }
            inputStream = sheetIterator.next();
            if (string.equalsIgnoreCase(sheetIterator.getSheetName())) break;
            inputStream.close();
            inputStream = null;
        }
        return inputStream;
    }

    public void setOPCPackage(OPCPackage oPCPackage) {
        this.opcPackage = oPCPackage;
    }
}

