/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.ximport.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xeni.extend.XeniBuiltinFormats;
import com.nexacro.xeni.extend.XeniDataFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.ErrorConstants;

public class HSSFEventModelHandler
extends AbortableHSSFListener {
    private static final Log logger = LogFactory.getLog(HSSFEventModelHandler.class);
    private int nextRow;
    private int nextColumn;
    private SSTRecord sstRecord;
    private boolean outputNextStringRecord;
    private XeniDataFormatter formatter;
    private commandType cmdType;
    private boolean outputFormulaValues = true;
    private String sSheetName = null;
    private int[] nStartRange = new int[]{-1, -1};
    private int[] nEndRange = new int[]{-1, -1};
    private int nStartCol = 0;
    private int nEndCol = 0;
    private int nStartRow = 0;
    private int nEndRow = 0;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private DataSet dsResult = null;
    private int nSheetIdx = 0;
    private boolean bFoundSheet = false;
    private String numberFmtLang = null;
    private boolean bRawDateValue = false;
    private boolean bRawNumValue = true;
    private boolean bMinRange = false;
    private String[] keywords = null;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private final Map<Integer, FormatRecord> customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extFormatRecords = new ArrayList<ExtendedFormatRecord>();

    public HSSFEventModelHandler(DataSet dataSet, String string, int[] nArray, int[] nArray2, commandType commandType2, String string2, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        this.dsResult = dataSet;
        this.sSheetName = string;
        this.nStartRange = nArray;
        this.nEndRange = nArray2;
        this.cmdType = commandType2;
        this.formatter = new XeniDataFormatter();
        this.numberFmtLang = string2;
        this.bRawDateValue = bl;
        this.bRawNumValue = bl2;
        this.bMinRange = bl3;
        this.keywords = stringArray;
    }

    public void excute(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords((HSSFListener)this);
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, nPOIFSFileSystem.getRoot());
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        short s = record.getSid();
        if (!this.bFoundSheet && s != 1054 && s != 224 && s != 133 && s != 2057 && s != 10 && s != 252) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string = null;
        switch (s) {
            case 1054: {
                FormatRecord formatRecord = (FormatRecord)record;
                this.customFormatRecords.put(formatRecord.getIndexCode(), formatRecord);
                break;
            }
            case 224: {
                ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)record;
                this.extFormatRecords.add(extendedFormatRecord);
                break;
            }
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() != 16) break;
                this.findSheet();
                break;
            }
            case 512: {
                DimensionsRecord dimensionsRecord = (DimensionsRecord)record;
                n = this.setDimension(dimensionsRecord);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 10: {
                if (this.cmdType == commandType.SHEETLIST) {
                    n = this.getSheetList();
                    break;
                }
                if (!this.bFoundSheet) break;
                n = -1;
                break;
            }
            case 513: {
                BlankRecord blankRecord = (BlankRecord)record;
                n2 = blankRecord.getRow();
                n3 = blankRecord.getColumn();
                string = "";
                break;
            }
            case 6: {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                n2 = formulaRecord.getRow();
                n3 = formulaRecord.getColumn();
                if (this.outputFormulaValues) {
                    int n4 = formulaRecord.getCachedResultType();
                    if (n4 == 1) {
                        this.outputNextStringRecord = true;
                        this.nextRow = formulaRecord.getRow();
                        this.nextColumn = formulaRecord.getColumn();
                        break;
                    }
                    if (n4 == 4) {
                        string = formulaRecord.getCachedBooleanValue() ? "TRUE" : "FALSE";
                        break;
                    }
                    if (n4 == 5) {
                        string = "ERROR:" + formulaRecord.getCachedErrorValue();
                        break;
                    }
                    string = this.formatNumberDateCell((CellValueRecordInterface)formulaRecord, formulaRecord.getValue());
                    break;
                }
                string = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaRecord.getParsedExpression());
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord stringRecord = (StringRecord)record;
                string = stringRecord.getString();
                n2 = this.nextRow;
                n3 = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord labelRecord = (LabelRecord)record;
                n2 = labelRecord.getRow();
                n3 = labelRecord.getColumn();
                string = labelRecord.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                n2 = labelSSTRecord.getRow();
                n3 = labelSSTRecord.getColumn();
                if (this.sstRecord == null) {
                    string = "";
                    break;
                }
                string = this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                n2 = numberRecord.getRow();
                n3 = numberRecord.getColumn();
                string = this.formatNumberDateCell((CellValueRecordInterface)numberRecord, numberRecord.getValue());
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                n2 = boolErrRecord.getRow();
                n3 = boolErrRecord.getColumn();
                byte by = boolErrRecord.getErrorValue();
                string = by == 0 ? Boolean.toString(boolErrRecord.getBooleanValue()) : ErrorConstants.getText((int)by);
                break;
            }
        }
        if (n > -1 && n2 >= 0 && n3 >= 0) {
            n = this.setCellValue(n2, n3, string);
        }
        return (short)n;
    }

    private void findSheet() {
        if (this.sSheetName == null || "".equals(this.sSheetName)) {
            this.bFoundSheet = true;
        } else {
            String string = this.boundSheetRecords.get(this.nSheetIdx).getSheetname();
            if (string.equalsIgnoreCase(this.sSheetName)) {
                this.bFoundSheet = true;
            }
        }
        ++this.nSheetIdx;
    }

    public boolean isFoundSheet() {
        return this.bFoundSheet;
    }

    private String formatNumberDateCell(CellValueRecordInterface cellValueRecordInterface, double d) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        String string = this.getFormatString(n);
        String string2 = "";
        string2 = this.formatter.formatRawCellContents(d, n, string, false, this.bRawDateValue, this.bRawNumValue);
        string2 = string2.replaceAll("[\"*? ]", "");
        return string2;
    }

    private short setDimension(DimensionsRecord dimensionsRecord) {
        if (this.cmdType == commandType.HEAD && this.nStartRange[0] < 0 && this.nStartRange[1] < 0 && this.nEndRange[0] < 0 && this.nEndRange[1] < 0) {
            int n = dimensionsRecord.getLastCol() - 1 - dimensionsRecord.getFirstCol();
            for (int i = 0; i <= n; ++i) {
                this.dsResult.addColumn("Column" + i, 2, 256);
            }
            return -1;
        }
        this.nStartCol = this.nStartRange[0] < 0 ? dimensionsRecord.getFirstCol() : this.nStartRange[0];
        this.nStartRow = this.nStartRange[1] < 0 ? dimensionsRecord.getFirstRow() : this.nStartRange[1];
        this.nEndCol = this.nEndRange[0] < 0 ? dimensionsRecord.getLastCol() - 1 : this.nEndRange[0];
        int n = this.nEndRow = this.nEndRange[1] < 0 ? dimensionsRecord.getLastRow() - 1 : this.nEndRange[1];
        if (this.bMinRange) {
            if (this.nEndRange[0] > 0 && this.nEndRange[0] > dimensionsRecord.getLastCol() - 1) {
                this.nEndCol = dimensionsRecord.getLastCol() - 1;
            }
            if (this.nEndRange[1] > 0 && this.nEndRange[1] > dimensionsRecord.getLastRow() - 1) {
                this.nEndRow = dimensionsRecord.getLastRow() - 1;
            }
        }
        if (this.cmdType == commandType.BODY) {
            for (int i = 0; i <= this.nEndRow - this.nStartRow; ++i) {
                this.dsResult.newRow();
            }
        }
        return 0;
    }

    private String getFormatString(CellValueRecordInterface cellValueRecordInterface) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        if (n == -1) {
            return null;
        }
        return this.getFormatString(n);
    }

    private int getFormatIndex(CellValueRecordInterface cellValueRecordInterface) {
        ExtendedFormatRecord extendedFormatRecord = this.extFormatRecords.get(cellValueRecordInterface.getXFIndex());
        if (extendedFormatRecord == null) {
            return -1;
        }
        return extendedFormatRecord.getFormatIndex();
    }

    private String getFormatString(int n) {
        if (n == -1) {
            return null;
        }
        String string = null;
        if (n == 14) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, this.numberFmtLang);
        } else if (n >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord formatRecord = this.customFormatRecords.get(n);
            if (formatRecord != null) {
                string = formatRecord.getFormatString();
            }
        } else {
            string = XeniBuiltinFormats.getBuiltinFormat(n);
        }
        if (string == null) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, this.numberFmtLang);
        }
        return string;
    }

    private short getSheetList() {
        for (int i = 0; i < this.boundSheetRecords.size(); ++i) {
            int n = this.dsResult.newRow();
            BoundSheetRecord boundSheetRecord = this.boundSheetRecords.get(i);
            this.dsResult.set(n, "number", i + 1);
            this.dsResult.set(n, "sheetname", boundSheetRecord == null ? "" : boundSheetRecord.getSheetname());
        }
        return -1;
    }

    private short setCellValue(int n, int n2, String string) {
        int n3;
        if (this.keywords != null) {
            for (n3 = 0; n3 < this.keywords.length; ++n3) {
                if (!string.contains(this.keywords[n3])) continue;
                return -1;
            }
        }
        if (n > this.nEndRow) {
            return -1;
        }
        if (n < this.nStartRow || n2 < this.nStartCol || n2 > this.nEndCol) {
            return 0;
        }
        if (this.cmdType == commandType.HEAD) {
            n3 = n2 - this.nPreColIndex;
            this.nPreColIndex = n2;
            if (this.nCurrDsCol != 0 && n3 > 1) {
                for (int i = 1; i < n3; ++i) {
                    this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                    ++this.nCurrDsCol;
                }
            }
            if (string == null || "".equals(string)) {
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
            } else {
                this.dsResult.addColumn(string, 2, 256);
            }
            ++this.nCurrDsCol;
        } else if (this.cmdType == commandType.BODY && string != null) {
            this.dsResult.set(n - this.nStartRow, n2 - this.nStartCol, string);
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum commandType {
        SHEETLIST,
        HEAD,
        BODY;

    }
}

