/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.ximport.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xeni.extend.XeniBuiltinFormats;
import com.nexacro.xeni.extend.XeniDataFormatter;
import com.nexacro.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.ximport.POIEventModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventModelHandler
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(XSSFEventModelHandler.class);
    private StylesTable stylesTable;
    private XeniReadOnlySharedStringsTable sharedStringsTable;
    private final ParsedContentsHandler output;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final XeniDataFormatter formatter;
    private String cellRef;
    private boolean formulasNotResults;
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private int[] nStartRange = new int[]{-1, -1};
    private int[] nEndRange = new int[]{-1, -1};
    private int nStartCol = 0;
    private int nEndCol = 0;
    private int nStartRow = 0;
    private int nEndRow = 0;
    private int nCurrRow = 0;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private boolean bDsHeader = false;
    private boolean bHeadRange = true;
    private DataSet dsResult = null;
    private String numberFmtLang = null;
    private boolean bRawDateValue = false;
    private boolean bRawNumValue = true;
    private boolean bMinRange = false;
    private String[] keywords = null;
    private final String TAG_INLINE = "inlineStr";
    private final String TAG_ROW = "row";
    private final String TAG_CELL = "c";
    private final String TAG_TYPE = "t";
    private final String TAG_CONTENTS = "v";
    private final String TAG_INLINEOUTER = "is";
    private final String TAG_FORMULA = "f";
    private final String TAG_ODDHEADER = "oddHeader";
    private final String TAG_EVENHEADER = "evenHeader";
    private final String TAG_FIRSTHEADER = "firstHeader";
    private final String TAG_FIRSTFOOTER = "firstFooter";
    private final String TAG_ODDFOOTER = "oddFooter";
    private final String TAG_EVENFOOTER = "evenFooter";
    private final String TAG_DIMENSION = "dimension";
    private final String TAG_SHEETDATA = "sheetData";
    private final String TYPE_SHARED = "shared";
    private final String TYPE_BOOLEAN = "b";
    private final String TYPE_ERROR = "e";
    private final String TYPE_INLINE = "inlineStr";
    private final String TYPE_STRING = "s";
    private final String TYPE_FORMULA = "str";
    private final String ATTR_REF = "ref";
    private final String ATTR_SHARED = "si";
    private final String ATTR_TYPE = "t";
    private final String ATTR_REF_ROW = "r";
    private final String ATTR_STYLE = "s";

    public XSSFEventModelHandler(DataSet dataSet, int[] nArray, int[] nArray2, boolean bl, StylesTable stylesTable, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, boolean bl2, ParsedContentsHandler parsedContentsHandler, String string, boolean bl3, boolean bl4, boolean bl5, String[] stringArray) {
        this.dsResult = dataSet;
        this.nStartRange = nArray;
        this.nEndRange = nArray2;
        this.bDsHeader = bl;
        this.stylesTable = stylesTable;
        this.sharedStringsTable = xeniReadOnlySharedStringsTable;
        this.formulasNotResults = bl2;
        this.formatter = new XeniDataFormatter();
        this.nextDataType = xssfDataType.NUMBER;
        this.output = parsedContentsHandler;
        this.numberFmtLang = string;
        this.bRawDateValue = bl3;
        this.bRawNumValue = bl4;
        this.bMinRange = bl5;
        this.keywords = stringArray;
    }

    public XSSFEventModelHandler(StylesTable stylesTable, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, ParsedContentsHandler parsedContentsHandler, XeniDataFormatter xeniDataFormatter, boolean bl) {
        this.stylesTable = stylesTable;
        this.sharedStringsTable = xeniReadOnlySharedStringsTable;
        this.output = parsedContentsHandler;
        this.formulasNotResults = bl;
        this.nextDataType = xssfDataType.NUMBER;
        this.formatter = xeniDataFormatter;
    }

    public XSSFEventModelHandler(StylesTable stylesTable, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, ParsedContentsHandler parsedContentsHandler, boolean bl) {
        this(stylesTable, xeniReadOnlySharedStringsTable, parsedContentsHandler, new XeniDataFormatter(), bl);
    }

    private boolean isTextTag(String string) {
        if (this.TAG_CONTENTS.equals(string)) {
            return true;
        }
        this.getClass();
        if ("inlineStr".equals(string)) {
            return true;
        }
        this.getClass();
        return "t".equals(string) && this.isIsOpen;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.TAG_DIMENSION.equals(string2)) {
            String string4 = attributes.getValue(this.ATTR_REF);
            if (this.output != null) {
                this.output.dimension(string4);
            }
            this.setDimension(string4);
        } else if (this.isTextTag(string2)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if (this.TAG_INLINEOUTER.equals(string2)) {
            this.isIsOpen = true;
        } else if (this.TAG_FORMULA.equals(string2)) {
            this.formula.setLength(0);
            if (this.nextDataType == xssfDataType.NUMBER) {
                this.nextDataType = xssfDataType.FORMULA;
            }
            this.getClass();
            String string5 = attributes.getValue("t");
            if (string5 != null && this.TYPE_SHARED.equals(string5)) {
                String string6 = attributes.getValue(this.ATTR_REF);
                String string7 = attributes.getValue(this.ATTR_SHARED);
                if (string6 != null) {
                    this.fIsOpen = true;
                } else if (this.formulasNotResults && logger.isErrorEnabled()) {
                    logger.error((Object)"Warning - shared formulas not yet supported!");
                }
            } else {
                this.fIsOpen = true;
            }
        } else if (this.TAG_ODDHEADER.equals(string2) || this.TAG_EVENHEADER.equals(string2) || this.TAG_FIRSTHEADER.equals(string2) || this.TAG_FIRSTFOOTER.equals(string2) || this.TAG_ODDFOOTER.equals(string2) || this.TAG_EVENFOOTER.equals(string2)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if (this.TAG_ROW.equals(string2)) {
            int n = Integer.parseInt(attributes.getValue(this.ATTR_REF_ROW)) - 1;
            if (this.output != null) {
                this.output.rowStart(n);
            }
            this.setStartRowIndex(n);
        } else if (this.TAG_CELL.equals(string2)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            this.cellRef = attributes.getValue(this.ATTR_REF_ROW);
            this.getClass();
            String string8 = attributes.getValue("t");
            this.getClass();
            String string9 = attributes.getValue("s");
            if (this.TYPE_BOOLEAN.equals(string8)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if (this.TYPE_ERROR.equals(string8)) {
                this.nextDataType = xssfDataType.ERROR;
            } else {
                this.getClass();
                if ("inlineStr".equals(string8)) {
                    this.nextDataType = xssfDataType.INLINE_STRING;
                } else {
                    this.getClass();
                    if ("s".equals(string8)) {
                        this.nextDataType = xssfDataType.SST_STRING;
                    } else if (this.TYPE_FORMULA.equals(string8)) {
                        this.nextDataType = xssfDataType.FORMULA;
                    } else if (string9 != null) {
                        int n = Integer.parseInt(string9);
                        XSSFCellStyle xSSFCellStyle = this.stylesTable.getStyleAt(n);
                        if (xSSFCellStyle != null) {
                            this.formatIndex = xSSFCellStyle.getDataFormat();
                            this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, this.numberFmtLang) : xSSFCellStyle.getDataFormatString();
                        }
                        if (this.formatString == null) {
                            this.formatString = XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, this.numberFmtLang);
                        }
                    }
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = null;
        if (this.isTextTag(string2)) {
            this.vIsOpen = false;
            switch (this.nextDataType) {
                case BOOLEAN: {
                    char c = this.value.charAt(0);
                    string4 = c == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    string4 = "ERROR:" + this.value.toString();
                }
                case FORMULA: {
                    if (this.formulasNotResults) {
                        string4 = this.formula.toString();
                        break;
                    }
                    string4 = this.value.toString();
                    if (this.bRawNumValue) break;
                    double d = Double.parseDouble(string4);
                    string4 = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.bRawDateValue, this.bRawNumValue);
                    string4 = string4.replaceAll("[\"*? ]", "");
                    break;
                }
                case INLINE_STRING: {
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.value.toString());
                    string4 = xSSFRichTextString.toString();
                    break;
                }
                case SST_STRING: {
                    String string5 = this.value.toString();
                    try {
                        int n = Integer.parseInt(string5);
                        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(n));
                        string4 = xSSFRichTextString.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!logger.isErrorEnabled()) break;
                        logger.error((Object)("Failed to parse SST index '" + string5 + "': " + numberFormatException.toString()));
                    }
                    break;
                }
                case NUMBER: {
                    double d = Double.parseDouble(this.value.toString());
                    string4 = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.bRawDateValue, this.bRawNumValue);
                    string4 = string4.replaceAll("[\"*? ]", "");
                    break;
                }
                default: {
                    string4 = "(Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            if (this.output != null) {
                this.output.cell(this.cellRef, string4);
            }
            this.setCellValue(this.cellRef, string4);
        } else if (this.TAG_FORMULA.equals(string2)) {
            this.fIsOpen = false;
        } else if (this.TAG_INLINEOUTER.equals(string2)) {
            this.isIsOpen = false;
        } else if (this.TAG_ROW.equals(string2)) {
            if (this.output != null) {
                this.output.rowEnd();
            }
            this.setEndRow();
        } else if (this.TAG_ODDHEADER.equals(string2) || this.TAG_EVENHEADER.equals(string2) || this.TAG_FIRSTHEADER.equals(string2)) {
            this.hfIsOpen = false;
            if (this.output != null) {
                this.output.headerFooter(this.headerFooter.toString(), true, string2);
            }
            this.setHeaderFooter(this.headerFooter.toString(), true, string2);
        } else if (this.TAG_ODDFOOTER.equals(string2) || this.TAG_EVENFOOTER.equals(string2) || this.TAG_FIRSTFOOTER.equals(string2)) {
            this.hfIsOpen = false;
            if (this.output != null) {
                this.output.headerFooter(this.headerFooter.toString(), false, string2);
            }
            this.setHeaderFooter(this.headerFooter.toString(), false, string2);
        } else if (this.TAG_CELL.equals(string2)) {
            if (this.bDsHeader && this.value.length() <= 0) {
                this.setCellValue(this.cellRef, null);
            }
            this.value.setLength(0);
        } else if (this.TAG_SHEETDATA.equals(string2)) {
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(cArray, n, n2);
        }
        if (this.fIsOpen) {
            this.formula.append(cArray, n, n2);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(cArray, n, n2);
        }
    }

    private void setDimension(String string) throws SAXException {
        int[] nArray = new int[]{-1, -1};
        int[] nArray2 = new int[]{-1, -1};
        String[] stringArray = string.split("\\:");
        CommUtil.getRangeIndex(stringArray[0], nArray);
        if (stringArray.length > 1) {
            CommUtil.getRangeIndex(stringArray[1], nArray2);
        } else if (stringArray.length == 1) {
            CommUtil.getRangeIndex(stringArray[0], nArray2);
        }
        if (this.bDsHeader && this.nStartRange[0] < 0 && this.nStartRange[1] < 0 && this.nEndRange[0] < 0 && this.nEndRange[1] < 0) {
            for (int i = 0; i <= nArray2[0] - nArray[0]; ++i) {
                this.dsResult.addColumn("Column" + i, 2, 256);
            }
            this.bHeadRange = false;
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
        this.nStartCol = this.nStartRange[0] < 0 ? nArray[0] : this.nStartRange[0];
        this.nStartRow = this.nStartRange[1] < 0 ? nArray[1] : this.nStartRange[1];
        this.nEndCol = this.nEndRange[0] < 0 ? nArray2[0] : this.nEndRange[0];
        int n = this.nEndRow = this.nEndRange[1] < 0 ? nArray2[1] : this.nEndRange[1];
        if (this.bMinRange) {
            if (this.nEndRange[0] > 0 && this.nEndRange[0] > nArray2[0]) {
                this.nEndCol = nArray2[0];
            }
            if (this.nEndRange[1] > 0 && this.nEndRange[1] > nArray2[1]) {
                this.nEndRow = nArray2[1];
            }
        }
        if (!this.bDsHeader) {
            for (int i = 0; i <= this.nEndRow - this.nStartRow; ++i) {
                this.dsResult.newRow();
            }
        }
    }

    private void setStartRowIndex(int n) {
        this.nPreColIndex = 0;
        this.nCurrRow = n;
    }

    private void setEndRow() {
        this.nCurrRow = -1;
    }

    private void setCellValue(String string, String string2) throws SAXException {
        if (this.keywords != null) {
            for (int i = 0; i < this.keywords.length; ++i) {
                if (!string2.contains(this.keywords[i])) continue;
                throw new SAXException("Invalid value [ " + string + " ]");
            }
        }
        if (!this.bHeadRange) {
            return;
        }
        if (this.nCurrRow < 0 || this.nCurrRow < this.nStartRow) {
            return;
        }
        if (this.nCurrRow > this.nEndRow) {
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
        int[] nArray = new int[]{-1, -1};
        CommUtil.getRangeIndex(this.cellRef, nArray);
        if (nArray[0] >= this.nStartCol && nArray[0] <= this.nEndCol) {
            if (this.bDsHeader) {
                int n = nArray[0] - this.nPreColIndex;
                this.nPreColIndex = nArray[0];
                if (this.nCurrDsCol == 0 && n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (i < this.nStartCol || i > this.nEndCol) continue;
                        this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                        ++this.nCurrDsCol;
                    }
                } else if (this.nCurrDsCol != 0 && n > 1) {
                    for (int i = 1; i < n; ++i) {
                        this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                        ++this.nCurrDsCol;
                    }
                }
                if (string2 == null || "".equals(string2)) {
                    this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                } else {
                    this.dsResult.addColumn(string2, 2, 256);
                }
                ++this.nCurrDsCol;
            } else if (string2 != null) {
                this.dsResult.set(nArray[1] - this.nStartRow, nArray[0] - this.nStartCol, string2);
            }
        }
    }

    private void setHeaderFooter(String string, boolean bl, String string2) {
    }

    public static interface ParsedContentsHandler {
        public void rowStart(int var1);

        public void rowEnd();

        public void cell(String var1, String var2);

        public void headerFooter(String var1, boolean var2, String var3);

        public void dimension(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

