/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeniapi.export.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xeni.data.ExportData;
import com.nexacro.xeni.data.ExportDataFactory;
import com.nexacro.xeni.data.exportformats.ExportFormat;
import com.nexacro.xeni.data.exportformats.FormatCell;
import com.nexacro.xeni.data.exportformats.FormatColumn;
import com.nexacro.xeni.data.exportformats.FormatRow;
import com.nexacro.xeni.export.impl.GridCellStyleInfo;
import com.nexacro.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.xeni.manager.ExportImportFileManager;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.util.XeniExtendBase;
import com.nexacro.xeni.util.XeniExtendFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GridExportExcel {
    private String sErrMessage = "";
    private String sExportFileUrl = "";
    private String sExportFilePath = "";
    private int nStartRow = 0;
    private int nStartCol = 0;
    private int nRowCntAll = 0;
    private int nAddedRow = 0;
    private int nNextExlRowIdx = 0;
    private String sSheetName;
    private String sInstanceId = null;
    private DataSet dsCommand = null;
    private DataSet dsStyle = null;
    private DataSet dsCell = null;
    private boolean bSetWidth = true;
    private boolean bSetHeight = false;
    private boolean bNoHead = true;
    private boolean bNoSummary = true;
    private DataSet dsCmd = null;
    private ExportData objExportData = null;
    private int iRunPeriodMinute = 1;
    private int iStorageTimeMinute = 1;
    private final int nMax2003 = 65536;
    private final int nMax2007 = 0x100000;
    private final int nMaxHcell = 0x100000;
    private static final Log objLogger = LogFactory.getLog(GridExportExcel.class);
    private boolean bIsExcel2007 = false;
    private char cGS = (char)29;
    private Workbook objWorkbook = null;
    private ExportFormat objGridFmt = null;
    private GridCellStyleInfo objStyleInfo = null;
    Drawing objDrawing = null;
    private HashMap<String, Integer> objPictures = new HashMap();

    public GridExportExcel() {
        this.dsCommand = new DataSet("COMMAND");
        this.dsStyle = new DataSet("STYLE");
        this.dsCell = new DataSet("CELL");
    }

    public GridExportExcel(ExportData exportData, int n, int n2) {
        this.objExportData = exportData;
        this.iRunPeriodMinute = n;
        this.iStorageTimeMinute = n2;
    }

    private void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (objLogger.isInfoEnabled()) {
            objLogger.info((Object)string);
        }
    }

    public void setExportType(String string) {
    }

    public String getExportFileUrl() {
        return this.sExportFileUrl;
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    public void setExportFilePath(String string, String string2, boolean bl) {
        this.sExportFilePath = string;
        this.sExportFileUrl = string2;
        if (bl) {
            this.enableFileMonitor(string, this.iRunPeriodMinute, this.iStorageTimeMinute);
        }
    }

    private void enableFileMonitor(String string, int n, int n2) {
        ExportImportFileManager exportImportFileManager = ExportImportFileManager.getInstance();
        Timer timer = exportImportFileManager.getTimer();
        if (timer == null) {
            timer = exportImportFileManager.newTimerInstance();
            exportImportFileManager.setServiceDir(string, true);
            timer.scheduleAtFixedRate((TimerTask)exportImportFileManager, n * 60 * 1000, (long)(n * 60 * 1000));
        }
    }

    public int createWorkbook() {
        return this.createWorkbook(false);
    }

    public void receiveExportData(DataSetList dataSetList) {
        HashMap<String, ExportData> hashMap;
        this.dsCommand = dataSetList.get("COMMAND");
        this.dsStyle = dataSetList.get("STYLE");
        this.dsCell = dataSetList.get("CELL");
        this.sInstanceId = this.dsCommand.getString(0, "instanceid");
        if (this.sInstanceId == null || this.sInstanceId.equals("")) {
            this.sInstanceId = CommUtil.generateSerialNo();
        }
        if ((hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory()).containsKey(this.sInstanceId)) {
            this.objExportData = hashMap.get(this.sInstanceId);
            this.objExportData.setCmdDataset(this.dsCommand);
            this.objExportData.setStyleDataset(this.dsStyle);
            this.objExportData.setCellDataset(this.dsCell);
        } else {
            this.dsCommand.set(0, "instanceid", this.sInstanceId);
            this.objExportData = new ExportData();
            this.objExportData.setCmdDataset(this.dsCommand);
            this.objExportData.setStyleDataset(this.dsStyle);
            this.objExportData.setCellDataset(this.dsCell);
            String string = this.dsCommand.getString(0, "url");
            if (string != null && string.length() > 0) {
                this.objExportData.setAppendExport(string);
            }
            hashMap.put(this.sInstanceId, this.objExportData);
        }
        this.objExportData.setLastAccTime(System.currentTimeMillis());
    }

    public boolean isLastExportData() {
        return this.dsCommand.getBoolean(0, "eof");
    }

    public int executeExport(VariableList variableList, boolean bl, HttpServletResponse httpServletResponse) {
        int n = 0;
        if (this.objExportData == null) {
            this.setErrorMessage("Export data is null.");
            return -2010;
        }
        DataSet dataSet = this.objExportData.getCmdDataset();
        DataSet dataSet2 = this.objExportData.getStyleDataset();
        DataSet dataSet3 = this.objExportData.getCellDataset();
        this.objGridFmt = this.objExportData.getGridFormat();
        if (dataSet == null || dataSet2 == null || dataSet3 == null || this.objGridFmt == null) {
            this.setErrorMessage("Dataset is null. \nFILENAME : " + (dataSet == null ? "null" : dataSet.getString(0, "exportfilename")) + "\n" + "COMMAND : " + (dataSet == null ? "null" : dataSet.toString()) + "\n" + "STYLE : " + (dataSet2 == null ? "null" : dataSet2.toString()) + "\n" + "CELL : " + (dataSet3 == null ? "null" : dataSet3.toString()) + "\n" + "FORMAT : " + (this.objGridFmt == null ? "null" : this.objGridFmt.toString()));
            return -2011;
        }
        int n2 = dataSet.getInt(0, "type");
        this.bIsExcel2007 = n2 == 288 || n2 == 1040;
        String string = dataSet.getString(0, "range");
        string = string == null || string.equals("") ? "Sheet" : this.getRangInfo(string);
        String string2 = dataSet.getString(0, "exporthead");
        boolean bl2 = string2.contains("nohead");
        boolean bl3 = string2.contains("nosumm");
        String string3 = dataSet.getString(0, "summarytype");
        boolean bl4 = false;
        if ("top".equals(string3)) {
            bl4 = true;
        }
        int n3 = dataSet3.getRowCount();
        int n4 = this.nStartRow + this.objGridFmt.getRowCountOfEachBand("body") * n3;
        if (!bl2) {
            n4 += this.objGridFmt.getRowCountOfEachBand("head");
        }
        if (!bl3) {
            n4 += this.objGridFmt.getRowCountOfEachBand("summ");
        }
        int n5 = 0;
        int n6 = 1;
        n5 = this.bIsExcel2007 ? 0x100000 : (n2 == 1024 || n2 == 1040 ? 0x100000 : 65536);
        if (n4 >= n5) {
            n6 = n4 / n5;
            if (n4 % n5 > 0) {
                ++n6;
            }
        }
        String string4 = dataSet.getString(0, "exportsize");
        boolean bl5 = true;
        boolean bl6 = false;
        if (string4.equals("both")) {
            bl6 = true;
        } else if (string4.equals("height")) {
            bl5 = false;
            bl6 = true;
        }
        n = this.makeExportFilePath(dataSet, bl);
        if (n < 0) {
            this.setErrorMessage("Fail to create export file path.");
            return n;
        }
        this.objWorkbook = this.createExcelWorkbook();
        if (this.objWorkbook == null) {
            this.setErrorMessage("Fail to create workbook!");
            return -2012;
        }
        boolean bl7 = true;
        if (dataSet.containsColumn("wraptext")) {
            bl7 = dataSet.getBoolean(0, "wraptext");
        }
        this.objStyleInfo = new GridCellStyleInfo();
        n = this.objStyleInfo.getStyleInfo(this.objWorkbook, dataSet2, this.bIsExcel2007, bl7, this.objExportData.isAppendExport());
        if (n < 0) {
            this.setErrorMessage(this.objStyleInfo.getErrorMessage());
            return n;
        }
        if (n6 == 1) {
            Sheet sheet = null;
            if (this.objExportData.isAppendExport()) {
                sheet = this.objWorkbook.getSheet(string);
            }
            if (sheet == null) {
                sheet = this.objWorkbook.createSheet(string);
            }
            if (bl5) {
                this.setColumnLayout(sheet);
            }
            int n7 = 0;
            int n8 = this.nStartRow;
            if (!bl2) {
                n7 = this.createEachBandLayout(sheet, "head", n8, bl6);
                if (n7 > 0 && (n = this.setHead(sheet, n8)) < 0) {
                    return n;
                }
                n8 += n7;
            }
            this.objDrawing = sheet.createDrawingPatriarch();
            if (bl4 && !bl3) {
                n7 = this.createEachBandLayout(sheet, "summ", n8, bl6);
                if (n7 > 0 && (n = this.setSummary(sheet, n8)) < 0) {
                    return n;
                }
                n8 += n7;
            }
            for (int i = 0; i < n3; ++i) {
                n7 = this.createEachBandLayout(sheet, "body", n8, bl6);
                n = this.setBody(sheet, dataSet3, i, n8);
                if (n < 0) {
                    return n;
                }
                n8 += n7;
            }
            if (!bl4 && !bl3) {
                n7 = this.createEachBandLayout(sheet, "summ", n8, bl6);
                if (n7 > 0 && (n = this.setSummary(sheet, n8)) < 0) {
                    return n;
                }
                n8 += n7;
            }
            this.UpdateDimension(sheet, string, this.nStartCol, this.nStartRow + 1, this.objGridFmt.getColumnCount() - 1 + this.nStartCol, n8);
        } else {
            n = this.createMultiSheet(dataSet3, string, n6, bl2, bl3, bl5, bl6, n5, bl4);
            if (n < 0) {
                return n;
            }
        }
        n = this.saveExportFile(variableList, dataSet, httpServletResponse);
        return n;
    }

    public DataSet getResponseCommand() {
        return CommUtil.getDatasetExportResponse(this.objExportData.getCmdDataset());
    }

    public int createWorkbook(boolean bl) {
        String string;
        int n = 0;
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        this.objExportData = hashMap.get(this.sInstanceId);
        if (this.objExportData == null) {
            this.setErrorMessage("Export data is null.");
            return -2010;
        }
        this.dsCmd = this.objExportData.getCmdDataset();
        DataSet dataSet = this.objExportData.getStyleDataset();
        this.objGridFmt = this.objExportData.getGridFormat();
        if (this.dsCmd == null || dataSet == null || this.objGridFmt == null) {
            this.setErrorMessage("Dataset is null. \nFILENAME : " + (this.dsCmd == null ? "null" : this.dsCmd.getString(0, "exportfilename")) + "\n" + "COMMAND : " + (this.dsCmd == null ? "null" : this.dsCmd.toString()) + "\n" + "STYLE : " + (dataSet == null ? "null" : dataSet.toString()) + "\n" + "FORMAT : " + (this.objGridFmt == null ? "null" : this.objGridFmt.toString()));
            return -2011;
        }
        this.bIsExcel2007 = true;
        this.sSheetName = this.dsCmd.getString(0, "range");
        this.sSheetName = this.sSheetName == null || this.sSheetName.equals("") ? "Sheet" : this.getRangInfo(this.sSheetName);
        String string2 = this.dsCmd.getString(0, "exporthead");
        this.bNoHead = string2.contains("nohead");
        this.bNoSummary = string2.contains("nosumm");
        this.nRowCntAll = this.nStartRow + this.objGridFmt.getRowCountOfEachBand("body");
        if (!this.bNoHead) {
            this.nRowCntAll += this.objGridFmt.getRowCountOfEachBand("head");
        }
        if (!this.bNoSummary) {
            this.nRowCntAll += this.objGridFmt.getRowCountOfEachBand("summ");
        }
        int n2 = 0;
        int n3 = 1;
        if (this.bIsExcel2007) {
            n2 = 0x100000;
        }
        if (this.nRowCntAll >= n2) {
            n3 = this.nRowCntAll / n2;
            if (this.nRowCntAll % n2 > 0) {
                ++n3;
            }
        }
        if ((string = this.dsCmd.getString(0, "exportsize")).equals("both")) {
            this.bSetHeight = true;
        } else if (string.equals("height")) {
            this.bSetWidth = false;
            this.bSetHeight = true;
        }
        n = this.makeExportFilePath(this.dsCmd, bl);
        if (n < 0) {
            this.setErrorMessage("Fail to create export file path.");
            return n;
        }
        this.objWorkbook = new SXSSFWorkbook(100);
        if (this.objWorkbook == null) {
            this.setErrorMessage("Fail to create workbook!");
            return -2012;
        }
        boolean bl2 = true;
        if (this.dsCmd.containsColumn("wraptext")) {
            bl2 = this.dsCmd.getBoolean(0, "wraptext");
        }
        this.objStyleInfo = new GridCellStyleInfo();
        n = this.objStyleInfo.getStyleInfo(this.objWorkbook, dataSet, this.bIsExcel2007, bl2, this.objExportData.isAppendExport());
        if (n < 0) {
            this.setErrorMessage(this.objStyleInfo.getErrorMessage());
            return n;
        }
        if (n3 == 1) {
            Sheet sheet = null;
            if (this.objExportData.isAppendExport()) {
                sheet = this.objWorkbook.getSheet(this.sSheetName);
            }
            if (sheet == null) {
                sheet = this.objWorkbook.createSheet(this.sSheetName);
            }
            if (this.bSetWidth) {
                this.setColumnLayout(sheet);
            }
            this.nNextExlRowIdx = this.nStartRow;
            if (!this.bNoHead) {
                this.nAddedRow = this.createEachBandLayout(sheet, "head", this.nNextExlRowIdx, this.bSetHeight);
                if (this.nAddedRow > 0 && (n = this.setHead(sheet, this.nNextExlRowIdx)) < 0) {
                    return n;
                }
                this.nNextExlRowIdx += this.nAddedRow;
            }
            this.objDrawing = sheet.createDrawingPatriarch();
        } else {
            n = this.createMultiSheetHead(this.sSheetName, n3, this.bNoHead, this.bNoSummary, this.bSetWidth, this.bSetHeight, n2);
            if (n < 0) {
                return n;
            }
        }
        return n;
    }

    public int appendBody(DataSet dataSet) {
        int n = 0;
        if (this.objWorkbook == null) {
            this.setErrorMessage("Fail to create workbook!");
            return -2012;
        }
        Sheet sheet = this.objWorkbook.getSheet(this.sSheetName);
        if (dataSet == null) {
            this.setErrorMessage("Dataset is null. \nCELL : " + (dataSet == null ? "null" : dataSet.toString()) + "\n");
            return -2011;
        }
        this.nRowCntAll += dataSet.getRowCount();
        int n2 = 0;
        int n3 = 1;
        if (this.bIsExcel2007) {
            n2 = 0x100000;
        }
        if (this.nRowCntAll >= n2) {
            n3 = this.nRowCntAll / n2;
            if (this.nRowCntAll % n2 > 0) {
                ++n3;
            }
        }
        if (n3 == 1) {
            int n4 = dataSet.getRowCount();
            for (int i = 0; i < n4; ++i) {
                this.nAddedRow = this.createEachBandLayout(sheet, "body", this.nNextExlRowIdx, this.bSetHeight);
                n = this.setBody(sheet, dataSet, i, this.nNextExlRowIdx);
                if (n < 0) {
                    return n;
                }
                this.nNextExlRowIdx += this.nAddedRow;
            }
            if (!this.bNoSummary) {
                this.nAddedRow = this.createEachBandLayout(sheet, "summ", this.nNextExlRowIdx, this.bSetHeight);
                if (this.nAddedRow > 0 && (n = this.setSummary(sheet, this.nNextExlRowIdx)) < 0) {
                    return n;
                }
                this.nNextExlRowIdx += this.nAddedRow;
            }
            this.UpdateDimension(sheet, this.sSheetName, this.nStartCol, this.nStartRow + 1, this.objGridFmt.getColumnCount() - 1 + this.nStartCol, this.nNextExlRowIdx);
        } else {
            n = this.createMultiSheetBody(dataSet, this.sSheetName, n3, this.bNoHead, this.bNoSummary, this.bSetWidth, this.bSetHeight, n2);
            if (n < 0) {
                return n;
            }
        }
        return n;
    }

    public int disposeWorkbook(VariableList variableList, HttpServletResponse httpServletResponse) {
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        hashMap.remove(this.sInstanceId);
        return this.saveExportFile(variableList, this.dsCmd, httpServletResponse);
    }

    public DataSet disposeWorkbook(VariableList variableList) {
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        hashMap.remove(this.sInstanceId);
        return this.saveExportFile(variableList, this.dsCmd);
    }

    public DataSet disposeWorkbook() {
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        hashMap.remove(this.sInstanceId);
        return this.saveExportFile(null, this.dsCmd);
    }

    private String getRangInfo(String string) {
        this.nStartCol = 0;
        this.nStartRow = 0;
        String string2 = string;
        String[] stringArray = string2.split("\\!");
        if (stringArray.length == 1) {
            return string2;
        }
        int[] nArray = new int[]{0, 0};
        CommUtil.getRangeIndex(stringArray[1], nArray);
        this.nStartCol = nArray[0];
        this.nStartRow = nArray[1];
        return stringArray[0].length() < 1 ? "Sheet" : stringArray[0];
    }

    private int makeExportFilePath(DataSet dataSet, boolean bl) {
        try {
            if (!this.objExportData.isAppendExport()) {
                String string = dataSet.getString(0, "instanceid");
                String string2 = dataSet.getString(0, "exportfilename");
                if (!(string2 != null && string2.length() >= 1 || (string2 = dataSet.getString(0, "item")) != null && string2.length() >= 1)) {
                    string2 = "TEMP";
                }
                int n = dataSet.getInt(0, "type");
                String string3 = string2;
                int n2 = 0;
                if (n == 1024) {
                    string3 = string3 + ".cell";
                    n2 = 2;
                } else if (n == 1040) {
                    string3 = string3 + ".cell";
                    n2 = 3;
                } else {
                    string3 = string3 + ".xls";
                    if (this.bIsExcel2007) {
                        string3 = string3 + "x";
                        n2 = 1;
                    }
                }
                this.sExportFilePath = this.sExportFilePath + string + "/" + string3;
                this.sExportFileUrl = bl ? this.sExportFileUrl + "?command=export" + "&key=" + string + "&name=" + URLEncoder.encode(string2, "UTF-8") + "&type=" + n2 : this.sExportFileUrl + string + "/" + string3;
            } else {
                String string;
                this.sExportFileUrl = string = this.objExportData.getAppendExportUrl();
                if (bl) {
                    int n = string.indexOf("key=");
                    String string4 = string.substring(n + 4, string.indexOf(38, n));
                    n = string.indexOf("name=", n);
                    String string5 = string.substring(n + 5, string.indexOf(38, n));
                    string5 = URLDecoder.decode(string5, "UTF-8");
                    n = string.indexOf("type=", n);
                    int n3 = Integer.parseInt(string.substring(n + 5));
                    String string6 = ".xls";
                    if (n3 == 1) {
                        string6 = ".xlsx";
                    } else if (n3 == 2) {
                        string6 = ".cell";
                    }
                    this.sExportFilePath = this.sExportFilePath + string4 + "/" + string5 + string6;
                } else {
                    int n = string.lastIndexOf("/");
                    String string7 = string.substring(n);
                    String string8 = string.substring(0, n);
                    this.sExportFilePath = this.sExportFilePath + string8.substring(string8.lastIndexOf("/")) + string7;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -2012;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook createExcelWorkbook() {
        Object object = null;
        if (this.objExportData.isAppendExport()) {
            InputStream inputStream = null;
            try {
                XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
                inputStream = xeniExtendBase.loadTargetStream(this.sExportFilePath);
                if (!this.bIsExcel2007) {
                    object = WorkbookFactory.create((InputStream)inputStream);
                }
                Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
                object = new SXSSFWorkbook((XSSFWorkbook)workbook, 100);
            }
            catch (InvalidFormatException invalidFormatException) {
                this.setErrorMessage(invalidFormatException.getMessage());
            }
            catch (IOException iOException) {
                this.setErrorMessage(iOException.getMessage());
            }
            catch (Exception exception) {
                this.setErrorMessage(exception + "");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        } else {
            object = !this.bIsExcel2007 ? new HSSFWorkbook() : new SXSSFWorkbook(100);
        }
        return object;
    }

    private void setColumnLayout(Sheet sheet) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.objGridFmt.getColumnCount(); ++i) {
            FormatColumn formatColumn = this.objGridFmt.getColumn(i);
            if (formatColumn == null) continue;
            n = Integer.parseInt(formatColumn.getSize());
            n2 = this.bIsExcel2007 ? n * 32 : n * 36;
            sheet.setColumnWidth(this.nStartCol + i, n2);
        }
    }

    private int createEachBandLayout(Sheet sheet, String string, int n, boolean bl) {
        int n2 = this.objGridFmt.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.objGridFmt.getRowCount(); ++i) {
            FormatRow formatRow = this.objGridFmt.getRow(i);
            if (!formatRow.getBand().equals(string)) continue;
            Row row = sheet.createRow(n + n3);
            if (bl) {
                n4 = Integer.parseInt(formatRow.getSize());
                row.setHeight((short)(n4 * 15));
            }
            for (int j = 0; j < n2; ++j) {
                row.createCell(j + this.nStartCol);
            }
            ++n3;
        }
        return n3;
    }

    private int setHead(Sheet sheet, int n) {
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        for (int i = 0; i < this.objGridFmt.getHeadCellCount(); ++i) {
            formatCell = this.objGridFmt.getHeadCell(i);
            Cell cell = this.getCellInExcel(sheet, formatCell, n);
            if (cell == null) {
                return -2015;
            }
            cellStyle = this.setStyleText(formatCell, cell);
            this.setMergeCell(sheet, formatCell, cell, cellStyle);
        }
        return 0;
    }

    private String findBindColumnNameInCelltext(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        if (string.startsWith("bind:")) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string2;
    }

    private int setBody(Sheet sheet, DataSet dataSet, int n, int n2) {
        int n3 = 0;
        int n4 = this.objGridFmt.getBodyCellCount();
        String string = "";
        String string2 = "";
        String string3 = "";
        GridCellStyleInfoExt gridCellStyleInfoExt = null;
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        for (int i = 0; i < n4; ++i) {
            formatCell = this.objGridFmt.getBodyCell(i);
            Cell cell = this.getCellInExcel(sheet, formatCell, n2);
            if (cell == null) {
                return -2015;
            }
            string = "";
            string2 = "";
            String string4 = this.findBindColumnNameInCelltext(formatCell.getText());
            string3 = dataSet.getString(n, string4);
            if (string3 != null && string3.length() > 0) {
                String[] stringArray = string3.split(String.valueOf(this.cGS));
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j == 0) {
                        string = stringArray[0];
                        continue;
                    }
                    if (j != 1) continue;
                    string2 = stringArray[1];
                }
            }
            if ((gridCellStyleInfoExt = this.getBodyCellStyle(cell, formatCell, string2, n)) != null && (cellStyle = this.objWorkbook.getCellStyleAt(gridCellStyleInfoExt.getStyleIndex())) != null) {
                cell.setCellStyle(cellStyle);
            }
            n3 = this.setBodyCellValue(cell, string, gridCellStyleInfoExt);
            this.setMergeCell(sheet, formatCell, cell, cellStyle);
            this.setSuppressCell(sheet, cell, gridCellStyleInfoExt);
        }
        return n3;
    }

    private GridCellStyleInfoExt getBodyCellStyle(Cell cell, FormatCell formatCell, String string, int n) {
        GridCellStyleInfoExt gridCellStyleInfoExt = null;
        gridCellStyleInfoExt = this.objStyleInfo.getCellStyle(string);
        if (gridCellStyleInfoExt == null) {
            String string2 = "";
            String string3 = formatCell.getStyle2();
            string2 = string3 != null && string3.length() > 0 ? (n % 2 == 0 ? formatCell.getStyle1() : formatCell.getStyle2()) : formatCell.getStyle1();
            gridCellStyleInfoExt = this.objStyleInfo.getCellStyle(string2);
        }
        return gridCellStyleInfoExt;
    }

    private int setBodyCellValue(Cell cell, String string, GridCellStyleInfoExt gridCellStyleInfoExt) {
        if (string.length() > 0) {
            if (gridCellStyleInfoExt.isImageData()) {
                this.setCellImage(cell, string);
            } else {
                int n = gridCellStyleInfoExt.getDataType();
                if (n == 1) {
                    if ((string = string.replaceAll("\\,|\\%", "")).matches("^\\d+\\.\\d+") && gridCellStyleInfoExt.getDataFormat() == null) {
                        this.setStyleDoubleFormat(cell, gridCellStyleInfoExt);
                    }
                    try {
                        double d = Double.parseDouble(string);
                        if (gridCellStyleInfoExt.isbPercentage()) {
                            d /= 100.0;
                        }
                        cell.setCellValue(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        CreationHelper creationHelper = this.objWorkbook.getCreationHelper();
                        RichTextString richTextString = creationHelper.createRichTextString(string);
                        cell.setCellValue(richTextString);
                    }
                } else if (n == 2) {
                    Date date = null;
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gridCellStyleInfoExt.getDataFormat());
                        date = simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        this.setErrorMessage(parseException.getMessage());
                        return -2001;
                    }
                    cell.setCellValue(date);
                } else {
                    if (n == 0 && string.charAt(0) == '=') {
                        cell.setCellFormula(string.substring(1));
                        return 0;
                    }
                    CreationHelper creationHelper = this.objWorkbook.getCreationHelper();
                    RichTextString richTextString = creationHelper.createRichTextString(string);
                    cell.setCellValue(richTextString);
                }
            }
        }
        return 0;
    }

    private void setStyleDoubleFormat(Cell cell, GridCellStyleInfoExt gridCellStyleInfoExt) {
        CellStyle cellStyle = null;
        String string = gridCellStyleInfoExt.getStyleName();
        GridCellStyleInfoExt gridCellStyleInfoExt2 = this.objStyleInfo.getCellStyle(string + "dbl");
        if (gridCellStyleInfoExt2 == null) {
            cellStyle = this.objWorkbook.createCellStyle();
            CellStyle cellStyle2 = this.objWorkbook.getCellStyleAt(gridCellStyleInfoExt.getStyleIndex());
            cellStyle.cloneStyleFrom(cellStyle2);
            cellStyle.setDataFormat(this.objWorkbook.createDataFormat().getFormat("#,##0.0#####################"));
            this.objStyleInfo.appendStyle(string + "dbl", cellStyle.getIndex(), gridCellStyleInfoExt.getDataType(), gridCellStyleInfoExt.getDataFormat(), gridCellStyleInfoExt.isImageData());
        } else {
            cellStyle = this.objWorkbook.getCellStyleAt(gridCellStyleInfoExt2.getStyleIndex());
        }
        cell.setCellStyle(cellStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setCellImage(Cell cell, String string) {
        URLConnection uRLConnection = null;
        DataInputStream dataInputStream = null;
        int n = -1;
        try {
            URL uRL;
            if (!string.trim().startsWith("http")) {
                return false;
            }
            if (this.objPictures.containsKey(string)) {
                n = this.objPictures.get(string);
            } else {
                uRL = new URL(string);
                uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(5000);
                uRLConnection.connect();
                dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                byte[] byArray = IOUtils.toByteArray((InputStream)dataInputStream);
                int n2 = -1;
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                n2 = string2.toUpperCase().equals("DIB") ? 7 : (string2.toUpperCase().equals("EMF") ? 2 : (string2.toUpperCase().equals("JPEG") || string2.toUpperCase().equals("JPG") ? 5 : (string2.toUpperCase().equals("PICT") ? 4 : (string2.toUpperCase().equals("PNG") ? 6 : (string2.toUpperCase().equals("WMF") ? 3 : 6)))));
                n = this.objWorkbook.addPicture(byArray, n2);
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        this.setErrorMessage(iOException.getMessage());
                        return false;
                    }
                }
                this.objPictures.put(string, n);
            }
            if (n < 0) return true;
            uRL = this.objWorkbook.getCreationHelper();
            this.setPicture((CreationHelper)uRL, cell, n, string);
            return true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.setErrorMessage(socketTimeoutException.getMessage() + "\n> " + string);
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(malformedURLException.getMessage() + "\n> " + string);
            return false;
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage() + "\n> " + string);
            return false;
        }
    }

    private void setPicture(CreationHelper creationHelper, Cell cell, int n, String string) {
        block8: {
            try {
                int n2;
                CellStyle cellStyle;
                ClientAnchor clientAnchor = creationHelper.createClientAnchor();
                clientAnchor.setAnchorType(0);
                clientAnchor.setCol1(cell.getColumnIndex());
                clientAnchor.setRow1(cell.getRowIndex());
                Picture picture = this.objDrawing.createPicture(clientAnchor, n);
                ClientAnchor clientAnchor2 = picture.getPreferredSize();
                short s = cell.getRow().getHeight();
                int n3 = clientAnchor2.getRow2() - clientAnchor2.getRow1();
                if (n3 > 0) {
                    int n4 = clientAnchor2.getDy2();
                    if (this.bIsExcel2007) {
                        n4 = (int)((double)n4 / 952.5);
                    }
                    double d = s * n3 + n4;
                    double d2 = (double)s / d;
                    picture.resize(d2);
                }
                if ((cellStyle = cell.getCellStyle()) != null && cellStyle.getAlignment() == 2) {
                    int n5 = 505;
                    if (this.bIsExcel2007) {
                        n2 = cell.getSheet().getColumnWidth(cell.getColumnIndex());
                        n5 = n2 * 150;
                    }
                    n2 = clientAnchor2.getDx2();
                    int n6 = n5 - n2 / 2;
                    clientAnchor2.setDx1(n6);
                    clientAnchor2.setDx2(n6 + n2);
                }
                if (cellStyle != null && cellStyle.getVerticalAlignment() == 1 && (n3 = clientAnchor2.getRow2() - clientAnchor2.getRow1()) == 0) {
                    int n7 = 130;
                    if (this.bIsExcel2007) {
                        n7 = s * 350;
                    }
                    n2 = clientAnchor2.getDy2();
                    int n8 = n7 - n2 / 2;
                    clientAnchor2.setDy1(n8);
                    clientAnchor2.setDy2(n8 + n2);
                }
            }
            catch (Exception exception) {
                if (!objLogger.isWarnEnabled()) break block8;
                objLogger.warn((Object)("Fail to draw image : " + string));
            }
        }
    }

    private int setSummary(Sheet sheet, int n) {
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        for (int i = 0; i < this.objGridFmt.getSummaryCellCount(); ++i) {
            formatCell = this.objGridFmt.getSummary(i);
            Cell cell = this.getCellInExcel(sheet, formatCell, n);
            if (cell == null) {
                return -2015;
            }
            cellStyle = this.setStyleText(formatCell, cell);
            this.setMergeCell(sheet, formatCell, cell, cellStyle);
        }
        return 0;
    }

    private Cell getCellInExcel(Sheet sheet, FormatCell formatCell, int n) {
        int n2 = Integer.parseInt(formatCell.getRow());
        int n3 = Integer.parseInt(formatCell.getCol());
        int n4 = n2 + n;
        int n5 = n3 + this.nStartCol;
        Row row = sheet.getRow(n4);
        Cell cell = row.getCell(n5);
        if (cell == null) {
            this.setErrorMessage("The cell in excel is null : [ row = " + n4 + ", col = " + n5 + " ]");
            return null;
        }
        return cell;
    }

    private CellStyle setStyleText(FormatCell formatCell, Cell cell) {
        CreationHelper creationHelper;
        cell.setCellType(1);
        String string = formatCell.getText();
        if (string != null) {
            creationHelper = this.objWorkbook.getCreationHelper();
            RichTextString richTextString = creationHelper.createRichTextString(string);
            cell.setCellValue(richTextString);
        }
        creationHelper = this.objStyleInfo.getCellStyle(this.objWorkbook, formatCell.getStyle1());
        creationHelper.setWrapText(true);
        if (creationHelper != null) {
            cell.setCellStyle((CellStyle)creationHelper);
        }
        return creationHelper;
    }

    private void setMergeCell(Sheet sheet, FormatCell formatCell, Cell cell, CellStyle cellStyle) {
        int n = Integer.parseInt(formatCell.getRowspan());
        int n2 = Integer.parseInt(formatCell.getColspan());
        if (n > 1 || n2 > 1) {
            int n3 = cell.getRowIndex();
            int n4 = cell.getColumnIndex();
            sheet.addMergedRegion(new CellRangeAddress(n3, n3 + n - 1, n4, n4 + n2 - 1));
            if (cellStyle == null) {
                return;
            }
            int n5 = 0;
            int n6 = 0;
            Row row = null;
            Cell cell2 = null;
            for (n5 = n3; n5 < n3 + n; ++n5) {
                row = sheet.getRow(n5);
                if (row == null) continue;
                for (n6 = n4; n6 < n4 + n2; ++n6) {
                    if (n5 == n3 && n6 == n4 || (cell2 = row.getCell(n6)) == null) continue;
                    cell2.setCellStyle(cellStyle);
                }
            }
        }
    }

    private void setSuppressCell(Sheet sheet, Cell cell, GridCellStyleInfoExt gridCellStyleInfoExt) {
        int n = gridCellStyleInfoExt.getiRowSuppressCount();
        int n2 = gridCellStyleInfoExt.getiColSuppressCount();
        if (n2 > 1 || n > 1) {
            int n3 = cell.getRowIndex();
            int n4 = cell.getColumnIndex();
            sheet.addMergedRegion(new CellRangeAddress(n3 - (n - 1), n3, n4 - (n2 - 1), n4));
        }
    }

    private int saveExportFile(VariableList variableList, DataSet dataSet, HttpServletResponse httpServletResponse) {
        int n = 0;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.objWorkbook.write((OutputStream)byteArrayOutputStream);
            if (this.bIsExcel2007) {
                ((SXSSFWorkbook)this.objWorkbook).dispose();
            }
            this.objWorkbook = null;
            this.objPictures.clear();
            this.objStyleInfo.clear();
            XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
            if (xeniExtendBase == null) {
                this.setErrorMessage("Could not create extend class : xeni.exportimport.extend");
                return -2004;
            }
            n = xeniExtendBase.saveExportStream(variableList, dataSet, byteArrayOutputStream, this.sExportFilePath, this.sExportFileUrl, httpServletResponse);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMessage(fileNotFoundException.getMessage());
            n = -2020;
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            n = -2003;
        }
        catch (Exception exception) {
            n = -2001;
            this.setErrorMessage(exception + "");
        }
        return n;
    }

    private DataSet saveExportFile(VariableList variableList, DataSet dataSet) {
        DataSet dataSet2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.objWorkbook.write((OutputStream)byteArrayOutputStream);
            if (this.bIsExcel2007) {
                ((SXSSFWorkbook)this.objWorkbook).dispose();
            }
            this.objWorkbook = null;
            this.objPictures.clear();
            this.objStyleInfo.clear();
            XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
            if (xeniExtendBase == null) {
                this.setErrorMessage("Could not create extend class : xeni.exportimport.extend");
                return null;
            }
            dataSet2 = xeniExtendBase.saveExportStream(variableList, dataSet, byteArrayOutputStream, this.sExportFilePath, this.sExportFileUrl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMessage(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
        }
        catch (Exception exception) {
            this.setErrorMessage(exception + "");
        }
        return dataSet2;
    }

    private int createMultiSheetHead(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        int n3 = 0;
        boolean bl5 = false;
        int n4 = this.objGridFmt.getRowCountOfEachBand("summ");
        boolean bl6 = false;
        for (int i = 1; i < n + 1; ++i) {
            Sheet sheet = null;
            if (this.objExportData.isAppendExport() && !bl6) {
                sheet = this.objWorkbook.getSheet(string);
                bl6 = true;
            }
            if (sheet == null) {
                sheet = this.objWorkbook.createSheet(string + i);
            }
            if (bl3) {
                this.setColumnLayout(sheet);
            }
            int n5 = 0;
            int n6 = this.nStartRow;
            if (!bl) {
                n5 = this.createEachBandLayout(sheet, "head", n6, bl4);
                if (n5 > 0 && (n3 = this.setHead(sheet, n6)) < 0) {
                    return n3;
                }
                n6 += n5;
            }
            this.objDrawing = sheet.createDrawingPatriarch();
        }
        return 0;
    }

    private int createMultiSheetBody(DataSet dataSet, String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = dataSet.getRowCount();
        int n6 = this.objGridFmt.getRowCountOfEachBand("summ");
        for (int i = 1; i < n + 1; ++i) {
            Sheet sheet = this.objWorkbook.getSheet(string);
            if (sheet == null) {
                sheet = this.objWorkbook.createSheet(string + i);
            }
            for (int j = n4; j < n5; ++j) {
                this.nAddedRow = this.createEachBandLayout(sheet, "body", this.nNextExlRowIdx, bl4);
                n3 = this.setBody(sheet, dataSet, j, this.nNextExlRowIdx);
                if (n3 < 0) {
                    return n3;
                }
                this.nNextExlRowIdx += this.nAddedRow;
                if (j < n5 - 1) {
                    int n7 = 0;
                    n7 = bl2 ? this.nNextExlRowIdx + this.nAddedRow : this.nNextExlRowIdx + this.nAddedRow + n6;
                    if (n7 <= n2) continue;
                    if (i == n) {
                        ++n;
                    }
                    n4 = j + 1;
                    break;
                }
                if (bl2 || this.nNextExlRowIdx + n6 <= n2) continue;
                if (i == n) {
                    ++n;
                }
                n4 = j + 1;
                break;
            }
            if (!bl2) {
                this.nAddedRow = this.createEachBandLayout(sheet, "summ", this.nNextExlRowIdx, bl4);
                if (this.nAddedRow > 0 && (n3 = this.setSummary(sheet, this.nNextExlRowIdx)) < 0) {
                    return n3;
                }
                this.nNextExlRowIdx += this.nAddedRow;
            }
            this.UpdateDimension(sheet, string + i, this.nStartCol, this.nStartRow + 1, this.objGridFmt.getColumnCount() - 1 + this.nStartCol, this.nNextExlRowIdx);
        }
        return 0;
    }

    private int createMultiSheet(DataSet dataSet, String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        int n3 = 0;
        int n4 = 0;
        int n5 = dataSet.getRowCount();
        int n6 = this.objGridFmt.getRowCountOfEachBand("summ");
        boolean bl6 = false;
        for (int i = 1; i < n + 1; ++i) {
            Sheet sheet = null;
            if (this.objExportData.isAppendExport() && !bl6) {
                sheet = this.objWorkbook.getSheet(string);
                bl6 = true;
            }
            if (sheet == null) {
                sheet = this.objWorkbook.createSheet(string + i);
            }
            if (bl3) {
                this.setColumnLayout(sheet);
            }
            int n7 = 0;
            int n8 = this.nStartRow;
            if (!bl) {
                n7 = this.createEachBandLayout(sheet, "head", n8, bl4);
                if (n7 > 0 && (n3 = this.setHead(sheet, n8)) < 0) {
                    return n3;
                }
                n8 += n7;
            }
            this.objDrawing = sheet.createDrawingPatriarch();
            if (bl5 && !bl2) {
                n7 = this.createEachBandLayout(sheet, "summ", n8, bl4);
                if (n7 > 0 && (n3 = this.setSummary(sheet, n8)) < 0) {
                    return n3;
                }
                n8 += n7;
            }
            for (int j = n4; j < n5; ++j) {
                n7 = this.createEachBandLayout(sheet, "body", n8, bl4);
                n3 = this.setBody(sheet, dataSet, j, n8);
                if (n3 < 0) {
                    return n3;
                }
                n8 += n7;
                if (j < n5 - 1) {
                    int n9 = 0;
                    n9 = bl2 ? n8 + n7 : n8 + n7 + n6;
                    if (n9 <= n2) continue;
                    if (i == n) {
                        ++n;
                    }
                    n4 = j + 1;
                    break;
                }
                if (bl2 || n8 + n6 <= n2) continue;
                if (i == n) {
                    ++n;
                }
                n4 = j + 1;
                break;
            }
            if (!bl5 && !bl2) {
                n7 = this.createEachBandLayout(sheet, "summ", n8, bl4);
                if (n7 > 0 && (n3 = this.setSummary(sheet, n8)) < 0) {
                    return n3;
                }
                n8 += n7;
            }
            this.UpdateDimension(sheet, string + i, this.nStartCol, this.nStartRow + 1, this.objGridFmt.getColumnCount() - 1 + this.nStartCol, n8);
        }
        return 0;
    }

    private void UpdateDimension(Sheet sheet, String string, int n, int n2, int n3, int n4) {
        if (this.bIsExcel2007) {
            String string2 = CellReference.convertNumToColString((int)n) + n2;
            string2 = string2 + ":";
            string2 = string2 + CellReference.convertNumToColString((int)n3) + n4;
            XSSFWorkbook xSSFWorkbook = ((SXSSFWorkbook)this.objWorkbook).getXSSFWorkbook();
            XSSFSheet xSSFSheet = xSSFWorkbook.getSheet(string);
            xSSFSheet.getCTWorksheet().getDimension().setRef(string2);
        }
    }
}

