/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.export.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xeni.data.ExportData;
import com.nexacro.xeni.data.exportformats.ExportFormat;
import com.nexacro.xeni.data.exportformats.FormatCell;
import com.nexacro.xeni.export.GridExportBase;
import com.nexacro.xeni.extend.XeniDataValidationBase;
import com.nexacro.xeni.extend.XeniDataValidationFactory;
import com.nexacro.xeni.util.XeniExtendBase;
import com.nexacro.xeni.util.XeniExtendFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridExportCsv
implements GridExportBase {
    private String errmsg = "";
    private String fileurl = "";
    private String filepath = "";
    private ExportData exportdata = null;
    private boolean csvquote = true;
    private static final Log logger = LogFactory.getLog(GridExportCsv.class);
    private XeniDataValidationBase validator;

    @Override
    public void setExportType(String string) {
    }

    private void setErrMessage(String string) {
        this.errmsg = string;
        if (logger.isInfoEnabled()) {
            logger.info((Object)string);
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errmsg;
    }

    @Override
    public void setExportData(ExportData exportData) {
        this.exportdata = exportData;
    }

    @Override
    public void setExportFilePath(String string, String string2, boolean bl) {
        this.filepath = string;
        this.fileurl = string2;
    }

    @Override
    public String getExportFileUrl() {
        return this.fileurl;
    }

    @Override
    public int executeExport(VariableList variableList, boolean bl, HttpServletResponse httpServletResponse, VariableList variableList2) {
        if (this.exportdata == null) {
            this.setErrMessage("Export data is null.");
            return -2010;
        }
        this.validator = XeniDataValidationFactory.getDataValidator();
        DataSet dataSet = this.exportdata.getCmdDataset();
        DataSet dataSet2 = this.exportdata.getStyleDataset();
        DataSet dataSet3 = this.exportdata.getCellDataset();
        ExportFormat exportFormat = this.exportdata.getGridFormat();
        if (dataSet == null || dataSet2 == null || dataSet3 == null || exportFormat == null) {
            this.setErrMessage("Dataset is null. \nFILENAME : " + (dataSet == null ? "null" : dataSet.getString(0, "exportfilename")) + "\nCOMMAND : " + (dataSet == null ? "null" : dataSet.toString()) + "\nSTYLE : " + (dataSet2 == null ? "null" : dataSet2.toString()) + "\nCELL : " + (dataSet3 == null ? "null" : dataSet3.toString()) + "\nFORMAT : " + (exportFormat == null ? "null" : exportFormat.toString()));
            return -2011;
        }
        String string = dataSet.getString(0, "exporthead");
        boolean bl2 = string.contains("nohead");
        boolean bl3 = string.contains("nosumm");
        boolean bl4 = "top".equals(dataSet.getString(0, "summarytype"));
        this.csvquote = variableList2.getBoolean("csv-quote");
        try {
            XeniExtendBase xeniExtendBase;
            int n;
            int n2 = this.makeExportFilepath(dataSet, bl);
            if (n2 < 0) {
                this.setErrMessage("Fail to create export file path.");
                return n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = this.getOutputStream();
            if (byteArrayOutputStream == null) {
                this.setErrMessage("Fail to create output stream.");
                return -2012;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!bl2 && exportFormat.getRowCountOfEachBand("head") > 0) {
                this.setHead(stringBuilder, exportFormat);
            }
            if (bl4 && !bl3 && exportFormat.getRowCountOfEachBand("summ") > 0) {
                this.setSummary(stringBuilder, exportFormat);
            }
            if (exportFormat.getRowCountOfEachBand("body") > 0 && (n = this.setBody(stringBuilder, exportFormat, dataSet3)) < 0) {
                return n;
            }
            if (!bl4 && !bl3 && exportFormat.getRowCountOfEachBand("summ") > 0) {
                this.setSummary(stringBuilder, exportFormat);
            }
            if ((xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend")) == null) {
                this.setErrMessage("Could not create extend class : xeni.exportimport.extend");
                return -2004;
            }
            byteArrayOutputStream.write(239);
            byteArrayOutputStream.write(187);
            byteArrayOutputStream.write(191);
            byteArrayOutputStream.write(stringBuilder.toString().getBytes("UTF-8"));
            int n3 = xeniExtendBase.saveExportStream(variableList, dataSet, byteArrayOutputStream, this.filepath, this.fileurl, httpServletResponse);
            if (n3 < 0) {
                return n3;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setErrMessage(unsupportedEncodingException.getMessage());
            return -2012;
        }
        catch (IOException iOException) {
            this.setErrMessage(iOException.getMessage());
            return -2003;
        }
        catch (Exception exception) {
            this.setErrMessage(exception + "");
            return -2001;
        }
        return 0;
    }

    int makeExportFilepath(DataSet dataSet, boolean bl) throws UnsupportedEncodingException {
        if (!this.exportdata.isAppendExport()) {
            String string = dataSet.getString(0, "instanceid");
            if (string.contains(".") || string.contains("/")) {
                return -3201;
            }
            String string2 = dataSet.getString(0, "exportfilename");
            if (!(string2 != null && string2.length() >= 1 || (string2 = dataSet.getString(0, "item")) != null && string2.length() >= 1)) {
                string2 = "TEMP";
            }
            if (string2.contains(".") || string2.contains("/")) {
                return -3201;
            }
            String string3 = string2 + ".csv";
            this.filepath = this.filepath + string + "/" + string3;
            this.fileurl = bl ? this.fileurl + "?command=export&key=" + string + "&name=" + URLEncoder.encode(string2, "UTF-8") + "&type=4" : this.fileurl + string + "/" + string3;
        } else {
            String string;
            this.fileurl = string = this.exportdata.getAppendExportUrl();
            if (bl) {
                int n = string.indexOf("key=");
                String string4 = string.substring(n + 4, string.indexOf(38, n));
                if (string4 == null || string4.contains(".") || string4.contains("/")) {
                    return -3201;
                }
                n = string.indexOf("name=", n);
                String string5 = string.substring(n + 5, string.indexOf(38, n));
                if ((string5 = URLDecoder.decode(string5, "UTF-8")) == null || string5.contains(".") || string5.contains("/")) {
                    return -3201;
                }
                this.filepath = this.filepath + string4 + "/" + string5 + ".csv";
            } else {
                int n;
                int n2 = string.lastIndexOf("/");
                String string6 = string.substring(n2);
                String string7 = string6.substring(1, n = string6.lastIndexOf(46));
                if (string7 == null || string7.contains(".") || string7.contains("/")) {
                    return -3201;
                }
                String string8 = string.substring(0, n2);
                this.filepath = this.filepath + string8.substring(string8.lastIndexOf("/") + 1) + string6;
            }
        }
        return 0;
    }

    ByteArrayOutputStream getOutputStream() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.exportdata.isAppendExport()) {
            InputStream inputStream = null;
            XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
            inputStream = xeniExtendBase.loadTargetStream(this.filepath);
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteArrayOutputStream;
    }

    void setHead(StringBuilder stringBuilder, ExportFormat exportFormat) throws IOException {
        int n = 0;
        int n2 = exportFormat.getHeadCellCount();
        if (this.exportdata.isAppendExport()) {
            stringBuilder.append("\r\n");
        }
        for (int i = 0; i < n2; ++i) {
            FormatCell formatCell = exportFormat.getHeadCell(i);
            int n3 = Integer.parseInt(formatCell.getRow());
            int n4 = Integer.parseInt(formatCell.getColspan());
            if (n3 > n) {
                stringBuilder.append("\r\n");
            } else if (i > 0) {
                stringBuilder.append(',');
            }
            this.setCsvValue(stringBuilder, formatCell.getText());
            for (int j = 1; j < n4; ++j) {
                stringBuilder.append(',');
            }
            n = n3;
        }
    }

    void setSummary(StringBuilder stringBuilder, ExportFormat exportFormat) throws IOException {
        int n = 0;
        int n2 = exportFormat.getSummaryCellCount();
        if (n2 > 0 && (stringBuilder.length() > 0 || this.exportdata.isAppendExport())) {
            stringBuilder.append("\r\n");
        }
        for (int i = 0; i < n2; ++i) {
            FormatCell formatCell = exportFormat.getSummary(i);
            int n3 = Integer.parseInt(formatCell.getRow());
            int n4 = Integer.parseInt(formatCell.getColspan());
            if (n3 > n) {
                stringBuilder.append("\r\n");
            } else if (i > 0) {
                stringBuilder.append(',');
            }
            this.setCsvValue(stringBuilder, formatCell.getText());
            for (int j = 1; j < n4; ++j) {
                stringBuilder.append(',');
            }
            n = n3;
        }
    }

    int setBody(StringBuilder stringBuilder, ExportFormat exportFormat, DataSet dataSet) throws IOException {
        int n;
        int n2 = dataSet.getRowCount();
        int n3 = dataSet.getColumnCount();
        if (n3 != (n = exportFormat.getBodyCellCount())) {
            this.setErrMessage("The body format is fault : [ colum count of CELL dataset = " + n3 + ", body cell count of FORMAT  = " + n + " ]");
            return -2014;
        }
        if (stringBuilder.length() > 0 || this.exportdata.isAppendExport()) {
            stringBuilder.append("\r\n");
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            if (i > 0) {
                stringBuilder.append("\r\n");
            }
            for (int j = 0; j < n; ++j) {
                String[] stringArray;
                FormatCell formatCell = exportFormat.getBodyCell(j);
                int n5 = Integer.parseInt(formatCell.getRow());
                int n6 = Integer.parseInt(formatCell.getColspan());
                if (n5 > n4) {
                    stringBuilder.append("\r\n");
                } else if (j > 0) {
                    stringBuilder.append(',');
                }
                String string = dataSet.getString(i, j);
                if (string != null && string.length() > 0 && (stringArray = string.split(String.valueOf('\u001d'))).length > 0) {
                    this.setCsvValue(stringBuilder, stringArray[0]);
                }
                for (int k = 1; k < n6; ++k) {
                    stringBuilder.append(',');
                }
                n4 = n5;
            }
        }
        return 0;
    }

    private void setCsvValue(StringBuilder stringBuilder, String string) {
        string = this.validator.checkData(string);
        if (this.csvquote) {
            stringBuilder.append('\"' + string + '\"');
        } else {
            stringBuilder.append(string);
        }
    }

    @Override
    public void receiveExportData(DataSetList dataSetList) {
    }

    @Override
    public boolean isLastExportData(DataSetList dataSetList) {
        return false;
    }

    @Override
    public DataSet getResponseCommand() {
        return null;
    }

    @Override
    public int createWorkbook() {
        return 0;
    }

    @Override
    public int createWorkbook(boolean bl) {
        return 0;
    }

    @Override
    public int appendBody(DataSet dataSet) {
        return 0;
    }

    @Override
    public int appendBody(List<Map<String, Object>> list) {
        return 0;
    }

    @Override
    public DataSet disposeWorkbook() {
        return null;
    }

    @Override
    public DataSet disposeWorkbook(VariableList variableList) {
        return null;
    }

    @Override
    public int disposeWorkbook(VariableList variableList, HttpServletResponse httpServletResponse) {
        return 0;
    }
}

