/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.util.StringUtils;
import com.nexacro.xeni.extend.XeniCSVReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformCsvDataDeSerializer
implements DataDeserializer {
    private Log log = LogFactory.getLog(PlatformCsvDataDeSerializer.class);
    private String CR = "\r\n";

    public void setProperty(String string, Object object) {
    }

    public PlatformData readData(InputStream inputStream, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + string));
        }
        try {
            byte[] byArray = this.readHeader(inputStream);
            String string2 = this.findEncoding(new String(byArray));
            if (string2 == null) {
                string2 = string;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            return this.read(inputStreamReader, dataTypeChanger);
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not deserialize: contentType=PlatformCsv", (Throwable)iOException);
            }
            return null;
        }
    }

    public PlatformData readData(Reader reader, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this + ", charset=" + string));
        }
        try {
            char[] cArray = this.readHeader(reader);
            String string2 = this.findEncoding(new String(cArray));
            return this.read(reader, dataTypeChanger);
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not deserialize: contentType=PlatformCsv", (Throwable)iOException);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlatformData read(Reader reader, DataTypeChanger dataTypeChanger) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        XeniCSVReader xeniCSVReader = new XeniCSVReader(bufferedReader);
        PlatformData platformData = new PlatformData();
        try {
            String[] stringArray;
            while ((stringArray = xeniCSVReader.readNext()) != null) {
                if (this.isDataSetHeader(stringArray[0])) {
                    this.readDataSet(xeniCSVReader, stringArray[0], platformData, dataTypeChanger);
                    continue;
                }
                this.readVariable(xeniCSVReader, stringArray, platformData, dataTypeChanger);
            }
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not deserialize: contentType=PlatformCsv", (Throwable)iOException);
            }
            platformData = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return platformData;
    }

    private boolean isDataSetHeader(String string) {
        return string.startsWith("Dataset:");
    }

    private void readVariable(XeniCSVReader xeniCSVReader, String[] stringArray, PlatformData platformData, DataTypeChanger dataTypeChanger) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            platformData.addVariable(new Variable(string2, 2, (Object)string3));
        }
    }

    private void readDataSet(XeniCSVReader xeniCSVReader, String string, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        int n = string.indexOf(58);
        String string2 = string.substring(n + 1);
        DataSet dataSet = new DataSet(string2);
        String[] stringArray = xeniCSVReader.readNext();
        this.readDefaultColumnHeader(stringArray, dataSet);
        while (!((stringArray = xeniCSVReader.readNext()) == null || stringArray.length == 1 && "".equals(stringArray[0]))) {
            this.readDataRow(stringArray, dataSet);
        }
        platformData.addDataSet(dataSet);
    }

    private void readDefaultColumnHeader(String[] stringArray, DataSet dataSet) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(58);
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = string3.indexOf(40);
                int n3 = string3.indexOf(41, n2 + 1);
                if (n2 > 0 && n3 > 0) {
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(n2 + 1, n3);
                    int n4 = this.getDataType(string4);
                    int n5 = StringUtils.toInt((String)string5, (int)DataTypes.getDefaultSize((int)n4));
                    dataSet.insertColumn(i, new ColumnHeader(string2, n4, n5));
                    continue;
                }
                int n6 = this.getDataType(string3);
                dataSet.insertColumn(i, new ColumnHeader(string2, n6));
                continue;
            }
            dataSet.insertColumn(i, new ColumnHeader(string, 2));
        }
    }

    private void readDataRow(String[] stringArray, DataSet dataSet) {
        int n = dataSet.newRow();
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < stringArray.length - 1 && i < n2; ++i) {
            String string = stringArray[i + 1];
            if (DataTypes.isBinary((int)dataSet.getColumnDataType(i)) && string != null) {
                dataSet.set(n, i, Base64.decodeBase64((String)string.toString()));
                continue;
            }
            dataSet.set(n, i, (Object)string);
        }
    }

    private byte[] readHeader(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            n = inputStream.read();
            byteArrayOutputStream.write(n);
        } while (n != -1 && n != 13 && n != 10);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private char[] readHeader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        do {
            n = reader.read();
            charArrayWriter.write(n);
        } while (n != -1 && n != 13 && n != 10);
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    private String findEncoding(String string) {
        int n;
        int n2;
        String string2;
        String string3 = "CSV:";
        int n3 = string.indexOf(string3);
        if (n3 == 0 && (string2 = string.substring(n2 = n3 + string3.length(), n = string.length()).trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    private int getDataType(String string) {
        if ("binary".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(string)) {
            return 7;
        }
        return DataTypes.toIntType((String)string);
    }
}

