/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.export.impl;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.xeni.util.CommUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;

public class GridCellStyleInfo {
    private String sErrMessage = "";
    private static final Log oLogger = LogFactory.getLog(GridCellStyleInfo.class);
    private List<GridCellStyleInfoExt> listStyle = new ArrayList<GridCellStyleInfoExt>();
    private HashMap<String, Integer> oColors = new HashMap();
    private short nOffset = (short)8;
    private boolean bAppended = false;

    public int getStyleInfo(Workbook workbook, DataSet dataSet, boolean bl, boolean bl2, boolean bl3) {
        this.bAppended = bl3;
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            String string = dataSet.getString(i, "type");
            if (!string.equals("style") || this.createCellStyle(workbook, dataSet, bl, bl2, i) >= 0) continue;
            return -2009;
        }
        return 0;
    }

    private void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (oLogger.isInfoEnabled()) {
            oLogger.info((Object)string);
        }
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    private int createCellStyle(Workbook workbook, DataSet dataSet, boolean bl, boolean bl2, int n) {
        GridCellStyleInfoExt gridCellStyleInfoExt = new GridCellStyleInfoExt();
        CellStyle cellStyle = workbook.createCellStyle();
        this.setDefaultStyle(cellStyle, bl2);
        Font font = null;
        String string = dataSet.getString(n, "name");
        String string2 = dataSet.getString(n, "value");
        String[] stringArray = string2.split("\\,");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            String[] stringArray2 = stringArray[i].split("\\:");
            if (stringArray2.length < 2) {
                this.setErrorMessage("Can't find style type [ " + string + " - " + stringArray[i] + " ]");
                continue;
            }
            String string3 = stringArray2[0].trim();
            String string4 = this.getStyleValue(dataSet, string3, stringArray2[1].trim());
            if (string4 == null || string4.length() < 1) {
                this.setErrorMessage("Can't find style type [ " + string + " - " + stringArray[i] + " ]");
                continue;
            }
            if (string3.equals("align")) {
                this.setStyleAlign(cellStyle, string4);
                continue;
            }
            if (string3.equals("font")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleFont(string4, font);
                continue;
            }
            if (string3.equals("background")) {
                this.setStyleBackground(workbook, cellStyle, string4, bl);
                continue;
            }
            if (string3.equals("color")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleForeground(workbook, string4, bl, font);
                continue;
            }
            if (string3.equals("line")) {
                this.setStyleBorder(workbook, cellStyle, string4, bl);
                continue;
            }
            if (string3.equals("type")) {
                this.setStyleDataType(workbook, cellStyle, string4, gridCellStyleInfoExt);
                continue;
            }
            if (string3.equals("rowsuppress") || string3.equals("merge")) {
                this.setStyleSuppress(workbook, cellStyle, string4, gridCellStyleInfoExt, true);
                continue;
            }
            if (string3.equals("colsuppress")) {
                this.setStyleSuppress(workbook, cellStyle, string4, gridCellStyleInfoExt, false);
                continue;
            }
            this.setErrorMessage("Can't find style type [ " + string + " - " + stringArray[i] + " ]");
            return -1;
        }
        if (font != null) {
            cellStyle.setFont(font);
        }
        gridCellStyleInfoExt.addStyle(string, cellStyle.getIndex());
        this.listStyle.add(gridCellStyleInfoExt);
        return 0;
    }

    private void setDefaultStyle(CellStyle cellStyle, boolean bl) {
        if (bl) {
            cellStyle.setWrapText(true);
        }
    }

    private String getStyleValue(DataSet dataSet, String string, String string2) {
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            String string3 = dataSet.getString(i, "type");
            String string4 = dataSet.getString(i, "name");
            if (!string.equals(string3.trim()) || !string2.equals(string4.trim())) continue;
            return dataSet.getString(i, "value");
        }
        return null;
    }

    private void setStyleAlign(CellStyle cellStyle, String string) {
        String[] stringArray = string.split("\\,");
        if (stringArray.length < 1) {
            return;
        }
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        if (stringArray[0].equals("left")) {
            horizontalAlignment = HorizontalAlignment.LEFT;
        } else if (stringArray[0].equals("center")) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        } else if (stringArray[0].equals("right")) {
            horizontalAlignment = HorizontalAlignment.RIGHT;
        }
        cellStyle.setAlignment(horizontalAlignment);
        if (stringArray.length > 1) {
            if (stringArray[1].equals("top")) {
                verticalAlignment = VerticalAlignment.TOP;
            } else if (stringArray[1].equals("middle")) {
                verticalAlignment = VerticalAlignment.CENTER;
            } else if (stringArray[1].equals("bottom")) {
                verticalAlignment = VerticalAlignment.BOTTOM;
            }
        }
        cellStyle.setVerticalAlignment(verticalAlignment);
    }

    private void setStyleFont(String string, Font font) {
        String[] stringArray = string.split("\\,");
        if (stringArray.length < 1) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.equals("bold")) {
                bl = true;
                continue;
            }
            if (string2.equals("italic")) {
                bl2 = true;
                continue;
            }
            if (string2.equals("underline")) {
                n = 33;
                continue;
            }
            if (string2.equals("strikeout")) {
                bl3 = true;
                continue;
            }
            if (string2.equals("antialias")) continue;
            if (CommUtil.isNumber(string2)) {
                font.setFontHeight((short)(Integer.parseInt(string2) * 20));
                continue;
            }
            font.setFontName(string2);
        }
        font.setBold(bl);
        font.setItalic(bl2);
        font.setUnderline((byte)n);
        font.setStrikeout(bl3);
    }

    private void setStyleBackground(Workbook workbook, CellStyle cellStyle, String string, boolean bl) {
        String[] stringArray = string.split("\\,");
        if (stringArray.length < 3) {
            return;
        }
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (bl) {
            XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], false);
            if (xSSFColor != null) {
                ((XSSFCellStyle)cellStyle).setFillForegroundColor(xSSFColor);
            }
        } else {
            short s = this.getHSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], workbook);
            cellStyle.setFillForegroundColor(s);
        }
    }

    private void setStyleForeground(Workbook workbook, String string, boolean bl, Font font) {
        String[] stringArray = string.split("\\,");
        if (stringArray.length < 3) {
            return;
        }
        font.setColor((short)Short.MAX_VALUE);
        if (bl) {
            XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], true);
            if (xSSFColor != null) {
                CTFont cTFont = ((XSSFFont)font).getCTFont();
                cTFont.setColorArray(0, xSSFColor.getCTColor());
            }
        } else {
            short s = this.getHSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], workbook);
            font.setColor(s);
        }
    }

    private void setStyleBorder(Workbook workbook, CellStyle cellStyle, String string, boolean bl) {
        String[] stringArray = string.split("\\:");
        if (stringArray.length < 4) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("") || stringArray[i].equals("empty")) continue;
            String[] stringArray2 = stringArray[i].split("\\,");
            BorderStyle borderStyle = BorderStyle.THIN;
            if (stringArray2.length > 3) {
                borderStyle = BorderStyle.MEDIUM;
                if (stringArray2[3].equals("double")) {
                    borderStyle = BorderStyle.DOUBLE;
                } else if (stringArray2[3].equals("dotted")) {
                    borderStyle = BorderStyle.DOTTED;
                } else if (stringArray2[3].equals("dashed")) {
                    borderStyle = BorderStyle.DASHED;
                }
            }
            if (bl) {
                XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray2[0], stringArray2[1], stringArray2[2], false);
                if (xSSFColor == null) continue;
                if (i == 0) {
                    cellStyle.setBorderLeft(borderStyle);
                    ((XSSFCellStyle)cellStyle).setLeftBorderColor(xSSFColor);
                    continue;
                }
                if (i == 1) {
                    cellStyle.setBorderTop(borderStyle);
                    ((XSSFCellStyle)cellStyle).setTopBorderColor(xSSFColor);
                    continue;
                }
                if (i == 2) {
                    cellStyle.setBorderRight(borderStyle);
                    ((XSSFCellStyle)cellStyle).setRightBorderColor(xSSFColor);
                    continue;
                }
                if (i != 3) continue;
                cellStyle.setBorderBottom(borderStyle);
                ((XSSFCellStyle)cellStyle).setBottomBorderColor(xSSFColor);
                continue;
            }
            short s = this.getHSSFRGBColor(stringArray2[0], stringArray2[1], stringArray2[2], workbook);
            if (i == 0) {
                cellStyle.setBorderLeft(borderStyle);
                cellStyle.setLeftBorderColor(s);
                continue;
            }
            if (i == 1) {
                cellStyle.setBorderTop(borderStyle);
                cellStyle.setTopBorderColor(s);
                continue;
            }
            if (i == 2) {
                cellStyle.setBorderRight(borderStyle);
                cellStyle.setRightBorderColor(s);
                continue;
            }
            if (i != 3) continue;
            cellStyle.setBorderBottom(borderStyle);
            cellStyle.setBottomBorderColor(s);
        }
    }

    private void setStyleDataType(Workbook workbook, CellStyle cellStyle, String string, GridCellStyleInfoExt gridCellStyleInfoExt) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n <= 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        int n2 = this.getDataTypeNumber(string2);
        gridCellStyleInfoExt.setDataType(n2);
        if (n2 == 1) {
            if (string3 != null) {
                if (string3.startsWith("!") || string3.startsWith("+") || string3.startsWith("-")) {
                    string3 = string3.substring(1);
                }
                if (string3.contains("9")) {
                    string3 = string3.replace('9', '#');
                }
                string3 = string3.replace("#.", "0.");
                if ((string3 = string3.replace(".#", ".0")).contains("%")) {
                    gridCellStyleInfoExt.setbPercentage(true);
                } else {
                    string3 = string3 + "_ ";
                }
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat(string3));
                gridCellStyleInfoExt.setDataFormat(string3);
            } else {
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0_ "));
            }
        } else if (n2 == 2) {
            if (string3 != null) {
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat(this.getLanguageTag(string3)));
                if (string3.contains("dddd")) {
                    string3 = string3.replace("dddd", "E");
                } else if (string3.contains("ddd")) {
                    string3 = string3.replace("ddd", "E");
                }
                gridCellStyleInfoExt.setDataFormat(string3);
            }
        } else if (n2 == 3) {
            if (string3 != null && string3.equals("image")) {
                gridCellStyleInfoExt.setImageData(true);
            } else {
                cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"TEXT"));
            }
        }
    }

    private String getLanguageTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = Locale.getDefault();
        if ("ko".equals(locale.getLanguage())) {
            stringBuffer.append("[$-412]");
        } else if ("ja".equals(locale.getLanguage())) {
            stringBuffer.append("[$-411]");
        } else if ("zh".equals(locale.getLanguage())) {
            if ("CN".equals(locale.getCountry())) {
                stringBuffer.append("[$-804]");
            } else {
                stringBuffer.append("[$-404]");
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void setStyleSuppress(Workbook workbook, CellStyle cellStyle, String string, GridCellStyleInfoExt gridCellStyleInfoExt, boolean bl) {
        int n = Integer.parseInt(string);
        if (n > 1) {
            if (bl) {
                gridCellStyleInfoExt.setiRowSuppressCount(n);
            } else {
                gridCellStyleInfoExt.setiColSuppressCount(n);
            }
        }
    }

    private XSSFColor getXSSFRGBColor(String string, String string2, String string3, boolean bl) {
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = Integer.parseInt(string3);
        byte[] byArray = new byte[]{0, (byte)n, (byte)n2, (byte)n3};
        return new XSSFColor(byArray, null);
    }

    private short getHSSFRGBColor(String string, String string2, String string3, Workbook workbook) {
        if (!this.bAppended) {
            String string4 = string + string2 + string3;
            if (this.oColors.containsKey(string4)) {
                return (short)this.oColors.get(string4).intValue();
            }
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            short s = this.nOffset;
            HSSFPalette hSSFPalette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (this.nOffset > 64) {
                this.setErrorMessage("User color is at the limit of 56. The color is fixed last user color.");
                HSSFColor hSSFColor = hSSFPalette.findSimilarColor(n, n2, n3);
                return hSSFColor != null ? (short)hSSFColor.getIndex() : (short)64;
            }
            hSSFPalette.setColorAtIndex(s, (byte)n, (byte)n2, (byte)n3);
            this.nOffset = (short)(this.nOffset + 1);
            this.oColors.put(string4, Integer.valueOf(s));
            return s;
        }
        HSSFColor hSSFColor = null;
        HSSFPalette hSSFPalette = ((HSSFWorkbook)workbook).getCustomPalette();
        byte by = (byte)Integer.parseInt(string);
        byte by2 = (byte)Integer.parseInt(string2);
        byte by3 = (byte)Integer.parseInt(string3);
        try {
            hSSFColor = hSSFPalette.findColor(by, by2, by3);
            if (hSSFColor == null) {
                hSSFColor = hSSFPalette.addColor(by, by2, by3);
            }
        }
        catch (RuntimeException runtimeException) {
            hSSFColor = hSSFPalette.findSimilarColor(by, by2, by3);
        }
        return hSSFColor.getIndex();
    }

    public GridCellStyleInfoExt getCellStyle(String string) {
        GridCellStyleInfoExt gridCellStyleInfoExt = null;
        for (int i = 0; i < this.listStyle.size(); ++i) {
            gridCellStyleInfoExt = this.listStyle.get(i);
            if (!string.equals(gridCellStyleInfoExt.getStyleName())) continue;
            return gridCellStyleInfoExt;
        }
        return null;
    }

    public CellStyle getCellStyle(Workbook workbook, String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        CellStyle cellStyle = null;
        GridCellStyleInfoExt gridCellStyleInfoExt = this.getCellStyle(string);
        if (gridCellStyleInfoExt != null) {
            cellStyle = workbook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex());
        }
        return cellStyle;
    }

    public void clear() {
        this.listStyle.clear();
        this.oColors.clear();
    }

    public short getPaletteOffset() {
        return this.nOffset;
    }

    public void setPaletteOffset(short s) {
        this.nOffset = s;
    }

    public void appendStyle(String string, short s, int n, String string2, boolean bl) {
        GridCellStyleInfoExt gridCellStyleInfoExt = new GridCellStyleInfoExt();
        gridCellStyleInfoExt.addStyle(string, s);
        gridCellStyleInfoExt.setDataType(n);
        gridCellStyleInfoExt.setDataFormat(string2);
        gridCellStyleInfoExt.setImageData(bl);
        this.listStyle.add(gridCellStyleInfoExt);
    }

    private int getDataTypeNumber(String string) {
        int n = 3;
        if ("normal".equals(string)) {
            n = 0;
        } else if ("number".equals(string)) {
            n = 1;
        } else if ("date".equals(string)) {
            n = 2;
        }
        return n;
    }
}

