/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.services;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.HttpPlatformResponse;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.xeni.data.ExportData;
import com.nexacro.xeni.data.ExportDataFactory;
import com.nexacro.xeni.data.GridImportFormatFactory;
import com.nexacro.xeni.data.importformats.ImportFormat;
import com.nexacro.xeni.export.GridExportBase;
import com.nexacro.xeni.export.GridExportTypeFactory;
import com.nexacro.xeni.extend.PlatformCsvDataDeSerializer;
import com.nexacro.xeni.extend.PlatformCsvDataSerializer;
import com.nexacro.xeni.extend.XeniExtendFactory2;
import com.nexacro.xeni.extend.XeniMultipartProcBase;
import com.nexacro.xeni.extend.XeniMultipartReqData;
import com.nexacro.xeni.util.CommUtil;
import com.nexacro.xeni.util.XeniExtendBase;
import com.nexacro.xeni.util.XeniExtendFactory;
import com.nexacro.xeni.util.XeniProperties;
import com.nexacro.xeni.ximport.GridImportBase;
import com.nexacro.xeni.ximport.GridImportTypeFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridExportImportAgent {
    private static final Log logger = LogFactory.getLog(GridExportImportAgent.class);
    private String sErrMsg = "";
    private String typeStr = "SSV";
    private String securityPattern = XeniProperties.getStringProperty("xeni.security.pattern", "'|\"|:|;|<|>|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href");

    public String getErrorMessage() {
        return this.sErrMsg;
    }

    public int gridExport(String string, String string2, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, VariableList variableList) throws PlatformException, IOException {
        PlatformCsvDataDeSerializer platformCsvDataDeSerializer;
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        InputStream inputStream = this.getContentType((InputStream)servletInputStream);
        variableList.add("contenttype", this.typeStr);
        PlatformData platformData = null;
        if (this.typeStr.equals("CSV")) {
            platformCsvDataDeSerializer = new PlatformCsvDataDeSerializer();
            platformData = platformCsvDataDeSerializer.readData(inputStream, null, "UTF-8");
        } else {
            platformCsvDataDeSerializer = new PlatformRequest(inputStream, "PlatformSsv", "UTF-8");
            platformCsvDataDeSerializer.receiveData();
            platformData = platformCsvDataDeSerializer.getData();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (servletInputStream != null) {
            servletInputStream.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("REQUEST DATA XML ============================ \n" + platformData.saveXml()));
        }
        if (platformData == null) {
            this.sErrMsg = "Input data does not exist. Check the 'data-type' option of transaction";
            return -2006;
        }
        platformCsvDataDeSerializer = null;
        String string3 = "";
        String string4 = "";
        DataSetList dataSetList = platformData.getDataSetList();
        VariableList variableList2 = platformData.getVariableList();
        try {
            platformCsvDataDeSerializer = dataSetList.get("COMMAND");
            string3 = platformCsvDataDeSerializer.getString(0, "command");
            string4 = platformCsvDataDeSerializer.getString(0, "instanceid");
        }
        catch (NullPointerException nullPointerException) {
            this.sErrMsg = "Input data does not exist. Check the 'data-type' option of transaction";
            return -2006;
        }
        if (!string3.equals("export")) {
            this.sErrMsg = "Not export type. The type is " + string3;
            return -2006;
        }
        if (string4 == null || string4.equals("")) {
            string4 = this.createInstanceId(httpServletRequest);
        }
        return this.gridExport(variableList2, dataSetList, string4, string, string2, bl, httpServletResponse, variableList);
    }

    private InputStream getContentType(InputStream inputStream) throws IOException {
        int n;
        int n2 = 4;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, n2 - n3)) != -1) {
            if (n == 0) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Check Export Content-Type: n=" + n + ", offset=" + n3 + ", count=" + n2));
                continue;
            }
            if ((n3 += n) != n2) continue;
            break;
        }
        if (n3 == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Check Default Content-Type: offset=" + n3));
            }
            return null;
        }
        if (n3 == n2) {
            String string = new String(byArray);
            if (string.equalsIgnoreCase("CSV:")) {
                this.typeStr = "CSV";
            }
            return new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
        }
        throw new IOException("Check Export Content-Type failed");
    }

    private int gridExport(VariableList variableList, DataSetList dataSetList, String string, String string2, String string3, boolean bl, HttpServletResponse httpServletResponse, VariableList variableList2) throws PlatformException {
        int n = 0;
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        DataSet dataSet = dataSetList.get("COMMAND");
        DataSet dataSet2 = dataSetList.get("STYLE");
        DataSet dataSet3 = dataSetList.get("CELL");
        ExportData exportData = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Input export data : [ Item = " + dataSet.getString(0, "item") + ", Seq. = " + dataSet.getString(0, "seq") + ", EOF = " + dataSet.getString(0, "eof") + ", Url = " + dataSet.getString(0, "url") + ", Inst.Id = " + dataSet.getString(0, "instanceid") + " ]"));
        }
        if (hashMap.containsKey(string)) {
            exportData = hashMap.get(string);
            exportData.setCmdDataset(dataSet);
            exportData.setStyleDataset(dataSet2);
            exportData.setCellDataset(dataSet3);
        } else {
            dataSet.set(0, "instanceid", string);
            exportData = new ExportData();
            exportData.setCmdDataset(dataSet);
            exportData.setStyleDataset(dataSet2);
            exportData.setCellDataset(dataSet3);
            String string4 = dataSet.getString(0, "url");
            if (string4 != null && string4.length() > 0) {
                exportData.setAppendExport(string4);
            }
            hashMap.put(string, exportData);
        }
        exportData.setLastAccTime(System.currentTimeMillis());
        boolean bl2 = dataSet.getBoolean(0, "eof");
        if (bl2) {
            exportData = hashMap.get(string);
            if (exportData != null) {
                int n2 = dataSet.getInt(0, "type");
                GridExportBase gridExportBase = GridExportTypeFactory.getGridExporter(n2);
                if (gridExportBase == null) {
                    String string5 = "Could not create Grid Exporter : export type = [ 0x" + Integer.toHexString(n2) + " ]";
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)string5);
                    }
                    return -2008;
                }
                gridExportBase.setExportData(exportData);
                gridExportBase.setExportFilePath(string2, string3, false);
                n = gridExportBase.executeExport(variableList, bl, httpServletResponse, variableList2);
                if (n != 0) {
                    this.sErrMsg = gridExportBase.getErrorMessage();
                }
                hashMap.remove(string);
            }
        } else {
            PlatformData platformData = new PlatformData();
            VariableList variableList3 = platformData.getVariableList();
            variableList3.add("ErrorCode", 0);
            variableList3.add("ErrorMsg", "SUCCESS");
            platformData.addDataSet(CommUtil.getDatasetExportResponse(dataSet));
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(httpServletResponse, "PlatformSsv", "UTF-8");
            httpPlatformResponse.setData(platformData);
            httpPlatformResponse.sendData();
        }
        return n;
    }

    public int gridImport(String string, String string2, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string3) throws IOException, FileUploadException, PlatformException, Exception {
        int n;
        String string4 = "";
        String string5 = null;
        InputStream inputStream = null;
        PlatformData platformData = null;
        XeniMultipartProcBase xeniMultipartProcBase = XeniExtendFactory2.getMultipartProc("xeni.multipart.proc");
        if (xeniMultipartProcBase == null) {
            this.sErrMsg = "XeniMultipartProc is null. check the 'xeni.multipart.proc' property.";
            return -3101;
        }
        XeniMultipartReqData xeniMultipartReqData = xeniMultipartProcBase.getImportData(httpServletRequest);
        if (xeniMultipartReqData == null) {
            this.sErrMsg = "Request data is null. (or Filename extention is not valid)";
            return -3101;
        }
        platformData = xeniMultipartReqData.getPlatformData();
        if (platformData == null) {
            this.sErrMsg = "Command data is null.";
            return -3101;
        }
        string4 = xeniMultipartReqData.getFileName();
        inputStream = xeniMultipartReqData.getFileStream();
        VariableList variableList = platformData.getVariableList();
        DataSetList dataSetList = platformData.getDataSetList();
        DataSet dataSet = dataSetList.get("COMMAND");
        String string6 = dataSet.getString(0, "command");
        String string7 = dataSet.getString(0, "filemode");
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Input import data : [ Mode = " + dataSet.getString(0, "filemode") + ", Url = " + dataSet.getString(0, "url") + ", Html tag = " + dataSet.getString(0, "usehtmltag") + ", Raw num = " + dataSet.getString(0, "rawnumbervalue") + " ]"));
        }
        String string8 = variableList.getString("domain");
        if (!string6.equals("import")) {
            this.sErrMsg = "Not import type. The type is " + string6;
            return this.setImportError(httpServletResponse, -2006, this.sErrMsg, string8);
        }
        if ("local".equals(string7) && inputStream != null) {
            String string9 = this.containSecureCharacter2(string4);
            if (string9.length() > 0) {
                this.sErrMsg = "The file name contains characters that violate security. [" + string9 + "]";
                return this.setImportError(httpServletResponse, -3101, this.sErrMsg, string8);
            }
            string5 = "/" + this.createInstanceId(httpServletRequest) + "/" + string4;
            XeniExtendBase xeniExtendBase = XeniExtendFactory.getExtendClass("xeni.exportimport.extend");
            String string10 = xeniExtendBase.saveImportStream(variableList, inputStream, string + string5);
            if (string10 != null) {
                string5 = string10;
            }
        }
        if ((n = this.gridImport(string5, string, string2, string8, bl, dataSet, httpServletResponse, variableList, string3)) < 0) {
            return this.setImportError(httpServletResponse, n, this.sErrMsg, string8);
        }
        return n;
    }

    private int gridImport(String string, String string2, String string3, String string4, boolean bl, DataSet dataSet, HttpServletResponse httpServletResponse, VariableList variableList, String string5) throws IOException, Exception {
        int n;
        block24: {
            n = 0;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            int n2 = dataSet.getInt(0, "type");
            String string6 = dataSet.getString(0, "format");
            String string7 = dataSet.getString(0, "filemode");
            String string8 = dataSet.getString(0, "url");
            String string9 = dataSet.getString(0, "rawdatevalue");
            String string10 = dataSet.getString(0, "usehtmltag");
            String string11 = dataSet.getString(0, "rawnumbervalue");
            String string12 = dataSet.getString(0, "password");
            String string13 = variableList.getString("contenttype");
            boolean bl5 = variableList.getBoolean("minrangemode");
            int n3 = 0;
            String string14 = dataSet.getString(0, "responsetype");
            if (string14 != null) {
                n3 = Integer.parseInt(string14);
            }
            GridImportFormatFactory gridImportFormatFactory = new GridImportFormatFactory();
            ImportFormat importFormat = gridImportFormatFactory.readFormatString(string6);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)string6);
            }
            string8 = "local".equals(string7) ? string : URLDecoder.decode(string8, "UTF-8");
            if (string9 != null && "true".equals(string9)) {
                bl2 = true;
            }
            if (string10 == null || "false".equals(string10)) {
                bl3 = false;
            }
            if (string11 != null && "false".equals(string11)) {
                bl4 = false;
            }
            GridImportBase gridImportBase = null;
            try {
                gridImportBase = GridImportTypeFactory.getGridImporter(n2, string2, string8, string12);
                if (gridImportBase == null || gridImportBase.getErrorCode() < 0) {
                    this.sErrMsg = "Could not create Grid Importer.";
                    this.sErrMsg = gridImportBase != null ? this.sErrMsg + " [" + gridImportBase.getErrorMessage() + "]" : this.sErrMsg + " [Unsupported excel format]";
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)this.sErrMsg);
                    }
                    if (bl && "local".equals(string7)) {
                        CommUtil.deleteDir(string2 + string);
                    }
                    return -2005;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.sErrMsg = "File or directory not found. [" + string + "]";
                fileNotFoundException.printStackTrace();
                return -2003;
            }
            gridImportBase.setImportFormat(importFormat);
            gridImportBase.setImportType(n2);
            gridImportBase.setImportFileMode(string7);
            gridImportBase.setImportFilePath(string2, string8);
            gridImportBase.setRawDateValue(bl2);
            gridImportBase.setRawNumberValue(bl4);
            gridImportBase.setMinRangeMode(bl5);
            gridImportBase.setSecurityKeyword(string5);
            if (string3 != null) {
                gridImportBase.setNumberFmtLnag(string3);
            }
            if (string12 != null) {
                gridImportBase.setPassWord(string12);
            }
            PlatformData platformData = new PlatformData();
            VariableList variableList2 = platformData.getVariableList();
            n = gridImportBase.executeImport(bl, platformData);
            if (n == 0) {
                variableList2.add("ErrorCode", 0);
                variableList2.add("ErrorMsg", "SUCCESS");
                try {
                    if (n3 == 1) {
                        this.corsReviseResponse(httpServletResponse, platformData, string13);
                        return n;
                    }
                    if (string4 == null || "".equals(string4)) {
                        if (string13 != null || "csv".equalsIgnoreCase(string13)) {
                            httpServletResponse.addHeader("Content-Type", "text/html;charset=UTF-8");
                            PrintWriter printWriter = httpServletResponse.getWriter();
                            if (bl3) {
                                ((Writer)printWriter).write("<!--[if lt IE 9]><comment><![endif]--><noscript>");
                            }
                            PlatformCsvDataSerializer platformCsvDataSerializer = new PlatformCsvDataSerializer();
                            platformCsvDataSerializer.writeData(printWriter, platformData, null, "UTF-8");
                            if (bl3) {
                                ((Writer)printWriter).write("</noscript></comment>");
                            }
                            ((Writer)printWriter).flush();
                            ((Writer)printWriter).close();
                        } else {
                            String string15 = "PlatformSsvExt";
                            if (!bl3) {
                                string15 = "PlatformSsv";
                            }
                            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(httpServletResponse, string15, "UTF-8");
                            httpPlatformResponse.setData(platformData);
                            httpPlatformResponse.sendData();
                        }
                        break block24;
                    }
                    CommUtil.sendDomainResponse(httpServletResponse, platformData, string4, string13);
                }
                catch (PlatformException platformException) {
                    n = -3101;
                    this.sErrMsg = platformException.getMessage();
                }
                catch (Exception exception) {
                    n = -2001;
                    this.sErrMsg = "" + exception;
                }
            } else {
                this.sErrMsg = gridImportBase.getErrorMessage();
            }
        }
        return n;
    }

    private String createInstanceId(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getSession().getId();
        string = Integer.toHexString(string.hashCode());
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendExportFileStream(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        int n = 0;
        String string2 = httpServletRequest.getParameter("command");
        if (string2 == null || !string2.equals("export")) {
            this.sErrMsg = "Could not excute command. (" + string2 + ")";
            return -3201;
        }
        String string3 = httpServletRequest.getParameter("key");
        if (string3 == null || this.containSecureCharacter2(string3).length() > 0) {
            this.sErrMsg = "Invalid export file key.";
            return -3201;
        }
        String string4 = httpServletRequest.getParameter("name");
        String string5 = "";
        try {
            string5 = URLDecoder.decode(string4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.sErrMsg = "Could not decode the name.";
            return -3201;
        }
        if (string5 == null || this.containSecureCharacter2(string5).length() > 0) {
            this.sErrMsg = "Invalid export file name.";
            return -3201;
        }
        String string6 = httpServletRequest.getParameter("type");
        if (string6 == null) {
            this.sErrMsg = "Invalid export file type. (null)";
            return -3201;
        }
        int n2 = Integer.parseInt(string6);
        String string7 = "";
        String string8 = "";
        if (n2 == 0) {
            string7 = ".xls";
            string8 = "application/vnd.ms-excel";
        } else if (n2 == 1) {
            string7 = ".xlsx";
            string8 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (n2 == 2) {
            string7 = ".cell";
            string8 = "application/vnd.ms-excel";
        } else if (n2 == 3) {
            string7 = ".cell";
            string8 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (n2 == 4) {
            string7 = ".csv";
            string8 = "text/csv";
        } else {
            this.sErrMsg = "Invalid export file type. (" + n2 + ")";
            return -3201;
        }
        String string9 = string + string3 + "/" + string5 + string7;
        FileInputStream fileInputStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            int n3;
            fileInputStream = new FileInputStream(string9);
            httpServletResponse.setContentType(string8);
            httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + string4 + string7);
            servletOutputStream = httpServletResponse.getOutputStream();
            while ((n3 = fileInputStream.read()) != -1) {
                servletOutputStream.write(n3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.sErrMsg = string3 + "/" + string5 + string7 + " (File not found)";
            n = -2001;
        }
        catch (IOException iOException) {
            this.sErrMsg = iOException.getMessage();
            n = -2003;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException iOException) {
                this.sErrMsg = iOException.getMessage();
                n = -2003;
            }
        }
        if (n == 0) {
            CommUtil.deleteDir(string + string3);
        }
        return n;
    }

    private String containSecureCharacter2(String string) {
        Pattern pattern = Pattern.compile("(?i)(" + this.securityPattern + "){1,}");
        Matcher matcher = pattern.matcher(string);
        String string2 = "";
        while (matcher.find()) {
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + matcher.group();
        }
        return string2;
    }

    private int setImportError(HttpServletResponse httpServletResponse, int n, String string, String string2) throws Exception {
        if (string2 != null && !"".equals(string2)) {
            PlatformData platformData = new PlatformData();
            VariableList variableList = platformData.getVariableList();
            variableList.add("ErrorCode", n);
            variableList.add("ErrorMsg", string);
            CommUtil.sendDomainResponse(httpServletResponse, platformData, string2, null);
            return 0;
        }
        return n;
    }

    private void corsReviseResponse(HttpServletResponse httpServletResponse, PlatformData platformData, String string) throws Exception {
        Object object = null;
        object = string != null && "csv".equalsIgnoreCase(string) ? new PlatformCsvDataSerializer() : new PlatformSsvDataSerializer();
        httpServletResponse.addHeader("Content-Type", "text/html;charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write("<script type=\"text/javascript\">");
        ((Writer)printWriter).write("var retValue = \"\";");
        ((Writer)printWriter).write("window.onload = function() { ");
        ((Writer)printWriter).write("if (window.addEventListener) { ");
        ((Writer)printWriter).write("window.addEventListener (\"message\", OnMessage, false); }");
        ((Writer)printWriter).write("else { ");
        ((Writer)printWriter).write("if (window.attachEvent) { ");
        ((Writer)printWriter).write("window.attachEvent(\"onmessage\", OnMessage); }");
        ((Writer)printWriter).write(" } }; ");
        ((Writer)printWriter).write("function OnMessage (event) { ");
        ((Writer)printWriter).write("message = \"");
        object.writeData((Writer)printWriter, platformData, null, "UTF-8");
        ((Writer)printWriter).write("\";");
        ((Writer)printWriter).write("message = event.data + message;");
        ((Writer)printWriter).write("event.source.postMessage (message, event.origin); }");
        ((Writer)printWriter).write("</script>");
        ((Writer)printWriter).flush();
        ((Writer)printWriter).close();
    }
}

