/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.util;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.xeni.extend.PlatformCsvDataSerializer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletResponse;

public class CommUtil {
    public static String generateSerialNo() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");
        String string = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        int n = new Random().nextInt(100);
        String string2 = String.format("%s%02d", string, n);
        return string2;
    }

    public static boolean isNumber(String string) {
        if (string.length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getDataRange(String string, int[] nArray, int[] nArray2) {
        if (string == null || "".equals(string)) {
            return null;
        }
        String[] stringArray = string.split("\\!");
        String string2 = stringArray[0];
        if (stringArray.length > 1 && !"".equals(stringArray[1])) {
            String[] stringArray2 = stringArray[1].split("\\:");
            CommUtil.getRangeIndex(stringArray2[0], nArray);
            if (stringArray2.length > 1) {
                CommUtil.getRangeIndex(stringArray2[1], nArray2);
            }
        }
        return string2;
    }

    public static void getRangeIndex(String string, int[] nArray) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                string3 = string.substring(i);
                break;
            }
            string2 = string2 + c;
        }
        if (!"".equals(string2)) {
            nArray[0] = CommUtil.getColumnIndexFormChars(string2);
        }
        if (!"".equals(string3)) {
            nArray[1] = Integer.parseInt(string3) - 1;
        }
    }

    public static int getColumnIndexFormChars(String string) {
        int n = 0;
        int n2 = 1;
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            n += (cArray[i] - 65 + 1) * n2;
            n2 *= 26;
        }
        return --n;
    }

    public static DataSet getDatasetImportResponse() {
        DataSet dataSet = new DataSet("IMPORTFILES");
        dataSet.addColumn("filename", 2);
        dataSet.addColumn("filesize", 5);
        dataSet.addColumn("filetype", 2);
        dataSet.addColumn("filepath", 2);
        dataSet.newRow();
        return dataSet;
    }

    public static DataSet getDatasetExportResponse(DataSet dataSet) {
        DataSet dataSet2 = new DataSet("RESPONSE");
        dataSet2.addColumn("command", 2, 32);
        dataSet2.addColumn("type", 3);
        dataSet2.addColumn("item", 2, 256);
        dataSet2.addColumn("instanceid", 2, 256);
        dataSet2.addColumn("lastseq", 3);
        dataSet2.addColumn("eof", 4);
        dataSet2.addColumn("url", 2, 1024);
        int n = dataSet2.newRow();
        dataSet2.set(n, "command", dataSet.getString(0, "command"));
        dataSet2.set(n, "type", dataSet.getInt(0, "type"));
        dataSet2.set(n, "item", dataSet.getString(0, "item"));
        dataSet2.set(n, "instanceid", dataSet.getString(0, "instanceid"));
        dataSet2.set(n, "lastseq", dataSet.getInt(0, "seq"));
        dataSet2.set(n, "eof", dataSet.getBoolean(0, "eof"));
        dataSet2.set(n, "url", "");
        return dataSet2;
    }

    public static void deleteDir(String string) {
        File file = null;
        File file2 = new File(string);
        file = file2.isDirectory() ? file2 : file2.getParentFile();
        if (file != null) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    if (file3 == null) continue;
                    file3.delete();
                }
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    public static void sendDomainResponse(HttpServletResponse httpServletResponse, PlatformData platformData, String string, String string2) throws Exception {
        httpServletResponse.addHeader("Content-Type", "text/html;charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Object object = null;
        object = string2 != null && "csv".equalsIgnoreCase(string2) ? new PlatformCsvDataSerializer() : new PlatformSsvDataSerializer();
        ((Writer)printWriter).write("<html><script>document.domain = \"" + string + "\";</script>");
        object.writeData((Writer)printWriter, platformData, null, "UTF-8");
        ((Writer)printWriter).write("</html>");
        ((Writer)printWriter).flush();
        ((Writer)printWriter).close();
    }
}

