/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.util;

import com.nexacro.xapi.util.JavaEnvUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniProperties {
    private static final String PROPERTIES_NAME = "xeni.properties";
    private static final String DEFAULT_VALUE_STRING = null;
    private static final char DEFAULT_VALUE_CHAR = ' ';
    private static final int DEFAULT_VALUE_INT = 0;
    private static final boolean DEFAULT_VALUE_BOOLEAN = false;
    private static Map propMap = new HashMap();

    private XeniProperties() {
    }

    public static Object getProperty(String string) {
        return propMap.get(string);
    }

    public static void setProperty(String string, Object object) {
        propMap.put(string, object);
    }

    public static void setProperty(String string, int n) {
        XeniProperties.setProperty(string, new Integer(n));
    }

    public static void setProperty(String string, boolean bl) {
        XeniProperties.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void removeProperty(String string) {
        propMap.remove(string);
    }

    public static String getStringProperty(String string) {
        return XeniProperties.getStringProperty(string, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String string, String string2) {
        Object object = XeniProperties.getProperty(string);
        return object == null ? string2 : object.toString();
    }

    public static char getCharProperty(String string) {
        return XeniProperties.getCharProperty(string, ' ');
    }

    public static char getCharProperty(String string, char c) {
        Object object = XeniProperties.getProperty(string);
        if (object instanceof String) {
            String string2 = object.toString();
            if (string2.length() > 1) {
                string2 = string2.trim();
            }
            if (string2.length() == 1) {
                return string2.charAt(0);
            }
        } else if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return c;
    }

    public static int getIntProperty(String string) {
        return XeniProperties.getIntProperty(string, 0);
    }

    public static int getIntProperty(String string, int n) {
        Object object = XeniProperties.getProperty(string);
        if (object instanceof String) {
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public static boolean getBooleanProperty(String string) {
        return XeniProperties.getBooleanProperty(string, false);
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        Object object = XeniProperties.getProperty(string);
        if (object instanceof String) {
            String string2 = object.toString().toLowerCase();
            return "true".equals(string2) || "on".equals(string2) || "yes".equals(string2);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(URL uRL) {
        if (uRL == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            propMap.putAll(properties);
        }
        catch (IOException iOException) {
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not load properties file", (Throwable)iOException);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = null;
        try {
            uRL = XeniProperties.getJarLocationResource(string);
            if (uRL == null) {
                uRL = XeniProperties.getClasspathResource(string);
            }
            return uRL;
        }
        catch (Throwable throwable) {
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", throwable);
            }
            return null;
        }
    }

    private static URL getJarLocationResource(String string) {
        block13: {
            int n;
            int n2;
            String string2;
            String string3 = XeniProperties.class.getName().replace('.', '/') + ".class";
            URL uRL = XeniProperties.class.getClassLoader().getResource(string3);
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): path=" + string3 + ", url=" + uRL));
            }
            String string4 = uRL.getProtocol();
            String string5 = string2 = uRL.getFile();
            if (JavaEnvUtils.isAtLeastJavaVersion((String)"1.4")) {
                try {
                    string5 = URLDecoder.decode(string5, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Could not decode filename: urlFile=" + string2), (Throwable)unsupportedEncodingException);
                    }
                }
            } else {
                string5 = URLDecoder.decode(string5);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): protocol=" + string4 + ", file=" + string5 + ", urlFile=" + string2));
            }
            if ((n2 = string5.indexOf("!/", n = string5.startsWith("file:") ? "file:".length() : 0)) > 0) {
                String string6 = string5.substring(n, n2);
                File file = new File(string6);
                File file2 = new File(file.getParent(), string);
                boolean bl = file2.exists();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getJarLocationResource(): jarFile=" + file + ", licenseFile=" + file2 + ", licenseExists=" + bl));
                }
                if (bl) {
                    try {
                        URL uRL2 = file2.toURL();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded property file in JAR dir: path=" + file2.getAbsolutePath()));
                        }
                        return uRL2;
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!log.isInfoEnabled()) break block13;
                        log.info((Object)("Could not find property file in JAR dir: " + malformedURLException.getMessage()));
                    }
                }
            }
        }
        return null;
    }

    private static URL getClasspathResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Log log = LogFactory.getLog(XeniProperties.class);
        try {
            URL uRL = classLoader.getResource(string);
            if (uRL != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded property file in CLASSPATH: path=" + uRL.getPath()));
            }
            return uRL;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Could not find property file in CLASSPATH: " + throwable.getMessage()));
            }
            return null;
        }
    }

    static {
        XeniProperties.load(XeniProperties.getResource(PROPERTIES_NAME));
    }
}

