/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetDataConverter;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import java.math.BigDecimal;
import java.util.Date;

public class ConstantColumnHeader
extends ColumnHeader {
    private static final long serialVersionUID = 3342450531147553941L;

    public ConstantColumnHeader(String name) {
        this(name, 2, 32);
    }

    public ConstantColumnHeader(String name, int dataType) {
        this(name, dataType, DataTypes.getDefaultSize(dataType));
    }

    public ConstantColumnHeader(String name, int dataType, int dataSize) {
        super(name, dataType, dataSize, null);
    }

    public ConstantColumnHeader(String name, DataType dataType) {
        this(name, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public ConstantColumnHeader(String name, DataType dataType, int dataSize) {
        super(name, dataType, dataSize, null);
    }

    public ConstantColumnHeader(String name, Object value) {
        this(name, value, DataTypes.findType(value));
    }

    public ConstantColumnHeader(String name, Object value, int dataType) {
        this(name, value, dataType, DataTypes.getDefaultSize(dataType));
    }

    public ConstantColumnHeader(String name, Object value, int dataType, int dataSize) {
        super(name, dataType, dataSize, value);
    }

    public ConstantColumnHeader(String name, Object value, DataType dataType) {
        this(name, value, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public ConstantColumnHeader(String name, Object value, DataType dataType, int dataSize) {
        super(name, dataType, dataSize, value);
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    public String getStringValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toString(parent, row, column, this.getValue(), this.getDataType());
    }

    public int getIntValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toInt(parent, row, column, this.getValue());
    }

    public boolean getBooleanValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toBoolean(parent, row, column, this.getValue());
    }

    public long getLongValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toLong(parent, row, column, this.getValue());
    }

    public float getFloatValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toFloat(parent, row, column, this.getValue());
    }

    public double getDoubleValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toDouble(parent, row, column, this.getValue());
    }

    public BigDecimal getBigDecimalValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toBigDecimal(parent, row, column, this.getValue());
    }

    public BigDecimal getDecimalValue(DataSet parent) {
        return this.getBigDecimalValue(parent);
    }

    public Date getDateTimeValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toDateTime(parent, row, column, this.getValue());
    }

    public byte[] getBlobValue(DataSet parent) {
        DataSetDataConverter dataConverter = parent.getCurrentDataConverter();
        int row = -1;
        int column = this.findColumnIndex(parent);
        return dataConverter.toBlob(parent, row, column, this.getValue());
    }

    private int findColumnIndex(DataSet parent) {
        if (parent == null) {
            return -1;
        }
        int count = parent.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (parent.getColumn(i) != this) continue;
            return i;
        }
        return -1;
    }
}

