/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9146369671625180745L;
    private transient Log log = null;
    private List values = new ArrayList();
    private static final String DUPLICATED_DATASET_NAME_CHECK_KEY = "platform.data.DataSet.duplicateddatasetnamecheck";

    public DataSet get(String name) {
        return this.get(this.indexOf(name));
    }

    public DataSet get(int index) {
        boolean contains = this.contains(index);
        if (contains) {
            return (DataSet)this.values.get(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Getting:index=" + index + ", contains=" + contains + ", values.size()=" + this.values.size())));
        }
        return null;
    }

    public void set(int index, DataSet ds) {
        this.checkNameExcludeIndex(ds.getName(), index);
        this.values.set(index, ds);
    }

    public void add(DataSet ds) {
        this.checkName(ds.getName());
        this.values.add(ds);
    }

    public void insert(int index, DataSet ds) {
        this.checkName(ds.getName());
        this.values.add(index, ds);
    }

    public DataSet remove(String name) {
        return this.remove(this.indexOf(name));
    }

    public DataSet remove(int index) {
        boolean contains = this.contains(index);
        if (contains) {
            return (DataSet)this.values.remove(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing: index=" + index + ", contains=" + contains + ", values.size()=" + this.values.size()));
        }
        return null;
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public int indexOf(String name) {
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            DataSet ds = (DataSet)this.values.get(i);
            if (!ds.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String name) {
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            DataSet ds = (DataSet)this.values.get(i);
            if (!ds.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public DataSetList getClone() {
        try {
            return (DataSetList)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSetList dl = (DataSetList)super.clone();
        dl.values = (List)((ArrayList)this.values).clone();
        int count = dl.values.size();
        for (int i = 0; i < count; ++i) {
            dl.values.set(i, ((DataSet)dl.values.get(i)).clone());
        }
        return dl;
    }

    private boolean contains(int index) {
        return this.contains(index, false);
    }

    private boolean contains(int index, boolean increase) {
        int max = increase ? this.values.size() : this.values.size() - 1;
        return index >= 0 && index <= max;
    }

    private void checkName(String name) {
        this.checkNameExcludeIndex(name, -1);
    }

    private void checkNameExcludeIndex(String name, int index) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            DataSet ds;
            if (i == index || !(ds = (DataSet)this.values.get(i)).getName().equals(name)) continue;
            if (PlatformGlobals.getBooleanProperty(DUPLICATED_DATASET_NAME_CHECK_KEY, true)) {
                throw new IllegalArgumentException("Duplicate name: " + name);
            }
            this.values.remove(i);
            break;
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.log = LogFactory.getLog((Class)DataSetList.class);
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)DataSetList.class);
        }
    }
}

