/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import java.math.BigDecimal;
import java.util.Date;

public class DataTypes {
    public static final int UNDEFINED = 0;
    public static final int NULL = 1;
    public static final int STRING = 2;
    public static final int INT = 3;
    public static final int BOOLEAN = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIG_DECIMAL = 8;
    public static final int DECIMAL = 8;
    public static final int DATE = 9;
    public static final int TIME = 10;
    public static final int DATE_TIME = 11;
    public static final int BLOB = 12;
    public static final int FILE = 13;
    public static final String STR_UNDEFINED = "undefined";
    public static final String STR_NULL = "null";
    public static final String STR_STRING = "string";
    public static final String STR_INT = "int";
    public static final String STR_BOOLEAN = "boolean";
    public static final String STR_LONG = "long";
    public static final String STR_FLOAT = "float";
    public static final String STR_DOUBLE = "double";
    public static final String STR_BIG_DECIMAL = "bigdecimal";
    public static final String STR_DECIMAL = "bigdecimal";
    public static final String STR_DATE = "date";
    public static final String STR_TIME = "time";
    public static final String STR_DATE_TIME = "datetime";
    public static final String STR_BLOB = "blob";
    public static final String STR_FILE = "file";
    public static final int DEFAULT_SIZE_UNDEFINED = 0;
    public static final int DEFAULT_SIZE_NULL = 0;
    public static final int DEFAULT_SIZE_STRING = 32;
    public static final int DEFAULT_SIZE_INT = 4;
    public static final int DEFAULT_SIZE_BOOLEAN = 2;
    public static final int DEFAULT_SIZE_LONG = 8;
    public static final int DEFAULT_SIZE_FLOAT = 4;
    public static final int DEFAULT_SIZE_DOUBLE = 8;
    public static final int DEFAULT_SIZE_BIG_DECIMAL = 16;
    public static final int DEFAULT_SIZE_DECIMAL = 16;
    public static final int DEFAULT_SIZE_DATE = 6;
    public static final int DEFAULT_SIZE_TIME = 9;
    public static final int DEFAULT_SIZE_DATE_TIME = 17;
    public static final int DEFAULT_SIZE_BLOB = 256;
    public static final int DEFAULT_SIZE_FILE = 256;
    public static final String DEFAULT_VALUE_STRING = null;
    public static final int DEFAULT_VALUE_INT = 0;
    public static final boolean DEFAULT_VALUE_BOOLEAN = false;
    public static final long DEFAULT_VALUE_LONG = 0L;
    public static final float DEFAULT_VALUE_FLOAT = 0.0f;
    public static final double DEFAULT_VALUE_DOUBLE = 0.0;
    public static final BigDecimal DEFAULT_VALUE_BIG_DECIMAL;
    public static final BigDecimal DEFAULT_VALUE_DECIMAL;
    public static final Date DEFAULT_VALUE_DATE;
    public static final Date DEFAULT_VALUE_TIME;
    public static final Date DEFAULT_VALUE_DATE_TIME;
    public static final byte[] DEFAULT_VALUE_BLOB;
    public static final byte[] DEFAULT_VALUE_FILE;
    public static final Object DEFAULT_VALUE_OBJECT;

    public static int getDefaultSize(int type) {
        switch (type) {
            case 2: {
                return 32;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 17;
            }
            case 12: {
                return 256;
            }
            case 13: {
                return 256;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }

    public static int getDefaultSize(String type) {
        return DataTypes.getDefaultSize(DataTypes.toIntType(type));
    }

    public static int toIntType(String type) {
        if (STR_STRING.equalsIgnoreCase(type)) {
            return 2;
        }
        if (STR_INT.equalsIgnoreCase(type)) {
            return 3;
        }
        if (STR_BOOLEAN.equalsIgnoreCase(type)) {
            return 4;
        }
        if (STR_LONG.equalsIgnoreCase(type)) {
            return 5;
        }
        if (STR_FLOAT.equalsIgnoreCase(type)) {
            return 6;
        }
        if (STR_DOUBLE.equalsIgnoreCase(type)) {
            return 7;
        }
        if ("bigdecimal".equalsIgnoreCase(type)) {
            return 8;
        }
        if (STR_DATE.equalsIgnoreCase(type)) {
            return 9;
        }
        if (STR_TIME.equalsIgnoreCase(type)) {
            return 10;
        }
        if (STR_DATE_TIME.equalsIgnoreCase(type)) {
            return 11;
        }
        if (STR_BLOB.equalsIgnoreCase(type)) {
            return 12;
        }
        if (STR_FILE.equalsIgnoreCase(type)) {
            return 13;
        }
        if (STR_NULL.equalsIgnoreCase(type)) {
            return 1;
        }
        return 0;
    }

    public static String toStringType(int type) {
        switch (type) {
            case 2: {
                return STR_STRING;
            }
            case 3: {
                return STR_INT;
            }
            case 4: {
                return STR_BOOLEAN;
            }
            case 5: {
                return STR_LONG;
            }
            case 6: {
                return STR_FLOAT;
            }
            case 7: {
                return STR_DOUBLE;
            }
            case 8: {
                return "bigdecimal";
            }
            case 9: {
                return STR_DATE;
            }
            case 10: {
                return STR_TIME;
            }
            case 11: {
                return STR_DATE_TIME;
            }
            case 12: {
                return STR_BLOB;
            }
            case 13: {
                return STR_FILE;
            }
            case 1: {
                return STR_NULL;
            }
        }
        return STR_UNDEFINED;
    }

    public static int findType(Object value) {
        return DataTypes.findType(value, true);
    }

    public static int findType(Object value, boolean include) {
        if (value == null) {
            return include ? 1 : 0;
        }
        if (value instanceof String) {
            return 2;
        }
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Long) {
            return 5;
        }
        if (value instanceof Float) {
            return 6;
        }
        if (value instanceof Double) {
            return 7;
        }
        if (value instanceof BigDecimal) {
            return 8;
        }
        if (value instanceof Date) {
            return 11;
        }
        if (value instanceof byte[]) {
            return 12;
        }
        return 0;
    }

    public static boolean isBinary(int type) {
        return type == 12;
    }

    private DataTypes() {
    }

    static {
        DEFAULT_VALUE_DECIMAL = DEFAULT_VALUE_BIG_DECIMAL = null;
        DEFAULT_VALUE_DATE = null;
        DEFAULT_VALUE_TIME = null;
        DEFAULT_VALUE_DATE_TIME = null;
        DEFAULT_VALUE_BLOB = null;
        DEFAULT_VALUE_FILE = null;
        DEFAULT_VALUE_OBJECT = null;
    }
}

