/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.Base64;
import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.SeperatorReader;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformSsvDataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvDataDeserializer.class);
    private char rs = (char)30;
    private char us = (char)31;
    private PlatformData data = null;
    private DataSet ds = null;

    public void readData(Reader in, PlatformData data) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setData(data);
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            this.read(in);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    public void readData(Reader in, DataSet ds) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setDataSet(ds);
        this.read(in);
    }

    void read(Reader in) throws PlatformException {
        SeperatorReader reader = new SeperatorReader(in, this.rs);
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) continue;
                if (this.isDataSetHeader(line)) {
                    this.readDataSet(reader, line);
                    continue;
                }
                this.readVariable(reader, line);
            }
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    void setData(PlatformData data) {
        this.data = data;
    }

    PlatformData getData() {
        return this.data;
    }

    void setDataSet(DataSet ds) {
        this.ds = ds;
    }

    DataSet getDataSet() {
        return this.ds;
    }

    void readVariable(SeperatorReader reader, String str) {
        if (this.getData() == null) {
            return;
        }
        List list = this.split(str, this.us);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name;
            String varStr = (String)iter.next();
            int index = varStr.indexOf(61);
            if (index <= 0) continue;
            String header = varStr.substring(0, index);
            String value = varStr.substring(index + 1);
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                Variable var;
                int dataType;
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    dataType = this.getDataType(dataTypeStr);
                    if (dataType == 2 && this.isNullString(value)) {
                        value = null;
                    }
                    var = new Variable(name, dataType, (Object)value);
                    this.getData().addVariable(var);
                    continue;
                }
                dataTypeStr = typeStr;
                dataType = this.getDataType(dataTypeStr);
                if (dataType == 2 && this.isNullString(value)) {
                    value = null;
                }
                var = new Variable(name, dataType, (Object)value);
                this.getData().addVariable(var);
                continue;
            }
            name = header;
            int dataType = 2;
            if (this.isNullString(value)) {
                value = null;
            }
            Variable var = new Variable(name, dataType, (Object)value);
            this.getData().addVariable(var);
        }
    }

    void readDataSet(SeperatorReader reader, String header) throws IOException {
        int index = header.indexOf(58);
        String name = header.substring(index + 1);
        DataSet ds = this.getDataSet();
        if (ds == null) {
            ds = new DataSet(name);
        }
        int startCol = ds.getColumnCount();
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        boolean isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        String line = null;
        while ((line = reader.readLine()) != null && line.length() != 0) {
            if (this.isConstantColumnHeader(line)) {
                this.readConstantColumnHeader(line, ds);
                continue;
            }
            if (this.isDefaultColumnHeader(line)) {
                this.readDefaultColumnHeader(line, ds, startCol);
                continue;
            }
            this.readDataRow(line, ds, startCol);
        }
        if (isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        if (this.getData() != null) {
            this.getData().addDataSet(ds);
        }
    }

    private void readConstantColumnHeader(String str, DataSet ds) {
        List list = this.split(str, this.us);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name;
            String columnStr = (String)iter.next();
            int index = columnStr.indexOf(61);
            if (index <= 0) continue;
            String header = columnStr.substring(0, index);
            String value = columnStr.substring(index + 1);
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    String dataSizeStr = typeStr.substring(sizeStartIndex + 1, sizeEndIndex);
                    int dataType = this.getDataType(dataTypeStr);
                    int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
                    ds.addConstantColumn(name, dataType, dataSize, (Object)value);
                    continue;
                }
                dataTypeStr = typeStr;
                int dataType = this.getDataType(dataTypeStr);
                ds.addConstantColumn(name, dataType, (Object)value);
                continue;
            }
            name = header;
            int dataType = 2;
            ds.addConstantColumn(name, dataType, (Object)value);
        }
    }

    private void readDefaultColumnHeader(String str, DataSet ds, int start) {
        List list = this.split(str, this.us);
        Iterator iter = list.iterator();
        iter.next();
        int i = start;
        while (iter.hasNext()) {
            String name;
            String header = (String)iter.next();
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    String dataSizeStr = typeStr.substring(sizeStartIndex + 1, sizeEndIndex);
                    int dataType = this.getDataType(dataTypeStr);
                    int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
                    ds.insertColumn(i, new ColumnHeader(name, dataType, dataSize));
                } else {
                    dataTypeStr = typeStr;
                    int dataType = this.getDataType(dataTypeStr);
                    ds.insertColumn(i, new ColumnHeader(name, dataType));
                }
            } else {
                name = header;
                int dataType = 2;
                ds.insertColumn(i, new ColumnHeader(name, dataType));
            }
            ++i;
        }
    }

    private void readDataRow(String str, DataSet ds, int start) {
        List list = this.split(str, this.us);
        Iterator iter = list.iterator();
        String rowType = (String)iter.next();
        if (rowType.length() == 1) {
            char ch = rowType.charAt(0);
            if (ch == 'O') {
                int rowIndex = ds.getRowCount() - 1;
                int columnCount = ds.getColumnCount();
                for (int i = start; iter.hasNext() && i < columnCount; ++i) {
                    Object value = iter.next();
                    if (this.isNullString(value)) {
                        value = null;
                    }
                    if (DataTypes.isBinary(ds.getColumnDataType(i)) && value != null) {
                        ds.setSavedData(rowIndex, i, (Object)Base64.decode(value.toString()));
                        continue;
                    }
                    ds.setSavedData(rowIndex, i, value);
                }
            } else if (ch == 'N' || ch == 'I' || ch == 'U' || ch == 'D') {
                int rowIndex = ds.newRow();
                int columnCount = ds.getColumnCount();
                for (int i = start; iter.hasNext() && i < columnCount; ++i) {
                    Object value = iter.next();
                    if (this.isNullString(value)) {
                        value = null;
                    }
                    if (DataTypes.isBinary(ds.getColumnDataType(i)) && value != null) {
                        ds.set(rowIndex, i, Base64.decode(value.toString()));
                        continue;
                    }
                    ds.set(rowIndex, i, value);
                }
                if (ch == 'N') {
                    ds.setRowType(rowIndex, 0);
                } else if (ch == 'I') {
                    ds.setRowType(rowIndex, 1);
                } else if (ch == 'U') {
                    ds.setRowType(rowIndex, 2);
                } else if (ch == 'D') {
                    ds.setRowType(rowIndex, 3);
                }
            }
        } else if (this.log.isWarnEnabled()) {
            int rowCount = ds.getRowCount();
            this.log.warn((Object)("Invalid SSV row type: rowType=" + rowType + ", rowCount=" + rowCount));
            this.log.warn((Object)("Invalid SSV row type: str=" + str));
        }
    }

    private boolean isConstantColumnHeader(String str) {
        return str.startsWith("_Const_");
    }

    private boolean isDefaultColumnHeader(String str) {
        return str.startsWith("_RowType_");
    }

    private boolean isDataSetHeader(String str) {
        return str.startsWith("Dataset:");
    }

    private char[] readHeader(Reader in) throws IOException {
        int ch;
        CharArrayWriter out = new CharArrayWriter();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != this.rs);
        out.close();
        return out.toCharArray();
    }

    private String findEncoding(char[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(String header) {
        int end;
        int begin;
        String encoding;
        String prefix = "SSV:";
        int index = header.indexOf(prefix);
        if (index == 0 && (encoding = header.substring(begin = index + prefix.length(), end = header.length()).trim()).length() > 0) {
            return encoding;
        }
        return null;
    }

    private List split(String str, char ch) {
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            int index;
            if ((index = str.indexOf(ch, start)) == -1) break;
            int end = index;
            list.add(str.substring(start, end));
            start = end + 1;
        }
        list.add(str.substring(start));
        return list;
    }

    private int getDataType(String str) {
        if ("binary".equalsIgnoreCase(str)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(str)) {
            return 7;
        }
        return DataTypes.toIntType(str);
    }

    private boolean isNullString(String value) {
        return value.length() == 1 && value.charAt(0) == '\u0003';
    }

    private boolean isNullString(Object value) {
        String newVal;
        if (value == null) {
            return true;
        }
        return value instanceof String && (newVal = (String)value).length() == 1 && newVal.charAt(0) == '\u0003';
    }
}

