/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.DataSetConvertHelper;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.DefaultVariableDataConverter;
import com.nexacro.java.xapi.data.VariableDataConverter;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Variable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4514398994894395517L;
    private transient Log log = null;
    public static final String UNDEFINED_NAME = "UNDEFINED";
    private static final String NAME_CHECK_KEY = "platform.data.Variable.namecheck";
    private static final String DEFAULT_DATA_CONVERTER_KEY = "platform.data.Variable.defaultdataconverter";
    private String name;
    private int type;
    private String charset;
    private Object value;
    private boolean isConvertingToDataType = true;
    private VariableDataConverter dataConverter;
    private VariableDataConverter defaultDataConverter;

    public static Variable createVariable(String name, String value) {
        Variable var = new Variable(name, 2);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, int value) {
        Variable var = new Variable(name, 3);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, boolean value) {
        Variable var = new Variable(name, 4);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, long value) {
        Variable var = new Variable(name, 5);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, float value) {
        Variable var = new Variable(name, 6);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, double value) {
        Variable var = new Variable(name, 7);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, BigDecimal value) {
        Variable var = new Variable(name, 8);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, Date value) {
        Variable var = new Variable(name, 11);
        var.set(value);
        return var;
    }

    public static Variable createVariable(String name, byte[] value) {
        Variable var = new Variable(name, 12);
        var.set(value);
        return var;
    }

    public Variable(String name) {
        this(name, 0);
    }

    public Variable(String name, int type) {
        this(name, type, null);
    }

    public Variable(String name, int type, Object value) {
        this.setName(name);
        this.setType(type);
        this.set(value);
    }

    public Variable(String name, DataType type) {
        this(name, type, null);
    }

    public Variable(String name, DataType type, Object value) {
        this(name, PlatformDataType.getType(type), value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkName(name);
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.checkType(type);
        this.type = type;
        this.value = this.getCurrentDataConverter().convert(this, this.value, type);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isConvertingToDataType() {
        return this.isConvertingToDataType;
    }

    public void setConvertingToDataType(boolean isConvertingToDataType) {
        this.isConvertingToDataType = isConvertingToDataType;
    }

    public VariableDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(VariableDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    public VariableDataConverter getCurrentDataConverter() {
        if (this.dataConverter == null) {
            if (this.defaultDataConverter == null) {
                this.defaultDataConverter = DataSetConvertHelper.getDefaultVariableDataConverter();
                if (this.defaultDataConverter != null) {
                    this.getLogger();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Creating VariableDataConverter:, defaultDataConverter=" + this.defaultDataConverter));
                    }
                }
                if (this.defaultDataConverter == null) {
                    this.defaultDataConverter = new DefaultVariableDataConverter();
                }
            }
            return this.defaultDataConverter;
        }
        return this.dataConverter;
    }

    public Object getObject() {
        return this.getCurrentDataConverter().toObject(this, this.value);
    }

    public String getString() {
        int type = this.getType();
        String charset = this.getCharset();
        return this.getCurrentDataConverter().toString(this, this.value, type, charset);
    }

    public String getString(String defaultValue) {
        String value = this.getString();
        return value == null ? defaultValue : value;
    }

    public int getInt() {
        return this.getCurrentDataConverter().toInt(this, this.value);
    }

    public boolean getBoolean() {
        return this.getCurrentDataConverter().toBoolean(this, this.value);
    }

    public long getLong() {
        return this.getCurrentDataConverter().toLong(this, this.value);
    }

    public float getFloat() {
        return this.getCurrentDataConverter().toFloat(this, this.value);
    }

    public double getDouble() {
        return this.getCurrentDataConverter().toDouble(this, this.value);
    }

    public BigDecimal getBigDecimal() {
        return this.getCurrentDataConverter().toBigDecimal(this, this.value);
    }

    public BigDecimal getDecimal() {
        return this.getBigDecimal();
    }

    public Date getDateTime() {
        return this.getCurrentDataConverter().toDateTime(this, this.value);
    }

    public byte[] getBlob() {
        String charset = this.getCharset();
        return this.getCurrentDataConverter().toBlob(this, this.value, charset);
    }

    public void set(Object value) {
        if (this.type == 0) {
            this.type = DataTypes.findType(value, false);
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Changed type: " + DataTypes.toStringType(this.type)));
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type, this.charset) : value;
    }

    public void set(String value) {
        if (this.type == 0) {
            this.type = 2;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: string");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type, this.charset) : value;
    }

    public void set(int value) {
        if (this.type == 0) {
            this.type = 3;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: int");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : new Integer(value);
    }

    public void set(boolean value) {
        if (this.type == 0) {
            this.type = 4;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: bool");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : (value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void set(long value) {
        if (this.type == 0) {
            this.type = 5;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: long");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : new Long(value);
    }

    public void set(float value) {
        if (this.type == 0) {
            this.type = 6;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: float");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : new Float(value);
    }

    public void set(double value) {
        if (this.type == 0) {
            this.type = 7;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: double");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : new Double(value);
    }

    public void set(BigDecimal value) {
        if (this.type == 0) {
            this.type = 8;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: decimal");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : value;
    }

    public void set(Date value) {
        if (this.type == 0) {
            this.type = 11;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: datetime");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type) : value;
    }

    public void set(byte[] value) {
        if (this.type == 0) {
            this.type = 12;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: blob");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, value, this.type, this.charset) : (Object)value;
    }

    public Variable getClone() {
        try {
            return (Variable)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            Variable another = (Variable)obj;
            if (this.name.equals(another.name) && this.type == another.type && this.isConvertingToDataType == another.isConvertingToDataType) {
                if (this.value == null) {
                    return another.value == null;
                }
                return this.value.equals(another.value);
            }
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", type=" + this.type + ", isConvertingToDataType=" + this.isConvertingToDataType + "]";
    }

    private void checkName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(name);
        }
    }

    private void checkNaming(String name) {
        if (name == null) {
            return;
        }
        char[] chars = name.toCharArray();
        int count = chars.length;
        char ch = chars[0];
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$')) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        for (int i = 1; i < count; ++i) {
            ch = chars[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '$' || ch == '-') continue;
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
    }

    private void checkType(int type) {
        if (type < 0 || type > 13) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.log = LogFactory.getLog((Class)Variable.class);
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)Variable.class);
        }
    }
}

