/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.util;

import com.nexacro.java.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class DoubleTypeConverter {
    public Object toObject(double value) {
        return new Double(value);
    }

    public String toString(double value) {
        return String.valueOf(value);
    }

    public int toInt(double value) {
        return (int)value;
    }

    public boolean toBoolean(double value) {
        return false;
    }

    public long toLong(double value) {
        return (long)value;
    }

    public float toFloat(double value) {
        return (float)value;
    }

    public BigDecimal toBigDecimal(double value) {
        return new BigDecimal(String.valueOf(value));
    }

    public Date toDate(double value) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(double value) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(double value) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(double value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(double value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return this.toObject(value);
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toBlob(value);
            }
        }
        return this.toObject(value);
    }
}

