/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.util;

import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.util.DateTypeConverter;
import java.math.BigDecimal;
import java.util.Date;

class LongTypeConverter {
    private DateTypeConverter dateConverter = new DateTypeConverter();

    public Object toObject(long value) {
        return new Long(value);
    }

    public String toString(long value) {
        return String.valueOf(value);
    }

    public int toInt(long value) {
        return (int)value;
    }

    public boolean toBoolean(long value) {
        return value != 0L;
    }

    public float toFloat(long value) {
        return value;
    }

    public double toDouble(long value) {
        return value;
    }

    public BigDecimal toBigDecimal(long value) {
        return new BigDecimal(String.valueOf(value));
    }

    public Date toDate(long value) {
        return this.dateConverter.toDate(new Date(value));
    }

    public Date toTime(long value) {
        return this.dateConverter.toTime(new Date(value));
    }

    public Date toDateTime(long value) {
        return new Date(value);
    }

    public byte[] toBlob(long value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(long value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.toObject(value);
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toBlob(value);
            }
        }
        return this.toObject(value);
    }
}

