/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.util;

import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.util.DateTypeConverter;
import com.nexacro.java.xapi.util.DatetimeFormat;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringTypeConverter {
    private Log log = null;
    private static String[] VALUES_TRUE = new String[]{"true", "True", "TRUE", "yes", "Yes", "YES", "y", "Y", "on", "On", "ON", "1"};
    private static String[] VALUES_FALSE = new String[]{"false", "false", "false", "no", "No", "NO", "n", "N", "off", "Off", "OFF", "0"};
    private DatetimeFormat datetimeParser = new DatetimeFormat();
    private DateTypeConverter dateConverter = new DateTypeConverter();

    public Object toObject(String value) {
        return value;
    }

    public int toInt(String value) {
        block8: {
            if (this.isValid(value)) {
                if (this.needTrim(value)) {
                    value = value.trim();
                }
                value = this.removeGroupingSeparator(value);
                try {
                    if (value.indexOf(46) == -1) {
                        if (value.startsWith("0x") || value.startsWith("0X")) {
                            return Integer.parseInt(value.substring(2), 16);
                        }
                        return Integer.parseInt(value);
                    }
                    return new BigDecimal(value).intValue();
                }
                catch (NumberFormatException ex) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block8;
                    try {
                        this.log.debug((Object)("Converting to type int failed: value=" + URLEncoder.encode(value, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return 0;
    }

    public boolean toBoolean(String value) {
        if (this.isValid(value)) {
            String[] trueValues = VALUES_TRUE;
            for (int i = 0; i < trueValues.length; ++i) {
                if (!trueValues[i].equals(value)) continue;
                return true;
            }
            String[] falseValues = VALUES_FALSE;
            for (int i = 0; i < falseValues.length; ++i) {
                if (!falseValues[i].equals(value)) continue;
                return false;
            }
        }
        return false;
    }

    public long toLong(String value) {
        block7: {
            if (this.isValid(value)) {
                if (this.needTrim(value)) {
                    value = value.trim();
                }
                value = this.removeGroupingSeparator(value);
                try {
                    if (value.indexOf(46) == -1) {
                        return Long.parseLong(value);
                    }
                    return new BigDecimal(value).longValue();
                }
                catch (NumberFormatException ex) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block7;
                    try {
                        this.log.debug((Object)("Converting to type long failed: value=" + URLEncoder.encode(value, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return 0L;
    }

    public float toFloat(String value) {
        block5: {
            if (this.isValid(value)) {
                value = this.removeGroupingSeparator(value);
                try {
                    return Float.parseFloat(value);
                }
                catch (NumberFormatException ex) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type float failed: value=" + URLEncoder.encode(value, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return 0.0f;
    }

    public double toDouble(String value) {
        block5: {
            if (this.isValid(value)) {
                value = this.removeGroupingSeparator(value);
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type double failed: value=" + URLEncoder.encode(value, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return 0.0;
    }

    public BigDecimal toBigDecimal(String value) {
        block5: {
            if (this.isValid(value)) {
                value = this.removeGroupingSeparator(value);
                try {
                    return new BigDecimal(value);
                }
                catch (NumberFormatException ex) {
                    this.getLogger();
                    if (!this.log.isDebugEnabled()) break block5;
                    try {
                        this.log.debug((Object)("Converting to type java.math.BigDecimal failed: value=" + URLEncoder.encode(value, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(String value) {
        if (this.isValidDate(value)) {
            return this.dateConverter.toDate(this.parseDate(value));
        }
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(String value) {
        if (this.isValidDate(value)) {
            return this.dateConverter.toTime(this.parseDate(value));
        }
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(String value) {
        if (this.isValidDate(value)) {
            Date date = this.parseDate(value);
            return date;
        }
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(String value) {
        return this.toBlob(value, null);
    }

    public byte[] toBlob(String value, String charset) {
        try {
            if (value == null) {
                return DataTypes.DEFAULT_VALUE_BLOB;
            }
            if (charset == null) {
                return value.getBytes();
            }
            return value.getBytes(charset);
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("Converting to type byte[] failed: value=" + URLEncoder.encode(value, "UTF-8") + ", charset=" + URLEncoder.encode(charset, "UTF-8")), (Throwable)ex);
                }
                catch (UnsupportedEncodingException e) {
                    this.log.debug((Object)"UnsupportedEncodingException");
                }
            }
            return value.getBytes();
        }
    }

    public Object convert(String value, int type) {
        return this.convert(value, type, null);
    }

    public Object convert(String value, int type, String charset) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 2: {
                return value;
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toBlob(value, charset);
            }
        }
        return value;
    }

    private Date parseDate(String value) {
        int length = value.length();
        if (length == 17) {
            this.datetimeParser.setFormat(0);
        } else if (length == 14) {
            this.datetimeParser.setFormat(1);
        } else if (length == 8) {
            this.datetimeParser.setFormat(2);
        } else if (length == 9) {
            this.datetimeParser.setFormat(3);
        } else {
            this.datetimeParser.setFormat(4);
        }
        Date date = this.datetimeParser.parse(value);
        if (date == null) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("Parsing date failed: value=" + URLEncoder.encode(value, "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.debug((Object)"UnsupportedEncodingException");
                }
            }
            date = DataTypes.DEFAULT_VALUE_DATE_TIME;
        }
        return date;
    }

    private String removeGroupingSeparator(String value) {
        if (value == null || value.indexOf(44) == -1) {
            return value;
        }
        char[] chars = value.toCharArray();
        int count = chars.length;
        char[] buffer = new char[count];
        int n = 0;
        for (int i = 0; i < count; ++i) {
            if (chars[i] == ',') continue;
            buffer[n++] = chars[i];
        }
        return new String(buffer, 0, n);
    }

    private boolean isValid(String value) {
        return value != null && !"".equals(value);
    }

    private boolean isValidDate(String value) {
        if (this.isValid(value)) {
            int length = value.length();
            return length == 17 || length == 14 || length == 8 || length == 9 || length == 6;
        }
        return false;
    }

    private boolean needTrim(String value) {
        if (value.charAt(0) == ' ') {
            return true;
        }
        int length = value.length();
        return length == 1 ? false : value.charAt(length - 1) == ' ';
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)StringTypeConverter.class);
        }
    }
}

