/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.util.PlatformCompatibilityUtils;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class PlatformUtils {
    private static PlatformEncoder defaultPlatformEncoder = null;
    private static PlatformEncoderFactory platformEncoderFactory = null;
    private static PlatformFileHandlerFactory fileHandlerFactory;

    public static String[] splitKeyAndValue(String str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        int index = str.indexOf(ch);
        if (index == -1) {
            return null;
        }
        String first = str.substring(0, index).trim();
        String second = str.substring(index + 1).trim();
        return new String[]{first, second};
    }

    public static String getHttpContentType(String contentType, String charset) {
        if ("PlatformXml".equals(contentType) || "MiXml".equals(contentType)) {
            if (charset == null) {
                return "text/xml";
            }
            return "text/xml; charset=" + charset;
        }
        if ("PlatformHtml".equals(contentType)) {
            if (charset == null) {
                return "text/html";
            }
            return "text/html; charset=" + charset;
        }
        if ("PlatformSsv".equals(contentType) || "PlatformSsvExt".equals(contentType)) {
            if (charset == null) {
                return "text/plain";
            }
            return "text/plain; charset=" + charset;
        }
        if ("PlatformBinary".equals(contentType) || "MiBinary".equals(contentType)) {
            return "application/octet-stream";
        }
        if ("PlatformJson".equals(contentType)) {
            return "application/json";
        }
        if (charset == null) {
            return "text/xml";
        }
        return "text/xml; charset=" + charset;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return PlatformCompatibilityUtils.createTempFile(prefix, suffix);
    }

    public static PlatformEncoder getPlatformEncoder(String type) {
        if (platformEncoderFactory == null) {
            return defaultPlatformEncoder;
        }
        return platformEncoderFactory.getEncoder(type);
    }

    public static PlatformFileHandler getPlatformFileHandler(String file) {
        if (fileHandlerFactory == null) {
            return null;
        }
        return fileHandlerFactory.getPlatformFileHandler(file);
    }

    private PlatformUtils() {
    }

    static {
        platformEncoderFactory = PlatformCompatibilityUtils.loadPlatformEncoderFactory();
        defaultPlatformEncoder = new DefaultPlatformEncoder();
        fileHandlerFactory = null;
        fileHandlerFactory = PlatformCompatibilityUtils.loadPlatformFileHandlerFactory();
    }

    public static interface PlatformFileHandlerFactory {
        public PlatformFileHandler getPlatformFileHandler(String var1);
    }

    public static interface PlatformFileHandler {
        public File toFile() throws IOException;
    }

    public static class DefaultPlatformEncoder
    implements PlatformEncoder {
        public void encodeTo(Writer out, String str) throws IOException {
            out.write(str);
        }

        public void encodeTo(OutputStream out, byte[] bytes) throws IOException {
            out.write(bytes);
        }
    }

    public static interface PlatformEncoderFactory {
        public PlatformEncoder getEncoder(String var1);
    }

    public static interface PlatformEncoder {
        public void encodeTo(Writer var1, String var2) throws IOException;

        public void encodeTo(OutputStream var1, byte[] var2) throws IOException;
    }
}

