/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiBinaryDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)MiBinaryDataSerializer.class);
    private static final int[] MONTH_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private Map columnIndexesMap = new HashMap();
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.write(out, data, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "MiBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        String contentType = "MiBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    private void write(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataOutputStream stream = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        int count = data.getDataSetCount();
        stream.writeShort(count + 1);
        this.writeVariableList(stream, data, dataTypeChanger);
        this.writeDataSetList(stream, data, dataTypeChanger);
        stream.flush();
    }

    private void writeVariableList(DataOutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
        VariableList vl = data.getVariableList();
        int count = vl.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        out.writeShort(65040);
        out.writeShort(4000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        bufferOut.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Variable var = vl.get(i);
            this.writeVariable(bufferOut, var, dataTypeChanger);
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        encoder.encodeTo(out, bin);
    }

    private void writeVariable(DataOutputStream out, Variable var, DataTypeChanger dataTypeChanger) throws IOException {
        String name = var.getName();
        int dataType = var.getType();
        byte[] nameBytes = name.getBytes(CHARSET);
        out.writeShort(nameBytes.length);
        out.write(nameBytes);
        switch (dataType) {
            case 2: {
                this.writeValue(out, var.getString());
                break;
            }
            case 3: {
                this.writeValue(out, var.getInt());
                break;
            }
            case 4: {
                this.writeValue(out, var.getBoolean());
                break;
            }
            case 5: {
                this.writeValue(out, var.getLong());
                break;
            }
            case 6: {
                this.writeValue(out, var.getFloat());
                break;
            }
            case 7: {
                this.writeValue(out, var.getDouble());
                break;
            }
            case 8: {
                this.writeValue(out, var.getString());
                break;
            }
            case 9: {
                this.writeValue(out, var.getDateTime());
                break;
            }
            case 10: {
                this.writeValue(out, var.getDateTime());
                break;
            }
            case 11: {
                this.writeValue(out, var.getDateTime());
                break;
            }
            case 12: {
                this.writeValue(out, var.getBlob());
                break;
            }
            case 13: {
                this.writeEmptyValue(out);
                break;
            }
            case 1: {
                this.writeEmptyValue(out);
                break;
            }
            default: {
                this.writeEmptyValue(out);
            }
        }
    }

    private void writeDataSetList(DataOutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dl = data.getDataSetList();
        int count = dl.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            DataSet ds = dl.get(i);
            this.writeDataSet(out, data, ds, dataTypeChanger);
        }
    }

    private void writeDataSet(DataOutputStream out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (name != null ? URLEncoder.encode(name, CHARSET) : null) + ", alias=" + (alias != null ? URLEncoder.encode(alias, CHARSET) : null) + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        out.writeShort(65025);
        out.writeShort(4000);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumnHeaders(out, ds, dataTypes);
        this.writeRows(out, data, ds, dataTypes);
        out.writeInt(0);
    }

    private void writeColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        String alias = ds.getAlias();
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        byte[] nameBytes = alias.getBytes(CHARSET);
        bufferOut.writeShort(nameBytes.length);
        bufferOut.write(nameBytes);
        this.writeConstantColumnHeaders(bufferOut, ds, dataTypes);
        this.writeDefaultColumnHeaders(bufferOut, ds, dataTypes);
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        encoder.encodeTo(out, bin);
    }

    private void writeDefaultColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        ColumnHeader header;
        int i;
        int count = ds.getColumnCount();
        int n = 0;
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.isConstant()) continue;
            ++n;
        }
        out.writeShort(n);
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            out.writeShort(nameBytes.length);
            out.write(nameBytes);
            int dataType = dataTypes[i];
            int dataSize = header.getDataSize();
            switch (dataType) {
                case 2: {
                    out.writeShort(1);
                    break;
                }
                case 3: {
                    out.writeShort(2);
                    break;
                }
                case 4: {
                    out.writeShort(2);
                    break;
                }
                case 5: {
                    out.writeShort(5);
                    break;
                }
                case 6: {
                    out.writeShort(4);
                    break;
                }
                case 7: {
                    out.writeShort(4);
                    break;
                }
                case 8: {
                    out.writeShort(1);
                    break;
                }
                case 9: {
                    out.writeShort(8);
                    break;
                }
                case 10: {
                    out.writeShort(8);
                    break;
                }
                case 11: {
                    out.writeShort(8);
                    break;
                }
                case 12: {
                    out.writeShort(9);
                    break;
                }
                case 13: {
                    out.writeShort(9);
                    break;
                }
                case 1: {
                    out.writeShort(0);
                    break;
                }
                default: {
                    out.writeShort(0);
                }
            }
            out.writeShort(dataSize);
            out.writeShort(1);
        }
    }

    private void writeConstantColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        ColumnHeader header;
        int i;
        out.writeShort(65040);
        out.writeShort(4000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        int count = ds.getColumnCount();
        int n = 0;
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (!header.isConstant()) continue;
            ++n;
        }
        bufferOut.writeShort(n);
        block15: for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (!header.isConstant()) continue;
            ConstantColumnHeader constantHeader = (ConstantColumnHeader)header;
            String name = constantHeader.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            bufferOut.writeShort(nameBytes.length);
            bufferOut.write(nameBytes);
            int sourceDataType = constantHeader.getDataType();
            int dataType = dataTypes[i];
            if (sourceDataType == 13) {
                this.writeValue(bufferOut, constantHeader.getStringValue(ds));
                continue;
            }
            if (dataType == 13) {
                dataType = sourceDataType;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(bufferOut, constantHeader.getStringValue(ds));
                    continue block15;
                }
                case 3: {
                    this.writeValue(bufferOut, constantHeader.getIntValue(ds));
                    continue block15;
                }
                case 4: {
                    this.writeValue(bufferOut, constantHeader.getBooleanValue(ds));
                    continue block15;
                }
                case 5: {
                    this.writeValue(bufferOut, constantHeader.getLongValue(ds));
                    continue block15;
                }
                case 6: {
                    this.writeValue(bufferOut, constantHeader.getFloatValue(ds));
                    continue block15;
                }
                case 7: {
                    this.writeValue(bufferOut, constantHeader.getDoubleValue(ds));
                    continue block15;
                }
                case 8: {
                    this.writeValue(bufferOut, constantHeader.getStringValue(ds));
                    continue block15;
                }
                case 9: {
                    this.writeValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 10: {
                    this.writeValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 11: {
                    this.writeValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 12: {
                    this.writeValue(bufferOut, constantHeader.getBlobValue(ds));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(bufferOut);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(bufferOut);
                }
            }
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        out.write(bin);
    }

    private void writeRows(DataOutputStream out, PlatformData data, DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream bufferOut = new DataOutputStream(buffer);
            this.writeRow(bufferOut, ds, dataTypes, i, saveType);
            bufferOut.close();
            buffer.close();
            byte[] bin = buffer.toByteArray();
            if (bin.length <= 0) continue;
            this.writeLength(out, bin.length);
            encoder.encodeTo(out, bin);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferOut = new DataOutputStream(buffer);
                this.writeRemovedRow(bufferOut, ds, dataTypes, i);
                bufferOut.close();
                buffer.close();
                byte[] bin = buffer.toByteArray();
                if (bin.length <= 0) continue;
                this.writeLength(out, bin.length);
                encoder.encodeTo(out, bin);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        if (saveType == 2) {
            out.writeShort(1);
        } else {
            switch (rowType) {
                case 0: {
                    out.writeShort(1);
                    break;
                }
                case 1: {
                    out.writeShort(2);
                    break;
                }
                case 2: {
                    out.writeShort(4);
                    break;
                }
                case 3: {
                    out.writeShort(8);
                    break;
                }
                default: {
                    out.writeShort(1);
                }
            }
        }
        out.writeShort(count);
        block21: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getString(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getString(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getString(row, index));
                    continue block21;
                }
                case 3: {
                    this.writeValue(out, ds.getInt(row, index));
                    continue block21;
                }
                case 4: {
                    this.writeValue(out, ds.getBoolean(row, index));
                    continue block21;
                }
                case 5: {
                    this.writeValue(out, ds.getLong(row, index));
                    continue block21;
                }
                case 6: {
                    this.writeValue(out, ds.getFloat(row, index));
                    continue block21;
                }
                case 7: {
                    this.writeValue(out, ds.getDouble(row, index));
                    continue block21;
                }
                case 8: {
                    this.writeValue(out, ds.getString(row, index));
                    continue block21;
                }
                case 9: {
                    this.writeValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 10: {
                    this.writeValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 11: {
                    this.writeValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 12: {
                    this.writeValue(out, ds.getBlob(row, index));
                    continue block21;
                }
                case 13: {
                    this.writeValue(out, ds.getBlob(row, index));
                    continue block21;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block21;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, dataTypes, row);
        }
    }

    private void writeSavedRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row) throws IOException {
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        out.writeShort(0);
        block15: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getSavedStringData(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getSavedStringData(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getSavedStringData(row, index));
                    continue block15;
                }
                case 3: {
                    this.writeValue(out, ds.getSavedIntData(row, index));
                    continue block15;
                }
                case 4: {
                    this.writeValue(out, ds.getSavedBooleanData(row, index));
                    continue block15;
                }
                case 5: {
                    this.writeValue(out, ds.getSavedLongData(row, index));
                    continue block15;
                }
                case 6: {
                    this.writeValue(out, ds.getSavedFloatData(row, index));
                    continue block15;
                }
                case 7: {
                    this.writeValue(out, ds.getSavedDoubleData(row, index));
                    continue block15;
                }
                case 8: {
                    this.writeValue(out, ds.getSavedStringData(row, index));
                    continue block15;
                }
                case 9: {
                    this.writeValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 10: {
                    this.writeValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 11: {
                    this.writeValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 12: {
                    this.writeValue(out, ds.getSavedBlobData(row, index));
                    continue block15;
                }
                case 13: {
                    this.writeValue(out, ds.getSavedBlobData(row, index));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
    }

    private void writeRemovedRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row) throws IOException {
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        out.writeShort(8);
        out.writeShort(count);
        block15: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getRemovedStringData(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getRemovedStringData(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getRemovedStringData(row, index));
                    continue block15;
                }
                case 3: {
                    this.writeValue(out, ds.getRemovedIntData(row, index));
                    continue block15;
                }
                case 4: {
                    this.writeValue(out, ds.getRemovedBooleanData(row, index));
                    continue block15;
                }
                case 5: {
                    this.writeValue(out, ds.getRemovedLongData(row, index));
                    continue block15;
                }
                case 6: {
                    this.writeValue(out, ds.getRemovedFloatData(row, index));
                    continue block15;
                }
                case 7: {
                    this.writeValue(out, ds.getRemovedDoubleData(row, index));
                    continue block15;
                }
                case 8: {
                    this.writeValue(out, ds.getRemovedStringData(row, index));
                    continue block15;
                }
                case 9: {
                    this.writeValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 10: {
                    this.writeValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 11: {
                    this.writeValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 12: {
                    this.writeValue(out, ds.getRemovedBlobData(row, index));
                    continue block15;
                }
                case 13: {
                    this.writeValue(out, ds.getRemovedBlobData(row, index));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
    }

    private void writeValue(DataOutputStream out, String value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            String str = this.platformCodec.encode(value);
            out.writeShort(8);
            byte[] strBytes = str.getBytes(CHARSET);
            this.writeLength(out, strBytes.length);
            out.write(strBytes);
        }
    }

    private void writeValue(DataOutputStream out, int value) throws IOException {
        out.writeShort(3);
        out.writeInt(value);
    }

    private void writeValue(DataOutputStream out, boolean value) throws IOException {
        out.writeShort(3);
        int booleanValue = value ? 1 : 0;
        out.writeInt(booleanValue);
    }

    private void writeValue(DataOutputStream out, long value) throws IOException {
        out.writeShort(6);
        int[] longInts = this.toInts(new BigDecimal(String.valueOf(value)));
        out.writeInt(longInts[0]);
        out.writeInt(longInts[1]);
    }

    private void writeValue(DataOutputStream out, float value) throws IOException {
        out.writeShort(5);
        out.writeDouble(value);
    }

    private void writeValue(DataOutputStream out, double value) throws IOException {
        out.writeShort(5);
        out.writeDouble(value);
    }

    private void writeValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(7);
            double dateDouble = this.toDouble(value);
            out.writeDouble(dateDouble);
        }
    }

    private void writeValue(DataOutputStream out, byte[] value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(13);
            this.writeLength(out, value.length);
            out.write(value);
        }
    }

    private void writeEmptyValue(DataOutputStream out) throws IOException {
        out.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeStringFromFile(DataOutputStream out, String filename) throws IOException {
        if (filename == null) {
            out.writeShort(0);
            return;
        } else {
            File file = null;
            PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
            if (fileHandler != null) {
                file = fileHandler.toFile();
            }
            if (file != null && file.canRead()) {
                out.writeShort(8);
                int len = (int)file.length();
                this.writeLength(out, len);
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = this.getBuffer();
                try {
                    int n;
                    while ((n = in.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Load data from file: file=" + file)));
                    return;
                }
                finally {
                    in.close();
                }
            } else {
                out.writeShort(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeBlobFromFile(DataOutputStream out, String filename) throws IOException {
        if (filename == null) {
            out.writeShort(0);
            return;
        } else {
            File file = null;
            PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
            if (fileHandler != null) {
                file = fileHandler.toFile();
            }
            if (file != null && file.canRead()) {
                out.writeShort(13);
                int len = (int)file.length();
                this.writeLength(out, len);
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = this.getBuffer();
                try {
                    int n;
                    while ((n = in.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Load data from file: file=" + file)));
                    return;
                }
                finally {
                    in.close();
                }
            } else {
                out.writeShort(0);
            }
        }
    }

    private void writeLength(DataOutputStream out, int length) throws IOException {
        if (length < 32768) {
            out.writeShort(length);
        } else {
            out.writeInt(length | Integer.MIN_VALUE);
        }
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private int[] getColumnIndexes(DataSet ds) {
        String id = ds.getName() + "@" + ds.hashCode();
        int[] indexes = (int[])this.columnIndexesMap.get(id);
        if (indexes == null) {
            indexes = this.sortColumnIndexes(ds);
            this.columnIndexesMap.put(id, indexes);
        }
        return indexes;
    }

    private int[] sortColumnIndexes(DataSet ds) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int count = ds.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ColumnHeader header = ds.getColumn(i2);
            if (header.isConstant()) continue;
            list.add(header.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>();
        Iterator iter = list.iterator();
        block1: while (iter.hasNext()) {
            String name = (String)iter.next();
            int size = sorted.size();
            for (i = 0; i < size; ++i) {
                String str = (String)sorted.get(i);
                if (name.compareToIgnoreCase(str) >= 0) continue;
                sorted.add(i, name);
                continue block1;
            }
            sorted.add(name);
        }
        int len = sorted.size();
        int[] indexes = new int[len];
        for (i = 0; i < len; ++i) {
            indexes[i] = ds.indexOfColumn(sorted.get(i).toString());
        }
        return indexes;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private int[] toInts(BigDecimal decimal) {
        int[] values = new int[2];
        String str = decimal.scale() == 4 ? decimal.toString() : decimal.setScale(4, 4).toString();
        int index = str.indexOf(46);
        if (index >= 0) {
            str = str.substring(0, index) + str.substring(index + 1, str.length());
        }
        long value = Long.parseLong(str);
        values[0] = (int)(value >> 32);
        values[1] = (int)(0xFFFFFFFFL & value);
        return values;
    }

    private double toDouble(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return this.toDouble(year, month, day, hour, minute, second);
    }

    private double toDouble(int year, int month, int day, int hour, int minute, int second) {
        boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
        long nDate = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)MONTH_DAYS[month - 1] + (long)day;
        if (month <= 2 && leapYear) {
            --nDate;
        }
        double dblTime = (double)((long)hour * 3600L + (long)minute * 60L + (long)second) / 86400.0;
        return (double)nDate + (nDate >= 0L ? dblTime : -dblTime);
    }
}

