/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformHtmlDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformHtmlDataSerializer.class);
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String DOC_TYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private static final String XML_NS = "http://www.w3.org/1999/xhtml";
    private static final String[] STYLE = new String[]{"<style type=\"text/css\">", "<!--/*--><![CDATA[/*><!--*/", "body {", TABS[1] + "font-family:Verdana, Helvetica, sans-serif;", "}", "table, tr, th, td {", TABS[1] + "margin:0;", TABS[1] + "padding:0;", TABS[1] + "border:0;", TABS[1] + "outline:0;", TABS[1] + "vertical-align:baseline;", "}", "table {", TABS[1] + "border-collapse:collapse;", TABS[1] + "border-spacing:0;", TABS[1] + "empty-cells:show;", TABS[1] + "border:1px solid #bbb;", TABS[1] + "margin:0.5em 0.25em;", "}", "th, td {", TABS[1] + "padding:0.25em 0.5em;", "}", "th {", TABS[1] + "border:1px solid #bbb;", TABS[1] + "background-color:#d7d7d7;", "}", "td {", TABS[1] + "border:1px solid #bbb;", "}", "tr.odd td {", TABS[1] + "background-color:#eee;", "}", "/*]]>*/-->", "</style>"};
    private static final String[] JAVA_SCRIPT = new String[]{"<script type=\"text/javascript\">", "<!--//--><![CDATA[//><!--", "function init() {", TABS[1] + ";", "}", "//--><!]]>", "</script>"};

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                try {
                    this.log.error((Object)("Unsupported charset: " + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)), (Throwable)ex);
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)"UnsupportedEncodingException");
                }
            }
            throw new PlatformException("Unsupported charset: " + charset, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.write(out, data, charset);
        }
        catch (IOException ex) {
            String contentType = "PlatformHtml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    protected void write(Writer out, PlatformData data, String charset) throws IOException {
        int depth = 0;
        this.writeHeader(out, charset, depth);
        this.writeHtmlHead(out, data, charset, depth);
        this.writeHtmlBody(out, data, charset, depth);
        this.writeFooter(out, charset, depth);
        out.flush();
    }

    protected void writeHeader(Writer out, String charset, int depth) throws IOException {
        this.write(out, DOC_TYPE, depth);
        this.write(out, "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">", depth);
    }

    protected void writeFooter(Writer out, String charset, int depth) throws IOException {
        this.write(out, "</html>", depth);
    }

    protected void writeHtmlHead(Writer out, PlatformData data, String charset, int depth) throws IOException {
        this.write(out, "<head>", depth);
        this.writeMeta(out, charset, depth);
        this.writeTitle(out, data, depth);
        this.writeStyle(out, depth);
        this.writeJavaScript(out, depth);
        this.write(out, "</head>", depth);
    }

    protected void writeMeta(Writer out, String charset, int depth) throws IOException {
        if (charset == null) {
            this.write(out, "<meta http-equiv=\"Content-Type\" content=\"text/html\" />", depth);
        } else {
            this.write(out, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\" />", depth);
        }
    }

    protected void writeTitle(Writer out, PlatformData data, int depth) throws IOException {
        this.write(out, "<title>" + data.toString() + "</title>", depth);
    }

    protected void writeStyle(Writer out, int depth) throws IOException {
        int count = STYLE.length;
        for (int i = 0; i < count; ++i) {
            this.write(out, STYLE[i], depth);
        }
    }

    protected void writeJavaScript(Writer out, int depth) throws IOException {
        int count = JAVA_SCRIPT.length;
        for (int i = 0; i < count; ++i) {
            this.write(out, JAVA_SCRIPT[i], depth);
        }
    }

    protected void writeHtmlBody(Writer out, PlatformData data, String charset, int depth) throws IOException {
        this.write(out, "<body onload=\"init()\">", depth);
        this.writeDate(out, depth);
        this.writeLine(out, depth);
        this.writeVariableList(out, data.getVariableList(), depth);
        this.writeLine(out, depth);
        this.writeDataSetList(out, data.getDataSetList(), depth);
        this.write(out, "</body>", depth);
    }

    protected void writeDate(Writer out, int depth) throws IOException {
        this.write(out, "<p>Date: " + new Date() + "</p>", depth);
    }

    protected void writeLine(Writer out, int depth) throws IOException {
        this.write(out, "<hr />", depth);
    }

    protected void writeVariableList(Writer out, VariableList varList, int depth) throws IOException {
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        this.write(out, "<p>Variable count=" + count + "</p>", depth);
        this.write(out, "<table>", depth++);
        this.write(out, "<tr>", depth++);
        this.write(out, "<th>Index</th>", depth);
        this.write(out, "<th>Name</th>", depth);
        this.write(out, "<th>DataType</th>", depth);
        this.write(out, "<th>Value</th>", depth);
        this.write(out, "</tr>", --depth);
        for (int i = 0; i < count; ++i) {
            this.writeVariable(out, i, varList.get(i), depth);
        }
        this.write(out, "</table>", --depth);
    }

    protected void writeVariable(Writer out, int index, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = DataTypes.toStringType(var.getType());
        String value = var.getString();
        if (index % 2 == 1) {
            this.write(out, "<tr class=\"odd\">", depth++);
        } else {
            this.write(out, "<tr>", depth++);
        }
        this.write(out, "<td>" + index + "</td>", depth);
        this.write(out, "<td>" + name + "</td>", depth);
        this.write(out, "<td>" + type + "</td>", depth);
        this.write(out, "<td>" + value + "</td>", depth);
        this.write(out, "</tr>", --depth);
    }

    protected void writeDataSetList(Writer out, DataSetList dsList, int depth) throws IOException {
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        this.write(out, "<p>DataSet count=" + count + "</p>", depth);
        for (int i = 0; i < count; ++i) {
            this.writeLine(out, depth);
            this.writeDataSet(out, i, dsList.get(i), depth);
        }
    }

    protected void writeDataSet(Writer out, int index, DataSet ds, int depth) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (name != null ? URLEncoder.encode(name, "UTF-8") : null) + ", alias=" + (alias != null ? URLEncoder.encode(alias, "UTF-8") : null) + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        this.write(out, "<p>DataSet index=" + index + ", name=" + alias + "</p>", depth);
        this.writeColumns(out, ds, depth);
        this.writeRows(out, ds, depth);
    }

    protected void writeColumns(Writer out, DataSet ds, int depth) throws IOException {
        int count = ds.getColumnCount();
        this.write(out, "<p>Header column=" + count + "</p>", depth);
        this.write(out, "<table>", depth);
        this.write(out, "<tr>", depth++);
        this.write(out, "<th>Index</th>", depth);
        this.write(out, "<th>Name</th>", depth);
        this.write(out, "<th>Type</th>", depth);
        this.write(out, "<th>DataType</th>", depth);
        this.write(out, "<th>DataSize</th>", depth);
        this.write(out, "<th>Value</th>", depth);
        this.write(out, "</tr>", --depth);
        for (int i = 0; i < count; ++i) {
            this.writeColumnHeader(out, i, ds, ds.getColumn(i), depth);
        }
        this.write(out, "</table>", depth);
    }

    protected void writeColumnHeader(Writer out, int index, DataSet ds, ColumnHeader header, int depth) throws IOException {
        String value;
        String name = header.getName();
        String type = header.isConstant() ? "constant" : "normal";
        String dataType = DataTypes.toStringType(header.getDataType());
        int dataSize = header.getDataSize();
        String string = value = header.isConstant() ? ((ConstantColumnHeader)header).getStringValue(ds) : null;
        if (index % 2 == 1) {
            this.write(out, "<tr class=\"odd\">", depth++);
        } else {
            this.write(out, "<tr>", depth++);
        }
        this.write(out, "<td>" + index + "</td>", depth);
        this.write(out, "<td>" + name + "</td>", depth);
        this.write(out, "<td>" + type + "</td>", depth);
        this.write(out, "<td>" + dataType + "</td>", depth);
        this.write(out, "<td>" + dataSize + "</td>", depth);
        this.write(out, "<td>" + value + "</td>", depth);
        this.write(out, "</tr>", --depth);
    }

    protected void writeRows(Writer out, DataSet ds, int depth) throws IOException {
        int columnCount = ds.getColumnCount();
        int rowCount = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: columnCount=" + columnCount + ", rowCount=" + rowCount));
        }
        this.write(out, "<p>Data row=" + rowCount + "</p>", depth);
        this.write(out, "<table>", depth++);
        boolean isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex();
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(false);
        }
        this.writeRow(out, -1, ds, -1, depth);
        for (int i = 0; i < rowCount; ++i) {
            this.writeRow(out, i, ds, i, depth);
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
        this.write(out, "</table>", --depth);
    }

    protected void writeRow(Writer out, int index, DataSet ds, int row, int depth) throws IOException {
        if (index % 2 == 1) {
            this.write(out, "<tr class=\"odd\">", depth);
        } else {
            this.write(out, "<tr>", depth);
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            if (row == -1) {
                this.write(out, "<th>" + header.getName() + "</th>", depth);
                continue;
            }
            this.write(out, "<td>" + ds.getString(row, i) + "</td>", depth);
        }
        this.write(out, "</tr>", depth);
    }

    protected void write(Writer out, String str, int depth) throws IOException {
        if (depth == 0) {
            out.write(str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            out.write(str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[0]);
            }
            out.write(str);
            out.write(NL);
        }
    }
}

