/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.util;

import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    private static final String SSV_DATA_UNIT_SEPERATOR = "platform.tx.platformssv.unitseperator";
    private static final String SSV_DATA_RECORD_SEPERATOR = "platform.tx.platformssv.recordseperator";

    public static int toInt(String str) {
        return StringUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        block5: {
            if (!StringUtils.isEmpty(str)) {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    Log log = LogFactory.getLog((Class)StringUtils.class);
                    if (!log.isDebugEnabled()) break block5;
                    try {
                        log.debug((Object)("Converting to type int failed: str=" + URLEncoder.encode(str, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.debug((Object)"UnsupportedEncodingException");
                    }
                }
            }
        }
        return defaultValue;
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty(str, true);
    }

    public static boolean isEmpty(String str, boolean isTrim) {
        if (str == null || str.length() == 0) {
            return true;
        }
        if (isTrim) {
            return str.trim().length() == 0;
        }
        return false;
    }

    public static List split(String str, char separator) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        if (len == 0) {
            return list;
        }
        if (str.indexOf(separator) == -1) {
            list.add(str);
        } else {
            int start = 0;
            while (true) {
                int end;
                if ((end = str.indexOf(separator, start)) == -1) {
                    list.add(str.substring(start, len));
                    break;
                }
                list.add(str.substring(start, end));
                start = end + 1;
            }
        }
        return list;
    }

    public static String leftPad(String str, int max, char ch) {
        int count = max - str.length();
        if (count > 0) {
            StringBuffer buffer = new StringBuffer(max);
            for (int i = 0; i < count; ++i) {
                buffer.append(ch);
            }
            str = buffer.append(str).toString();
        }
        return str;
    }

    public static void getDataSeperator(StringBuffer uBuff, StringBuffer rBuff) throws PlatformException {
        String useruseperators = PlatformGlobals.getStringProperty(SSV_DATA_UNIT_SEPERATOR, null);
        if (useruseperators == null || StringUtils.isEmpty(useruseperators)) {
            uBuff.append('\u001f');
        } else {
            StringUtils.loadDataSeparators(uBuff, useruseperators);
        }
        String userrseperators = PlatformGlobals.getStringProperty(SSV_DATA_RECORD_SEPERATOR, null);
        if (userrseperators == null || StringUtils.isEmpty(userrseperators)) {
            rBuff.append('\u001e');
        } else {
            StringUtils.loadDataSeparators(rBuff, userrseperators);
        }
    }

    public static void loadDataSeparators(StringBuffer buf, String str) throws PlatformException {
        List list = StringUtils.split(str, ',');
        int count = list.size();
        for (int index = 0; index < count && index <= 4; ++index) {
            String codestr = list.get(index).toString().trim();
            if (codestr == null || codestr.length() <= 0) continue;
            int intval = codestr.startsWith("0x") ? Integer.decode(codestr) : StringUtils.toInt(codestr);
            if (intval > 127 || intval == 0) {
                throw new PlatformException("Could not deserialize: seperator = " + intval);
            }
            if (count < 2 && !StringUtils.isValidSperator(intval)) {
                throw new PlatformException("Could not deserialize: seperator = " + intval);
            }
            buf.append((char)intval);
        }
    }

    public static List split(String str, String separator) {
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        int slength = separator.length();
        while (true) {
            int index;
            if ((index = str.indexOf(separator, start)) == -1) break;
            int end = index;
            list.add(str.substring(start, end));
            start = end + slength;
        }
        list.add(str.substring(start));
        return list;
    }

    public static boolean isValidSperator(int val) {
        return val != 3 && val != 40 && val != 41 && val != 58 && val != 61;
    }

    private StringUtils() {
    }
}

