/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataRow;
import com.nexacro.java.xapi.data.DataSetConvertHelper;
import com.nexacro.java.xapi.data.DataSetDataConverter;
import com.nexacro.java.xapi.data.DataSetEvent;
import com.nexacro.java.xapi.data.DataSetListener;
import com.nexacro.java.xapi.data.DataSetRowTypeAccessor;
import com.nexacro.java.xapi.data.DataSetSavedDataAccessor;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.DefaultDataSetDataConverter;
import com.nexacro.java.xapi.data.PlatformSsvDataDeserializer;
import com.nexacro.java.xapi.data.PlatformSsvDataSerializer;
import com.nexacro.java.xapi.data.PlatformXmlDataDeserializer;
import com.nexacro.java.xapi.data.PlatformXmlDataSerializer;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8554107363861310920L;
    private transient Log log = null;
    public static final int SAVE_TYPE_NONE = 0;
    public static final int SAVE_TYPE_ALL = 1;
    public static final int SAVE_TYPE_NORMAL = 2;
    public static final int SAVE_TYPE_UPDATED = 3;
    public static final int SAVE_TYPE_DELETED = 4;
    public static final int SAVE_TYPE_CHANGED = 5;
    public static final int SAVE_TYPE_REMOVED = 4;
    public static final int ROW_TYPE_NORMAL = 0;
    public static final int ROW_TYPE_INSERTED = 1;
    public static final int ROW_TYPE_UPDATED = 2;
    public static final int ROW_TYPE_DELETED = 3;
    public static final int ROW_TYPE_REMOVED = 3;
    public static final String ROW_TYPE_NAME_NORMAL = "normal";
    public static final String ROW_TYPE_NAME_INSERTED = "inserted";
    public static final String ROW_TYPE_NAME_UPDATED = "updated";
    public static final String ROW_TYPE_NAME_DELETED = "deleted";
    public static final String ROW_TYPE_NAME_REMOVED = "removed";
    public static final int DEFAULT_SAVE_TYPE = 2;
    private static final String NAME_CHECK_KEY = "platform.data.DataSet.namecheck";
    private static final String DUPLICATED_COLUMN_NAME_CHECK_KEY = "platform.data.DataSet.duplicatedcolumnnamecheck";
    private static final String CONVERTING_TO_DATATYPE_KEY = "platform.data.DataSet.convertingtodatatype";
    private static final String DEFAULT_DATA_CONVERTER_KEY = "platform.data.DataSet.defaultdataconverter";
    private static final String GETTER_DATA_INDEX_CHECK_KEY = "platform.data.DataSet.getterdataindexcheck";
    private static final String SETTER_DATA_INDEX_CHECK_KEY = "platform.data.DataSet.setterdataindexcheck";
    protected List columnList;
    protected List rowList;
    private transient Map columnMap;
    private String name;
    private String alias;
    private String charset;
    private int saveType;
    private EventListenerList listenerList;
    private boolean isStoreDataChanges = true;
    private List savedRowList;
    private List removedRowList;
    private boolean isCheckingGetterDataIndex;
    private boolean isCheckingSetterDataIndex = true;
    private boolean changeStructureWithData;
    private boolean isConvertingToDataType;
    private DataSetDataConverter dataConverter;
    private DataSetDataConverter defaultDataConverter;

    public DataSet() {
        this(null);
    }

    public DataSet(String name) {
        this(name, null);
    }

    public DataSet(String name, String alias) {
        this.name = name;
        this.alias = alias;
        this.saveType = 0;
        this.isConvertingToDataType = PlatformGlobals.getBooleanProperty(CONVERTING_TO_DATATYPE_KEY, true);
        this.isCheckingGetterDataIndex = PlatformGlobals.getBooleanProperty(GETTER_DATA_INDEX_CHECK_KEY, false);
        this.isCheckingSetterDataIndex = PlatformGlobals.getBooleanProperty(SETTER_DATA_INDEX_CHECK_KEY, true);
        this.checkName(name, false);
        this.checkAlias(alias);
        this.columnMap = new HashMap();
        this.setColumnList(this.createColumnList());
        this.setRowList(this.createRowList());
        if (this.isStoreDataChanges()) {
            this.startStoreDataChanges();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkName(name, true);
        this.name = name;
    }

    public String getAlias() {
        return this.alias == null ? this.getName() : this.alias;
    }

    public void setAlias(String alias) {
        this.checkAlias(alias);
        this.alias = alias;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isCheckingGetterDataIndex() {
        return this.isCheckingGetterDataIndex;
    }

    public void setCheckingGetterDataIndex(boolean isChecking) {
        this.isCheckingGetterDataIndex = isChecking;
    }

    public boolean isCheckingSetterDataIndex() {
        return this.isCheckingSetterDataIndex;
    }

    public void setCheckingSetterDataIndex(boolean isChecking) {
        this.isCheckingSetterDataIndex = isChecking;
    }

    public boolean canChangeStructureWithData() {
        return this.changeStructureWithData;
    }

    public void setChangeStructureWithData(boolean changeStructureWithData) {
        this.changeStructureWithData = changeStructureWithData;
    }

    public boolean isConvertingToDataType() {
        return this.isConvertingToDataType;
    }

    public void setConvertingToDataType(boolean isConvertingToDataType) {
        this.isConvertingToDataType = isConvertingToDataType;
    }

    public int getSaveType() {
        return this.saveType;
    }

    public void setSaveType(int saveType) {
        this.saveType = saveType;
    }

    public DataSetDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataSetDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    public DataSetDataConverter getCurrentDataConverter() {
        if (this.dataConverter == null) {
            if (this.defaultDataConverter == null) {
                this.defaultDataConverter = DataSetConvertHelper.getDefaultDataSetDataConverter();
                if (this.defaultDataConverter != null) {
                    this.getLogger();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)StringUtils.normalizeSpace((String)("Creating DataSetDataConverter:, defaultDataConverter=" + this.defaultDataConverter)));
                    }
                }
                if (this.defaultDataConverter == null) {
                    this.defaultDataConverter = new DefaultDataSetDataConverter();
                }
            }
            return this.defaultDataConverter;
        }
        return this.dataConverter;
    }

    public int getColumnDataType(String name) {
        ColumnHeader header = this.getColumn(name);
        return header == null ? 0 : header.getDataType();
    }

    public int getColumnDataType(int index) {
        ColumnHeader header = this.getColumn(index);
        return header == null ? 0 : header.getDataType();
    }

    public void setColumnDataType(String name, int dataType) {
        int index = this.indexOfColumn(name);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown column header name: " + name);
        }
        this.setColumnDataType(index, dataType);
    }

    public void setColumnDataType(int index, int dataType) {
        ColumnHeader header = this.getColumn(index);
        if (header == null) {
            throw new IllegalArgumentException("Unknown column header index: " + index);
        }
        if (header.getDataType() == dataType) {
            return;
        }
        header.setDataType(dataType);
        if (this.isConvertingToDataType()) {
            this.changeColumnDataType(index, dataType);
        }
    }

    private void changeColumnDataType(int index, int dataType) {
        this.changeColumnDataType(this.rowList, index, dataType, this.charset);
        this.changeColumnDataType(this.savedRowList, index, dataType, this.charset);
        this.changeColumnDataType(this.removedRowList, index, dataType, this.charset);
    }

    private void changeColumnDataType(List list, int index, int dataType, String charset) {
        DataSetDataConverter converter = this.getCurrentDataConverter();
        int count = list == null ? -1 : list.size();
        for (int i = 0; i < count; ++i) {
            DataRow row = (DataRow)list.get(i);
            if (row == null) continue;
            Object value = row.get(index);
            Object converted = converter.convert(this, i, index, value, dataType, charset);
            row.set(index, converted);
        }
    }

    public ColumnHeader getColumn(String name) {
        int index = this.indexOfColumn(name);
        ColumnHeader header = this.getColumn(index);
        if (header == null) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("getColumn(String): header=" + header + ", name=" + name + ", index=" + index)));
            }
        }
        return header;
    }

    public ColumnHeader getColumn(int index) {
        boolean contains = this.containsColumn(index);
        if (contains) {
            return (ColumnHeader)this.columnList.get(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("getColumn(int): index=" + index + ", contains=" + contains)));
        }
        return null;
    }

    public void addColumn(ColumnHeader header) {
        this.checkDuplicatedColumn(header, -1, "add");
        this.increaseColumn(-1, "add");
        int size = this.columnList.size();
        String name = header.getName();
        this.columnMap.put(name, new Integer(size));
        this.columnList.add(header);
        this.fireDataSetStructureChanged();
    }

    public void addColumn(String name, int dataType) {
        this.addColumn(name, dataType, DataTypes.getDefaultSize(dataType));
    }

    public void addColumn(String name, int dataType, int dataSize) {
        this.addColumn(this.createColumnHeader(name, dataType, dataSize));
    }

    public void addColumn(String name, DataType dataType) {
        this.addColumn(name, dataType, PlatformDataType.getDefaultSize(dataType));
    }

    public void addColumn(String name, DataType dataType, int dataSize) {
        this.addColumn(this.createColumnHeader(name, dataType, dataSize));
    }

    public void addConstantColumn(String name, Object value) {
        this.addConstantColumn(name, DataTypes.findType(value), value);
    }

    public void addConstantColumn(String name, int dataType, Object value) {
        this.addConstantColumn(name, dataType, DataTypes.getDefaultSize(dataType), value);
    }

    public void addConstantColumn(String name, int dataType, int dataSize, Object value) {
        this.addColumn(this.createConstantColumnHeader(name, dataType, dataSize, value));
    }

    public void addConstantColumn(String name, DataType dataType, Object value) {
        this.addConstantColumn(name, dataType, PlatformDataType.getDefaultSize(dataType), value);
    }

    public void addConstantColumn(String name, DataType dataType, int dataSize, Object value) {
        this.addColumn(this.createConstantColumnHeader(name, dataType, dataSize, value));
    }

    public void setColumn(int index, ColumnHeader header) {
        ColumnHeader oldHeader = (ColumnHeader)this.columnList.get(index);
        if (oldHeader == header) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Same header: " + header)));
            }
            return;
        }
        this.checkDuplicatedColumn(header, index, "set");
        this.clearColumn(index, "set");
        String oldName = oldHeader.getName();
        this.columnMap.remove(oldName);
        String name = header.getName();
        this.columnMap.put(name, new Integer(index));
        this.columnList.set(index, header);
        this.fireDataSetStructureChanged();
    }

    public void insertColumn(int index, ColumnHeader header) {
        this.checkDuplicatedColumn(header, -1, "insert");
        this.increaseColumn(index, "insert");
        int size = this.columnList.size();
        if (size == 0 || size == index) {
            String name = header.getName();
            this.columnMap.put(name, new Integer(index));
        } else {
            this.columnMap.clear();
        }
        this.columnList.add(index, header);
        this.fireDataSetStructureChanged();
    }

    public ColumnHeader removeColumn(String name) {
        return this.removeColumn(this.indexOfColumn(name));
    }

    public ColumnHeader removeColumn(int index) {
        boolean hasData = this.hasData();
        boolean changeStructureWithData = this.canChangeStructureWithData();
        if (hasData && !changeStructureWithData) {
            throw new IllegalStateException("Unable to remove column: hasData=true, changeStructureWithData=false, index=" + index);
        }
        boolean contains = this.containsColumn(index);
        if (contains) {
            if (hasData) {
                this.decreaseColumn(index);
            }
            ColumnHeader removedHeader = (ColumnHeader)this.columnList.remove(index);
            this.columnMap.clear();
            this.fireDataSetStructureChanged();
            return removedHeader;
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("removeColumn(int): index=" + index + ", contains=" + contains)));
        }
        return null;
    }

    public int indexOfColumn(String name) {
        if (name == null || "".equals(name)) {
            return -1;
        }
        this.checkColumnMap();
        Object index = this.columnMap.get(name);
        return index == null ? -1 : (Integer)index;
    }

    public boolean containsColumn(String name) {
        if (name == null || "".equals(name)) {
            return false;
        }
        this.checkColumnMap();
        return this.columnMap.get(name) != null;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public void copyColumn(ColumnHeader source) {
        if (this.hasData() && !this.canChangeStructureWithData()) {
            throw new IllegalStateException("Unable to copy column: hasData=true, changeStructureWithData=false");
        }
        String name = source.getName();
        int dataType = source.getDataType();
        int dataSize = source.getDataSize();
        Object value = source.getValue();
        ColumnHeader header = source.isConstant() ? this.createConstantColumnHeader(name, dataType, dataSize, value) : this.createColumnHeader(name, dataType, dataSize);
        this.addColumn(header);
    }

    public void copyColumn(int index, ColumnHeader source) {
        if (this.hasData() && !this.canChangeStructureWithData()) {
            throw new IllegalStateException("Unable to copy column: hasData=true, changeStructureWithData=false, index=" + index);
        }
        String name = source.getName();
        int dataType = source.getDataType();
        int dataSize = source.getDataSize();
        Object value = source.getValue();
        ColumnHeader header = source.isConstant() ? this.createConstantColumnHeader(name, dataType, dataSize, value) : this.createColumnHeader(name, dataType, dataSize);
        this.setColumn(index, header);
    }

    private void increaseColumn(int index, String command) {
        if (this.hasData()) {
            if (this.canChangeStructureWithData()) {
                this.increaseColumn(index);
            } else {
                throw new IllegalStateException("Unable to " + command + " column: hasData=true, changeStructureWithData=false, index=" + index);
            }
        }
    }

    private void increaseColumn(int index) {
        int rowCount = this.rowList.size();
        for (int i = 0; i < rowCount; ++i) {
            Object obj = this.rowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).increase();
                continue;
            }
            ((DataRow)obj).increase(index);
        }
        int savedRowCount = this.savedRowList.size();
        for (int i = 0; i < savedRowCount; ++i) {
            Object obj = this.savedRowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).increase();
                continue;
            }
            ((DataRow)obj).increase(index);
        }
        int removedRowCount = this.removedRowList.size();
        for (int i = 0; i < removedRowCount; ++i) {
            Object obj = this.removedRowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).increase();
                continue;
            }
            ((DataRow)obj).increase(index);
        }
    }

    private void decreaseColumn(int index) {
        int rowCount = this.rowList.size();
        for (int i = 0; i < rowCount; ++i) {
            Object obj = this.rowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).decrease();
                continue;
            }
            ((DataRow)obj).decrease(index);
        }
        int savedRowCount = this.savedRowList.size();
        for (int i = 0; i < savedRowCount; ++i) {
            Object obj = this.savedRowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).decrease();
                continue;
            }
            ((DataRow)obj).decrease(index);
        }
        int removedRowCount = this.removedRowList.size();
        for (int i = 0; i < removedRowCount; ++i) {
            Object obj = this.removedRowList.get(i);
            if (obj == null) continue;
            if (index == -1) {
                ((DataRow)obj).decrease();
                continue;
            }
            ((DataRow)obj).decrease(index);
        }
    }

    private void clearColumn(int index, String command) {
        if (this.hasData()) {
            if (this.canChangeStructureWithData()) {
                this.clearColumn(index);
            } else {
                throw new IllegalStateException("Unable to " + command + " column: hasData=true, changeStructureWithData=false, index=" + index);
            }
        }
    }

    private void clearColumn(int index) {
        int rowCount = this.rowList.size();
        for (int i = 0; i < rowCount; ++i) {
            Object obj = this.rowList.get(i);
            if (obj == null) continue;
            ((DataRow)obj).set(index, null);
        }
        int savedRowCount = this.savedRowList.size();
        for (int i = 0; i < savedRowCount; ++i) {
            Object obj = this.savedRowList.get(i);
            if (obj == null) continue;
            ((DataRow)obj).set(index, null);
        }
        int removedRowCount = this.removedRowList.size();
        for (int i = 0; i < removedRowCount; ++i) {
            Object obj = this.removedRowList.get(i);
            if (obj == null) continue;
            ((DataRow)obj).set(index, null);
        }
    }

    DataRow getRow(int index) {
        boolean contains = this.containsRow(index);
        if (contains) {
            return (DataRow)this.rowList.get(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("getRow(int): index=" + index + ", contains=" + contains)));
        }
        return null;
    }

    void setRow(int index, DataRow row) {
        DataRow oldRow = (DataRow)this.rowList.get(index);
        if (oldRow == row) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Same row: " + row)));
            }
            return;
        }
        if (this.isStoreDataChanges()) {
            int oldRowType = oldRow.getType();
            if (oldRowType == 0) {
                row.setType(2);
                this.setSavedRow(index, oldRow);
            } else if (oldRowType == 1) {
                row.setType(1);
            } else if (oldRowType == 2) {
                row.setType(2);
            } else {
                this.getLogger();
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)StringUtils.normalizeSpace((String)("Invalid row type: oldRowType=" + oldRowType)));
                }
            }
        } else {
            row.setType(0);
        }
        this.rowList.set(index, row);
        this.fireDataSetDataUpdated(index, index);
    }

    void addRow(DataRow row) {
        if (this.isStoreDataChanges()) {
            row.setType(1);
            this.rowList.add(row);
        } else {
            row.setType(0);
            this.rowList.add(row);
        }
        this.fireDataSetRowInserted(this.rowList.size() - 1, this.rowList.size() - 1);
    }

    void insertRow(int index, DataRow row) {
        if (this.isStoreDataChanges()) {
            row.setType(1);
            this.rowList.add(index, row);
            this.insertSavedRow(index, null);
        } else {
            row.setType(0);
            this.rowList.add(index, row);
        }
        this.fireDataSetRowInserted(index, index);
    }

    public void removeRow(int index) {
        this.removeRow(index, false);
    }

    private void removeRow(int index, boolean isSave) {
        boolean contains = this.containsRow(index);
        if (contains) {
            DataRow removedRow = (DataRow)this.rowList.remove(index);
            if (this.isStoreDataChanges() || isSave) {
                int rowType = removedRow.getType();
                if (rowType == 0) {
                    this.addRemovedRow(removedRow);
                    this.removeSavedRow(index);
                } else if (rowType == 1) {
                    this.removeSavedRow(index);
                } else if (rowType == 2) {
                    DataRow savedRow = this.removeSavedRow(index);
                    this.addRemovedRow(savedRow);
                } else {
                    this.getLogger();
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)StringUtils.normalizeSpace((String)("Invalid row type: " + rowType)));
                    }
                }
            }
            this.fireDataSetRowRemoved(index, index);
        } else {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("removeRow(int): index=" + index + ", contains=" + contains)));
            }
        }
    }

    public int newRow() {
        this.addRow(this.createRow());
        return this.getRowCount() - 1;
    }

    public int newRow(int index) {
        this.insertRow(index, this.createRow());
        return index;
    }

    DataRow createRow() {
        return new DataRow(this.getColumnCount());
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    void copyRow(DataRow source) {
        DataRow row = this.createRow();
        row.copyFrom(source);
        row.setType(source.getType());
        this.rowList.add(row);
    }

    void copyRow(int index, DataRow source) {
        DataRow row = this.createRow();
        row.copyFrom(source);
        row.setType(source.getType());
        this.rowList.set(index, row);
    }

    public int getRowType(int index) {
        return this.getRow(index).getType();
    }

    public void setRowType(int index, int rowType) {
        DataRow row = this.getRow(index);
        if (this.isStoreDataChanges()) {
            int oldRowType = row.getType();
            if (oldRowType == 0) {
                if (rowType != 0) {
                    if (rowType == 1) {
                        row.setType(1);
                    } else if (rowType == 2) {
                        row.setType(2);
                        this.newSavedRow(index);
                    } else if (rowType == 3) {
                        this.removeRow(index);
                    }
                }
            } else if (oldRowType == 1) {
                if (rowType == 0) {
                    row.setType(0);
                } else if (rowType != 1) {
                    if (rowType == 2) {
                        row.setType(2);
                        this.newSavedRow(index);
                    } else if (rowType == 3) {
                        this.removeRow(index);
                    }
                }
            } else if (oldRowType == 2) {
                if (rowType == 0) {
                    row.setType(0);
                    this.clearSavedRow(index);
                } else if (rowType == 1) {
                    row.setType(1);
                    this.clearSavedRow(index);
                } else if (rowType != 2 && rowType == 3) {
                    this.removeRow(index);
                }
            }
        } else if (rowType == 0 || rowType == 1 || rowType == 2) {
            row.setType(rowType);
        } else if (rowType == 3) {
            this.removeRow(index, true);
        }
    }

    public String getRowTypeName(int index) {
        int rowType = this.getRowType(index);
        if (rowType == 0) {
            return ROW_TYPE_NAME_NORMAL;
        }
        if (rowType == 1) {
            return ROW_TYPE_NAME_INSERTED;
        }
        if (rowType == 2) {
            return ROW_TYPE_NAME_UPDATED;
        }
        if (rowType == 3) {
            return ROW_TYPE_NAME_DELETED;
        }
        if (rowType == 3) {
            return ROW_TYPE_NAME_REMOVED;
        }
        throw new IllegalArgumentException("Invalid row type: index=" + index + ", rowType=" + rowType);
    }

    public void setRowTypeName(int index, String rowType) {
        if (ROW_TYPE_NAME_NORMAL.equals(rowType)) {
            this.setRowType(index, 0);
        } else if (ROW_TYPE_NAME_INSERTED.equals(rowType)) {
            this.setRowType(index, 1);
        } else if (ROW_TYPE_NAME_UPDATED.equals(rowType)) {
            this.setRowType(index, 2);
        } else if (ROW_TYPE_NAME_DELETED.equals(rowType)) {
            this.setRowType(index, 3);
        } else if (ROW_TYPE_NAME_REMOVED.equals(rowType)) {
            this.setRowType(index, 3);
        } else {
            throw new IllegalArgumentException("Invalid row type: index=" + index + ", rowType=" + rowType);
        }
    }

    public Object getObject(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getObject(rowIndex, this.indexOfColumn(columnName));
    }

    public String getString(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getString(rowIndex, this.indexOfColumn(columnName));
    }

    public String getString(int rowIndex, String columnName, String defaultValue) {
        String value = this.getString(rowIndex, columnName);
        return value == null ? defaultValue : value;
    }

    public int getInt(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getInt(rowIndex, this.indexOfColumn(columnName));
    }

    public boolean getBoolean(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getBoolean(rowIndex, this.indexOfColumn(columnName));
    }

    public long getLong(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getLong(rowIndex, this.indexOfColumn(columnName));
    }

    public float getFloat(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getFloat(rowIndex, this.indexOfColumn(columnName));
    }

    public double getDouble(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getDouble(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getBigDecimal(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getBigDecimal(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getDecimal(int rowIndex, String columnName) {
        return this.getBigDecimal(rowIndex, columnName);
    }

    public Date getDateTime(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getDateTime(rowIndex, this.indexOfColumn(columnName));
    }

    public byte[] getBlob(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getBlob(rowIndex, this.indexOfColumn(columnName));
    }

    public Object getObject(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toObject(this, rowIndex, columnIndex, value);
    }

    public String getString(int rowIndex, int columnIndex) {
        Object obj = this.getValue(rowIndex, columnIndex);
        ColumnHeader header = this.getColumn(columnIndex);
        int dataType = header == null ? 0 : header.getDataType();
        String charset = this.getCharset();
        return this.getCurrentDataConverter().toString(this, rowIndex, columnIndex, obj, dataType, charset);
    }

    public String getString(int rowIndex, int columnIndex, String defaultValue) {
        String value = this.getString(rowIndex, columnIndex);
        return value == null ? defaultValue : value;
    }

    public int getInt(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toInt(this, rowIndex, columnIndex, value);
    }

    public boolean getBoolean(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBoolean(this, rowIndex, columnIndex, value);
    }

    public long getLong(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toLong(this, rowIndex, columnIndex, value);
    }

    public float getFloat(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toFloat(this, rowIndex, columnIndex, value);
    }

    public double getDouble(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDouble(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getBigDecimal(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBigDecimal(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getDecimal(int rowIndex, int columnIndex) {
        return this.getBigDecimal(rowIndex, columnIndex);
    }

    public Date getDateTime(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDateTime(this, rowIndex, columnIndex, value);
    }

    public byte[] getBlob(int rowIndex, int columnIndex) {
        Object value = this.getValue(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBlob(this, rowIndex, columnIndex, value, this.getCharset());
    }

    public void set(int rowIndex, String columnName, Object value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, String value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, int value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, boolean value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, long value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, float value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, double value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, BigDecimal value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, Date value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, String columnName, byte[] value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.set(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void set(int rowIndex, int columnIndex, Object value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            String charset = this.getCharset();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType, charset);
        } else {
            obj = value;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, String value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            String charset = this.getCharset();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType, charset);
        } else {
            obj = value;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, int value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = new Integer(value);
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, boolean value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            Object object = obj = value ? Boolean.TRUE : Boolean.FALSE;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, long value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = new Long(value);
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, float value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = new Float(value);
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, double value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = new Double(value);
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, BigDecimal value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = value;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, Date value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType);
        } else {
            obj = value;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public void set(int rowIndex, int columnIndex, byte[] value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        ColumnHeader header = this.getColumn(columnIndex);
        DataRow row = this.getRow(rowIndex);
        if (header == null || row == null) {
            return;
        }
        if (this.isStoreDataChanges()) {
            this.saveRow(rowIndex);
        }
        Object obj = null;
        if (this.isConvertingToDataType()) {
            DataSetDataConverter converter = this.getCurrentDataConverter();
            int dataType = header.getDataType();
            String charset = this.getCharset();
            obj = converter.convert(this, rowIndex, columnIndex, value, dataType, charset);
        } else {
            obj = value;
        }
        if (header.isConstant()) {
            header.setValue(obj);
        } else {
            row.set(columnIndex, obj);
        }
        this.fireDataSetDataUpdated(rowIndex, rowIndex, columnIndex);
    }

    public boolean hasData() {
        return this.hasData(true);
    }

    public boolean hasData(boolean includeChangedData) {
        boolean hasNormalData;
        boolean bl = hasNormalData = !this.rowList.isEmpty();
        if (includeChangedData) {
            return hasNormalData || this.hasDataChanges();
        }
        return hasNormalData;
    }

    public void clearData() {
        this.clearData(false);
    }

    public void clearData(boolean preserveChangedData) {
        if (preserveChangedData) {
            int count = this.getRowCount();
            if (count > 0) {
                if (this.isStoreDataChanges()) {
                    for (DataRow row : this.rowList) {
                        row.setType(3);
                    }
                    this.removedRowList.addAll(this.rowList);
                }
                this.rowList.clear();
                this.fireDataSetRowRemoved(0, count - 1);
            }
        } else {
            this.clearDataChanges();
            int count = this.getRowCount();
            if (count > 0) {
                this.rowList.clear();
                this.fireDataSetRowRemoved(0, count - 1);
            }
        }
    }

    public void clear() {
        this.clearData();
        int count = this.columnList.size();
        if (count == 0) {
            return;
        }
        this.columnList.clear();
        this.columnMap.clear();
        this.fireDataSetStructureChanged();
    }

    public void copyTo(DataSet target) {
        this.copyTo(target, true);
    }

    public void copyTo(DataSet target, boolean copyData) {
        this.copy(this, target, copyData);
    }

    public void copyFrom(DataSet source) {
        this.copyFrom(source, true);
    }

    public void copyFrom(DataSet source, boolean copyData) {
        this.copy(source, this, copyData);
    }

    public void copyDataTo(DataSet target) {
        this.copyDataTo(target, false);
    }

    public void copyDataTo(DataSet target, boolean preserveData) {
        this.copyData(this, target, preserveData);
    }

    public void copyDataFrom(DataSet source) {
        this.copyDataFrom(source, false);
    }

    public void copyDataFrom(DataSet source, boolean preserveData) {
        this.copyData(source, this, preserveData);
    }

    public void startStoreDataChanges() {
        this.startStoreDataChanges(false);
    }

    public void startStoreDataChanges(boolean preserveData) {
        this.isStoreDataChanges = true;
        if (this.savedRowList == null) {
            this.savedRowList = this.createRowList();
        }
        if (this.removedRowList == null) {
            this.removedRowList = this.createRowList();
        }
        if (!preserveData) {
            this.clearDataChanges();
        }
    }

    public void stopStoreDataChanges() {
        this.stopStoreDataChanges(true);
    }

    public void stopStoreDataChanges(boolean preserveData) {
        if (this.isStoreDataChanges) {
            this.isStoreDataChanges = false;
        }
        if (!preserveData) {
            this.clearDataChanges();
        }
    }

    public boolean isStoreDataChanges() {
        return this.isStoreDataChanges;
    }

    public boolean hasDataChanges() {
        return this.hasSavedData() || this.hasRemovedData();
    }

    public void clearDataChanges() {
        this.clearSavedData();
        this.clearRemovedData();
    }

    public void setSavepoint() {
        this.startStoreDataChanges();
    }

    public void setSavepoint(boolean preserveData) {
        this.startStoreDataChanges(preserveData);
    }

    public void releaseSavepoint() {
        this.stopStoreDataChanges();
    }

    public void releaseSavepoint(boolean preserveData) {
        this.stopStoreDataChanges(preserveData);
    }

    public boolean hasSavepoint() {
        return this.isStoreDataChanges();
    }

    void rollback() {
        throw new UnsupportedOperationException();
    }

    public boolean hasChangedData() {
        return this.hasDataChanges();
    }

    public void clearChangedData() {
        this.clearDataChanges();
    }

    DataRow getSavedRow(int index) {
        if (this.savedRowList == null || index >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int savedRowCount = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)StringUtils.normalizeSpace((String)("getSavedRow(int): index=" + index + ", savedRowCount=" + savedRowCount)));
            }
            return null;
        }
        return (DataRow)this.savedRowList.get(index);
    }

    void setSavedRow(int index, DataRow row) {
        this.checkSavedRowList();
        int count = index - this.savedRowList.size();
        if (count < 0) {
            this.savedRowList.set(index, row);
        } else if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.savedRowList.add(null);
            }
            this.savedRowList.add(row);
        } else {
            this.savedRowList.add(row);
        }
    }

    void insertSavedRow(int index, DataRow row) {
        this.checkSavedRowList();
        int delta = index - this.savedRowList.size();
        if (row == null) {
            if (delta < 0) {
                this.savedRowList.add(index, null);
            }
        } else if (delta < 0) {
            this.savedRowList.add(index, row);
        } else {
            for (int i = 0; i < delta; ++i) {
                this.savedRowList.add(null);
            }
            this.savedRowList.add(row);
        }
    }

    DataRow removeSavedRow(int index) {
        if (this.savedRowList == null || index >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int savedRowCount = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)StringUtils.normalizeSpace((String)("removeSavedRow(int): index=" + index + ", savedRowCount=" + savedRowCount)));
            }
            return null;
        }
        return (DataRow)this.savedRowList.remove(index);
    }

    DataRow clearSavedRow(int index) {
        if (this.savedRowList == null || index >= this.savedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int savedRowCount = this.savedRowList == null ? -1 : this.savedRowList.size();
                this.log.debug((Object)StringUtils.normalizeSpace((String)("clearSavedRow(int): index=" + index + ", savedRowCount=" + savedRowCount)));
            }
            return null;
        }
        return this.savedRowList.set(index, null);
    }

    DataRow newSavedRow(int index) {
        DataRow row = this.createRow();
        this.setSavedRow(index, row);
        return row;
    }

    public boolean hasSavedRow(int index) {
        if (this.savedRowList == null || index >= this.savedRowList.size()) {
            return false;
        }
        return this.savedRowList.get(index) != null;
    }

    public int getSavedRowCount() {
        int count;
        int n = count = this.savedRowList == null ? 0 : this.savedRowList.size();
        if (count == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < count; ++i) {
            if (this.savedRowList.get(i) == null) continue;
            ++n2;
        }
        return n2;
    }

    void copySavedRow(int index, DataRow source) {
        DataRow row = this.createRow();
        row.copyFrom(source);
        row.setType(source.getType());
        this.setSavedRow(index, row);
    }

    public void clearSavedData() {
        if (this.savedRowList != null) {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getRow(i).setType(0);
            }
            this.savedRowList.clear();
        }
    }

    public boolean hasSavedData() {
        return this.getSavedRowCount() > 0;
    }

    public Object getSavedData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedData(rowIndex, this.indexOfColumn(columnName));
    }

    public String getSavedStringData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedStringData(rowIndex, this.indexOfColumn(columnName));
    }

    public String getSavedStringData(int rowIndex, String columnName, String defaultValue) {
        String value = this.getSavedStringData(rowIndex, columnName);
        return value == null ? defaultValue : value;
    }

    public int getSavedIntData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedIntData(rowIndex, this.indexOfColumn(columnName));
    }

    public boolean getSavedBooleanData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedBooleanData(rowIndex, this.indexOfColumn(columnName));
    }

    public long getSavedLongData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedLongData(rowIndex, this.indexOfColumn(columnName));
    }

    public float getSavedFloatData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedFloatData(rowIndex, this.indexOfColumn(columnName));
    }

    public double getSavedDoubleData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedDoubleData(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getSavedBigDecimalData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedBigDecimalData(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getSavedDecimalData(int rowIndex, String columnName) {
        return this.getSavedBigDecimalData(rowIndex, columnName);
    }

    public Date getSavedDateTimeData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedDateTimeData(rowIndex, this.indexOfColumn(columnName));
    }

    public byte[] getSavedBlobData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getSavedBlobData(rowIndex, this.indexOfColumn(columnName));
    }

    public Object getSavedData(int rowIndex, int columnIndex) {
        ColumnHeader header;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        if ((header = this.getColumn(columnIndex)) == null) {
            return null;
        }
        if (header.isConstant()) {
            return header.getValue();
        }
        DataRow row = this.getSavedRow(rowIndex);
        return row == null ? null : row.get(columnIndex);
    }

    public String getSavedStringData(int rowIndex, int columnIndex) {
        Object obj = this.getSavedData(rowIndex, columnIndex);
        ColumnHeader header = this.getColumn(columnIndex);
        int dataType = header == null ? 0 : header.getDataType();
        String charset = this.getCharset();
        return this.getCurrentDataConverter().toString(this, rowIndex, columnIndex, obj, dataType, charset);
    }

    public String getSavedStringData(int rowIndex, int columnIndex, String defaultValue) {
        String value = this.getSavedStringData(rowIndex, columnIndex);
        return value == null ? defaultValue : value;
    }

    public int getSavedIntData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toInt(this, rowIndex, columnIndex, value);
    }

    public boolean getSavedBooleanData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBoolean(this, rowIndex, columnIndex, value);
    }

    public long getSavedLongData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toLong(this, rowIndex, columnIndex, value);
    }

    public float getSavedFloatData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toFloat(this, rowIndex, columnIndex, value);
    }

    public double getSavedDoubleData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDouble(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getSavedBigDecimalData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBigDecimal(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getSavedDecimalData(int rowIndex, int columnIndex) {
        return this.getSavedBigDecimalData(rowIndex, columnIndex);
    }

    public Date getSavedDateTimeData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDateTime(this, rowIndex, columnIndex, value);
    }

    public byte[] getSavedBlobData(int rowIndex, int columnIndex) {
        Object value = this.getSavedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBlob(this, rowIndex, columnIndex, value);
    }

    public void setSavedData(int rowIndex, String columnName, Object value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.setSavedData(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void setSavedData(int rowIndex, int columnIndex, Object value) {
        DataRow row;
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        if ((row = this.getSavedRow(rowIndex)) == null) {
            row = this.newSavedRow(rowIndex);
        }
        row.set(columnIndex, value);
    }

    DataRow getRemovedRow(int index) {
        if (this.removedRowList == null || index >= this.removedRowList.size()) {
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                int removedRowCount = this.removedRowList == null ? -1 : this.removedRowList.size();
                this.log.debug((Object)StringUtils.normalizeSpace((String)("getRemovedRow(int): index=" + index + ", removedRowCount=" + removedRowCount)));
            }
            return null;
        }
        return (DataRow)this.removedRowList.get(index);
    }

    void addRemovedRow(DataRow row) {
        this.checkRemovedRowList();
        row.setType(3);
        this.removedRowList.add(row);
    }

    public int newRemovedRow() {
        this.checkRemovedRowList();
        DataRow row = this.createRow();
        this.removedRowList.add(row);
        return this.removedRowList.size() - 1;
    }

    public int getRemovedRowCount() {
        return this.removedRowList == null ? 0 : this.removedRowList.size();
    }

    void copyRemovedRow(DataRow source) {
        DataRow row = this.createRow();
        row.copyFrom(source);
        row.setType(source.getType());
        this.addRemovedRow(row);
    }

    public void clearRemovedData() {
        if (this.removedRowList != null) {
            this.removedRowList.clear();
        }
    }

    public boolean hasRemovedData() {
        return this.getRemovedRowCount() > 0;
    }

    public Object getRemovedData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedData(rowIndex, this.indexOfColumn(columnName));
    }

    public String getRemovedStringData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedStringData(rowIndex, this.indexOfColumn(columnName));
    }

    public String getRemovedStringData(int rowIndex, String columnName, String defaultValue) {
        String value = this.getRemovedStringData(rowIndex, columnName);
        return value == null ? defaultValue : value;
    }

    public int getRemovedIntData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedIntData(rowIndex, this.indexOfColumn(columnName));
    }

    public boolean getRemovedBooleanData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedBooleanData(rowIndex, this.indexOfColumn(columnName));
    }

    public long getRemovedLongData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedLongData(rowIndex, this.indexOfColumn(columnName));
    }

    public float getRemovedFloatData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedFloatData(rowIndex, this.indexOfColumn(columnName));
    }

    public double getRemovedDoubleData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedDoubleData(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getRemovedBigDecimalData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedBigDecimalData(rowIndex, this.indexOfColumn(columnName));
    }

    public BigDecimal getRemovedDecimalData(int rowIndex, String columnName) {
        return this.getRemovedBigDecimalData(rowIndex, columnName);
    }

    public Date getRemovedDateTimeData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedDateTimeData(rowIndex, this.indexOfColumn(columnName));
    }

    public byte[] getRemovedBlobData(int rowIndex, String columnName) {
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        return this.getRemovedBlobData(rowIndex, this.indexOfColumn(columnName));
    }

    public Object getRemovedData(int rowIndex, int columnIndex) {
        ColumnHeader header;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRemovedRowIndex(rowIndex);
        }
        if ((header = this.getColumn(columnIndex)) == null) {
            return null;
        }
        if (header.isConstant()) {
            return header.getValue();
        }
        DataRow row = this.getRemovedRow(rowIndex);
        return row == null ? null : row.get(columnIndex);
    }

    public String getRemovedStringData(int rowIndex, int columnIndex) {
        Object obj = this.getRemovedData(rowIndex, columnIndex);
        ColumnHeader header = this.getColumn(columnIndex);
        int dataType = header == null ? 0 : header.getDataType();
        String charset = this.getCharset();
        return this.getCurrentDataConverter().toString(this, rowIndex, columnIndex, obj, dataType, charset);
    }

    public String getRemovedStringData(int rowIndex, int columnIndex, String defaultValue) {
        String value = this.getRemovedStringData(rowIndex, columnIndex);
        return value == null ? defaultValue : value;
    }

    public int getRemovedIntData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toInt(this, rowIndex, columnIndex, value);
    }

    public boolean getRemovedBooleanData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBoolean(this, rowIndex, columnIndex, value);
    }

    public long getRemovedLongData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toLong(this, rowIndex, columnIndex, value);
    }

    public float getRemovedFloatData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toFloat(this, rowIndex, columnIndex, value);
    }

    public double getRemovedDoubleData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDouble(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getRemovedBigDecimalData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBigDecimal(this, rowIndex, columnIndex, value);
    }

    public BigDecimal getRemovedDecimalData(int rowIndex, int columnIndex) {
        return this.getRemovedBigDecimalData(rowIndex, columnIndex);
    }

    public Date getRemovedDateTimeData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toDateTime(this, rowIndex, columnIndex, value);
    }

    public byte[] getRemovedBlobData(int rowIndex, int columnIndex) {
        Object value = this.getRemovedData(rowIndex, columnIndex);
        return this.getCurrentDataConverter().toBlob(this, rowIndex, columnIndex, value);
    }

    public void setRemovedData(int rowIndex, String columnName, Object value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnName(columnName);
        }
        this.setRemovedData(rowIndex, this.indexOfColumn(columnName), value);
    }

    public void setRemovedData(int rowIndex, int columnIndex, Object value) {
        if (this.isCheckingSetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRemovedRowIndex(rowIndex);
        }
        DataRow row = this.getRemovedRow(rowIndex);
        row.set(columnIndex, value);
    }

    public void addDataSetListener(DataSetListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("addDataSetListener: " + listener)));
        }
        this.listenerList.add(DataSetListener.class, listener);
    }

    public void removeDataSetListener(DataSetListener listener) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            int listenerCount = this.listenerList == null ? -1 : this.listenerList.getListenerCount();
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("removeDataSetListener: listenerCount=" + listenerCount + ", listener=" + listener)));
            }
            return;
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("removeDataSetListener=" + listener)));
        }
        this.listenerList.remove(DataSetListener.class, listener);
    }

    public DataSet getClone() {
        try {
            return (DataSet)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSet ds = (DataSet)super.clone();
        ds.columnList = (List)((ArrayList)this.columnList).clone();
        ds.rowList = (List)((ArrayList)this.rowList).clone();
        ds.savedRowList = this.savedRowList == null ? null : (List)((ArrayList)this.savedRowList).clone();
        ds.removedRowList = this.removedRowList == null ? null : (List)((ArrayList)this.removedRowList).clone();
        return ds;
    }

    public boolean equals(Object obj) {
        DataSet another;
        if (obj instanceof DataSet && this.equalsName(another = (DataSet)obj) && this.equalsAlias(another) && this.equalsCharset(another) && this.saveType == another.saveType && this.isStoreDataChanges == another.isStoreDataChanges && this.isCheckingGetterDataIndex == another.isCheckingGetterDataIndex && this.isCheckingSetterDataIndex == another.isCheckingSetterDataIndex && this.changeStructureWithData == another.changeStructureWithData && this.isConvertingToDataType == another.isConvertingToDataType && this.equalsDataConverter(another) && this.equalsDefaultDataConverter(another)) {
            return this.equalsStructure(another) && this.equalsData(another);
        }
        return false;
    }

    public boolean equalsStructure(DataSet another) {
        if (another == null) {
            return false;
        }
        if (this.getColumnCount() != another.getColumnCount()) {
            return false;
        }
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.getColumn(i).equals(another.getColumn(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsData(DataSet another) {
        return this.equalsData(another, true);
    }

    public boolean hasSameSchemaWith(DataSet another) {
        return this.equalsStructure(another);
    }

    public boolean hasSameDataWith(DataSet another) {
        if (another == null) {
            return false;
        }
        if (this.getColumnCount() != another.getColumnCount()) {
            return false;
        }
        if (this.getRowCount() != another.getRowCount()) {
            return false;
        }
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Object obj = this.getValue(i, j);
                Object anotherObj = another.getValue(i, j);
                if (!(obj == null || anotherObj == null ? obj != anotherObj : !obj.toString().equals(anotherObj.toString()))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXml(String str) {
        try (StringReader in = new StringReader(str);){
            PlatformXmlDataDeserializer deserializer = new PlatformXmlDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveXml() {
        StringWriter out = new StringWriter();
        try {
            PlatformXmlDataSerializer serializer = new PlatformXmlDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not save xml", (Throwable)ex);
            }
        }
        finally {
            block13: {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error((Object)StringUtils.normalizeSpace((String)ex.getMessage()));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSsv(String str) {
        try (StringReader in = new StringReader(str);){
            PlatformSsvDataDeserializer deserializer = new PlatformSsvDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSsv() {
        StringWriter out = new StringWriter();
        try {
            PlatformSsvDataSerializer serializer = new PlatformSsvDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not save ssv", (Throwable)ex);
            }
        }
        finally {
            block13: {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error((Object)StringUtils.normalizeSpace((String)ex.getMessage()));
                }
            }
        }
        return null;
    }

    protected void fireDataSetStructureChanged() {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent e = new DataSetEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetListener.class) continue;
            ((DataSetListener)listeners[i + 1]).structureChanged(e);
        }
    }

    protected void fireDataSetDataUpdated(int firstRow, int lastRow) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        this.fireDataSetDataUpdated(firstRow, lastRow, -1);
    }

    protected void fireDataSetDataUpdated(int firstRow, int lastRow, int column) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent e = new DataSetEvent(this, firstRow, lastRow, column);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetListener.class) continue;
            ((DataSetListener)listeners[i + 1]).dataUpdated(e);
        }
    }

    protected void fireDataSetRowInserted(int firstRow, int lastRow) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent e = new DataSetEvent(this, firstRow, lastRow);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetListener.class) continue;
            ((DataSetListener)listeners[i + 1]).rowInserted(e);
        }
    }

    protected void fireDataSetRowRemoved(int firstRow, int lastRow) {
        if (this.listenerList == null || this.listenerList.getListenerCount() == 0) {
            return;
        }
        DataSetEvent e = new DataSetEvent(this, firstRow, lastRow);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetListener.class) continue;
            ((DataSetListener)listeners[i + 1]).rowRemoved(e);
        }
    }

    protected List getColumnList() {
        return this.columnList;
    }

    protected void setColumnList(List columnList) {
        this.columnList = columnList;
        this.columnMap.clear();
    }

    List getRowList() {
        return this.rowList;
    }

    void setRowList(List rowList) {
        this.rowList = rowList;
    }

    List getSavedRowList() {
        return this.savedRowList;
    }

    void setSavedRowList(List savedRowList) {
        this.savedRowList = savedRowList;
    }

    List getRemovedRowList() {
        return this.removedRowList;
    }

    void setRemovedRowList(List removedRowList) {
        this.removedRowList = removedRowList;
    }

    protected List createColumnList() {
        return new ArrayList();
    }

    List createRowList() {
        return new ArrayList();
    }

    protected ColumnHeader createColumnHeader(String name, int dataType, int dataSize) {
        return new ColumnHeader(name, dataType, dataSize);
    }

    protected ColumnHeader createColumnHeader(String name, DataType dataType, int dataSize) {
        return new ColumnHeader(name, dataType, dataSize);
    }

    protected ConstantColumnHeader createConstantColumnHeader(String name, int dataType, int dataSize, Object value) {
        return new ConstantColumnHeader(name, value, dataType, dataSize);
    }

    protected ConstantColumnHeader createConstantColumnHeader(String name, DataType dataType, int dataSize, Object value) {
        return new ConstantColumnHeader(name, value, dataType, dataSize);
    }

    private Object getValue(int rowIndex, int columnIndex) {
        ColumnHeader header;
        if (this.isCheckingGetterDataIndex()) {
            this.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
        }
        if ((header = this.getColumn(columnIndex)) == null) {
            return null;
        }
        if (header.isConstant()) {
            return header.getValue();
        }
        DataRow row = this.getRow(rowIndex);
        return row == null ? null : row.get(columnIndex);
    }

    private void saveRow(int rowIndex) {
        DataRow row = this.getRow(rowIndex);
        int rowType = row.getType();
        if (rowType == 0) {
            try {
                DataRow oldRow = (DataRow)row.clone();
                row.setType(2);
                this.setSavedRow(rowIndex, oldRow);
            }
            catch (CloneNotSupportedException ex) {
                this.getLogger();
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)StringUtils.normalizeSpace((String)("Could not clone: row=" + row)), (Throwable)ex);
                }
                DataRow oldRow = new DataRow(row.size());
                row.copyTo(oldRow);
                row.setType(2);
                this.setSavedRow(rowIndex, oldRow);
            }
        } else if (rowType != 1 && rowType != 2) {
            this.getLogger();
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)StringUtils.normalizeSpace((String)("saveRow(int): rowIndex=" + rowIndex + ", rowType=" + rowType)));
            }
        }
    }

    private void copy(DataSet source, DataSet target, boolean copyData) {
        target.clear();
        int columnCount = source.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            target.copyColumn(source.getColumn(i));
        }
        if (copyData) {
            this.copyData(source, target, true);
        }
    }

    private void copyData(DataSet source, DataSet target, boolean preserveData) {
        if (!preserveData) {
            target.clearData();
        }
        int rowCount = source.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            target.copyRow(source.getRow(i));
            DataRow savedRow = source.getSavedRow(i);
            if (savedRow == null) continue;
            target.copySavedRow(i, savedRow);
        }
        int removedRowCount = source.getRemovedRowCount();
        for (int i = 0; i < removedRowCount; ++i) {
            target.copyRemovedRow(source.getRemovedRow(i));
        }
    }

    private boolean equalsName(DataSet another) {
        if (this.name == null) {
            return another.name == null;
        }
        return this.name.equals(another.name);
    }

    private boolean equalsAlias(DataSet another) {
        if (this.alias == null) {
            return another.alias == null;
        }
        return this.alias.equals(another.alias);
    }

    private boolean equalsCharset(DataSet another) {
        if (this.charset == null) {
            return another.charset == null;
        }
        return this.charset.equals(another.charset);
    }

    private boolean equalsDataConverter(DataSet another) {
        if (this.dataConverter == null) {
            return another.dataConverter == null;
        }
        return this.dataConverter.equals(another.dataConverter);
    }

    private boolean equalsDefaultDataConverter(DataSet another) {
        if (this.defaultDataConverter == null) {
            return another.defaultDataConverter == null;
        }
        return this.defaultDataConverter.equals(another.defaultDataConverter);
    }

    private boolean equalsData(DataSet another, boolean isCheckingSavedData) {
        if (another == null) {
            return false;
        }
        if (this.getColumnCount() != another.getColumnCount()) {
            return false;
        }
        if (this.getRowCount() != another.getRowCount()) {
            return false;
        }
        if (isCheckingSavedData && this.getRemovedRowCount() != another.getRemovedRowCount()) {
            return false;
        }
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.getRow(i).equals(another.getRow(i))) {
                return false;
            }
            if (!isCheckingSavedData || this.getRow(i).getType() != 2 || this.getSavedRow(i).equals(another.getSavedRow(i))) continue;
            return false;
        }
        if (isCheckingSavedData) {
            int removedRowCount = this.getRemovedRowCount();
            for (int i = 0; i < removedRowCount; ++i) {
                if (this.getRemovedRow(i).equals(another.getRemovedRow(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void checkName(String name, boolean checkNull) {
        if (name == null) {
            if (checkNull) {
                throw new IllegalArgumentException("No name specified");
            }
            return;
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(name);
        }
    }

    private void checkAlias(String alias) {
        if (alias == null) {
            return;
        }
        if ("".equals(alias)) {
            throw new IllegalArgumentException("No alias specified");
        }
        if (alias.charAt(0) == ' ' && "".equals(alias.trim())) {
            throw new IllegalArgumentException("Invalid alias: \"" + alias + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(alias);
        }
    }

    private void checkNaming(String name) {
        if (name == null) {
            return;
        }
        char[] chars = name.toCharArray();
        int count = chars.length;
        char ch = chars[0];
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$')) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        for (int i = 1; i < count; ++i) {
            ch = chars[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '$' || ch == '-') continue;
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
    }

    private void checkSavedRowList() {
        if (this.savedRowList == null) {
            this.savedRowList = this.createRowList();
        }
    }

    private void checkRemovedRowList() {
        if (this.removedRowList == null) {
            this.removedRowList = this.createRowList();
        }
    }

    private void checkColumnMap() {
        if (!this.columnList.isEmpty() && this.columnMap.isEmpty()) {
            Iterator iter = this.columnList.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ColumnHeader header = (ColumnHeader)iter.next();
                String name = header.getName();
                this.columnMap.put(name, new Integer(i));
                ++i;
            }
        }
    }

    private boolean containsColumn(int index) {
        return this.containsColumn(index, false);
    }

    private boolean containsColumn(int index, boolean increase) {
        int max = increase ? this.columnList.size() : this.columnList.size() - 1;
        return index >= 0 && index <= max;
    }

    private boolean containsRow(int index) {
        return index >= 0 && index < this.rowList.size();
    }

    private boolean containsRemovedRow(int index) {
        return index >= 0 && index < this.getRemovedRowCount();
    }

    private void checkColumnName(String columnName) {
        if (!this.containsColumn(columnName)) {
            throw new IllegalArgumentException("Invalid column name: " + columnName);
        }
    }

    private void checkColumnIndex(int columnIndex) {
        if (!this.containsColumn(columnIndex)) {
            throw new IndexOutOfBoundsException("Invalid column index value: columnIndex=" + columnIndex + ", columnCount=" + this.getColumnCount());
        }
    }

    private void checkDuplicatedColumn(ColumnHeader header, int index, String command) {
        String name;
        int duplicatedIndex;
        if (PlatformGlobals.getBooleanProperty(DUPLICATED_COLUMN_NAME_CHECK_KEY, true) && (duplicatedIndex = this.indexOfColumn(name = header.getName())) != -1 && duplicatedIndex != index) {
            throw new IllegalStateException("Unable to " + command + " column: duplicatedName=" + name + ", duplicatedIndex=" + duplicatedIndex);
        }
    }

    private void checkRowIndex(int rowIndex) {
        if (!this.containsRow(rowIndex)) {
            throw new IndexOutOfBoundsException("Invalid row index value: rowIndex=" + rowIndex + ", rowCount=" + this.getRowCount());
        }
    }

    private void checkRemovedRowIndex(int rowIndex) {
        if (!this.containsRemovedRow(rowIndex)) {
            throw new IndexOutOfBoundsException("Invalid removed row index value: removedRowIndex=" + rowIndex + ", removedRowCount=" + this.getRemovedRowCount());
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.log = LogFactory.getLog(DataSet.class);
        this.columnMap = new HashMap();
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog(DataSet.class);
        }
    }

    public void setRow(int index, Object source) throws PlatformException {
        if (source == null) {
            return;
        }
        try {
            if (source instanceof Map) {
                this.setRowFromMap(index, (Map)source);
            } else {
                this.setRowFromObject(index, source);
            }
        }
        catch (IllegalArgumentException e) {
            Log log = LogFactory.getLog(DataSet.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("IllegalArgumentException : " + e)));
        }
        catch (IllegalAccessException e) {
            Log log = LogFactory.getLog(DataSet.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("IllegalAccessException : " + e)));
        }
    }

    public Map getRowToMap(int index) {
        String[] columnNames = this.getColumnNames();
        HashMap<String, Object> dataRow = new HashMap<String, Object>();
        int rowType = this.getRowType(index);
        for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
            Object object = this.getObject(index, columnIndex);
            dataRow.put(columnNames[columnIndex], object);
        }
        if (this.hasSavedRow(index)) {
            HashMap<String, Object> savedDataRow = new HashMap<String, Object>();
            for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
                Object object = this.getSavedData(index, columnIndex);
                savedDataRow.put(columnNames[columnIndex], object);
            }
            dataRow.put("DataSetSavedData", savedDataRow);
        }
        dataRow.put("DataSetRowType", new Integer(rowType));
        return dataRow;
    }

    public Object getRowToObject(int index, Class clazz) throws PlatformException {
        boolean isSavedData = false;
        boolean isRemovedData = false;
        Object object = null;
        try {
            Class<?> beanType;
            Class<?> newClazz = Class.forName(clazz.getName());
            object = newClazz.newInstance();
            this.addRowIntoBean(newClazz, object, index, isSavedData, isRemovedData);
            if (this.hasSavedRow(index) && DataSetConvertHelper.isImplemented(beanType = object.getClass(), DataSetSavedDataAccessor.class)) {
                isSavedData = true;
                Object savedObject = newClazz.newInstance();
                this.addRowIntoBean(newClazz, savedObject, index, isSavedData, isRemovedData);
                DataSetSavedDataAccessor accessor = (DataSetSavedDataAccessor)object;
                accessor.setData(savedObject);
            }
        }
        catch (IllegalAccessException e) {
            Log log = LogFactory.getLog(DataSet.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("IllegalAccessException : " + e)));
        }
        catch (InstantiationException e) {
            Log log = LogFactory.getLog(DataSet.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("InstantiationException : " + e)));
        }
        catch (ClassNotFoundException e) {
            Log log = LogFactory.getLog(DataSet.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("ClassNotFoundException : " + e)));
        }
        return object;
    }

    private void setRowFromMap(int index, Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            String columnName = (String)key;
            if (DataSetConvertHelper.ignoreSpecfiedColumnName(columnName)) continue;
            Object object = DataSetConvertHelper.toObject(value);
            int columnIndex = this.indexOfColumn(columnName);
            if (columnIndex < 0) {
                this.setChangeStructureWithData(true);
                if (value == null) {
                    this.addColumn(columnName, PlatformDataType.UNDEFINED);
                } else {
                    DataType dataType = DataSetConvertHelper.getDataTypeOfValue(value);
                    this.addColumn(columnName, dataType);
                }
            }
            this.set(index, columnName, object);
        }
    }

    private void setRowFromObject(int index, Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int fldIdx = 0; fldIdx < fields.length; ++fldIdx) {
            Field field = fields[fldIdx];
            field.setAccessible(true);
            String name = field.getName();
            Object value = field.get(object);
            value = DataSetConvertHelper.toObject(value);
            int columnIndex = this.indexOfColumn(name);
            if (columnIndex < 0) {
                this.setChangeStructureWithData(true);
                if (value == null) {
                    this.addColumn(name, PlatformDataType.UNDEFINED);
                } else {
                    DataType dataType = DataSetConvertHelper.getDataTypeOfValue(value);
                    this.addColumn(name, dataType);
                }
            }
            this.set(index, columnIndex, value);
        }
    }

    protected String[] getColumnNames() {
        int columnCount = this.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.getColumn(i).getName();
        }
        return columnNames;
    }

    protected void addRowIntoMap(Map dataMap, int rowIndex, String[] columnNames) {
        int rowType = this.getRowType(rowIndex);
        for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
            Object object = this.getObject(rowIndex, columnIndex);
            dataMap.put(columnNames[columnIndex], object);
        }
        if (this.hasSavedRow(rowIndex)) {
            HashMap<String, Object> savedDataRow = new HashMap<String, Object>();
            for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
                Object object = this.getSavedData(rowIndex, columnIndex);
                savedDataRow.put(columnNames[columnIndex], object);
            }
            dataMap.put("DataSetSavedData", savedDataRow);
        }
        dataMap.put("DataSetRowType", new Integer(rowType));
    }

    protected void addRowIntoBean(Class clazz, Object object, int rowIndex, boolean isSavedData, boolean isRemovedData) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = clazz.getDeclaredFields();
        for (int fldIdx = 0; fldIdx < fields.length; ++fldIdx) {
            Field field = fields[fldIdx];
            field.setAccessible(true);
            String name = field.getName();
            int colIndex = this.indexOfColumn(name);
            if (colIndex == -1) continue;
            Class<?> type = field.getType();
            Object value = DataSetConvertHelper.toObjectFromDataSetValue(this, rowIndex, colIndex, type, isSavedData, isRemovedData);
            field.set(object, value);
        }
        Class<?> beanType = object.getClass();
        if (DataSetConvertHelper.isImplemented(beanType, DataSetRowTypeAccessor.class)) {
            int rowType = isRemovedData ? 3 : (isSavedData ? 0 : this.getRowType(rowIndex));
            DataSetRowTypeAccessor accessor = (DataSetRowTypeAccessor)object;
            accessor.setRowType(rowType);
        }
    }
}

