/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetConvertHelper;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformSsvDataDeserializer;
import com.nexacro.java.xapi.data.PlatformSsvDataSerializer;
import com.nexacro.java.xapi.data.PlatformXmlDataDeserializer;
import com.nexacro.java.xapi.data.PlatformXmlDataSerializer;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.java.xapi.tx.PlatformException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8979436269137318153L;
    private VariableList varList = new VariableList();
    private DataSetList dsList = new DataSetList();
    private int saveType = 0;

    public int getSaveType() {
        return this.saveType;
    }

    public void setSaveType(int saveType) {
        this.saveType = saveType;
    }

    public Variable getVariable(String name) {
        return this.varList.get(name);
    }

    public Variable getVariable(int index) {
        return this.varList.get(index);
    }

    public void addVariable(Variable var) {
        this.varList.add(var);
    }

    public int getVariableCount() {
        return this.varList.size();
    }

    public VariableList getVariableList() {
        return this.varList;
    }

    public void setVariableList(VariableList varList) {
        this.varList = varList;
    }

    public DataSet getDataSet(String name) {
        return this.dsList.get(name);
    }

    public DataSet getDataSet(int index) {
        return this.dsList.get(index);
    }

    public void addDataSet(DataSet ds) {
        this.dsList.add(ds);
    }

    public int getDataSetCount() {
        return this.dsList.size();
    }

    public DataSetList getDataSetList() {
        return this.dsList;
    }

    public void setDataSetList(DataSetList dsList) {
        this.dsList = dsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXml(String str) {
        try (StringReader in = new StringReader(str);){
            PlatformXmlDataDeserializer deserializer = new PlatformXmlDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveXml() {
        Log log;
        StringWriter out = new StringWriter();
        try {
            PlatformXmlDataSerializer serializer = new PlatformXmlDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            log = LogFactory.getLog(PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not save xml", (Throwable)ex);
            }
        }
        finally {
            block13: {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log = LogFactory.getLog(PlatformData.class);
                    if (!log.isErrorEnabled()) break block13;
                    log.error((Object)ex.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSsv(String str) {
        try (StringReader in = new StringReader(str);){
            PlatformSsvDataDeserializer deserializer = new PlatformSsvDataDeserializer();
            deserializer.readData((Reader)in, this);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSsv() {
        Log log;
        StringWriter out = new StringWriter();
        try {
            PlatformSsvDataSerializer serializer = new PlatformSsvDataSerializer();
            serializer.writeData((Writer)out, this);
            String string = out.toString();
            return string;
        }
        catch (PlatformException ex) {
            log = LogFactory.getLog(PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not save ssv", (Throwable)ex);
            }
        }
        finally {
            block13: {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log = LogFactory.getLog(PlatformData.class);
                    if (!log.isErrorEnabled()) break block13;
                    log.error((Object)ex.getMessage());
                }
            }
        }
        return null;
    }

    public PlatformData getClone() {
        try {
            return (PlatformData)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log log = LogFactory.getLog(PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PlatformData data = (PlatformData)super.clone();
        data.varList = (VariableList)this.varList.clone();
        data.dsList = (DataSetList)this.dsList.clone();
        return data;
    }

    public DataSet addDataSet(String name, List source) throws PlatformException {
        DataSet ds = new DataSet(name);
        if (source == null || source.size() == 0) {
            this.dsList.add(ds);
            return ds;
        }
        try {
            Object availableData = this.getAvailableData(source);
            if (availableData instanceof Map) {
                this.mapListToDataSet(ds, source, (Map)availableData);
            } else {
                this.objectListToDataSet(ds, source, availableData);
            }
        }
        catch (IllegalArgumentException e) {
            Log log = LogFactory.getLog(PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException("IllegalArgumentException : " + e);
        }
        catch (IllegalAccessException e) {
            Log log = LogFactory.getLog(PlatformData.class);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new PlatformException("IllegalAccessException : " + e);
        }
        this.dsList.add(ds);
        return ds;
    }

    public List getMapList(String dsName) {
        DataSet ds = this.dsList.get(dsName);
        return this.convertDataSetToListMap(ds);
    }

    public List getMapList(int index) {
        DataSet ds = this.dsList.get(index);
        return this.convertDataSetToListMap(ds);
    }

    public List getObjectList(String dsName, Class clazz) throws PlatformException {
        DataSet ds = this.dsList.get(dsName);
        return this.convertDataSetToListObject(ds, clazz);
    }

    public List getObjectList(int index, Class clazz) throws PlatformException {
        DataSet ds = this.dsList.get(index);
        return this.convertDataSetToListObject(ds, clazz);
    }

    private Object getAvailableData(List source) {
        for (int index = 0; index < source.size(); ++index) {
            Object object = source.get(index);
            if (object == null) continue;
            return object;
        }
        return new HashMap();
    }

    private void mapListToDataSet(DataSet ds, List source, Map map) {
        this.addColumnFromMap(ds, map);
        for (int index = 0; index < source.size(); ++index) {
            Object object = source.get(index);
            this.addRowAtDataSetFromMap(ds, (Map)object);
        }
    }

    private void objectListToDataSet(DataSet ds, List source, Object data) throws IllegalArgumentException, IllegalAccessException {
        this.addColumnFromObject(ds, data);
        for (int index = 0; index < source.size(); ++index) {
            Object object = source.get(index);
            this.addRowAtDataSetFromObject(ds, object);
        }
    }

    private void addColumnFromMap(DataSet ds, Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            String columnName = (String)key;
            this.addColumnByMap(ds, columnName, value);
        }
    }

    private void addColumnFromObject(DataSet ds, Object data) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = data.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            field.setAccessible(true);
            String name = field.getName();
            Class<?> type = field.getType();
            DataType dataType = DataSetConvertHelper.getDataType(type);
            if (Modifier.isStatic(field.getModifiers())) {
                Object value = field.get(data);
                value = DataSetConvertHelper.toObject(value);
                ds.addConstantColumn(name, dataType, value);
                continue;
            }
            ds.addColumn(name, dataType);
        }
    }

    private void addRowAtDataSetFromMap(DataSet ds, Map map) {
        int newRow = ds.newRow();
        if (map == null) {
            return;
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            String columnName = (String)key;
            if (DataSetConvertHelper.ignoreSpecfiedColumnName(columnName)) continue;
            Object object = DataSetConvertHelper.toObject(value);
            int columnIndex = ds.indexOfColumn(columnName);
            if (columnIndex < 0) {
                ds.setChangeStructureWithData(true);
                if (!this.addColumnByMap(ds, columnName, value)) continue;
            }
            ds.set(newRow, columnName, object);
        }
    }

    private void addRowAtDataSetFromObject(DataSet ds, Object object) throws IllegalArgumentException, IllegalAccessException {
        int newRow = ds.newRow();
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            field.setAccessible(true);
            String name = field.getName();
            Object value = field.get(object);
            value = DataSetConvertHelper.toObject(value);
            int columnIndex = ds.indexOfColumn(name);
            if (columnIndex < 0) continue;
            ds.set(newRow, columnIndex, value);
        }
    }

    private boolean addColumnByMap(DataSet ds, String columnName, Object value) {
        if (DataSetConvertHelper.ignoreSpecfiedColumnName(columnName)) {
            return false;
        }
        if (value == null) {
            ds.addColumn(columnName, PlatformDataType.UNDEFINED);
            return true;
        }
        DataType dataType = DataSetConvertHelper.getDataTypeOfValue(value);
        ds.addColumn(columnName, dataType);
        return true;
    }

    private List convertDataSetToListMap(DataSet ds) {
        String[] columnNames = this.getDataSetColumnNames(ds);
        ArrayList dataListMap = new ArrayList();
        int rowCount = ds.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.addRowIntoListMap(dataListMap, ds, rowIndex, columnNames);
        }
        int removedRowCount = ds.getRemovedRowCount();
        for (int removedIndex = 0; removedIndex < removedRowCount; ++removedIndex) {
            this.addRemovedRowIntoListMap(dataListMap, ds, removedIndex, columnNames);
        }
        return dataListMap;
    }

    private List convertDataSetToListObject(DataSet ds, Class clazz) throws PlatformException {
        ArrayList<Object> dataListObject = new ArrayList<Object>();
        int rowCount = ds.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Object object = ds.getRowToObject(rowIndex, clazz);
            dataListObject.add(object);
        }
        return dataListObject;
    }

    private String[] getDataSetColumnNames(DataSet ds) {
        int columnCount = ds.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = ds.getColumn(i).getName();
        }
        return columnNames;
    }

    private void addRowIntoListMap(List dataListMap, DataSet ds, int rowIndex, String[] columnNames) {
        HashMap dataRow = new HashMap();
        this.addRowIntoMap(dataRow, ds, rowIndex, columnNames);
        dataListMap.add(dataRow);
    }

    private void addRowIntoMap(Map dataMap, DataSet ds, int rowIndex, String[] columnNames) {
        int rowType = ds.getRowType(rowIndex);
        for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
            Object object = ds.getObject(rowIndex, columnIndex);
            dataMap.put(columnNames[columnIndex], object);
        }
        if (ds.hasSavedRow(rowIndex)) {
            HashMap<String, Object> savedDataRow = new HashMap<String, Object>();
            for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
                Object object = ds.getSavedData(rowIndex, columnIndex);
                savedDataRow.put(columnNames[columnIndex], object);
            }
            dataMap.put("DataSetSavedData", savedDataRow);
        }
        dataMap.put("DataSetRowType", new Integer(rowType));
    }

    private void addRemovedRowIntoListMap(List dataList, DataSet ds, int removedIndex, String[] columnNames) {
        HashMap<String, Object> dataRow = new HashMap<String, Object>();
        for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
            Object object = ds.getRemovedData(removedIndex, columnIndex);
            dataRow.put(columnNames[columnIndex], object);
        }
        dataRow.put("DataSetRowType", new Integer(3));
        dataList.add(dataRow);
    }
}

