/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.Base64;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.util.TypeConverter;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.util.PlatformGlobals;
import com.nexacro.java.xapi.util.SequenceReader;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class PlatformXmlDataDeserializer
extends DefaultHandler {
    private Log log = LogFactory.getLog(PlatformXmlDataDeserializer.class);
    private static final String PARSER_FACTORY_KEY = "platform.tx.DataDeserializer.platformxml.parserfactory";
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    static final int INDEX_UNDEFINED = 0;
    static final int INDEX_VARIABLE = 1;
    static final int INDEX_DATA_ROW = 2;
    static final int INDEX_DATA_CELL = 3;
    static final int INDEX_SAVED_DATA_ROW = 4;
    static final int INDEX_SAVED_DATA_CELL = 5;
    private static ThreadLocal parserThreadLocal;
    private boolean isEmptyToNull;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private String rowType;
    private String columnName;
    private StringBuffer value = new StringBuffer();

    public void readData(Reader in, PlatformData data) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setData(data);
        this.init();
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            SequenceReader sin = new SequenceReader(new CharArrayReader(header), in);
            InputSource source = new InputSource(sin);
            if (encoding != null) {
                source.setEncoding(encoding);
            }
            this.read(source);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    public void readData(Reader in, DataSet ds) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: this=" + this));
        }
        this.setCurrentDataSet(ds);
        this.init();
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            SequenceReader sin = new SequenceReader(new CharArrayReader(header), in);
            InputSource source = new InputSource(sin);
            if (encoding != null) {
                source.setEncoding(encoding);
            }
            this.read(source);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    int getCurrentIndex() {
        return this.index;
    }

    void setCurrentIndex(int index) {
        this.index = index;
    }

    Variable getCurrentVariable() {
        return this.var;
    }

    void setCurrentVariable(Variable var) {
        this.var = var;
    }

    DataSet getCurrentDataSet() {
        return this.ds;
    }

    void setCurrentDataSet(DataSet ds) {
        this.ds = ds;
    }

    String getCurrentRowType() {
        return this.rowType;
    }

    void setCurrentRowType(String rowType) {
        this.rowType = rowType;
    }

    String getCurrentColumnName() {
        return this.columnName;
    }

    void setCurrentColumnName(String columnName) {
        this.columnName = columnName;
    }

    String getCurrentValue() {
        return this.value.toString();
    }

    void addCurrentValue(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    void clearCurrentValue() {
        this.value.setLength(0);
    }

    PlatformData getData() {
        return this.data;
    }

    void setData(PlatformData data) {
        this.data = data;
    }

    void read(InputSource source) throws PlatformException {
        try {
            SAXParser parser = this.getSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parser.parse(source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
        catch (SAXException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private char[] readHeader(Reader in) throws IOException {
        int ch;
        CharArrayWriter out = new CharArrayWriter();
        do {
            ch = in.read();
            out.write(ch);
        } while (ch != -1 && ch != 62);
        out.close();
        return out.toCharArray();
    }

    private String findEncoding(char[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(String header) {
        String encoding;
        int end;
        int begin;
        int separator;
        int index = header.indexOf("encoding");
        if (index != -1 && (separator = header.indexOf(61, index + 8)) != -1 && (begin = header.indexOf(34, separator + 1)) != -1 && (end = header.indexOf(34, ++begin)) != -1 && (encoding = header.substring(begin, end).trim()).length() > 0) {
            return encoding;
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Col".equals(qName)) {
            this.startDataSetCell(attributes);
        } else if ("Row".equals(qName)) {
            this.startDataSetRow(attributes);
        } else if ("OrgRow".equals(qName)) {
            this.startDataSetSavedRow(attributes);
        } else if ("Column".equals(qName)) {
            this.startDataSetDefaultColumn(attributes);
        } else if ("Parameter".equals(qName)) {
            this.startVariable(attributes);
        } else if ("ConstColumn".equals(qName)) {
            this.startDataSetConstantColumn(attributes);
        } else if (!"Rows".equals(qName) && !"ColumnInfo".equals(qName)) {
            if ("Dataset".equals(qName)) {
                this.startDataSet(attributes);
            } else if ("Parameters".equals(qName) || "Root".equals(qName)) {
                // empty if block
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Col".equals(qName)) {
            this.endDataSetCell();
        } else if ("Row".equals(qName)) {
            this.endDataSetRow();
        } else if ("OrgRow".equals(qName)) {
            this.endDataSetSavedRow();
        } else if ("Column".equals(qName)) {
            this.endDataSetDefaultColumn();
        } else if ("Parameter".equals(qName)) {
            this.endVariable();
        } else if ("ConstColumn".equals(qName)) {
            this.endDataSetConstantColumn();
        } else if ("Rows".equals(qName)) {
            this.endDataSetRowList();
        } else if ("ColumnInfo".equals(qName)) {
            this.endDataSetColumnList();
        } else if ("Dataset".equals(qName)) {
            this.endDataSet();
        } else if ("Parameters".equals(qName)) {
            this.endVariableList();
        } else if ("Root".equals(qName)) {
            this.endData();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int index = this.getCurrentIndex();
        if (index == 1 || index == 3 || index == 5) {
            this.addCurrentValue(ch, start, length);
        }
    }

    void endData() {
        this.setCurrentIndex(0);
    }

    void endVariableList() {
        this.setCurrentIndex(0);
    }

    void startVariable(Attributes attributes) {
        if (this.getData() == null) {
            return;
        }
        String name = attributes.getValue("id");
        String typeStr = attributes.getValue("type");
        int type = "binary".equals(typeStr) ? 12 : DataTypes.toIntType(typeStr);
        Variable var = new Variable(name, type);
        this.setCurrentVariable(var);
        this.setCurrentIndex(1);
    }

    void endVariable() {
        if (this.getData() == null) {
            return;
        }
        Variable var = this.getCurrentVariable();
        int dataType = var.getType();
        String value = this.getCurrentValue();
        if (!this.isNull(value, dataType)) {
            var.set(value);
        }
        this.getData().addVariable(var);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Adding Variable: " + var)));
        }
        this.setCurrentVariable(null);
        this.clearCurrentValue();
        this.setCurrentIndex(0);
    }

    void startDataSet(Attributes attributes) {
        DataSet ds = null;
        if (this.getData() == null) {
            ds = this.getCurrentDataSet();
        } else {
            String name = attributes.getValue("id");
            ds = new DataSet(name);
            this.setCurrentDataSet(ds);
        }
        this.isStoreDataChanges = ds.isStoreDataChanges();
        this.isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (this.isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (this.isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
    }

    void endDataSet() {
        DataSet ds = this.getCurrentDataSet();
        if (this.isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (this.isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        if (this.getData() != null) {
            this.getData().addDataSet(ds);
            this.setCurrentDataSet(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding DataSet: " + ds));
        }
        this.setCurrentIndex(0);
    }

    void endDataSetColumnList() {
        this.setCurrentIndex(0);
    }

    void startDataSetDefaultColumn(Attributes attributes) {
        String name;
        DataSet ds = this.getCurrentDataSet();
        if (ds.containsColumn(name = attributes.getValue("id"))) {
            return;
        }
        String dataTypeStr = attributes.getValue("type");
        String dataSizeStr = attributes.getValue("size");
        int dataType = "binary".equals(dataTypeStr) ? 12 : DataTypes.toIntType(dataTypeStr);
        int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
        ds.addColumn(name, dataType, dataSize);
    }

    void endDataSetDefaultColumn() {
        this.setCurrentIndex(0);
    }

    void startDataSetConstantColumn(Attributes attributes) {
        String name;
        DataSet ds = this.getCurrentDataSet();
        if (ds.containsColumn(name = attributes.getValue("id"))) {
            return;
        }
        String dataTypeStr = attributes.getValue("type");
        String dataSizeStr = attributes.getValue("size");
        String valueStr = attributes.getValue("value");
        int dataType = "binary".equals(dataTypeStr) ? 12 : DataTypes.toIntType(dataTypeStr);
        int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
        Object value = DataTypes.isBinary(dataType) ? Base64.decode(valueStr) : (Object)TypeConverter.convert(valueStr, dataType);
        ds.addConstantColumn(name, dataType, dataSize, value);
    }

    void endDataSetConstantColumn() {
        this.setCurrentIndex(0);
    }

    void endDataSetRowList() {
        this.setCurrentIndex(0);
    }

    void startDataSetRow(Attributes attributes) {
        DataSet ds = this.getCurrentDataSet();
        this.setCurrentRowType(attributes.getValue("type"));
        ds.newRow();
        this.setCurrentIndex(2);
    }

    void endDataSetRow() {
        DataSet ds = this.getCurrentDataSet();
        String rowType = this.getCurrentRowType();
        if ("insert".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 1);
        } else if ("update".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 2);
        } else if ("delete".equals(rowType)) {
            ds.setRowType(ds.getRowCount() - 1, 3);
        } else {
            ds.setRowType(ds.getRowCount() - 1, 0);
        }
        this.setCurrentIndex(0);
    }

    void startDataSetSavedRow(Attributes attributes) {
        this.setCurrentIndex(4);
    }

    void endDataSetSavedRow() {
        this.setCurrentIndex(2);
        DataSet ds = this.getCurrentDataSet();
        int row = ds.getRowCount() - 1;
        if (!ds.hasSavedRow(row) && ds.getColumnCount() > 0) {
            ds.setSavedData(row, 0, null);
        }
    }

    void startDataSetCell(Attributes attributes) {
        String columnName = attributes.getValue("id");
        this.setCurrentColumnName(columnName);
        if (this.getCurrentIndex() == 2) {
            this.setCurrentIndex(3);
        } else if (this.getCurrentIndex() == 4) {
            this.setCurrentIndex(5);
        }
    }

    void endDataSetCell() {
        block20: {
            block17: {
                boolean isNull;
                int dataType;
                String value;
                String columnName;
                DataSet ds;
                block21: {
                    int index;
                    block18: {
                        block16: {
                            block19: {
                                index = this.getCurrentIndex();
                                ds = this.getCurrentDataSet();
                                columnName = this.getCurrentColumnName();
                                value = this.getCurrentValue();
                                dataType = ds.getColumn(columnName).getDataType();
                                isNull = this.isNull(value, dataType);
                                if (index != 3) break block18;
                                if (dataType != 13) break block19;
                                try {
                                    File file = PlatformUtils.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                    if (!isNull) {
                                        this.writeValueToFile(Base64.decode(value), file);
                                    }
                                    ds.set(ds.getRowCount() - 1, columnName, file.getAbsolutePath());
                                }
                                catch (IOException ex) {
                                    int rowIndex = ds.getRowCount() - 1;
                                    if (!this.log.isErrorEnabled()) break block16;
                                    try {
                                        this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnName=" + URLEncoder.encode(columnName, "UTF-8")), (Throwable)ex);
                                        break block16;
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        this.log.error((Object)"endDataSetCell: UnsupportedEncodingException");
                                    }
                                }
                                break block16;
                            }
                            if (!isNull) {
                                if (DataTypes.isBinary(dataType)) {
                                    ds.set(ds.getRowCount() - 1, columnName, Base64.decode(value));
                                } else {
                                    ds.set(ds.getRowCount() - 1, columnName, value);
                                }
                            }
                        }
                        this.setCurrentIndex(2);
                        break block20;
                    }
                    if (index != 5) break block20;
                    if (dataType != 13) break block21;
                    try {
                        File file = PlatformUtils.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                        if (!isNull) {
                            this.writeValueToFile(Base64.decode(value), file);
                        }
                        ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        int rowIndex = ds.getRowCount() - 1;
                        if (!this.log.isErrorEnabled()) break block17;
                        try {
                            this.log.error((Object)("Could not save: rowIndex=" + rowIndex + ", columnName=" + URLEncoder.encode(columnName, "UTF-8")), (Throwable)ex);
                            break block17;
                        }
                        catch (UnsupportedEncodingException e) {
                            this.log.error((Object)"endDataSetCell: UnsupportedEncodingException");
                        }
                    }
                    break block17;
                }
                if (!isNull) {
                    if (DataTypes.isBinary(dataType)) {
                        ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)Base64.decode(value));
                    } else {
                        ds.setSavedData(ds.getRowCount() - 1, columnName, (Object)value);
                    }
                }
            }
            this.setCurrentIndex(4);
        }
        this.setCurrentColumnName(null);
        this.clearCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeValueToFile(byte[] value, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(value);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private boolean isNull(String value, int dataType) {
        return this.isEmptyToNull() && dataType == 2 && "".equals(value);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("init: isEmptyToNull=" + this.isEmptyToNull));
        }
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        String systemEmptyToNull = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(systemEmptyToNull);
    }

    private SAXParser getSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        String parserFactory = PlatformGlobals.getStringProperty(PARSER_FACTORY_KEY);
        if ("threadlocal".equals(parserFactory)) {
            return this.getSAXParserFromThreadLocal();
        }
        return this.createSAXParser();
    }

    private SAXParser createSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newSAXParser();
    }

    private SAXParser getSAXParserFromThreadLocal() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        if (parserThreadLocal == null) {
            parserThreadLocal = new ThreadLocal();
        }
        SAXParser parser = (SAXParser)parserThreadLocal.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting SAXParser: thread=" + Thread.currentThread().getName() + ", parser=" + parser));
        }
        if (parser == null) {
            parser = this.createSAXParser();
            parserThreadLocal.set(parser);
        }
        return parser;
    }
}

