/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.Base64;
import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.data.XmlCodec;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformXmlDataSerializer {
    private Log log = LogFactory.getLog(PlatformXmlDataSerializer.class);
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private static final int BUFFER_SIZE = 4096;
    private XmlCodec codec = new XmlCodec();
    private byte[] buffer;

    public void writeData(Writer out, PlatformData data) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(out, data);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    public void writeData(Writer out, DataSet ds) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(out, ds);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    void write(Writer out, PlatformData data) throws IOException {
        int depth = 0;
        this.writeBeginRoot(out, depth);
        this.writeVariableList(out, data, ++depth);
        this.writeDataSetList(out, data, depth--);
        this.writeEndRoot(out, depth);
        out.flush();
    }

    void write(Writer out, DataSet ds) throws IOException {
        int depth = 0;
        this.writeDataSet(out, null, ds, depth);
        out.flush();
    }

    void writeBeginRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", depth);
    }

    void writeEndRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "</Root>", depth);
    }

    void writeVariableList(Writer out, PlatformData data, int depth) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count == 0) {
            this.writeString(out, "<Parameters/>", depth);
        } else {
            this.writeString(out, "<Parameters>", depth++);
            for (int i = 0; i < count; ++i) {
                this.writeVariable(out, varList.get(i), depth);
            }
            this.writeString(out, "</Parameters>", --depth);
        }
    }

    void writeVariable(Writer out, Variable var, int depth) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(out, var, depth);
        } else {
            this.writeStringVariable(out, var, depth);
        }
    }

    void writeStringVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<Parameter id=\"").append(name);
        buffer.append("\" type=\"").append(type);
        if (value == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(value);
            buffer.append("</Parameter>");
        }
        this.writeString(out, buffer.toString(), depth);
    }

    void writeBinaryVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<Parameter id=\"").append(name);
            buffer.append("\" type=\"").append(type);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<Parameter id=\"" + name + "\" type=\"" + type + "\" encrypt=\"base64\">";
            String suffix = "</Parameter>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    void writeDataSetList(Writer out, PlatformData data, int depth) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            this.writeDataSet(out, data, dsList.get(i), depth);
        }
    }

    void writeDataSet(Writer out, PlatformData data, DataSet ds, int depth) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing DataSet: name=" + URLEncoder.encode(name, "UTF-8") + ", alias=" + URLEncoder.encode(alias, "UTF-8") + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"writeDataSet: UnsupportedEncodingException");
            }
        }
        this.writeString(out, "<Dataset id=\"" + alias + "\">", depth);
        this.writeColumns(out, ds, ++depth);
        this.writeRows(out, data, ds, depth--);
        this.writeString(out, "</Dataset>", depth);
    }

    void writeColumns(Writer out, DataSet ds, int depth) throws IOException {
        this.writeString(out, "<ColumnInfo>", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(out, header, depth);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(out, ds, header, depth);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        this.writeString(out, "</ColumnInfo>", --depth);
    }

    void writeDefaultColumnHeader(Writer out, ColumnHeader header, int depth) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<Column id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (dataType == 13 || DataTypes.isBinary(dataType)) {
            buffer.append("\" encrypt=\"").append("base64");
        }
        buffer.append("\"/>");
        this.writeString(out, buffer.toString(), depth);
    }

    void writeConstantColumnHeader(Writer out, DataSet ds, ColumnHeader header, int depth) throws IOException {
        if (DataTypes.isBinary(header.getDataType())) {
            this.writeBinaryColumnHeader(out, ds, (ConstantColumnHeader)header, depth);
        } else {
            this.writeStringColumnHeader(out, ds, (ConstantColumnHeader)header, depth);
        }
    }

    void writeStringColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int depth) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<ConstColumn id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (value != null) {
            buffer.append("\" value=\"").append(value);
        }
        buffer.append("\"/>");
        this.writeString(out, buffer.toString(), depth);
    }

    void writeBinaryColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int depth) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<ConstColumn id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\" size=\"").append(dataSize);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<ConstColumn id=\"" + name + "\" type=\"" + dataTypeStr + "\" size=\"" + dataSize + "\" encrypt=\"base64\" value=\"";
            String suffix = "\"></ConstColumn>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    void writeRows(Writer out, PlatformData data, DataSet ds, int depth) throws IOException {
        boolean isCheckingGetterDataIndex;
        this.writeString(out, "<Rows>", depth++);
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            int n = saveType = data == null ? 2 : data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, i, saveType, depth);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(out, ds, i, depth);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
        this.writeString(out, "</Rows>", --depth);
    }

    void writeRow(Writer out, DataSet ds, int row, int saveType, int depth) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        if (saveType == 2) {
            this.writeString(out, "<Row>", depth++);
        } else if (rowType == 1) {
            this.writeString(out, "<Row type=\"insert\">", depth++);
        } else if (rowType == 2) {
            this.writeString(out, "<Row type=\"update\">", depth++);
        } else if (rowType == 3) {
            this.writeString(out, "<Row type=\"delete\">", depth++);
        } else {
            this.writeString(out, "<Row>", depth++);
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = dataType == 13 ? this.getBinaryValueFromFile(ds, row, i) : this.getBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = dataType == 13 ? this.getStringValueFromFile(ds, row, i) : this.getStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, row, depth);
        }
        this.writeString(out, "</Row>", --depth);
    }

    void writeSavedRow(Writer out, DataSet ds, int row, int depth) throws IOException {
        this.writeString(out, "<OrgRow>", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = dataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = dataType == 13 ? this.getSavedStringValueFromFile(ds, row, i) : this.getSavedStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        this.writeString(out, "</OrgRow>", --depth);
    }

    void writeRemovedRow(Writer out, DataSet ds, int row, int depth) throws IOException {
        this.writeString(out, "<Row type=\"delete\">", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = dataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) continue;
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = dataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i) : this.getRemovedStringValue(ds, row, i);
            if (value == null) continue;
            this.writeString(out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", depth);
        }
        this.writeString(out, "</Row>", --depth);
    }

    String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    String getStringValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getString(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"getStringValueFromFile: UnsupportedEncodingException");
            }
        }
        return content == null ? null : this.encode(new String(content));
    }

    byte[] getBinaryValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getString(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"getBinaryValueFromFile: UnsupportedEncodingException");
            }
        }
        return content;
    }

    String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    String getSavedStringValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getSavedStringData(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading saved data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"SavedStringValueFromFile: UnsupportedEncodingException");
            }
        }
        return content == null ? null : this.encode(new String(content));
    }

    byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getSavedStringData(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading saved data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"getSavedBinaryValueFromFile: UnsupportedEncodingException");
            }
        }
        return content;
    }

    String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    String getRemovedStringValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getRemovedStringData(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading removed data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"getRemovedStringValueFromFile: UnsupportedEncodingException");
            }
        }
        return content == null ? null : this.encode(new String(content));
    }

    byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column) throws IOException {
        String filename = ds.getRemovedStringData(row, column);
        byte[] content = this.loadFile(filename);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Loading removed data from file: filename=" + URLEncoder.encode(filename, "UTF-8") + ", content=" + content));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"getRemovedBinaryValueFromFile: UnsupportedEncodingException");
            }
        }
        return content;
    }

    void writeString(Writer out, String str, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            encoder.encodeTo(out, str);
            out.write(NL);
        }
    }

    void writeBinary(Writer out, byte[] value, String prefix, String suffix, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        }
    }

    String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    String encode(String str) {
        return this.codec.encode(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = null;
        PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
        if (fileHandler != null) {
            file = fileHandler.toFile();
        }
        if (file != null && file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

