/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.Variable;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6858534571331380498L;
    private transient Log log = null;
    private static final boolean CHECK_DUPLICATED = false;
    private List values = new ArrayList();

    public Variable get(String name) {
        return this.get(this.indexOf(name));
    }

    public Object getObject(String name) {
        Variable var = this.get(name);
        return var == null ? DataTypes.DEFAULT_VALUE_OBJECT : var.getObject();
    }

    public String getString(String name) {
        Variable var = this.get(name);
        return var == null ? DataTypes.DEFAULT_VALUE_STRING : var.getString();
    }

    public int getInt(String name) {
        Variable var = this.get(name);
        return var == null ? 0 : var.getInt();
    }

    public boolean getBoolean(String name) {
        Variable var = this.get(name);
        return var == null ? false : var.getBoolean();
    }

    public long getLong(String name) {
        Variable var = this.get(name);
        return var == null ? 0L : var.getLong();
    }

    public float getFloat(String name) {
        Variable var = this.get(name);
        return var == null ? 0.0f : var.getFloat();
    }

    public double getDouble(String name) {
        Variable var = this.get(name);
        return var == null ? 0.0 : var.getDouble();
    }

    public BigDecimal getBigDecimal(String name) {
        Variable var = this.get(name);
        return var == null ? DataTypes.DEFAULT_VALUE_BIG_DECIMAL : var.getBigDecimal();
    }

    public BigDecimal getDecimal(String name) {
        return this.getBigDecimal(name);
    }

    public Date getDateTime(String name) {
        Variable var = this.get(name);
        return var == null ? DataTypes.DEFAULT_VALUE_DATE_TIME : var.getDateTime();
    }

    public byte[] getBlob(String name) {
        Variable var = this.get(name);
        return var == null ? DataTypes.DEFAULT_VALUE_BLOB : var.getBlob();
    }

    public Variable get(int index) {
        boolean contains = this.contains(index);
        if (contains) {
            return (Variable)this.values.get(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Getting: index=" + index + ", contains=" + contains + ", values.size()=" + this.values.size())));
        }
        return null;
    }

    public Object getObject(int index) {
        Variable var = this.get(index);
        return var == null ? DataTypes.DEFAULT_VALUE_OBJECT : var.getObject();
    }

    public String getString(int index) {
        Variable var = this.get(index);
        return var == null ? DataTypes.DEFAULT_VALUE_STRING : var.getString();
    }

    public int getInt(int index) {
        Variable var = this.get(index);
        return var == null ? 0 : var.getInt();
    }

    public boolean getBoolean(int index) {
        Variable var = this.get(index);
        return var == null ? false : var.getBoolean();
    }

    public long getLong(int index) {
        Variable var = this.get(index);
        return var == null ? 0L : var.getLong();
    }

    public float getFloat(int index) {
        Variable var = this.get(index);
        return var == null ? 0.0f : var.getFloat();
    }

    public double getDouble(int index) {
        Variable var = this.get(index);
        return var == null ? 0.0 : var.getDouble();
    }

    public BigDecimal getBigDecimal(int index) {
        Variable var = this.get(index);
        return var == null ? DataTypes.DEFAULT_VALUE_BIG_DECIMAL : var.getBigDecimal();
    }

    public BigDecimal getDecimal(int index) {
        return this.getBigDecimal(index);
    }

    public Date getDateTime(int index) {
        Variable var = this.get(index);
        return var == null ? DataTypes.DEFAULT_VALUE_DATE_TIME : var.getDateTime();
    }

    public byte[] getBlob(int index) {
        Variable var = this.get(index);
        return var == null ? DataTypes.DEFAULT_VALUE_BLOB : var.getBlob();
    }

    public void set(String name, Variable var) {
        this.set(this.indexOf(name), var);
    }

    public void set(String name, Object value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, String value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, int value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, boolean value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, long value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, float value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, double value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, BigDecimal value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, Date value) {
        this.set(this.indexOf(name), value);
    }

    public void set(String name, byte[] value) {
        this.set(this.indexOf(name), value);
    }

    public void set(int index, Variable var) {
        this.values.set(index, var);
    }

    public void set(int index, Object value) {
        Variable var = this.get(index);
        if (var == null) {
            int type = DataTypes.findType(value);
            var = new Variable("UNDEFINED", type);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, String value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 2);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, int value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 3);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, boolean value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 4);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, long value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 5);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, float value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 6);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, double value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 7);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, BigDecimal value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 8);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, Date value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 11);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void set(int index, byte[] value) {
        Variable var = this.get(index);
        if (var == null) {
            var = new Variable("UNDEFINED", 12);
            var.set(value);
            this.set(index, var);
        } else {
            var.set(value);
        }
    }

    public void add(Variable var) {
        this.checkName(var.getName(), false);
        int index = this.indexOf(var.getName());
        if (index == -1) {
            this.values.add(var);
        } else {
            this.values.set(index, var);
        }
    }

    public void add(String name, Object value) {
        Variable var = new Variable(name, DataTypes.findType(value));
        var.set(value);
        this.add(var);
    }

    public void add(String name, String value) {
        Variable var = new Variable(name, 2);
        var.set(value);
        this.add(var);
    }

    public void add(String name, int value) {
        Variable var = new Variable(name, 3);
        var.set(value);
        this.add(var);
    }

    public void add(String name, boolean value) {
        Variable var = new Variable(name, 4);
        var.set(value);
        this.add(var);
    }

    public void add(String name, long value) {
        Variable var = new Variable(name, 5);
        var.set(value);
        this.add(var);
    }

    public void add(String name, float value) {
        Variable var = new Variable(name, 6);
        var.set(value);
        this.add(var);
    }

    public void add(String name, double value) {
        Variable var = new Variable(name, 7);
        var.set(value);
        this.add(var);
    }

    public void add(String name, BigDecimal value) {
        Variable var = new Variable(name, 8);
        var.set(value);
        this.add(var);
    }

    public void add(String name, Date value) {
        Variable var = new Variable(name, 11);
        var.set(value);
        this.add(var);
    }

    public void add(String name, byte[] value) {
        Variable var = new Variable(name, 12);
        var.set(value);
        this.add(var);
    }

    public void insert(int index, Variable var) {
        this.checkName(var.getName());
        this.values.add(index, var);
    }

    public void insert(int index, String name, Object value) {
        this.checkName(name);
        Variable var = new Variable(name, DataTypes.findType(value));
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, String value) {
        this.checkName(name);
        Variable var = new Variable(name, 2);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, int value) {
        this.checkName(name);
        Variable var = new Variable(name, 3);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, boolean value) {
        this.checkName(name);
        Variable var = new Variable(name, 4);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, long value) {
        this.checkName(name);
        Variable var = new Variable(name, 5);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, float value) {
        this.checkName(name);
        Variable var = new Variable(name, 6);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, double value) {
        this.checkName(name);
        Variable var = new Variable(name, 7);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, BigDecimal value) {
        this.checkName(name);
        Variable var = new Variable(name, 8);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, Date value) {
        this.checkName(name);
        Variable var = new Variable(name, 11);
        var.set(value);
        this.insert(index, var);
    }

    public void insert(int index, String name, byte[] value) {
        this.checkName(name);
        Variable var = new Variable(name, 12);
        var.set(value);
        this.insert(index, var);
    }

    public Variable remove(String name) {
        return this.remove(this.indexOf(name));
    }

    public Variable remove(int index) {
        boolean contains = this.contains(index);
        if (contains) {
            return (Variable)this.values.remove(index);
        }
        this.getLogger();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing: index=" + index + ", contains=" + contains + ", values.size()=" + this.values.size()));
        }
        return null;
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public int indexOf(String name) {
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            Variable variable = (Variable)this.values.get(i);
            if (!variable.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String name) {
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            Variable variable = (Variable)this.values.get(i);
            if (!variable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List keyList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Variable variable : this.values) {
            list.add(variable.getName());
        }
        return list;
    }

    public List valueList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Variable variable : this.values) {
            list.add(variable.getObject());
        }
        return list;
    }

    public VariableList getClone() {
        try {
            return (VariableList)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VariableList vl = (VariableList)super.clone();
        vl.values = (List)((ArrayList)this.values).clone();
        return vl;
    }

    private boolean contains(int index) {
        return this.contains(index, false);
    }

    private boolean contains(int index, boolean increase) {
        int max = increase ? this.values.size() : this.values.size() - 1;
        return index >= 0 && index <= max;
    }

    private void checkName(String name) {
        this.checkName(name, true);
    }

    private void checkName(String name, boolean checkDuplicated) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
        if (checkDuplicated && this.contains(name)) {
            throw new IllegalArgumentException("Duplicate name: " + name);
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.log = LogFactory.getLog(VariableList.class);
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog(VariableList.class);
        }
    }
}

