/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.data.Debugger;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.DataDeserializer;
import com.nexacro.java.xapi.tx.DataSerializerFactory;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformTransaction;
import com.nexacro.java.xapi.tx.ProtocolDecoder;
import com.nexacro.java.xapi.tx.ProtocolFilterFactory;
import com.nexacro.java.xapi.tx.StreamLog;
import com.nexacro.java.xapi.tx.StreamLogInputStream;
import com.nexacro.java.xapi.tx.StreamLogReader;
import com.nexacro.java.xapi.util.PlatformGlobals;
import com.nexacro.java.xapi.util.SequenceReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformRequest
extends PlatformTransaction {
    private Log log = LogFactory.getLog(PlatformRequest.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformRequest.ioclose";
    private static final String STREAM_LOG_ENABLED_KEY = "platform.tx.PlatformRequest.streamlog.enabled";
    private static final String STREAM_LOG_DIR_KEY = "platform.tx.PlatformRequest.streamlog.dir";
    private static final String STREAM_LOG_MAXSIZE_KEY = "platform.tx.PlatformRequest.streamlog.maxsize";
    private static final String STREAM_LOG_PREFIX_KEY = "platform.tx.PlatformRequest.streamlog.prefix";
    private static final String STREAM_LOG_SUFFIX_KEY = "platform.tx.PlatformRequest.streamlog.suffix";
    private static final String STREAM_LOG_EXCEEDED_SIZE_KEY = "platform.tx.PlatformRequest.streamlog.exceededsize";
    private InputStream in;
    private Reader reader;
    private StreamLogInputStream logStream;
    private StreamLogReader logReader;
    private StreamLog streamLog;

    public PlatformRequest() {
    }

    public PlatformRequest(String contentType) {
        this(contentType, null);
    }

    public PlatformRequest(String contentType, String charset) {
        super(contentType, charset);
    }

    public PlatformRequest(InputStream in) {
        this(in, null);
    }

    public PlatformRequest(InputStream in, String contentType) {
        this(in, contentType, null);
    }

    public PlatformRequest(InputStream in, String contentType, String charset) {
        super(contentType, charset);
        this.in = in;
    }

    public PlatformRequest(Reader reader) {
        this(reader, null);
    }

    public PlatformRequest(Reader reader, String contentType) {
        this(reader, contentType, null);
    }

    public PlatformRequest(Reader reader, String contentType, String charset) {
        super(contentType, charset);
        this.reader = reader;
    }

    @Override
    public Object getProperty(String key) {
        return super.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
    }

    public void receiveData() throws PlatformException {
        this.checkLicense();
        this.checkGlobalStreamLog();
        boolean isVerbose = this.isCurrentVerbose();
        long startTime = System.currentTimeMillis();
        if (isVerbose) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)StringUtils.normalizeSpace((String)("Receiving data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset())));
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Receiving data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + startTime)));
        }
        try {
            this.checkStream();
            if (this.useInputStream()) {
                this.readFrom(this.getInputStream());
            } else {
                this.readFrom(this.getReader());
            }
        }
        catch (PlatformException ex) {
            block19: {
                try {
                    this.storeStreamLog();
                }
                catch (IOException ie) {
                    if (!this.log.isErrorEnabled()) break block19;
                    this.log.error((Object)"Storing stream failed", (Throwable)ie);
                }
            }
            throw ex;
        }
        catch (Throwable th) {
            block20: {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Receiving data failed", th);
                }
                try {
                    this.storeStreamLog();
                }
                catch (IOException ie) {
                    if (!this.log.isErrorEnabled()) break block20;
                    this.log.error((Object)"Storing stream failed", (Throwable)ie);
                }
            }
            throw new PlatformException("Receiving data failed", th);
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        if (isVerbose) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)StringUtils.normalizeSpace((String)("Received data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime)));
            }
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)StringUtils.normalizeSpace((String)("Received data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime)));
            }
            if (this.log.isDebugEnabled()) {
                Debugger debugger = new Debugger();
                this.log.debug((Object)StringUtils.normalizeSpace((String)debugger.detail(this.getData())));
            }
        }
    }

    public boolean isStreamLogEnabled() {
        return this.streamLog == null ? false : this.streamLog.isLogEnabled();
    }

    public void setStreamLogEnabled(boolean isStreamLogEnabled) {
        this.checkStreamLog();
        this.streamLog.setLogEnabled(isStreamLogEnabled);
    }

    public String getStreamLogDir() {
        return this.streamLog == null ? null : this.streamLog.getLogDir();
    }

    public void setStreamLogDir(String streamLogDir) {
        this.checkStreamLog();
        this.streamLog.setLogDir(streamLogDir);
    }

    public int getStreamLogMaxSize() {
        return this.streamLog == null ? 0 : this.streamLog.getLogMaxSize();
    }

    public void setStreamLogMaxSize(int streamLogMaxSize) {
        this.checkStreamLog();
        this.streamLog.setLogMaxSize(streamLogMaxSize);
    }

    public String getStreamLogPrefix() {
        return this.streamLog == null ? null : this.streamLog.getLogPrefix();
    }

    public void setStreamLogPrefix(String streamLogPrefix) {
        this.checkStreamLog();
        this.streamLog.setLogPrefix(streamLogPrefix);
    }

    public String getStreamLogSuffix() {
        return this.streamLog == null ? null : this.streamLog.getLogSuffix();
    }

    public void setStreamLogSuffix(String streamLogSuffix) {
        this.checkStreamLog();
        this.streamLog.setLogSuffix(streamLogSuffix);
    }

    public void storeStreamLog() throws IOException {
        if (this.isStreamLogEnabled()) {
            if (this.useInputStream()) {
                if (this.logStream == null) {
                    new StreamLogInputStream(null, this.streamLog).storeStreamLog();
                } else {
                    this.logStream.storeStreamLog();
                }
            } else if (this.logReader == null) {
                new StreamLogReader(null, this.streamLog).storeStreamLog();
            } else {
                this.logReader.storeStreamLog();
            }
        }
    }

    InputStream getInputStream() {
        if (this.isStreamLogEnabled()) {
            if (this.logStream == null) {
                this.logStream = new StreamLogInputStream(this.in, this.streamLog);
            }
            return this.logStream;
        }
        return this.in;
    }

    void setInputStream(InputStream in) {
        this.in = in;
    }

    Reader getReader() {
        if (this.isStreamLogEnabled()) {
            if (this.logReader == null) {
                this.logReader = new StreamLogReader(this.reader, this.streamLog);
            }
            return this.logReader;
        }
        return this.reader;
    }

    void setReader(Reader reader) {
        this.reader = reader;
    }

    boolean useInputStream() {
        return this.reader == null;
    }

    private void readFrom(InputStream in) throws PlatformException {
        InputStream checkedIn = this.checkInputStream(in);
        if (checkedIn == null) {
            this.setData(new PlatformData());
            return;
        }
        int protocolTypeCount = this.getProtocolTypeCount();
        InputStream[] decoders = null;
        InputStream decoder = checkedIn;
        if (protocolTypeCount == 0) {
            try {
                decoder = this.checkProtocolFilter(decoder);
                protocolTypeCount = this.getProtocolTypeCount();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Checking ProtocolFilter failed", (Throwable)ex);
                }
                throw new PlatformException("Checking ProtocolFilter failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            decoders = new InputStream[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                decoders[i] = decoder = ProtocolFilterFactory.getDecoder(protocolType, decoder);
                if (decoder != null) continue;
                throw new PlatformException(StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: " + protocolType)));
            }
        }
        InputStream typeIn = this.checkDefaultContentType(decoder);
        String contentType = this.getCurrentContentType();
        DataDeserializer deserializer = DataSerializerFactory.getDeserializer(contentType);
        if (deserializer == null) {
            throw new PlatformException("Could not create DataDeserializer: " + contentType);
        }
        String emptyToNullKey = "deserializer.data.emptytonull";
        deserializer.setProperty(emptyToNullKey, this.getProperty(emptyToNullKey));
        this.setData(deserializer.readData(typeIn == null ? decoder : typeIn, this.getDataTypeChanger(), this.getCurrentCharset()));
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                decoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing InputStream failed", (Throwable)ex);
                }
                throw new PlatformException("Closing InputStream failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolDecoder)((Object)decoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Ended ProtocolDecoder: decoders[" + i + "]=" + decoders[i])));
            }
        }
    }

    private void readFrom(Reader reader) throws PlatformException {
        Reader checkedReader = this.checkReader(reader);
        if (checkedReader == null) {
            this.setData(new PlatformData());
            return;
        }
        int protocolTypeCount = this.getProtocolTypeCount();
        Reader[] decoders = null;
        Reader decoder = checkedReader;
        if (protocolTypeCount > 0) {
            decoders = new Reader[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                decoders[i] = decoder = ProtocolFilterFactory.getDecoder(protocolType, decoder);
                if (decoder != null) continue;
                throw new PlatformException(StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: " + protocolType)));
            }
        }
        Reader typeReader = this.checkDefaultContentType(decoder);
        String contentType = this.getCurrentContentType();
        DataDeserializer deserializer = DataSerializerFactory.getDeserializer(contentType);
        if (deserializer == null) {
            throw new PlatformException("Could not create DataDeserializer: " + contentType);
        }
        String emptyToNullKey = "deserializer.data.emptytonull";
        deserializer.setProperty(emptyToNullKey, this.getProperty(emptyToNullKey));
        this.setData(deserializer.readData(typeReader == null ? decoder : typeReader, this.getDataTypeChanger(), this.getCurrentCharset()));
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                decoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Reader failed", (Throwable)ex);
                }
                throw new PlatformException("Closing Reader failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolDecoder)((Object)decoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Ended ProtocolDecoder: decoders[" + i + "]=" + decoders[i])));
            }
        }
    }

    private InputStream checkDefaultContentType(InputStream in) throws PlatformException {
        String currContentType = this.getContentType();
        if (currContentType == null || "".equals(currContentType)) {
            try {
                int n;
                int count = 4;
                byte[] buffer = new byte[count];
                int offset = 0;
                while ((n = in.read(buffer, offset, count - offset)) != -1) {
                    if (n == 0) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: n=" + n + ", offset=" + offset + ", count=" + count)));
                        continue;
                    }
                    if ((offset += n) != count) continue;
                    break;
                }
                if (offset == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: offset=" + offset)));
                    }
                    return null;
                }
                if (offset == count) {
                    String head = new String(buffer);
                    if (head.equalsIgnoreCase("SSV:")) {
                        this.setContentType("PlatformSsv");
                    } else if (head.equalsIgnoreCase("<?xm")) {
                        this.setContentType("PlatformXml");
                    } else if (head.startsWith("{")) {
                        this.setContentType("PlatformJson");
                    } else {
                        this.setContentType("PlatformBinary");
                    }
                    return new SequenceInputStream(new ByteArrayInputStream(buffer), in);
                }
                throw new PlatformException("Check Default Content-Type failed: offset=" + offset);
            }
            catch (EOFException ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: ex=" + ex)));
                }
                throw new PlatformException("Check Default Content-Type: ex=", ex);
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Check Default Content-Type failed", (Throwable)ex);
                }
                throw new PlatformException("Check Default Content-Type failed", ex);
            }
        }
        return null;
    }

    private Reader checkDefaultContentType(Reader in) throws PlatformException {
        String currContentType = this.getContentType();
        if (currContentType == null || "".equals(currContentType)) {
            try {
                int n;
                int count = 4;
                char[] buffer = new char[count];
                int offset = 0;
                while ((n = in.read(buffer, offset, count - offset)) != -1) {
                    if (n == 0) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: n=" + n + ", offset=" + offset + ", count=" + count)));
                        continue;
                    }
                    if ((offset += n) != count) continue;
                    break;
                }
                if (offset == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: offset=" + offset)));
                    }
                    return null;
                }
                if (offset == count) {
                    String head = new String(buffer);
                    if (head.equalsIgnoreCase("SSV:")) {
                        this.setContentType("PlatformSsv");
                    } else if (head.equalsIgnoreCase("<?xm")) {
                        this.setContentType("PlatformXml");
                    } else if (head.startsWith("{")) {
                        this.setContentType("PlatformJson");
                    } else {
                        this.setContentType("PlatformBinary");
                    }
                    return new SequenceReader(new CharArrayReader(buffer), in);
                }
                throw new PlatformException("Check Default Content-Type failed: offset=" + offset);
            }
            catch (EOFException ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Default Content-Type: ex=" + ex)));
                }
                throw new PlatformException("Check Default Content-Type: ex=", ex);
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Check Default Content-Type failed", (Throwable)ex);
                }
                throw new PlatformException("Check Default Content-Type failed", ex);
            }
        }
        return null;
    }

    private InputStream checkInputStream(InputStream in) throws PlatformException {
        try {
            int n;
            int count = 4;
            byte[] buffer = new byte[count];
            int offset = 0;
            while ((n = in.read(buffer, offset, count - offset)) != -1) {
                if (n == 0) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check InputStream: n=" + n + ", offset=" + offset + ", count=" + count)));
                    continue;
                }
                if ((offset += n) != count) continue;
                break;
            }
            if (offset == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check InputStream: offset=" + offset)));
                }
                return null;
            }
            if (offset == count) {
                return new SequenceInputStream(new ByteArrayInputStream(buffer), in);
            }
            throw new PlatformException("Checking InputStream failed: offset=" + offset);
        }
        catch (EOFException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Check InputStream: ex=" + ex)));
            }
            return null;
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Checking InputStream failed", (Throwable)ex);
            }
            throw new PlatformException("Checking InputStream failed", ex);
        }
    }

    private Reader checkReader(Reader in) throws PlatformException {
        try {
            int n;
            int count = 8;
            char[] buffer = new char[count];
            int offset = 0;
            while ((n = in.read(buffer)) != -1) {
                if (n == 0) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Reader: n=" + n + ", offset=" + offset + ", count=" + count)));
                    continue;
                }
                if ((offset += n) != count) continue;
                break;
            }
            if (offset == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Check Reader: offset=" + offset)));
                }
                return null;
            }
            if (offset == 8) {
                return new SequenceReader(new CharArrayReader(buffer), in);
            }
            throw new PlatformException("Checking Reader failed: offset=" + offset);
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Checking Reader failed", (Throwable)ex);
            }
            throw new PlatformException("Checking Reader failed", ex);
        }
    }

    private InputStream checkProtocolFilter(InputStream in) throws IOException {
        byte[] signature = new byte[2];
        int n = in.read(signature);
        if (n == 2) {
            if (signature[0] == -1 && signature[1] == -83) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Adding protocol type: PlatformZlib");
                }
                this.addProtocolType("PlatformZlib");
            }
        } else {
            throw new IOException(StringUtils.normalizeSpace((String)("Checking protocol filter failed: n=" + n)));
        }
        return new SequenceInputStream(new ByteArrayInputStream(signature), in);
    }

    private void checkStreamLog() {
        if (this.streamLog == null) {
            this.streamLog = new StreamLog();
        }
    }

    private void checkGlobalStreamLog() {
        boolean isEnabled;
        if (this.streamLog == null && (isEnabled = PlatformGlobals.getBooleanProperty(STREAM_LOG_ENABLED_KEY, false))) {
            this.streamLog = this.createGlobalStreamLog();
        }
    }

    private void checkStream() throws PlatformException {
        if (this.in == null && this.reader == null) {
            throw new PlatformException("InputStream and Reader are null");
        }
    }

    private StreamLog createGlobalStreamLog() {
        String dir = PlatformGlobals.getStringProperty(STREAM_LOG_DIR_KEY);
        int maxSize = PlatformGlobals.getIntProperty(STREAM_LOG_MAXSIZE_KEY, -1);
        String prefix = PlatformGlobals.getStringProperty(STREAM_LOG_PREFIX_KEY);
        String suffix = PlatformGlobals.getStringProperty(STREAM_LOG_SUFFIX_KEY);
        boolean isExceededSize = PlatformGlobals.getBooleanProperty(STREAM_LOG_EXCEEDED_SIZE_KEY, false);
        StreamLog log = new StreamLog();
        log.setLogEnabled(true);
        log.setLogDir(dir);
        log.setLogMaxSize(maxSize);
        log.setLogPrefix(prefix);
        log.setLogSuffix(suffix);
        log.setExceededSize(isExceededSize);
        return log;
    }
}

