/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.util.DatetimeFormat;
import com.nexacro.java.xapi.util.PlatformCompatibilityUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class StreamLog {
    private static final int KILO = 1024;
    private static final int MEGA = 1024000;
    public static final int IO_BUFFER_SIZE = 4096;
    public static final int SKIP_BUFFER_SIZE = 2048;
    private static final String DEFAULT_LOG_DIR = ".";
    private static final int DEFAULT_LOG_MAX_SIZE = 4096000;
    private static final String DEFAULT_LOG_PREFIX = "xapi";
    private static final String DEFAULT_LOG_SUFFIX = "req";
    private static StreamLogFileFactory logFileFactory = null;
    private DatetimeFormat dateFormat = new DatetimeFormat();
    private boolean isLogEnabled;
    private String logDir;
    private int logMaxSize;
    private String logPrefix;
    private String logSuffix;
    private boolean isExceededSize;
    private StreamLogFile streamLogFile;

    public StreamLog() {
        if (logFileFactory != null) {
            this.streamLogFile = logFileFactory.getStreamLogFile();
        }
    }

    public boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public void setLogEnabled(boolean isLogEnabled) {
        this.isLogEnabled = isLogEnabled;
    }

    public String getLogDir() {
        if (this.streamLogFile == null) {
            return DEFAULT_LOG_DIR;
        }
        return this.streamLogFile.getPath();
    }

    public void setLogDir(String logDir) {
        if (this.streamLogFile != null) {
            this.streamLogFile.setPath(logDir);
        }
    }

    protected File createLogFile() throws IOException {
        if (this.streamLogFile == null) {
            return PlatformUtils.createTempFile(DEFAULT_LOG_PREFIX, DEFAULT_LOG_SUFFIX);
        }
        return this.streamLogFile.createLogFile(this.getLogPrefix(), this.getLogSuffix());
    }

    public int getLogMaxSize() {
        return this.logMaxSize <= 0 ? 4096000 : this.logMaxSize;
    }

    public void setLogMaxSize(int logMaxSize) {
        this.logMaxSize = logMaxSize;
    }

    public String getLogPrefix() {
        return this.isEmpty(this.logPrefix) ? DEFAULT_LOG_PREFIX : this.logPrefix;
    }

    public void setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public String getLogSuffix() {
        return this.isEmpty(this.logSuffix) ? DEFAULT_LOG_SUFFIX : this.logSuffix;
    }

    public void setLogSuffix(String logSuffix) {
        this.logSuffix = logSuffix;
    }

    public boolean isExceededSize() {
        return this.isExceededSize;
    }

    public void setExceededSize(boolean isExceededSize) {
        this.isExceededSize = isExceededSize;
    }

    private String getCurrentDateString() {
        return this.getDateString(System.currentTimeMillis());
    }

    private String getDateString(long time) {
        Date date = new Date(time);
        StringBuffer buffer = new StringBuffer();
        this.dateFormat.setFormat(2);
        buffer.append(this.dateFormat.format(date));
        buffer.append('_');
        this.dateFormat.setFormat(3);
        buffer.append(this.dateFormat.format(date));
        return buffer.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    static {
        logFileFactory = PlatformCompatibilityUtils.loadStreamLogFileFactory();
    }

    public static interface StreamLogFileFactory {
        public StreamLogFile getStreamLogFile();
    }

    public static interface StreamLogFile {
        public String getPath();

        public void setPath(String var1);

        public File createLogFile(String var1, String var2) throws IOException;
    }
}

