/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.StreamLog;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamLogReader
extends Reader {
    private Reader in;
    private StreamLog streamLog;
    private CharArrayWriter buffer;

    public StreamLogReader(Reader in, StreamLog streamLog) {
        this.in = in;
        this.streamLog = streamLog;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1 && this.checkBuffer(1)) {
            this.buffer.write(ch);
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = this.in.read(cbuf, off, len);
        if (n > 0 && this.checkBuffer(n)) {
            this.buffer.write(cbuf, off, n);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int nr;
        if (n <= 0L) {
            return 0L;
        }
        char[] skipBuffer = new char[2048];
        for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)nr) {
            if (nr <= 0 || !this.checkBuffer(nr)) continue;
            this.buffer.write(skipBuffer, 0, nr);
        }
        return n - remaining;
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File parent;
        Log log = LogFactory.getLog(StreamLogReader.class);
        File file = this.streamLog.createLogFile();
        if (file == null) {
            return;
        }
        boolean exists = file.exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing stream: path=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8") + ", exists=" + exists));
        }
        if (exists) {
            block20: {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    if (!log.isErrorEnabled()) break block20;
                    log.error((Object)ex.getMessage());
                }
            }
            file = this.streamLog.createLogFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing stream: path=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8")));
            }
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        try (FileWriter out = new FileWriter(file);){
            if (this.buffer == null) {
                if (this.in == null) {
                    out.write("The buffer does not exist. in=null");
                } else if (this.in.ready()) {
                    this.copy(this.in, out);
                } else {
                    out.write("The buffer does not exist. in.ready()=false");
                }
            } else {
                out.write(this.buffer.toCharArray());
                if (this.streamLog.isExceededSize()) {
                    int maxSize = this.streamLog.getLogMaxSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The buffer was exceeded. maxSize=" + maxSize));
                    }
                    out.write(System.getProperty("line.separator"));
                    out.write("The buffer was exceeded. maxSize=" + maxSize);
                } else if (this.in.ready()) {
                    this.copy(this.in, out);
                }
            }
        }
    }

    private long copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private boolean checkBuffer(int length) {
        if (this.streamLog.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new CharArrayWriter();
        }
        if (this.buffer.size() + length > this.streamLog.getLogMaxSize()) {
            this.streamLog.setExceededSize(true);
            return false;
        }
        return true;
    }
}

