/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EmptyElementInputStream
extends FilterInputStream {
    private Log log = LogFactory.getLog(EmptyElementInputStream.class);
    private static final byte[] EMPTY_SUFFIX = " empty=\"true\"/>".getBytes();
    private byte[] buffer;
    private int pos;

    public EmptyElementInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null || this.buffer.length - this.pos <= 0) {
            return this.readFromSource(b, off, len);
        }
        return this.readFromBuffer(b, off, len);
    }

    private int readFromBuffer(byte[] b, int off, int len) throws IOException {
        int remaining = this.buffer.length - this.pos;
        int n = remaining < len ? remaining : len;
        System.arraycopy(this.buffer, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    private int readFromSource(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n <= 0) {
            return n;
        }
        int index = this.indexOfEmptyElement(b, off, n);
        if (index == -1) {
            int next;
            byte last = b[off + n - 1];
            if (last == 47 && (next = super.read()) != -1) {
                if (next == 62) {
                    this.buffer = EMPTY_SUFFIX;
                    this.pos = 0;
                    --n;
                } else {
                    this.buffer = new byte[]{(byte)next};
                    this.pos = 0;
                }
            }
            return n;
        }
        if (index == 0) {
            this.initBuffer(b, off, n, index);
            System.arraycopy(this.buffer, 0, b, off, n);
            this.pos = n;
            return n;
        }
        this.initBuffer(b, off, n, index);
        return index - off;
    }

    private void initBuffer(byte[] b, int off, int n, int index) throws IOException {
        int offset;
        int count;
        byte[] emptySuffix = EMPTY_SUFFIX;
        int lastIndex = off + n;
        int emptyIndex = index;
        int bufferSize = lastIndex - index + emptySuffix.length * 4;
        ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
        out.write(emptySuffix);
        while ((count = lastIndex - (offset = emptyIndex + 2)) != 0) {
            emptyIndex = this.indexOfEmptyElement(b, offset, count);
            if (emptyIndex == -1) {
                byte last = b[offset + count - 1];
                if (last == 47) {
                    int next = super.read();
                    if (next == -1) {
                        out.write(b, offset, count);
                        break;
                    }
                    if (next == 62) {
                        out.write(b, offset, count - 1);
                        out.write(emptySuffix);
                        break;
                    }
                    out.write(b, offset, count);
                    out.write(next);
                    break;
                }
                out.write(b, offset, count);
                break;
            }
            out.write(b, offset, emptyIndex - offset);
            out.write(emptySuffix);
        }
        out.close();
        this.buffer = out.toByteArray();
        this.pos = 0;
    }

    private int indexOfEmptyElement(byte[] buffer, int offset, int count) {
        int last = offset + count - 1;
        for (int i = offset; i < last; ++i) {
            if (buffer[i] != 47 || buffer[i + 1] != 62) continue;
            return i;
        }
        return -1;
    }
}

