/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.DataDeserializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog(PlatformBinaryDataDeserializer.class);
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private static final boolean COLUMN_SORT = false;
    private static final int TIMEZONE_OFFSET = PlatformBinaryDataDeserializer.getTimezoneOffset();
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private Map properties;
    private boolean isEmptyToNull;
    private byte[] buffer;

    private static int getTimezoneOffset() {
        Calendar cal = Calendar.getInstance();
        return cal.get(15) + cal.get(16);
    }

    private Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    @Override
    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        this.init();
        try {
            return this.read(in, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        String contentType = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    protected PlatformData read(InputStream in, DataTypeChanger dataTypeChanger) throws IOException {
        DataInputStream stream = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        PlatformData data = new PlatformData();
        short mark = stream.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: mark=0x" + Integer.toHexString(mark)));
        }
        boolean isDataSet = false;
        if (mark == -496) {
            this.readVariableList(stream, data, dataTypeChanger);
        } else if (mark == -511) {
            isDataSet = true;
        } else {
            throw new IOException("Invalid mark: 0x" + Integer.toHexString(mark));
        }
        int i = 0;
        while (true) {
            if (isDataSet) {
                isDataSet = false;
            } else {
                mark = this.readShort(in);
            }
            if (mark == -1) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)"Reading DataSet: mark=-1");
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reading DataSet: mark=0x" + Integer.toHexString(mark)));
            }
            if (mark != -511) {
                throw new IOException("Invalid DataSet mark: 0x" + Integer.toHexString(mark));
            }
            this.readDataSet(stream, data, dataTypeChanger, i);
            ++i;
        }
        return data;
    }

    protected void readVariableList(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        short version = in.readShort();
        int size = this.readLength(in);
        int count = in.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading VariableList: version=" + version + ", size=" + size + ", count=" + count));
        }
        if (version != 5000) {
            throw new IOException("Invalid version: " + version);
        }
        for (int i = 0; i < count; ++i) {
            this.readVariable(in, data, dataTypeChanger, i);
        }
    }

    protected void readVariable(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger, int index) throws IOException {
        short length = in.readShort();
        String name = new String(this.readBytes(in, length), CHARSET);
        short type = in.readShort();
        int dataType = this.variantTypeToDataType(type);
        Object value = this.readValue(in, type);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Variable: index=" + index + ", length=" + length + ", name=" + URLEncoder.encode(name, CHARSET) + ", type=" + type + ", dataType=" + dataType));
        }
        Variable var = new Variable(name, dataType);
        if (!this.isNull(value, dataType)) {
            var.set(value);
        }
        data.addVariable(var);
    }

    protected void readDataSet(DataInputStream in, PlatformData data, DataTypeChanger dataTypeChanger, int index) throws IOException {
        short version = in.readShort();
        int size = this.readLength(in);
        short length = in.readShort();
        String name = new String(this.readBytes(in, length), CHARSET);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading DataSet: index=" + index + ", version=" + version + ", size=" + size + ", name=" + URLEncoder.encode(name, CHARSET)));
        }
        if (version != 5000) {
            throw new IOException("Invalid version: " + version);
        }
        DataSet ds = new DataSet(name);
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        boolean isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        this.readConstantColumnHeaders(in, ds);
        this.readDefaultColumnHeaders(in, ds);
        int[] dataTypes = this.getSourceDataTypes(ds, dataTypeChanger);
        this.readDataRows(in, ds, dataTypes);
        if (isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        data.addDataSet(ds);
    }

    protected void readDefaultColumnHeaders(DataInputStream in, DataSet ds) throws IOException {
        int count = in.readShort();
        for (int i = 0; i < count; ++i) {
            short length = in.readShort();
            String name = new String(this.readBytes(in, length), CHARSET);
            short type = in.readShort();
            int dataType = this.columnTypeToDataType(type);
            short dataSize = in.readShort();
            short attr = in.readShort();
            if ((attr & 0xF000) == 24576) {
                short sumLength = in.readShort();
                String sumStr = new String(this.readBytes(in, sumLength), CHARSET);
                ds.addColumn(name, dataType, (int)dataSize);
                continue;
            }
            ds.addColumn(name, dataType, (int)dataSize);
        }
    }

    protected void readConstantColumnHeaders(DataInputStream in, DataSet ds) throws IOException {
        short mark = in.readShort();
        short version = in.readShort();
        int size = this.readLength(in);
        int count = in.readShort();
        if (mark != -496) {
            throw new IOException("Invalid ConstantColumnHeader mark: 0x" + Integer.toHexString(mark));
        }
        if (version != 5000) {
            throw new IOException("Invalid version: " + version);
        }
        for (int i = 0; i < count; ++i) {
            short length = in.readShort();
            String name = new String(this.readBytes(in, length), CHARSET);
            short type = in.readShort();
            int dataType = this.variantTypeToDataType(type);
            int dataSize = DataTypes.getDefaultSize(dataType);
            Object value = this.readValue(in, type);
            ds.addConstantColumn(name, dataType, dataSize, value);
        }
    }

    protected void readDataRows(DataInputStream in, DataSet ds, int[] dataTypes) throws IOException {
        int i;
        int[] indexes = this.getColumnIndexes(ds);
        int[] targetDataTypes = new int[indexes.length];
        for (i = 0; i < targetDataTypes.length; ++i) {
            targetDataTypes[i] = ds.getColumn(indexes[i]).getDataType();
        }
        i = 0;
        while (true) {
            File file;
            int dataType;
            int targetDataType;
            int index;
            int j;
            int size = this.readLength(in);
            short rowType = in.readShort();
            if (size == 0 && rowType == 0) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Finish reading rows: i=" + i + ", size=" + size + ", rowType=0x" + Integer.toHexString(rowType)));
                break;
            }
            int columnCount = indexes.length;
            int count = in.readShort();
            if (rowType == 8) {
                int removedRow = ds.newRemovedRow();
                for (j = 0; j < count; ++j) {
                    if (j >= columnCount) {
                        this.readValue(in);
                        continue;
                    }
                    index = indexes[j];
                    targetDataType = targetDataTypes[j];
                    dataType = dataTypes[index];
                    Object value = null;
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            file = PlatformUtils.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(in, file);
                            value = file.getAbsolutePath();
                        }
                    } else {
                        value = this.readValue(in);
                    }
                    if (this.isNull(value, dataType)) continue;
                    ds.setRemovedData(removedRow, index, value);
                }
            } else {
                int row = ds.newRow();
                for (j = 0; j < count; ++j) {
                    if (j >= columnCount) {
                        this.readValue(in);
                        continue;
                    }
                    index = indexes[j];
                    targetDataType = targetDataTypes[j];
                    dataType = dataTypes[index];
                    Object value = null;
                    if (targetDataType == 13) {
                        if (dataType == 2 || dataType == 12) {
                            file = PlatformUtils.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(in, file);
                            value = file.getAbsolutePath();
                        }
                    } else {
                        value = this.readValue(in);
                    }
                    if (this.isNull(value, dataType)) continue;
                    ds.set(row, index, value);
                }
                if (rowType != 0 && rowType != 1) {
                    if (rowType == 2) {
                        ds.setRowType(row, 1);
                    } else if (rowType == 4) {
                        ds.setRowType(row, 2);
                        int savedCount = in.readShort();
                        if (savedCount > 0) {
                            for (int j2 = 0; j2 < savedCount; ++j2) {
                                if (j2 >= columnCount) {
                                    this.readValue(in);
                                    continue;
                                }
                                int index2 = indexes[j2];
                                int targetDataType2 = targetDataTypes[j2];
                                int dataType2 = dataTypes[index2];
                                Object value = null;
                                if (targetDataType2 == 13) {
                                    if (dataType2 == 2 || dataType2 == 12) {
                                        File file2 = PlatformUtils.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                        this.readValueToFile(in, file2);
                                        value = file2.getAbsolutePath();
                                    }
                                } else {
                                    value = this.readValue(in);
                                }
                                if (this.isNull(value, dataType2)) continue;
                                ds.setSavedData(row, index2, value);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected Object readValue(DataInputStream in) throws IOException {
        return this.readValue(in, in.readShort());
    }

    protected Object readValue(DataInputStream in, short type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                short booleanValue = in.readShort();
                return booleanValue == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: {
                int intValue = in.readInt();
                return new Integer(intValue);
            }
            case 4: {
                double doubleValue = in.readDouble();
                return new Double(doubleValue);
            }
            case 21: {
                int strLength = this.readLength(in);
                String strValue = new String(this.readBytes(in, strLength), CHARSET);
                return strValue;
            }
            case 26: {
                int binLength = this.readLength(in);
                byte[] binValue = this.readBytes(in, binLength);
                return binValue;
            }
            case 40: {
                int decimalLength = this.readLength(in);
                String decimalValue = new String(this.readBytes(in, decimalLength));
                return new BigDecimal(decimalValue);
            }
            case 41: {
                long dateValue = this.reviseTimeValue((long)in.readDouble());
                return new Date(dateValue);
            }
        }
        throw new IOException("Invalid data type: 0x" + Integer.toHexString(type));
    }

    protected void readValueToFile(DataInputStream in, File file) throws IOException {
        this.readValueToFile(in, in.readShort(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readValueToFile(DataInputStream in, short type, File file) throws IOException {
        if (type != 21 && type != 26) throw new IOException("Invalid data type: 0x" + Integer.toHexString(type));
        int length = this.readLength(in);
        byte[] buffer = this.getBuffer();
        int bufferLength = buffer.length;
        int offset = 0;
        try (FileOutputStream out = new FileOutputStream(file);){
            int n;
            do {
                int count;
                if ((count = length - offset) > bufferLength) {
                    count = bufferLength;
                }
                if ((n = in.read(buffer, 0, count)) == -1) {
                    throw new EOFException();
                }
                out.write(buffer, 0, n);
            } while ((offset += n) != length);
            if (!this.log.isDebugEnabled()) return;
            this.log.debug((Object)("Saving data to file: type=" + type + ", file=" + file));
            return;
        }
    }

    protected int readLength(DataInputStream in) throws IOException {
        int length = in.readShort();
        if ((length & 0x8000) == 0) {
            return length;
        }
        length = length << 16 & 0xFFFF0000 | in.readShort() & 0xFFFF;
        return length &= Integer.MAX_VALUE;
    }

    protected byte[] readBytes(DataInputStream in, int count) throws IOException {
        int n;
        byte[] buffer = new byte[count];
        int offset = 0;
        while ((offset += (n = in.read(buffer, offset, count - offset))) != count) {
        }
        return buffer;
    }

    protected int[] getSourceDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            String columnName;
            String dsName;
            int dataType;
            int sourceDataType;
            ColumnHeader header = ds.getColumn(i);
            dataTypes[i] = sourceDataType = header.getDataType();
            if (dataTypeChanger == null || (dataType = dataTypeChanger.getDataType(dsName = ds.getAlias(), columnName = header.getName(), sourceDataType)) == sourceDataType) continue;
            int dataSize = header.getDataSize();
            if (header.isConstant()) {
                if (dataType == 13) continue;
                Object value = ((ConstantColumnHeader)header).getValue();
                ConstantColumnHeader newHeader = new ConstantColumnHeader(columnName, value, dataType, dataSize);
                ds.setColumn(i, newHeader);
                continue;
            }
            ColumnHeader newHeader = new ColumnHeader(columnName, dataType, dataSize);
            ds.setColumn(i, newHeader);
        }
        return dataTypes;
    }

    protected int[] getColumnIndexes(DataSet ds) {
        return this.getNormalColumnIndexes(ds);
    }

    private int[] sortColumnIndexes(DataSet ds) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int count = ds.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ColumnHeader header = ds.getColumn(i2);
            if (header.isConstant()) continue;
            list.add(header.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>();
        block1: for (String name : list) {
            int size = sorted.size();
            for (i = 0; i < size; ++i) {
                String str = (String)sorted.get(i);
                if (name.compareToIgnoreCase(str) >= 0) continue;
                sorted.add(i, name);
                continue block1;
            }
            sorted.add(name);
        }
        int len = sorted.size();
        int[] indexes = new int[len];
        for (i = 0; i < len; ++i) {
            indexes[i] = ds.indexOfColumn(sorted.get(i).toString());
        }
        return indexes;
    }

    private int[] getNormalColumnIndexes(DataSet ds) {
        int count = ds.getColumnCount();
        int[] list = new int[count];
        int n = 0;
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            list[n++] = i;
        }
        int[] indexes = new int[n];
        System.arraycopy(list, 0, indexes, 0, n);
        return indexes;
    }

    protected int variantTypeToDataType(short type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 7;
            }
            case 21: {
                return 2;
            }
            case 26: {
                return 12;
            }
            case 40: {
                return 8;
            }
            case 41: {
                return 11;
            }
        }
        return 0;
    }

    protected int columnTypeToDataType(short type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
        }
        return 0;
    }

    private short readShort(InputStream in) throws IOException {
        int second;
        int first = in.read();
        if ((first | (second = in.read())) < 0) {
            return -1;
        }
        return (short)((first << 8) + (second << 0));
    }

    private long reviseTimeValue(long time) {
        return time - (long)TIMEZONE_OFFSET;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private boolean isNull(Object value, int dataType) {
        return this.isEmptyToNull() && dataType == 2 && "".equals(value);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        Object emptyToNull = this.getProperty("deserializer.data.emptytonull");
        if ("true".equals(emptyToNull)) {
            return true;
        }
        if ("false".equals(emptyToNull)) {
            return false;
        }
        String systemEmptyToNull = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(systemEmptyToNull);
    }
}

