/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.JavaTypeDataConverter;
import com.nexacro.java.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryJavaTypeDataSerializer
implements JavaTypeDataSerializer {
    private Log log = LogFactory.getLog(PlatformBinaryJavaTypeDataSerializer.class);
    private static final String CHARSET = "UTF-8";
    private PlatformCodec platformCodec = new PlatformCodec();
    private VariableList vl;
    private JavaTypeDataConverter dataConverter;
    private DataOutputStream out;
    private Object dataClass;
    private String dsName;
    private List columnHeaders = new ArrayList();
    private List constantColumnHeaders = new ArrayList();

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public void setCharset(String charset) {
    }

    @Override
    public void setDataConverter(JavaTypeDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public void setOutputStream(OutputStream out) throws PlatformException {
        this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
    }

    @Override
    public void setWriter(Writer out) throws PlatformException {
        String contentType = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    @Override
    public void writeHead() throws PlatformException {
    }

    @Override
    public void writeTail() throws PlatformException {
        try {
            if (this.dataClass == Variable.class) {
                this.writeVariableList(this.out, this.vl, this.dataConverter);
            } else if (this.dataClass == DataSet.class || this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.out.writeInt(0);
            } else if (this.dataClass == Object.class) {
                this.out.writeInt(0);
            }
            this.out.flush();
        }
        catch (IOException ex) {
            String contentType = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeVariable(String name, int dataType, Object value) throws PlatformException {
        if (this.vl == null) {
            this.vl = new VariableList();
        }
        Variable var = new Variable(name, dataType);
        var.setConvertingToDataType(false);
        var.set(value);
        this.vl.add(var);
        this.dataClass = Variable.class;
    }

    @Override
    public void writeDataSet(String name) throws PlatformException {
        try {
            String alias = name;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing DataSet: name=" + name + ", alias=" + alias));
            }
            if (this.dataClass == Variable.class) {
                this.writeVariableList(this.out, this.vl, this.dataConverter);
            } else if (this.dataClass == DataSet.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.dsName = null;
                this.out.writeInt(0);
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.dsName = null;
                this.constantColumnHeaders.clear();
                this.columnHeaders.clear();
                this.out.writeInt(0);
            } else if (this.dataClass == Object.class) {
                this.dsName = null;
                this.constantColumnHeaders.clear();
                this.columnHeaders.clear();
                this.out.writeInt(0);
            }
            this.out.writeShort(65025);
            this.out.writeShort(5000);
            this.dsName = name;
            this.dataClass = DataSet.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeDataSetHeader(String name, int dataType, int dataSize) throws PlatformException {
        this.columnHeaders.add(new ColumnHeader(name, dataType, dataSize));
        this.dataClass = ColumnHeader.class;
    }

    @Override
    public void writeDataSetConstantHeader(String name, int dataType, int dataSize, Object value) throws PlatformException {
        this.constantColumnHeaders.add(new ConstantColumnHeader(name, value, dataType, dataSize));
        this.dataClass = ConstantColumnHeader.class;
    }

    @Override
    public void writeDataSetRow(Object[] values) throws PlatformException {
        try {
            if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
            }
            this.writeRowData(this.out, this.columnHeaders, values, this.dataConverter);
            this.dataClass = Object.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    private void writeVariableList(DataOutputStream out, VariableList vl, JavaTypeDataConverter converter) throws IOException {
        int count = vl.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count == 0) {
            return;
        }
        out.writeShort(65040);
        out.writeShort(5000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        bufferOut.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Variable var = vl.get(i);
            this.writeVariable(bufferOut, var, converter);
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        out.write(bin);
    }

    private void writeVariable(DataOutputStream out, Variable var, JavaTypeDataConverter converter) throws IOException {
        String name = var.getName();
        int dataType = var.getType();
        byte[] nameBytes = name.getBytes(CHARSET);
        out.writeShort(nameBytes.length);
        out.write(nameBytes);
        Object value = var.getObject();
        switch (dataType) {
            case 2: {
                String strValue = converter.toString(value);
                this.writeValue(out, strValue);
                break;
            }
            case 3: {
                int intValue = converter.toInt(value);
                this.writeValue(out, intValue);
                break;
            }
            case 4: {
                boolean boolValue = converter.toBoolean(value);
                this.writeValue(out, boolValue);
                break;
            }
            case 5: {
                long longValue = converter.toLong(value);
                this.writeValue(out, longValue);
                break;
            }
            case 6: {
                float floatValue = converter.toFloat(value);
                this.writeValue(out, floatValue);
                break;
            }
            case 7: {
                double doubleValue = converter.toDouble(value);
                this.writeValue(out, doubleValue);
                break;
            }
            case 8: {
                BigDecimal decimalValue = converter.toBigDecimal(value);
                this.writeValue(out, decimalValue);
                break;
            }
            case 9: {
                Date dateValue = converter.toDateTime(value);
                this.writeDateValue(out, dateValue);
                break;
            }
            case 10: {
                Date timeValue = converter.toDateTime(value);
                this.writeTimeValue(out, timeValue);
                break;
            }
            case 11: {
                Date datetimeValue = converter.toDateTime(value);
                this.writeValue(out, datetimeValue);
                break;
            }
            case 12: {
                byte[] blobValue = converter.toBlob(value);
                this.writeValue(out, blobValue);
                break;
            }
            default: {
                this.writeEmptyValue(out);
            }
        }
    }

    private void writeColumnHeaders(DataOutputStream out, String name, List headers, List constantHeaders, JavaTypeDataConverter converter) throws IOException {
        String alias = name;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        byte[] nameBytes = alias.getBytes(CHARSET);
        bufferOut.writeShort(nameBytes.length);
        bufferOut.write(nameBytes);
        this.writeConstantColumnHeaders(bufferOut, constantHeaders, converter);
        this.writeDefaultColumnHeaders(bufferOut, headers);
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        out.write(bin);
    }

    private void writeDefaultColumnHeaders(DataOutputStream out, List headers) throws IOException {
        int count = headers.size();
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = (ColumnHeader)headers.get(i);
            String name = header.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            out.writeShort(nameBytes.length);
            out.write(nameBytes);
            int dataType = header.getDataType();
            int dataSize = header.getDataSize();
            switch (dataType) {
                case 2: {
                    out.writeShort(1);
                    break;
                }
                case 3: {
                    out.writeShort(2);
                    break;
                }
                case 4: {
                    out.writeShort(2);
                    break;
                }
                case 5: {
                    out.writeShort(4);
                    break;
                }
                case 6: {
                    out.writeShort(3);
                    break;
                }
                case 7: {
                    out.writeShort(3);
                    break;
                }
                case 8: {
                    out.writeShort(4);
                    break;
                }
                case 9: {
                    out.writeShort(5);
                    break;
                }
                case 10: {
                    out.writeShort(6);
                    break;
                }
                case 11: {
                    out.writeShort(7);
                    break;
                }
                case 12: {
                    out.writeShort(8);
                    break;
                }
                case 13: {
                    out.writeShort(0);
                    break;
                }
                case 1: {
                    out.writeShort(0);
                    break;
                }
                default: {
                    out.writeShort(0);
                }
            }
            out.writeShort(dataSize);
            out.writeShort(1);
        }
    }

    private void writeConstantColumnHeaders(DataOutputStream out, List headers, JavaTypeDataConverter converter) throws IOException {
        out.writeShort(65040);
        out.writeShort(5000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        int count = headers.size();
        bufferOut.writeShort(count);
        block15: for (int i = 0; i < count; ++i) {
            ConstantColumnHeader header = (ConstantColumnHeader)headers.get(i);
            String name = header.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            bufferOut.writeShort(nameBytes.length);
            bufferOut.write(nameBytes);
            int dataType = header.getDataType();
            Object value = header.getValue();
            switch (dataType) {
                case 2: {
                    String strValue = converter.toString(value);
                    this.writeValue(bufferOut, strValue);
                    continue block15;
                }
                case 3: {
                    int intValue = converter.toInt(value);
                    this.writeValue(bufferOut, intValue);
                    continue block15;
                }
                case 4: {
                    boolean boolValue = converter.toBoolean(value);
                    this.writeValue(bufferOut, boolValue);
                    continue block15;
                }
                case 5: {
                    long longValue = converter.toLong(value);
                    this.writeValue(bufferOut, longValue);
                    continue block15;
                }
                case 6: {
                    float floatValue = converter.toFloat(value);
                    this.writeValue(bufferOut, floatValue);
                    continue block15;
                }
                case 7: {
                    double doubleValue = converter.toDouble(value);
                    this.writeValue(bufferOut, doubleValue);
                    continue block15;
                }
                case 8: {
                    BigDecimal decimalValue = converter.toBigDecimal(value);
                    this.writeValue(bufferOut, decimalValue);
                    continue block15;
                }
                case 9: {
                    Date dateValue = converter.toDateTime(value);
                    this.writeDateValue(bufferOut, dateValue);
                    continue block15;
                }
                case 10: {
                    Date timeValue = converter.toDateTime(value);
                    this.writeTimeValue(bufferOut, timeValue);
                    continue block15;
                }
                case 11: {
                    Date datetimeValue = converter.toDateTime(value);
                    this.writeValue(bufferOut, datetimeValue);
                    continue block15;
                }
                case 12: {
                    byte[] blobValue = converter.toBlob(value);
                    this.writeValue(bufferOut, blobValue);
                    continue block15;
                }
                case 13: {
                    this.writeEmptyValue(bufferOut);
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(bufferOut);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(bufferOut);
                }
            }
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        out.write(bin);
    }

    private void writeRowData(DataOutputStream out, List headers, Object[] values, JavaTypeDataConverter converter) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        this.writeRow(bufferOut, headers, values, converter);
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        if (bin.length > 0) {
            this.writeLength(out, bin.length);
            out.write(bin);
        }
    }

    private void writeRow(DataOutputStream out, List headers, Object[] values, JavaTypeDataConverter converter) throws IOException {
        int count = headers.size();
        out.writeShort(1);
        out.writeShort(count);
        block15: for (int i = 0; i < count; ++i) {
            ColumnHeader header = (ColumnHeader)headers.get(i);
            int dataType = header.getDataType();
            Object value = values[i];
            switch (dataType) {
                case 2: {
                    String strValue = converter.toString(value);
                    this.writeValue(out, strValue);
                    continue block15;
                }
                case 3: {
                    int intValue = converter.toInt(value);
                    this.writeValue(out, intValue);
                    continue block15;
                }
                case 4: {
                    boolean boolValue = converter.toBoolean(value);
                    this.writeValue(out, boolValue);
                    continue block15;
                }
                case 5: {
                    long longValue = converter.toLong(value);
                    this.writeValue(out, longValue);
                    continue block15;
                }
                case 6: {
                    float floatValue = converter.toFloat(value);
                    this.writeValue(out, floatValue);
                    continue block15;
                }
                case 7: {
                    double doubleValue = converter.toDouble(value);
                    this.writeValue(out, doubleValue);
                    continue block15;
                }
                case 8: {
                    BigDecimal decimalValue = converter.toBigDecimal(value);
                    this.writeValue(out, decimalValue);
                    continue block15;
                }
                case 9: {
                    Date dateValue = converter.toDateTime(value);
                    this.writeDateValue(out, dateValue);
                    continue block15;
                }
                case 10: {
                    Date timeValue = converter.toDateTime(value);
                    this.writeTimeValue(out, timeValue);
                    continue block15;
                }
                case 11: {
                    Date datetimeValue = converter.toDateTime(value);
                    this.writeValue(out, datetimeValue);
                    continue block15;
                }
                case 12: {
                    byte[] blobValue = converter.toBlob(value);
                    this.writeValue(out, blobValue);
                    continue block15;
                }
                case 13: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
    }

    private void writeValue(DataOutputStream out, String value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            String str = this.platformCodec.encode(value);
            out.writeShort(21);
            byte[] strBytes = str.getBytes(CHARSET);
            this.writeLength(out, strBytes.length);
            out.write(strBytes);
        }
    }

    private void writeValue(DataOutputStream out, int value) throws IOException {
        out.writeShort(3);
        out.writeInt(value);
    }

    private void writeValue(DataOutputStream out, boolean value) throws IOException {
        out.writeShort(3);
        int bool = value ? 1 : 0;
        out.writeInt(bool);
    }

    private void writeValue(DataOutputStream out, long value) throws IOException {
        out.writeShort(40);
        String longStr = String.valueOf(value);
        byte[] longBytes = longStr.getBytes();
        this.writeLength(out, longBytes.length);
        out.write(longBytes);
    }

    private void writeValue(DataOutputStream out, float value) throws IOException {
        out.writeShort(4);
        out.writeDouble(value);
    }

    private void writeValue(DataOutputStream out, double value) throws IOException {
        out.writeShort(4);
        out.writeDouble(value);
    }

    private void writeValue(DataOutputStream out, BigDecimal value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(40);
            String decimalStr = value.toString();
            byte[] decimalBytes = decimalStr.getBytes();
            this.writeLength(out, decimalBytes.length);
            out.write(decimalBytes);
        }
    }

    private void writeDateValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long dateLong = value.getTime();
            out.writeDouble(dateLong);
        }
    }

    private void writeTimeValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long timeLong = value.getTime();
            out.writeDouble(timeLong);
        }
    }

    private void writeValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long datetimeLong = value.getTime();
            out.writeDouble(datetimeLong);
        }
    }

    private void writeValue(DataOutputStream out, byte[] value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(26);
            this.writeLength(out, value.length);
            out.write(value);
        }
    }

    private void writeEmptyValue(DataOutputStream out) throws IOException {
        out.writeShort(0);
    }

    private void writeLength(DataOutputStream out, int length) throws IOException {
        if (length < 32768) {
            out.writeShort(length);
        } else {
            out.writeInt(length | Integer.MIN_VALUE);
        }
    }
}

