/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.ProtocolDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformZlibByteDecoder
extends InflaterInputStream
implements ProtocolDecoder {
    private Log log = LogFactory.getLog(PlatformZlibByteDecoder.class);
    private static final int ZLIB_SIGNATURE = 65453;
    private Inflater inflater;

    public PlatformZlibByteDecoder(InputStream in) throws IOException {
        this(in, PlatformZlibByteDecoder.createInflater());
    }

    private PlatformZlibByteDecoder(InputStream in, Inflater inflater) throws IOException {
        super(in, inflater);
        this.inflater = inflater;
        this.readSignature();
    }

    @Override
    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Closing: " + this)));
        }
        super.close();
    }

    @Override
    public void end() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Ending: " + this)));
        }
        this.inflater.end();
    }

    private void readSignature() throws IOException {
        int signature = this.readShort(this.in);
        if (!this.isValidSignature(signature)) {
            String hex = "0x" + Integer.toHexString(signature);
            throw new IOException("Invalid ZLIB data format: signature=" + hex);
        }
    }

    private boolean isValidSignature(int signature) {
        return signature == 65453;
    }

    private int readShort(InputStream in) throws IOException {
        int lo;
        int hi = in.read();
        if ((hi | (lo = in.read())) < 0) {
            throw new EOFException("Reading short failed");
        }
        return (hi << 8) + (lo << 0);
    }

    private static Inflater createInflater() {
        return new Inflater();
    }
}

