/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.util;

import com.nexacro.java.xapi.license.A.D;
import com.nexacro.java.xapi.license.InvalidLicenseException;
import com.nexacro.java.xapi.license.License;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;

public class JarInfo {
    public void info(OutputStream out) throws IOException {
        this.info(new OutputStreamWriter(out));
    }

    public void info(Writer out) throws IOException {
        this.infoManifest(out);
        if (this.checkClasspath()) {
            this.infoLicense(out);
        } else {
            this.infoClasspath(out);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void infoManifest(Writer out) throws IOException {
        String nl = System.getProperty("line.separator");
        out.write("--- Manifest ---");
        out.write(nl);
        URL info = this.getClass().getResource("/com/nexacro/java/xapi/util/JarInfo.class");
        String protocol = info.getProtocol();
        String host = info.getHost();
        String file = info.getFile();
        int index = file.indexOf(33);
        if (index == -1) {
            out.write("File not found");
            out.flush();
            return;
        }
        URL manifest = new URL(protocol, host, file.substring(0, index + 1) + "/META-INF/MANIFEST.MF");
        InputStream stream = manifest.openStream();
        InputStreamReader in = new InputStreamReader(stream);
        try {
            int n;
            char[] buffer = new char[1024];
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            out.flush();
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
            try {
                stream.close();
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private void infoLicense(Writer out) throws IOException {
        try {
            License license = License.getInstance(0);
            this.writeLogs(out, D.B);
            this.writeLicense(out, license);
        }
        catch (InvalidLicenseException ex) {
            this.writeLogs(out, D.B);
            this.writeThrowable(out, ex);
        }
    }

    private void writeLogs(Writer out, List logs) throws IOException {
        int count = logs.size();
        if (count > 0) {
            String nl = System.getProperty("line.separator");
            out.write("--- Log ---");
            out.write(nl);
            for (int i = 0; i < count; ++i) {
                out.write(logs.get(i).toString());
                out.write(nl);
            }
            out.write(nl);
        }
    }

    private void writeLicense(Writer out, License license) throws IOException {
        String nl = System.getProperty("line.separator");
        out.write("--- License ---");
        out.write(nl);
        for (String key : new String[]{"product.name", "product.version", "product.function", "customer.name", "server.cpuCoreCount", "server.ipAddress", "date.activation", "date.term", "date.term.unit", "customer.targetPlatform"}) {
            String value = license.getFeature(key);
            if (value == null) {
                value = "";
            }
            out.write(key);
            out.write(": ");
            out.write(value);
            out.write(nl);
        }
        if ("nexacro platform".equals(license.getProductName()) && !license.isValidTime()) {
            out.write(nl);
            out.write("License has expired");
        }
    }

    private void writeThrowable(Writer out, Throwable ex) throws IOException {
        String nl = System.getProperty("line.separator");
        out.write("--- Exception ---");
        out.write(nl);
        out.write(this.toString(ex));
    }

    private boolean checkClasspath() {
        try {
            Class.forName("org.apache.commons.logging.LogFactory");
            return true;
        }
        catch (Throwable th) {
            System.out.println(th.getMessage());
            return false;
        }
    }

    private void infoClasspath(Writer out) throws IOException {
        String nl = System.getProperty("line.separator");
        out.write("--- Log ---");
        out.write(nl);
        out.write("Apache Commons Logging not found.");
    }

    private String toString(Throwable th) throws IOException {
        StringWriter out = new StringWriter();
        PrintWriter pout = new PrintWriter(out);
        pout.println(th.getMessage());
        pout.close();
        out.close();
        return out.toString();
    }

    public static void main(String[] args) throws IOException {
        new JarInfo().info(System.out);
    }
}

