/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DataRow
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3549819208790286520L;
    private static final boolean CHECK_INDEX = false;
    private int type;
    private List values;

    public DataRow(int count) {
        this(count, 0);
    }

    public DataRow(int count, int type) {
        this.type = type;
        this.values = this.createEmptyValues(count);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public void set(int index, Object value) {
        this.values.set(index, value);
    }

    public Object remove(int index) {
        return this.values.set(index, null);
    }

    public void clear() {
        if (this.values == null) {
            return;
        }
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            this.values.set(i, null);
        }
    }

    public int size() {
        return this.values.size();
    }

    public void copyTo(DataRow target) {
        this.copy(this, target);
    }

    public void copyFrom(DataRow source) {
        this.copy(source, this);
    }

    public DataRow getClone() {
        try {
            return (DataRow)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log log = LogFactory.getLog(DataRow.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)ex);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataRow row = (DataRow)super.clone();
        row.values = (List)((ArrayList)this.values).clone();
        return row;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataRow) {
            DataRow another = (DataRow)obj;
            return this.type == another.type && this.equalsValues(another);
        }
        return false;
    }

    void increase() {
        this.values.add(null);
    }

    void increase(int index) {
        this.values.add(index, null);
    }

    void decrease() {
        this.values.remove(this.values.size() - 1);
    }

    void decrease(int index) {
        this.values.remove(index);
    }

    private boolean equalsValues(DataRow another) {
        if (this.values.size() != another.values.size()) {
            return false;
        }
        int count = this.values.size();
        for (int i = 0; i < count; ++i) {
            Object anotherObj;
            Object obj = this.values.get(i);
            if (this.equalsValue(obj, anotherObj = another.values.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsValue(Object obj, Object anotherObj) {
        if (obj == null) {
            return anotherObj == null;
        }
        return obj.equals(anotherObj);
    }

    private void copy(DataRow source, DataRow target) {
        int sourceCount = source.size();
        int targetCount = target.size();
        if (sourceCount == 0 || targetCount == 0) {
            return;
        }
        int count = Math.min(sourceCount, targetCount);
        for (int i = 0; i < count; ++i) {
            target.set(i, source.get(i));
        }
    }

    private boolean contains(int index) {
        return this.contains(index, false);
    }

    private boolean contains(int index, boolean increase) {
        int max = increase ? this.values.size() : this.values.size() - 1;
        return index >= 0 && index <= max;
    }

    private List createEmptyValues(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            values.add(null);
        }
        return values;
    }
}

