/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.license;

import com.nexacro.java.xapi.license.A.D;
import com.nexacro.java.xapi.license.InvalidLicenseException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class License {
    private Log log = LogFactory.getLog(License.class);
    public static final int TYPE_SERVER = 0;
    public static final int TYPE_CLIENT = 1;
    public static final int TYPE_TOOL = 2;
    public static final String KEY_LICENSE_VERSION = "license.version";
    public static final String KEY_PRODUCT_NAME = "product.name";
    public static final String KEY_PRODUCT_VERSION = "product.version";
    public static final String KEY_PRODUCT_FUNCTION = "product.function";
    public static final String KEY_PRODUCT_FUNCTION_BINARY = "product.function.binary";
    public static final String KEY_PRODUCT_LICENSE_TYPE = "product.licenseType";
    public static final String KEY_CUSTOMER_NAME = "customer.name";
    public static final String KEY_CUSTOMER_DEVELOPER_COUNT = "customer.developerCount";
    public static final String KEY_CUSTOMER_DOMAIN = "customer.rootDomain";
    public static final String KEY_CUSTOMER_TARGET_PLATFORM = "customer.targetPlatform";
    public static final String KEY_DATE_ACTIVATION = "date.activation";
    public static final String KEY_DATE_TERM = "date.term";
    public static final String KEY_DATE_TERM_UNIT = "date.term.unit";
    public static final String KEY_SERVER_CPU_CORE_COUNT = "server.cpuCoreCount";
    public static final String KEY_SERVER_IP_ADDRESS = "server.ipAddress";
    public static final String KEY_SERIAL_KEY = "key";
    public static final String PRODUCT_NEXACRO_PLATFORM = "nexacro platform";
    public static final String PRODUCT_XPOP = "X-POP";
    public static final String PRODUCT_XPUSH = "X-PUSH";
    public static final String PRODUCT_XUP = "X-UP";
    public static final String PRODUCT_NEXUP = "Nex-UP";
    private static long defaultActivationTime = 0L;
    private static long defaultExpiredTime = 0L;
    private Map properties = new HashMap();
    private boolean initializedTime;
    private boolean isLimitByTime;
    private long activationTime;
    private long expireTime;
    private boolean initializedFunction;
    private String product;
    private int function;
    private boolean frozen;

    public static License getInstance() {
        return D.C();
    }

    public static License getInstance(int type) {
        return D.B(type);
    }

    public static License load(int type) throws InvalidLicenseException {
        return D.A(type);
    }

    public static License load(int type, URL url) throws InvalidLicenseException {
        return D.A(type, url);
    }

    public static License load(int type, String filename) throws InvalidLicenseException {
        return D.A(type, filename);
    }

    public static License load(int type, InputStream in) throws InvalidLicenseException {
        return D.A(type, in);
    }

    public static License load(int type, Properties properties) throws InvalidLicenseException {
        return D.A(type, properties);
    }

    public static boolean isLoaded() {
        return D.B();
    }

    public String getLicenseVersion() {
        return this.getFeature(KEY_LICENSE_VERSION);
    }

    public String getProductName() {
        return this.getFeature(KEY_PRODUCT_NAME);
    }

    public void setProductName(String productName) {
        this.addFeature(KEY_PRODUCT_NAME, productName);
    }

    public String getProductVersion() {
        return this.getFeature(KEY_PRODUCT_VERSION);
    }

    public void setProductVersion(String productVersion) {
        this.addFeature(KEY_PRODUCT_VERSION, productVersion);
    }

    public String getCustomerName() {
        return this.getFeature(KEY_CUSTOMER_NAME);
    }

    public void setCustomerName(String customerName) {
        this.addFeature(KEY_CUSTOMER_NAME, customerName);
    }

    public String getCustomerDomain() {
        return this.getFeature(KEY_CUSTOMER_DOMAIN);
    }

    public void setCustomerDomain(String customerDomain) {
        this.addFeature(KEY_CUSTOMER_DOMAIN, customerDomain);
    }

    public String getServerIpAddress() {
        return this.getFeature(KEY_SERVER_IP_ADDRESS);
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.addFeature(KEY_SERVER_IP_ADDRESS, serverIpAddress);
    }

    public String getSerialKey() {
        return this.getFeature(KEY_SERIAL_KEY);
    }

    public void setSerialKey(String serialKey) {
        this.addFeature(KEY_SERIAL_KEY, serialKey);
    }

    public String getFeature(String name) {
        return (String)this.properties.get(name);
    }

    public void addFeature(String name, String value) {
        this.checkFreeze();
        this.properties.put(name, value);
    }

    public String removeFeature(String name) {
        this.checkFreeze();
        return (String)this.properties.remove(name);
    }

    public boolean isValidTime() {
        if (!this.frozen) {
            return false;
        }
        if (!this.initializedTime) {
            this.initializeTime();
            this.initializedTime = true;
        }
        if (this.isLimitByTime) {
            long remains;
            long now = this.getCurrentTime();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)StringUtils.normalizeSpace((String)("isValidTime(): now=" + now + ", expireTime=" + this.expireTime)));
            }
            if ((remains = this.expireTime - now) < 2592000000L && this.log.isWarnEnabled()) {
                this.log.warn((Object)StringUtils.normalizeSpace((String)("The license is " + remains / 1000L / 60L / 60L / 24L + " days left.")));
            }
            return now >= this.activationTime && now < this.expireTime;
        }
        return true;
    }

    public boolean isFunctionSupported(String productName, int functionCode) {
        if (this.isValidTime()) {
            if (!this.initializedFunction) {
                this.initializeFunction();
                this.initializedFunction = true;
            }
            if (this.product.equals(productName)) {
                if (this.function == 0) {
                    return true;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)StringUtils.normalizeSpace((String)("isFunctionSupported(): function=" + Integer.toBinaryString(this.function) + ", functionCode=" + Integer.toBinaryString(functionCode) + ", (function & functionCode)=" + Integer.toBinaryString(this.function & functionCode))));
                }
                return (this.function & functionCode) == functionCode;
            }
        }
        return false;
    }

    public boolean isFunctionSupported(String productName, BitSet functionBitSet) {
        int count = functionBitSet.size();
        if (count > 16) {
            count = 16;
        }
        int functionCode = 0;
        for (int i = 0; i < count; ++i) {
            if (!functionBitSet.get(i)) continue;
            functionCode += (int)Math.pow(2.0, i);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("isFunctionSupported(): functionBitSet=" + functionBitSet + ", functionCode=" + functionCode)));
        }
        return this.isFunctionSupported(productName, functionCode);
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isLimitByTime() {
        String licenseType = this.getFeature(KEY_PRODUCT_LICENSE_TYPE);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("isLimitByTime(): licenseType=" + licenseType)));
        }
        return this.isLimitByMonth(licenseType) || this.isLimitByYear(licenseType);
    }

    public long getActivationTime() {
        String dateStr = this.getFeature(KEY_DATE_ACTIVATION);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(dateStr);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)StringUtils.normalizeSpace((String)("getActivationTime(): date=" + date + ", dateStr=" + dateStr)));
            }
            return date.getTime();
        }
        catch (ParseException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not parse date", (Throwable)ex);
            }
            return defaultActivationTime;
        }
    }

    public long getExpireTime() {
        return this.getExpireTime(this.getActivationTime());
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private void initializeTime() {
        this.isLimitByTime = this.isLimitByTime();
        this.activationTime = this.getActivationTime();
        this.expireTime = this.getExpireTime(this.activationTime);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("initializeTime(): isLimitByTime=" + this.isLimitByTime + ", activationTime=" + new Date(this.activationTime) + ", expireTime=" + new Date(this.expireTime))));
        }
    }

    private boolean isLimitByMonth(String licenseType) {
        if (licenseType == null) {
            return false;
        }
        return licenseType.indexOf("TimeByMonth") != -1;
    }

    private boolean isLimitByYear(String licenseType) {
        if (licenseType == null) {
            return false;
        }
        return licenseType.indexOf("TimeByYear") != -1;
    }

    private long getExpireTime(long activationTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(activationTime));
        String termStr = this.getFeature(KEY_DATE_TERM);
        try {
            int term = Integer.parseInt(termStr);
            String licenseType = this.getFeature(KEY_PRODUCT_LICENSE_TYPE);
            if (this.isLimitByMonth(licenseType)) {
                cal.add(2, term);
            } else {
                cal.add(1, term);
            }
            return cal.getTime().getTime();
        }
        catch (NumberFormatException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not parse int", (Throwable)ex);
            }
            return defaultExpiredTime;
        }
    }

    private void initializeFunction() {
        this.product = this.getProduct();
        this.function = this.getFunction();
    }

    private String getProduct() {
        return this.getFeature(KEY_PRODUCT_NAME);
    }

    private int getFunction() {
        String functionStr = this.getFeature(KEY_PRODUCT_FUNCTION_BINARY);
        int function = Integer.parseInt(functionStr, 2);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("getFunction(): function=" + Integer.toBinaryString(function) + ", functionStr=" + functionStr)));
        }
        return function;
    }

    private void checkFreeze() {
        if (this.frozen) {
            throw new IllegalStateException("License is frozen");
        }
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(2999, 11, 31, 23, 59, 59);
        defaultActivationTime = cal.getTime().getTime();
        cal.set(1970, 0, 1, 0, 0, 0);
        defaultExpiredTime = cal.getTime().getTime();
    }
}

