/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.DefaultJavaTypeDataConverter;
import com.nexacro.java.xapi.tx.JavaTypeDataConverter;
import com.nexacro.java.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.java.xapi.tx.JavaTypeDataSerializerFactory;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xapi.tx.PlatformTransaction;
import com.nexacro.java.xapi.tx.ProtocolEncoder;
import com.nexacro.java.xapi.tx.ProtocolFilterFactory;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaTypePlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog(JavaTypePlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private static final int INDEX_INIT = 0;
    private static final int INDEX_STARTED = 1;
    private static final int INDEX_HEAD = 2;
    private static final int INDEX_VARIABLE = 3;
    private static final int INDEX_DATASET = 4;
    private static final int INDEX_DATASET_HEADER = 5;
    private static final int INDEX_DATASET_ROW = 6;
    private static final int INDEX_TAIL = 7;
    private static final int INDEX_ENDED = 8;
    private static final String[] INDEX_NAMES = new String[]{"INIT", "STARTED", "HEAD", "VARIABLE", "DATASET", "DATASET_HEADER", "DATASET_ROW", "TAIL", "ENDED", "UNKNOWN"};
    private JavaTypeDataConverter dataConverter;
    private JavaTypeDataConverter defaultDataConverter = new DefaultJavaTypeDataConverter();
    private Object[][] values = new Object[][]{{null}, {null, null}, {null, null, null}, {null, null, null, null}, {null, null, null, null, null}};
    private OutputStream out;
    private Writer writer;
    private int index;
    private long startTime;
    private JavaTypeDataSerializer serializer;
    private OutputStream[] streamEncoders;
    private OutputStream streamEncoder;
    private Writer[] writerEncoders;
    private Writer writerEncoder;

    public JavaTypePlatformResponse() {
    }

    public JavaTypePlatformResponse(String contentType) {
        this(contentType, null);
    }

    public JavaTypePlatformResponse(String contentType, String charset) {
        super(contentType, charset);
    }

    public JavaTypePlatformResponse(PlatformRequest req) {
        this(req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public JavaTypePlatformResponse(OutputStream out) {
        this(out, (String)null);
    }

    public JavaTypePlatformResponse(OutputStream out, String contentType) {
        this(out, contentType, null);
    }

    public JavaTypePlatformResponse(OutputStream out, String contentType, String charset) {
        super(contentType, charset);
        this.out = out;
    }

    public JavaTypePlatformResponse(OutputStream out, PlatformRequest req) {
        this(out, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public JavaTypePlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public JavaTypePlatformResponse(Writer writer, String contentType) {
        this(writer, contentType, null);
    }

    public JavaTypePlatformResponse(Writer writer, String contentType, String charset) {
        super(contentType, charset);
        this.writer = writer;
    }

    public JavaTypePlatformResponse(Writer writer, PlatformRequest req) {
        this(writer, req.getContentType(), req.getCharset());
        this.setCheckLicense(req.isCheckLicense());
    }

    public JavaTypeDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(JavaTypeDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    public void start() throws PlatformException {
        if (this.getIndex() > 0) {
            throw new PlatformException("Sending data failed. command=start, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkLicense();
        this.setStartTime(System.currentTimeMillis());
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + this.startTime));
        }
        this.checkStream();
        this.init();
        this.setIndex(1);
        this.serializer.writeHead();
        this.setIndex(2);
    }

    public void end() throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 6) {
            throw new PlatformException("Sending data failed. command=end, index=" + this.getIndexName(this.getIndex()));
        }
        this.serializer.writeTail();
        this.setIndex(7);
        this.destroy();
        this.setIndex(8);
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - this.getStartTime();
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + elapsedTime + ", endTime=" + endTime));
        }
    }

    public void sendVariable(String name, int dataType, Object value) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 3) {
            throw new PlatformException("Sending data failed. command=variable, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkVariable(name, dataType, value);
        this.serializer.writeVariable(name, dataType, value);
        this.setIndex(3);
    }

    public void sendDataSet(String name) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 6) {
            throw new PlatformException("Sending data failed. command=dataset, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSet(name);
        this.serializer.writeDataSet(name);
        this.setIndex(4);
    }

    public void sendDataSetHeader(String name, int dataType, int dataSize) throws PlatformException {
        if (this.getIndex() != 4 && this.getIndex() != 5) {
            throw new PlatformException("Sending data failed. command=datasetheader, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetHeader(name, dataType, dataSize);
        this.serializer.writeDataSetHeader(name, dataType, dataSize);
        this.setIndex(5);
    }

    public void sendDataSetConstantHeader(String name, int dataType, int dataSize, Object value) throws PlatformException {
        if (this.getIndex() != 4 && this.getIndex() != 5) {
            throw new PlatformException("Sending data failed. command=datasetconstantheader, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetHeader(name, dataType, dataSize);
        this.serializer.writeDataSetConstantHeader(name, dataType, dataSize, value);
        this.setIndex(5);
    }

    public void sendDataSetRow(Object value) throws PlatformException {
        this.values[0][0] = value;
        this.sendDataSetRow(this.values[0]);
    }

    public void sendDataSetRow(Object value1, Object value2) throws PlatformException {
        this.values[1][0] = value1;
        this.values[1][1] = value2;
        this.sendDataSetRow(this.values[1]);
    }

    public void sendDataSetRow(Object value1, Object value2, Object value3) throws PlatformException {
        this.values[2][0] = value1;
        this.values[2][1] = value2;
        this.values[2][2] = value3;
        this.sendDataSetRow(this.values[2]);
    }

    public void sendDataSetRow(Object value1, Object value2, Object value3, Object value4) throws PlatformException {
        this.values[3][0] = value1;
        this.values[3][1] = value2;
        this.values[3][2] = value3;
        this.values[3][3] = value4;
        this.sendDataSetRow(this.values[3]);
    }

    public void sendDataSetRow(Object value1, Object value2, Object value3, Object value4, Object value5) throws PlatformException {
        this.values[4][0] = value1;
        this.values[4][1] = value2;
        this.values[4][2] = value3;
        this.values[4][3] = value4;
        this.values[4][4] = value5;
        this.sendDataSetRow(this.values[4]);
    }

    public void sendDataSetRow(Object[] values) throws PlatformException {
        if (this.getIndex() != 5 && this.getIndex() != 6) {
            throw new PlatformException("Sending data failed. command=datasetrow, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetRow(values);
        this.serializer.writeDataSetRow(values);
        this.setIndex(6);
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream out) {
        this.out = out;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void init() throws PlatformException {
        this.initSerializer();
        if (this.useOutputStream()) {
            this.initStreamEncoders(this.getOutputStream());
        } else {
            this.initWriterEncoders(this.getWriter());
        }
    }

    private void destroy() throws PlatformException {
        this.destroySerializer();
        if (this.useOutputStream()) {
            this.destroyStreamEncoders();
        } else {
            this.destroyWriterEncoders();
        }
    }

    private void initSerializer() throws PlatformException {
        String contentType = this.getCurrentContentType();
        JavaTypeDataSerializer dataSerializer = JavaTypeDataSerializerFactory.getSerializer(contentType);
        if (dataSerializer == null) {
            throw new PlatformException("Could not create JavaTypeDataSerializer: " + contentType);
        }
        this.serializer = dataSerializer;
    }

    private void initStreamEncoders(OutputStream out) throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        OutputStream[] encoders = null;
        OutputStream encoder = out;
        if (protocolTypeCount > 0) {
            encoders = new OutputStream[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        this.streamEncoders = encoders;
        this.streamEncoder = encoder;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataConverter(this.getCurrentDataConverter());
        this.serializer.setOutputStream(encoder);
    }

    private void initWriterEncoders(Writer writer) throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        Writer[] encoders = null;
        Writer encoder = writer;
        if (protocolTypeCount > 0) {
            encoders = new Writer[protocolTypeCount];
            for (int i = 0; i < protocolTypeCount; ++i) {
                String protocolType = this.getProtocolType(i);
                encoders[i] = encoder = ProtocolFilterFactory.getEncoder(protocolType, encoder);
                if (encoder != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + protocolType);
            }
        }
        this.writerEncoders = encoders;
        this.writerEncoder = encoder;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataConverter(this.getCurrentDataConverter());
        this.serializer.setWriter(encoder);
    }

    private void destroySerializer() throws PlatformException {
    }

    private void destroyStreamEncoders() throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        OutputStream[] encoders = this.streamEncoders;
        OutputStream encoder = this.streamEncoder;
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing OutputStream failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)ex);
                }
                throw new PlatformException("Closing OutputStream failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    private void destroyWriterEncoders() throws PlatformException {
        int protocolTypeCount = this.getProtocolTypeCount();
        Writer[] encoders = this.writerEncoders;
        Writer encoder = this.writerEncoder;
        try {
            encoder.flush();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)ex);
            }
            throw new PlatformException("Flushing Writer failed", ex);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)ex);
                }
                throw new PlatformException("Closing Writer failed", ex);
            }
        }
        if (protocolTypeCount > 0) {
            for (int i = 0; i < protocolTypeCount; ++i) {
                ((ProtocolEncoder)((Object)encoders[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + encoders[i]));
            }
        }
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    private String getIndexName(int index) {
        int len = INDEX_NAMES.length;
        if (index >= 0 && index < len) {
            return INDEX_NAMES[index];
        }
        return INDEX_NAMES[len];
    }

    private long getStartTime() {
        return this.startTime;
    }

    private void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }

    private JavaTypeDataConverter getCurrentDataConverter() {
        return this.dataConverter == null ? this.defaultDataConverter : this.dataConverter;
    }

    private void checkVariable(String name, int dataType, Object value) throws PlatformException {
        this.checkName(name);
        this.checkDataType(dataType);
    }

    private void checkDataSet(String name) {
        this.checkName(name);
    }

    private void checkDataSetHeader(String name, int dataType, int dataSize) {
        this.checkName(name);
        this.checkDataType(dataType);
        this.checkDataSize(dataSize);
    }

    private void checkDataSetRow(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Invalid values: " + values);
        }
    }

    private void checkName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.charAt(0) == ' ' && "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + name + "\"");
        }
    }

    private void checkDataType(int dataType) {
        if (dataType < 2 || dataType > 12) {
            throw new IllegalArgumentException("Invalid data type: " + dataType);
        }
    }

    private void checkDataSize(int dataSize) {
        if (dataSize < 0) {
            throw new IllegalArgumentException("Invalid data size: " + dataSize);
        }
    }
}

