/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.DataDeserializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PlatformJsonDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog(PlatformJsonDataDeserializer.class);

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse((Reader)reader);
            String version = (String)jsonObject.get((Object)"version");
            return this.read(jsonObject, dataTypeChanger);
        }
        catch (Exception ex) {
            String contentType = "PlatformJson";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(in);
            String version = (String)jsonObject.get((Object)"version");
            return this.read(jsonObject, dataTypeChanger);
        }
        catch (Exception ex) {
            String contentType = "PlatformJson";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private PlatformData read(JSONObject jsonObject, DataTypeChanger dataTypeChanger) throws PlatformException {
        PlatformData data = new PlatformData();
        try {
            JSONArray datasets;
            JSONArray parameters = (JSONArray)jsonObject.get((Object)"Parameters");
            if (parameters != null) {
                for (int index = 0; index < parameters.size(); ++index) {
                    JSONObject parameter = (JSONObject)parameters.get(index);
                    this.readVariable(parameter, data, dataTypeChanger);
                }
            }
            if ((datasets = (JSONArray)jsonObject.get((Object)"Datasets")) != null) {
                for (int index = 0; index < datasets.size(); ++index) {
                    JSONObject dataset = (JSONObject)datasets.get(index);
                    this.readDataSet(dataset, data, dataTypeChanger);
                }
            }
            return data;
        }
        catch (Exception ex) {
            String contentType = "PlatformJson";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private void readVariable(JSONObject param, PlatformData data, DataTypeChanger dataTypeChanger) {
        String id = (String)param.get((Object)"id");
        String dataTypeStr = (String)param.get((Object)"type");
        Object value = param.get((Object)"value");
        int dataType = 2;
        if (dataTypeStr == null) {
            if (value instanceof Integer) {
                dataType = 3;
            } else if (value instanceof Float) {
                dataType = 6;
            }
        } else {
            dataType = this.getDataType(dataTypeStr);
        }
        Variable var = new Variable(id, dataType, value);
        data.addVariable(var);
    }

    private void readDataSet(JSONObject dataset, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        JSONArray rows;
        JSONObject columnInfo;
        String id = (String)dataset.get((Object)"id");
        DataSet ds = new DataSet(id);
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        boolean isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        if ((columnInfo = (JSONObject)dataset.get((Object)"ColumnInfo")) != null) {
            JSONArray columns;
            JSONArray constColumns = (JSONArray)columnInfo.get((Object)"ConstColumn");
            if (constColumns != null) {
                for (int index = 0; index < constColumns.size(); ++index) {
                    JSONObject constCol = (JSONObject)constColumns.get(index);
                    this.readConstantColumnHeader(constCol, ds);
                }
            }
            if ((columns = (JSONArray)columnInfo.get((Object)"Column")) != null) {
                this.readDefaultColumnHeader(columns, ds);
            }
        }
        if ((rows = (JSONArray)dataset.get((Object)"Rows")) != null) {
            for (int rowindex = 0; rowindex < rows.size(); ++rowindex) {
                JSONObject row = (JSONObject)rows.get(rowindex);
                this.readDataRow(row, ds);
            }
        }
        if (isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        data.addDataSet(ds);
    }

    private void readConstantColumnHeader(JSONObject constCol, DataSet ds) {
        String id = (String)constCol.get((Object)"id");
        String dataTypeStr = (String)constCol.get((Object)"type");
        String dataSizeStr = (String)constCol.get((Object)"size");
        Object value = constCol.get((Object)"value");
        int dataType = 2;
        if (dataTypeStr == null) {
            if (value instanceof Integer) {
                dataType = 3;
            } else if (value instanceof Float) {
                dataType = 6;
            }
        } else {
            dataType = this.getDataType(dataTypeStr);
        }
        if (dataSizeStr != null) {
            int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
            ds.addConstantColumn(id, dataType, dataSize, value);
        } else {
            ds.addConstantColumn(id, dataType, value);
        }
    }

    private void readDefaultColumnHeader(JSONArray columns, DataSet ds) {
        for (int index = 0; index < columns.size(); ++index) {
            JSONObject col = (JSONObject)columns.get(index);
            String id = (String)col.get((Object)"id");
            String dataTypeStr = (String)col.get((Object)"type");
            String dataSizeStr = (String)col.get((Object)"size");
            int dataType = 2;
            if (dataTypeStr != null) {
                dataType = this.getDataType(dataTypeStr);
            }
            if (dataSizeStr != null) {
                int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
                ds.insertColumn(index, new ColumnHeader(id, dataType, dataSize));
                continue;
            }
            ds.insertColumn(index, new ColumnHeader(id, dataType));
        }
    }

    private void readDataRow(JSONObject row, DataSet ds) {
        String rowType = (String)row.get((Object)"_RowType_");
        if (rowType == null) {
            rowType = "N";
        }
        if (rowType.length() == 1) {
            char ch = rowType.charAt(0);
            if (ch == 'O') {
                int rowIndex = ds.getRowCount() - 1;
                int columnCount = ds.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    String colId = ds.getColumn(i).getName();
                    Object value = row.get((Object)colId);
                    if (value == null) continue;
                    if (DataTypes.isBinary(ds.getColumnDataType(i))) {
                        ds.setSavedData(rowIndex, i, (Object)Base64.decode(value.toString()));
                        continue;
                    }
                    ds.setSavedData(rowIndex, i, value);
                }
            } else if (ch == 'N' || ch == 'I' || ch == 'U' || ch == 'D') {
                int rowIndex = ds.newRow();
                int columnCount = ds.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    String colId = ds.getColumn(i).getName();
                    Object value = row.get((Object)colId);
                    if (value == null) continue;
                    if (DataTypes.isBinary(ds.getColumnDataType(i))) {
                        ds.set(rowIndex, i, Base64.decode(value.toString()));
                        continue;
                    }
                    ds.set(rowIndex, i, value);
                }
                if (ch == 'N') {
                    ds.setRowType(rowIndex, 0);
                } else if (ch == 'I') {
                    ds.setRowType(rowIndex, 1);
                } else if (ch == 'U') {
                    ds.setRowType(rowIndex, 2);
                } else if (ch == 'D') {
                    ds.setRowType(rowIndex, 3);
                }
            }
        } else if (this.log.isWarnEnabled()) {
            int rowCount = ds.getRowCount();
            this.log.warn((Object)("Invalid JSON row type: rowType=" + rowType + ", rowCount=" + rowCount));
            this.log.warn((Object)("Invalid JSON row type: str=" + row.toJSONString()));
        }
    }

    private int getDataType(String str) {
        if ("binary".equalsIgnoreCase(str)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(str)) {
            return 7;
        }
        return DataTypes.toIntType(str);
    }
}

