/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PartDataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import com.nexacro.java.xapi.util.PlatformGlobals;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformSsvPartDataSerializer
implements PartDataSerializer {
    private Log log = LogFactory.getLog(PlatformSsvPartDataSerializer.class);
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private byte[] buffer;
    private String charset;
    private DataTypeChanger dataTypeChanger;
    private Writer out;
    private Object data;
    private char etx = (char)3;
    private String unitSeperator;
    private String recordSeperator;
    private boolean nullToEmpty = PlatformGlobals.getBooleanProperty("platform.tx.DataSerializer.nullchar.toempty", false);

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    @Override
    public void setOutputStream(OutputStream out) throws PlatformException {
        try {
            this.out = this.charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    @Override
    public void setWriter(Writer out) throws PlatformException {
        this.out = out;
    }

    @Override
    public void writeHead() throws PlatformException {
        this.getDataSeperator();
        try {
            if (this.charset == null) {
                this.writeString(this.out, "SSV");
            } else {
                this.writeString(this.out, "SSV:" + this.charset);
            }
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    @Override
    public void writeTail() throws PlatformException {
        this.getDataSeperator();
        try {
            if (this.data instanceof DataSet) {
                this.writeString(this.out, "");
            }
            this.out.write(this.recordSeperator);
            this.out.flush();
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    @Override
    public void writeVariable(Variable var) throws PlatformException {
        this.getDataSeperator();
        try {
            if (DataTypes.isBinary(var.getType())) {
                this.writeBinaryVariable(this.out, var);
            } else {
                this.writeStringVariable(this.out, var);
            }
            this.out.flush();
            this.data = var;
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    @Override
    public void writeDataSet(DataSet ds) throws PlatformException {
        this.getDataSeperator();
        try {
            String name = ds.getName();
            String alias = ds.getAlias();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount())));
            }
            if (this.data == ds) {
                int[] dataTypes = this.getTargetDataTypes(ds, this.dataTypeChanger);
                this.writeRowData(ds, dataTypes);
            } else {
                if (this.data instanceof DataSet) {
                    this.writeString(this.out, "");
                }
                this.writeString(this.out, "Dataset:" + alias);
                int[] dataTypes = this.getTargetDataTypes(ds, this.dataTypeChanger);
                this.writeColumns(this.out, ds, dataTypes);
                this.writeRowData(ds, dataTypes);
            }
            this.out.flush();
            this.data = ds;
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    private void writeStringVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        if (value == null) {
            buffer.append(name).append(':').append(type).append('=');
            if (!this.nullToEmpty) {
                buffer.append(this.etx);
            }
        } else {
            buffer.append(name).append(':').append(type).append('=').append(value);
        }
        this.writeString(out, buffer.toString());
    }

    private void writeBinaryVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(32);
            buffer.append(name).append(':').append(type).append('=');
            this.writeString(out, buffer.toString());
        } else {
            String encoded = Base64.encodeBytes(value, 8);
            int length = encoded == null ? 0 : encoded.length();
            StringBuffer buffer = new StringBuffer(length + 32);
            buffer.append(name).append(':').append(type).append('=');
            if (encoded != null) {
                buffer.append(encoded);
            }
            this.writeString(out, buffer.toString());
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeColumns(Writer out, DataSet ds, int[] dataTypes) throws IOException {
        int count = ds.getColumnCount();
        StringBuffer defaultBuffer = new StringBuffer();
        StringBuffer constantBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(defaultBuffer, header, dataType);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(constantBuffer, ds, header, dataType);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (constantBuffer.length() > 0) {
            this.writeString(out, "_Const_" + constantBuffer.toString());
        }
        if (defaultBuffer.length() > 0) {
            this.writeString(out, "_RowType_" + defaultBuffer.toString());
        }
    }

    private void writeDefaultColumnHeader(StringBuffer buffer, ColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        buffer.append(this.unitSeperator);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
    }

    private void writeConstantColumnHeader(StringBuffer buffer, DataSet ds, ColumnHeader header, int dataType) throws IOException {
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        } else {
            this.writeStringColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        }
    }

    private void writeStringColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        buffer.append(this.unitSeperator);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            buffer.append(value);
        }
    }

    private void writeBinaryColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        buffer.append(this.unitSeperator);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            String encoded = Base64.encodeBytes(value, 8);
            buffer.append(encoded);
        }
    }

    private String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    private void writeRowData(DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(ds, dataTypes, i, saveType);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(ds, dataTypes, i);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (saveType == 2) {
            buffer.append('N');
        } else if (rowType == 1) {
            buffer.append('I');
        } else if (rowType == 2) {
            buffer.append('U');
        } else if (rowType == 3) {
            buffer.append('D');
        } else {
            buffer.append('N');
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.unitSeperator);
                    if (this.nullToEmpty) continue;
                    buffer.append(this.etx);
                    continue;
                }
                buffer.append(this.unitSeperator);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) {
                buffer.append(this.unitSeperator);
                if (this.nullToEmpty) continue;
                buffer.append(this.etx);
                continue;
            }
            buffer.append(this.unitSeperator);
            buffer.append((String)value);
        }
        this.writeString(this.out, buffer.toString());
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(ds, dataTypes, row);
        }
    }

    private void writeSavedRow(DataSet ds, int[] dataTypes, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('O');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.unitSeperator);
                    if (this.nullToEmpty) continue;
                    buffer.append(this.etx);
                    continue;
                }
                buffer.append(this.unitSeperator);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) {
                buffer.append(this.unitSeperator);
                if (this.nullToEmpty) continue;
                buffer.append(this.etx);
                continue;
            }
            buffer.append(this.unitSeperator);
            buffer.append((String)value);
        }
        this.writeString(this.out, buffer.toString());
    }

    private void writeRemovedRow(DataSet ds, int[] dataTypes, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('D');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.unitSeperator);
                    if (this.nullToEmpty) continue;
                    buffer.append(this.etx);
                    continue;
                }
                buffer.append(this.unitSeperator);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) {
                buffer.append(this.unitSeperator);
                if (this.nullToEmpty) continue;
                buffer.append(this.etx);
                continue;
            }
            buffer.append(this.unitSeperator);
            buffer.append((String)value);
        }
        this.writeString(this.out, buffer.toString());
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    private String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading saved data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading saved data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    private String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading removed data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Loading removed data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private void writeString(Writer out, String str) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("ssv");
        encoder.encodeTo(out, str);
        encoder.encodeTo(out, this.recordSeperator);
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.platformCodec.encode(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = null;
        PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
        if (fileHandler != null) {
            file = fileHandler.toFile();
        }
        if (file != null && file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private void getDataSeperator() throws PlatformException {
        if (this.unitSeperator == null || this.recordSeperator == null) {
            StringBuffer unitBuff = new StringBuffer();
            StringBuffer recordBuff = new StringBuffer();
            StringUtils.getDataSeperator(unitBuff, recordBuff);
            this.unitSeperator = unitBuff.toString();
            this.recordSeperator = recordBuff.toString();
        }
    }
}

