/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.util.TypeConverter;
import com.nexacro.java.xapi.tx.JavaTypeDataConverter;
import com.nexacro.java.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import com.nexacro.java.xapi.tx.impl.XmlCodec;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformXmlJavaTypeDataSerializer
implements JavaTypeDataSerializer {
    private Log log = LogFactory.getLog(PlatformXmlJavaTypeDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final boolean WRITE_NULL_VALUE = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private String charset;
    private JavaTypeDataConverter dataConverter;
    private Writer out;
    private int depth;
    private Class dataClass;
    private List columnHeaders = new ArrayList();
    private boolean nullToEmpty = PlatformGlobals.getBooleanProperty("platform.tx.DataSerializer.nullchar.toempty", false);

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setDataConverter(JavaTypeDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public void setOutputStream(OutputStream out) throws PlatformException {
        try {
            this.out = this.charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void setWriter(Writer out) throws PlatformException {
        this.out = out;
    }

    @Override
    public void writeHead() throws PlatformException {
        try {
            if (this.charset == null) {
                this.writeString(this.out, "<?xml version=\"1.0\"?>", this.depth);
            } else {
                this.writeString(this.out, "<?xml version=\"1.0\" encoding=\"" + this.charset + "\"?>", this.depth);
            }
            this.writeString(this.out, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", this.depth);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeTail() throws PlatformException {
        try {
            if (this.dataClass == Variable.class) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
                --this.depth;
            } else if (this.dataClass == DataSet.class) {
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            } else if (this.dataClass == Object.class) {
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            }
            this.writeString(this.out, "</Root>", this.depth);
            this.out.flush();
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeVariable(String name, int dataType, Object value) throws PlatformException {
        try {
            if (this.dataClass == null) {
                ++this.depth;
                this.writeString(this.out, "<Parameters>", this.depth);
                ++this.depth;
            }
            if (DataTypes.isBinary(dataType)) {
                this.writeBinaryVariable(name, dataType, value);
            } else {
                this.writeStringVariable(name, dataType, value);
            }
            this.dataClass = Variable.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeDataSet(String name) throws PlatformException {
        try {
            String alias = name;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing DataSet: name=" + name + ", alias=" + alias));
            }
            if (this.dataClass == Variable.class) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
            } else if (this.dataClass == DataSet.class) {
                this.writeString(this.out, "</Dataset>", this.depth);
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.columnHeaders.clear();
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
            } else if (this.dataClass == Object.class) {
                this.columnHeaders.clear();
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
            } else {
                ++this.depth;
            }
            this.writeString(this.out, "<Dataset id=\"" + alias + "\">", this.depth);
            this.dataClass = DataSet.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeDataSetHeader(String name, int dataType, int dataSize) throws PlatformException {
        try {
            if (this.dataClass == DataSet.class) {
                ++this.depth;
                this.writeString(this.out, "<ColumnInfo>", this.depth);
                ++this.depth;
            }
            this.columnHeaders.add(new ColumnHeader(name, dataType, dataSize));
            this.writeDefaultColumnHeader(name, dataType, dataSize);
            this.dataClass = ColumnHeader.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeDataSetConstantHeader(String name, int dataType, int dataSize, Object value) throws PlatformException {
        try {
            if (this.dataClass == DataSet.class) {
                ++this.depth;
                this.writeString(this.out, "<ColumnInfo>", this.depth);
                ++this.depth;
            }
            this.writeConstantColumnHeader(name, dataType, dataSize, value);
            this.dataClass = ConstantColumnHeader.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    @Override
    public void writeDataSetRow(Object[] values) throws PlatformException {
        try {
            if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                this.writeString(this.out, "<Rows>", this.depth);
                ++this.depth;
            }
            this.writeRow(this.columnHeaders, values);
            this.dataClass = Object.class;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    private void writeStringVariable(String name, int dataType, Object value) throws IOException {
        String dataTypeStr = this.getDataType(dataType);
        String valueStr = this.getStringValue(dataType, value);
        int length = valueStr == null ? 0 : valueStr.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<Parameter id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        if (valueStr == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(valueStr);
            buffer.append("</Parameter>");
        }
        this.writeString(this.out, buffer.toString(), this.depth);
    }

    private void writeBinaryVariable(String name, int dataType, Object value) throws IOException {
        String dataTypeStr = this.getDataType(dataType);
        byte[] valueBytes = this.getBinaryValue(dataType, value);
        if (valueBytes == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<Parameter id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\"/>");
            this.writeString(this.out, buffer.toString(), this.depth);
        } else {
            String prefix = "<Parameter id=\"" + name + "\" type=\"" + dataTypeStr + "\" encrypt=\"base64\">";
            String suffix = "</Parameter>";
            this.writeBinary(this.out, valueBytes, prefix, suffix, this.depth);
        }
    }

    private void writeDefaultColumnHeader(String name, int dataType, int dataSize) throws IOException {
        String dataTypeStr = this.getDataType(dataType);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<Column id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (dataType == 13 || DataTypes.isBinary(dataType)) {
            buffer.append("\" encrypt=\"").append("base64");
        }
        buffer.append("\"/>");
        this.writeString(this.out, buffer.toString(), this.depth);
    }

    private void writeConstantColumnHeader(String name, int dataType, int dataSize, Object value) throws IOException {
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(name, dataType, dataSize, value);
        } else {
            this.writeStringColumnHeader(name, dataType, dataSize, value);
        }
    }

    private void writeStringColumnHeader(String name, int dataType, int dataSize, Object value) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String dataTypeStr = this.getDataType(dataType);
        String valueStr = this.getStringValue(dataType, value);
        int length = valueStr == null ? 0 : valueStr.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<ConstColumn id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (valueStr != null) {
            buffer.append("\" value=\"").append(valueStr);
        }
        buffer.append("\"/>");
        this.writeString(this.out, buffer.toString(), this.depth);
    }

    private void writeBinaryColumnHeader(String name, int dataType, int dataSize, Object value) throws IOException {
        String dataTypeStr = this.getDataType(dataType);
        byte[] valueBytes = this.getBinaryValue(dataType, value);
        if (valueBytes == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<ConstColumn id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\" size=\"").append(dataSize);
            buffer.append("\"/>");
            this.writeString(this.out, buffer.toString(), this.depth);
        } else {
            String prefix = "<ConstColumn id=\"" + name + "\" type=\"" + dataTypeStr + "\" size=\"" + dataSize + "\" encrypt=\"base64\" value=\"";
            String suffix = "\"></ConstColumn>";
            this.writeBinary(this.out, valueBytes, prefix, suffix, this.depth);
        }
    }

    private void writeRow(List headers, Object[] values) throws IOException {
        this.writeString(this.out, "<Row>", this.depth++);
        int count = Math.min(headers.size(), values.length);
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = (ColumnHeader)headers.get(i);
            String name = header.getName();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                value = this.getBinaryValue(dataType, values[i]);
                if (value == null) {
                    if (!this.nullToEmpty) continue;
                    this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                    continue;
                }
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(this.out, (byte[])value, prefix, suffix, this.depth);
                continue;
            }
            value = this.getStringValue(dataType, values[i]);
            if (value == null) {
                if (!this.nullToEmpty) continue;
                this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                continue;
            }
            this.writeString(this.out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", this.depth);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private String getStringValue(int dataType, Object value) {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case 2: {
                String strValue = this.dataConverter.toString(value, this.charset);
                return this.encode(strValue);
            }
            case 3: {
                int intValue = this.dataConverter.toInt(value);
                return (String)TypeConverter.convert(intValue, 2);
            }
            case 4: {
                boolean boolValue = this.dataConverter.toBoolean(value);
                return boolValue ? "1" : "0";
            }
            case 5: {
                long longValue = this.dataConverter.toLong(value);
                return (String)TypeConverter.convert(longValue, 2);
            }
            case 8: {
                BigDecimal decimalValue = this.dataConverter.toBigDecimal(value);
                return (String)TypeConverter.convert(decimalValue, 2);
            }
            case 6: {
                float floatValue = this.dataConverter.toFloat(value);
                return (String)TypeConverter.convert(floatValue, 2);
            }
            case 7: {
                double doubleValue = this.dataConverter.toDouble(value);
                return (String)TypeConverter.convert(doubleValue, 2);
            }
            case 9: 
            case 10: 
            case 11: {
                Date dateValue = this.dataConverter.toDateTime(value);
                return (String)TypeConverter.convert(dateValue, 2);
            }
            case 12: {
                byte[] blobValue = this.dataConverter.toBlob(value, this.charset);
                return (String)TypeConverter.convert(blobValue, 2);
            }
        }
        return null;
    }

    private byte[] getBinaryValue(int dataType, Object value) {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case 2: {
                String strValue = this.dataConverter.toString(value, this.charset);
                return (byte[])TypeConverter.convert(strValue, 12);
            }
            case 3: {
                int intValue = this.dataConverter.toInt(value);
                return (byte[])TypeConverter.convert(intValue, 12);
            }
            case 4: {
                boolean boolValue = this.dataConverter.toBoolean(value);
                return (byte[])TypeConverter.convert(boolValue, 12);
            }
            case 5: {
                long longValue = this.dataConverter.toLong(value);
                return (byte[])TypeConverter.convert(longValue, 12);
            }
            case 8: {
                BigDecimal decimalValue = this.dataConverter.toBigDecimal(value);
                return (byte[])TypeConverter.convert(decimalValue, 12);
            }
            case 6: {
                float floatValue = this.dataConverter.toFloat(value);
                return (byte[])TypeConverter.convert(floatValue, 12);
            }
            case 7: {
                double doubleValue = this.dataConverter.toDouble(value);
                return (byte[])TypeConverter.convert(doubleValue, 12);
            }
            case 9: 
            case 10: 
            case 11: {
                Date dateValue = this.dataConverter.toDateTime(value);
                return (byte[])TypeConverter.convert(dateValue, 12);
            }
            case 12: {
                byte[] blobValue = this.dataConverter.toBlob(value, this.charset);
                return (byte[])TypeConverter.convert(blobValue, 12);
            }
        }
        return null;
    }

    private void writeString(Writer out, String str, int depth) throws IOException {
        if (depth == 0) {
            out.write(str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            out.write(str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            out.write(str);
            out.write(NL);
        }
    }

    private void writeBinary(Writer out, byte[] value, String prefix, String suffix, int depth) throws IOException {
        if (depth == 0) {
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            out.write(prefix);
            String encoded = Base64.encodeBytes(value, 8);
            out.write(encoded);
            out.write(suffix);
            out.write(NL);
        }
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(str));
    }
}

