/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.ProtocolEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformZlibByteEncoder
extends DeflaterOutputStream
implements ProtocolEncoder {
    private Log log = LogFactory.getLog(PlatformZlibByteEncoder.class);
    private static final int ZLIB_SIGNATURE = 65453;
    private Deflater deflater;

    public PlatformZlibByteEncoder(OutputStream out) throws IOException {
        this(out, PlatformZlibByteEncoder.createDeflater());
    }

    private PlatformZlibByteEncoder(OutputStream out, Deflater deflater) throws IOException {
        super(out, deflater);
        this.deflater = deflater;
        this.writeSignature(out);
    }

    @Override
    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Closing: " + this)));
        }
        super.close();
    }

    @Override
    public void end() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ending: " + this));
        }
        try {
            this.finish();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Finishing PlatformZlibByteEncoder failed", (Throwable)ex);
            }
            throw new PlatformException("Finishing PlatformZlibByteEncoder failed", ex);
        }
        this.deflater.end();
    }

    private void writeSignature(OutputStream out) throws IOException {
        this.writeShort(out, 65453);
    }

    private void writeShort(OutputStream out, int value) throws IOException {
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }

    private static Deflater createDeflater() {
        return new Deflater(1);
    }
}

