/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import [Ljava.lang.Byte;;
import com.nexacro.java.xapi.data.DataConvertProvider;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetDataConverter;
import com.nexacro.java.xapi.data.VariableDataConverter;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.DataTypeFactory;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.java.xapi.util.PlatformCompatibilityUtils;
import java.math.BigDecimal;
import java.util.Date;

public class DataSetConvertHelper {
    private static DataConvertProvider convertProvider = null;

    public static DataType getDataTypeOfValue(Object value) {
        if (value == null) {
            return PlatformDataType.UNDEFINED;
        }
        DataType dataType = DataTypeFactory.getDataTypeOfValue(value);
        if (dataType.getType() == PlatformDataType.UNDEFINED.getType()) {
            if (value instanceof Byte[]) {
                dataType = PlatformDataType.BLOB;
            }
        } else if (dataType.getType() == PlatformDataType.DATE.getType()) {
            dataType = PlatformDataType.DATE_TIME;
        }
        return dataType;
    }

    public static DataType getDataType(Class clazz) {
        if (String.class.equals(clazz)) {
            return PlatformDataType.STRING;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return PlatformDataType.INT;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return PlatformDataType.LONG;
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return PlatformDataType.FLOAT;
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return PlatformDataType.DOUBLE;
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            return PlatformDataType.BOOLEAN;
        }
        if (Date.class.equals(clazz)) {
            return PlatformDataType.DATE_TIME;
        }
        if (BigDecimal.class.equals(clazz)) {
            return PlatformDataType.BIG_DECIMAL;
        }
        if (Object.class.equals(clazz)) {
            return PlatformDataType.UNDEFINED;
        }
        if (clazz.isArray() && ([B.class.equals(clazz) || Byte;.class.equals(clazz))) {
            return PlatformDataType.BLOB;
        }
        return PlatformDataType.UNDEFINED;
    }

    public static Object toObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte[]) {
            return DataSetConvertHelper.toPrimitive((Byte[])obj);
        }
        return obj;
    }

    private static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean ignoreSpecfiedColumnName(String columnName) {
        return "DataSetRowType".equals(columnName) || "DataSetSavedData".equals(columnName);
    }

    public static Object toObjectFromDataSetValue(DataSet ds, int rowIndex, int colIndex, Class targetClass, boolean isSavedData, boolean isRemovedData) {
        if (Object.class.equals(targetClass)) {
            if (isSavedData) {
                return ds.getSavedData(rowIndex, colIndex);
            }
            if (isRemovedData) {
                return ds.getRemovedData(rowIndex, colIndex);
            }
            return ds.getObject(rowIndex, colIndex);
        }
        if (String.class.equals(targetClass)) {
            if (isSavedData) {
                return ds.getSavedStringData(rowIndex, colIndex);
            }
            if (isRemovedData) {
                return ds.getRemovedStringData(rowIndex, colIndex);
            }
            return ds.getString(rowIndex, colIndex);
        }
        if (Integer.TYPE.equals(targetClass) || Integer.class.equals(targetClass)) {
            if (isSavedData) {
                return new Integer(ds.getSavedIntData(rowIndex, colIndex));
            }
            if (isRemovedData) {
                return new Integer(ds.getRemovedIntData(rowIndex, colIndex));
            }
            return new Integer(ds.getInt(rowIndex, colIndex));
        }
        if (Long.TYPE.equals(targetClass) || Long.class.equals(targetClass)) {
            if (isSavedData) {
                return new Long(ds.getSavedLongData(rowIndex, colIndex));
            }
            if (isRemovedData) {
                return new Long(ds.getRemovedLongData(rowIndex, colIndex));
            }
            return new Long(ds.getLong(rowIndex, colIndex));
        }
        if (Float.TYPE.equals(targetClass) || Float.class.equals(targetClass)) {
            if (isSavedData) {
                return new Float(ds.getSavedFloatData(rowIndex, colIndex));
            }
            if (isRemovedData) {
                return new Float(ds.getRemovedFloatData(rowIndex, colIndex));
            }
            return new Float(ds.getFloat(rowIndex, colIndex));
        }
        if (Double.TYPE.equals(targetClass) || Double.class.equals(targetClass)) {
            if (isSavedData) {
                return new Double(ds.getSavedDoubleData(rowIndex, colIndex));
            }
            if (isRemovedData) {
                return new Double(ds.getRemovedDoubleData(rowIndex, colIndex));
            }
            return new Double(ds.getDouble(rowIndex, colIndex));
        }
        if (Boolean.TYPE.equals(targetClass) || Boolean.class.equals(targetClass)) {
            if (isSavedData) {
                return new Boolean(ds.getSavedBooleanData(rowIndex, colIndex));
            }
            if (isRemovedData) {
                return new Boolean(ds.getRemovedBooleanData(rowIndex, colIndex));
            }
            return new Boolean(ds.getBoolean(rowIndex, colIndex));
        }
        if (Date.class.equals(targetClass)) {
            if (isSavedData) {
                return ds.getSavedDateTimeData(rowIndex, colIndex);
            }
            if (isRemovedData) {
                return ds.getRemovedDateTimeData(rowIndex, colIndex);
            }
            return ds.getDateTime(rowIndex, colIndex);
        }
        if (BigDecimal.class.equals(targetClass)) {
            if (isSavedData) {
                return ds.getSavedBigDecimalData(rowIndex, colIndex);
            }
            if (isRemovedData) {
                return ds.getRemovedBigDecimalData(rowIndex, colIndex);
            }
            return ds.getBigDecimal(rowIndex, colIndex);
        }
        if (targetClass.isArray()) {
            if ([B.class.equals(targetClass)) {
                if (isSavedData) {
                    return ds.getSavedBlobData(rowIndex, colIndex);
                }
                if (isRemovedData) {
                    return ds.getRemovedBlobData(rowIndex, colIndex);
                }
                return ds.getBlob(rowIndex, colIndex);
            }
            if (Byte;.class.equals(targetClass)) {
                if (isSavedData) {
                    byte[] blob = ds.getSavedBlobData(rowIndex, colIndex);
                    return DataSetConvertHelper.toObject(blob);
                }
                if (isRemovedData) {
                    byte[] blob = ds.getRemovedBlobData(rowIndex, colIndex);
                    return DataSetConvertHelper.toObject(blob);
                }
                byte[] blob = ds.getBlob(rowIndex, colIndex);
                return DataSetConvertHelper.toObject(blob);
            }
        }
        if (isSavedData) {
            return ds.getSavedData(rowIndex, colIndex);
        }
        if (isRemovedData) {
            return ds.getRemovedData(rowIndex, colIndex);
        }
        return ds.getObject(rowIndex, colIndex);
    }

    public static boolean isImplemented(Class targetClass, Class interfaceClass) {
        Class<?>[] interfaceClasses = targetClass.getInterfaces();
        for (int i = 0; i < interfaceClasses.length; ++i) {
            if (interfaceClasses[i] != interfaceClass) continue;
            return true;
        }
        Class superClass = targetClass.getSuperclass();
        if (superClass != null) {
            return DataSetConvertHelper.isImplemented(superClass, interfaceClass);
        }
        return false;
    }

    static DataSetDataConverter getDefaultDataSetDataConverter() {
        if (convertProvider == null) {
            return null;
        }
        return convertProvider.getDataSetDataConverter();
    }

    static VariableDataConverter getDefaultVariableDataConverter() {
        if (convertProvider == null) {
            return null;
        }
        return convertProvider.getVariableDataConverter();
    }

    static {
        convertProvider = PlatformCompatibilityUtils.loadDataConvertProvider();
    }
}

