/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;

public class Debugger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String[] ROW_TYPE_NAMES = new String[]{"normal", "inserted", "updated", "removed"};
    private static final int MAX_LENGTH = 1024;

    public String info(Variable var) {
        return this.detail(var);
    }

    public String detail(Variable var) {
        if (var == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer(32);
        String name = var.getName();
        String type = DataTypes.toStringType(var.getType());
        if (name == null) {
            buffer.append("name=null");
        } else {
            buffer.append("name=").append(name);
        }
        buffer.append(", type=").append(type);
        buffer.append(", value=");
        if (DataTypes.isBinary(var.getType())) {
            byte[] value = var.getBlob();
            if (value == null) {
                buffer.append("null");
            } else {
                buffer.append("blob[").append(value.length).append(']');
            }
        } else {
            String value = var.getString();
            if (value == null) {
                buffer.append("null");
            } else {
                buffer.append('\"').append(value).append('\"');
            }
        }
        return buffer.toString();
    }

    public String info(VariableList vl) {
        return this.detail(vl);
    }

    public String detail(VariableList vl) {
        if (vl == null) {
            return "null";
        }
        int count = vl.size();
        if (count == 0) {
            return "variable=[]";
        }
        int bufferSize = 32 + count * 16;
        if (bufferSize > 1024) {
            bufferSize = 1024;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append("variable=[").append(NEW_LINE);
        for (int i = 0; i < count; ++i) {
            Object value;
            Variable var = vl.get(i);
            String name = var.getName();
            String type = DataTypes.toStringType(var.getType());
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("index=").append(i);
            buffer.append(" (").append(name);
            buffer.append(", ").append(type);
            if (DataTypes.isBinary(var.getType())) {
                value = var.getBlob();
                if (value == null) {
                    buffer.append(", null");
                } else {
                    buffer.append(", blob[").append(((byte[])value).length).append(']');
                }
            } else {
                value = var.getString();
                if (value == null) {
                    buffer.append(", null");
                } else {
                    buffer.append(", \"").append((String)value).append('\"');
                }
            }
            buffer.append(')').append(NEW_LINE);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String info(DataSet ds) {
        if (ds == null) {
            return "null";
        }
        int columnCount = ds.getColumnCount();
        int rowCount = ds.getRowCount();
        StringBuffer buffer = new StringBuffer(128);
        String name = ds.getName();
        String alias = ds.getAlias();
        String charset = ds.getCharset();
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        buffer.append("name=").append(name);
        buffer.append(", alias=").append(alias);
        buffer.append(", columnCount=").append(columnCount);
        buffer.append(", rowCount=").append(rowCount);
        buffer.append(", charset=").append(charset);
        buffer.append(", isStoreDataChanges=").append(isStoreDataChanges);
        return buffer.toString();
    }

    public String detail(DataSet ds) {
        int rowCount;
        if (ds == null) {
            return "null";
        }
        int columnCount = ds.getColumnCount();
        int bufferSize = 128 + columnCount * 32 + (rowCount = ds.getRowCount()) * columnCount * 16;
        if (bufferSize > 1024) {
            bufferSize = 1024;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(this.info(ds));
        this.detailColumnHeaders(ds, buffer);
        this.detailDataRows(ds, buffer);
        this.detailRemovedDataRows(ds, buffer);
        return buffer.toString();
    }

    public String info(DataSetList dl) {
        if (dl == null) {
            return "null";
        }
        int count = dl.size();
        if (count == 0) {
            return "dataset=[]";
        }
        int bufferSize = count * 128;
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append("dataset=[").append(NEW_LINE);
        for (int i = 0; i < count; ++i) {
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("index=").append(i);
            buffer.append(" (");
            buffer.append(this.info(dl.get(i)));
            buffer.append(')').append(NEW_LINE);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String detail(DataSetList dl) {
        if (dl == null) {
            return "null";
        }
        int count = dl.size();
        int bufferSize = count * 256;
        if (bufferSize > 4096) {
            bufferSize = 4096;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(NEW_LINE);
            }
            buffer.append("---------- ").append("index=").append(this.leftPad(i, 3)).append(" ----------");
            buffer.append(NEW_LINE);
            buffer.append(this.detail(dl.get(i)));
        }
        return buffer.toString();
    }

    public String info(PlatformData data) {
        int dsCount;
        if (data == null) {
            return "null";
        }
        VariableList vl = data.getVariableList();
        DataSetList dl = data.getDataSetList();
        int varCount = vl.size();
        int bufferSize = 32 + varCount * 16 + (dsCount = dl.size()) * 128;
        if (bufferSize > 4096) {
            bufferSize = 4096;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(this.info(vl));
        buffer.append(NEW_LINE);
        buffer.append(this.info(dl));
        return buffer.toString();
    }

    public String detail(PlatformData data) {
        int dsCount;
        if (data == null) {
            return "null";
        }
        VariableList vl = data.getVariableList();
        DataSetList dl = data.getDataSetList();
        int varCount = vl.size();
        int bufferSize = 32 + varCount * 16 + (dsCount = dl.size()) * 256;
        if (bufferSize > 4096) {
            bufferSize = 4096;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(this.detail(vl));
        buffer.append(NEW_LINE);
        buffer.append(this.detail(dl));
        return buffer.toString();
    }

    private void detailColumnHeaders(DataSet ds, StringBuffer buffer) {
        buffer.append(NEW_LINE);
        int count = ds.getColumnCount();
        if (count == 0) {
            buffer.append(", column=[]");
            return;
        }
        buffer.append(", column=[").append(NEW_LINE);
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            String columnName = header.getName();
            String dataType = DataTypes.toStringType(header.getDataType());
            int dataSize = header.getDataSize();
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("index=").append(i);
            buffer.append(" (").append(columnName);
            buffer.append(", ").append(dataType);
            buffer.append(", ").append(dataSize);
            if (header.isConstant()) {
                Object value = ((ConstantColumnHeader)header).getValue();
                if (value == null) {
                    buffer.append(", null");
                } else {
                    buffer.append(", \"").append(value).append('\"');
                }
            }
            buffer.append(')').append(NEW_LINE);
        }
        buffer.append(']');
    }

    private void detailDataRows(DataSet ds, StringBuffer buffer) {
        buffer.append(NEW_LINE);
        int columnCount = ds.getColumnCount();
        int rowCount = ds.getRowCount();
        if (rowCount == 0) {
            buffer.append(", row=[]");
            return;
        }
        buffer.append(", row=[").append(NEW_LINE);
        for (int i = 0; i < rowCount; ++i) {
            int len;
            Object value;
            int j;
            int rowType = ds.getRowType(i);
            String rowTypeStr = ROW_TYPE_NAMES[rowType];
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("index=").append(i);
            buffer.append(' ').append(rowTypeStr).append(" (");
            for (j = 0; j < columnCount; ++j) {
                if (j > 0) {
                    buffer.append(", ");
                }
                if (DataTypes.isBinary(ds.getColumn(j).getDataType())) {
                    value = ds.getBlob(i, j);
                    if (value == null) {
                        buffer.append("null");
                        continue;
                    }
                    buffer.append("blob[").append(((Object)value).length).append(']');
                    continue;
                }
                value = ds.getString(i, j);
                if (value == null) {
                    buffer.append("null");
                    continue;
                }
                len = value.length();
                if (len > 1024) {
                    buffer.append("string[").append(len).append("]");
                    continue;
                }
                buffer.append('\"').append((String)value).append('\"');
            }
            buffer.append(')').append(NEW_LINE);
            if (rowType != 2 || !ds.hasSavedRow(i)) continue;
            buffer.append("\t\t");
            buffer.append(", index=").append(i);
            buffer.append(" saved (");
            for (j = 0; j < columnCount; ++j) {
                if (j > 0) {
                    buffer.append(", ");
                }
                if (DataTypes.isBinary(ds.getColumn(j).getDataType())) {
                    value = (byte[])ds.getSavedData(i, j);
                    if (value == null) {
                        buffer.append("null");
                        continue;
                    }
                    buffer.append("blob[").append(((Object)value).length).append(']');
                    continue;
                }
                value = ds.getSavedStringData(i, j);
                if (value == null) {
                    buffer.append("null");
                    continue;
                }
                len = value.length();
                if (len > 1024) {
                    buffer.append("string[").append(len).append("]");
                    continue;
                }
                buffer.append('\"').append((String)value).append('\"');
            }
            buffer.append(')').append(NEW_LINE);
        }
        buffer.append(']');
    }

    private void detailRemovedDataRows(DataSet ds, StringBuffer buffer) {
        int columnCount = ds.getColumnCount();
        int rowCount = ds.getRemovedRowCount();
        if (rowCount == 0) {
            return;
        }
        buffer.append(NEW_LINE);
        buffer.append(", removed row=[").append(NEW_LINE);
        for (int i = 0; i < rowCount; ++i) {
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("index=").append(i);
            buffer.append(" removed (");
            for (int j = 0; j < columnCount; ++j) {
                Object value;
                if (j > 0) {
                    buffer.append(", ");
                }
                if (DataTypes.isBinary(ds.getColumn(j).getDataType())) {
                    value = (byte[])ds.getRemovedData(i, j);
                    if (value == null) {
                        buffer.append("null");
                        continue;
                    }
                    buffer.append("blob[").append(((Object)value).length).append(']');
                    continue;
                }
                value = ds.getRemovedStringData(i, j);
                if (value == null) {
                    buffer.append("null");
                    continue;
                }
                int len = ((String)value).length();
                if (len > 1024) {
                    buffer.append("string[").append(len).append("]");
                    continue;
                }
                buffer.append('\"').append((String)value).append('\"');
            }
            buffer.append(')').append(NEW_LINE);
        }
        buffer.append(']');
    }

    private String leftPad(int n, int len) {
        String source = String.valueOf(n);
        char ch = '0';
        StringBuffer value = new StringBuffer();
        int count = len - source.length();
        for (int i = 0; i < count; ++i) {
            value.append(ch);
        }
        value.append(source);
        return value.toString();
    }
}

