/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data;

import com.nexacro.java.xapi.data.Base64;
import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformCodec;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformSsvDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvDataSerializer.class);
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private byte[] buffer;
    private char rs = (char)30;
    private char us = (char)31;
    private char etx = (char)3;

    public void writeData(Writer out, PlatformData data) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(out, data);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    public void writeData(Writer out, DataSet ds) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(out, ds);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    void write(Writer out, PlatformData data) throws IOException {
        this.writeHeader(out, data);
        this.writeVariableList(out, data);
        this.writeDataSetList(out, data);
        out.flush();
    }

    void write(Writer out, DataSet ds) throws IOException {
        this.writeDataSet(out, null, ds);
        out.flush();
    }

    void writeHeader(Writer out, PlatformData data) throws IOException {
        this.writeString(out, "SSV");
    }

    void writeVariableList(Writer out, PlatformData data) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeVariable(out, varList.get(i));
            }
        }
    }

    void writeVariable(Writer out, Variable var) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(out, var);
        } else {
            this.writeStringVariable(out, var);
        }
    }

    void writeStringVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        if (value == null) {
            if (var.getType() == 2) {
                buffer.append(name).append(':').append(type).append('=').append(this.etx);
            } else {
                buffer.append(name).append(':').append(type).append('=');
            }
        } else {
            buffer.append(name).append(':').append(type).append('=').append(value);
        }
        this.writeString(out, buffer.toString());
    }

    void writeBinaryVariable(Writer out, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(32);
            buffer.append(name).append(':').append(type).append('=');
            this.writeString(out, buffer.toString());
        } else {
            String encoded = Base64.encodeBytes(value, 8);
            int length = encoded == null ? 0 : encoded.length();
            StringBuffer buffer = new StringBuffer(length + 32);
            buffer.append(name).append(':').append(type).append('=');
            if (encoded != null) {
                buffer.append(encoded);
            }
            this.writeString(out, buffer.toString());
        }
    }

    String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    void writeDataSetList(Writer out, PlatformData data) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writeString(out, "");
            }
            this.writeDataSet(out, data, dsList.get(i));
        }
    }

    void writeDataSet(Writer out, PlatformData data, DataSet ds) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        this.writeString(out, "Dataset:" + alias);
        this.writeColumns(out, ds);
        this.writeRows(out, data, ds);
    }

    void writeColumns(Writer out, DataSet ds) throws IOException {
        int count = ds.getColumnCount();
        StringBuffer defaultBuffer = new StringBuffer();
        StringBuffer constantBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(defaultBuffer, header);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(constantBuffer, ds, header);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (constantBuffer.length() > 0) {
            this.writeString(out, "_Const_" + constantBuffer.toString());
        }
        if (defaultBuffer.length() > 0) {
            this.writeString(out, "_RowType_" + defaultBuffer.toString());
        }
    }

    void writeDefaultColumnHeader(StringBuffer buffer, ColumnHeader header) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
    }

    void writeConstantColumnHeader(StringBuffer buffer, DataSet ds, ColumnHeader header) throws IOException {
        if (DataTypes.isBinary(header.getDataType())) {
            this.writeBinaryColumnHeader(buffer, ds, (ConstantColumnHeader)header);
        } else {
            this.writeStringColumnHeader(buffer, ds, (ConstantColumnHeader)header);
        }
    }

    void writeStringColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            buffer.append(value);
        }
    }

    void writeBinaryColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header) throws IOException {
        String name = header.getName();
        int dataType = header.getDataType();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        buffer.append(this.us);
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
        buffer.append('=');
        if (value != null) {
            String encoded = Base64.encodeBytes(value, 8);
            buffer.append(encoded);
        }
    }

    String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    void writeRows(Writer out, PlatformData data, DataSet ds) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            int n = saveType = data == null ? 2 : data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, i, saveType);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(out, ds, i);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    void writeRow(Writer out, DataSet ds, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (saveType == 2) {
            buffer.append('N');
        } else if (rowType == 1) {
            buffer.append('I');
        } else if (rowType == 2) {
            buffer.append('U');
        } else if (rowType == 3) {
            buffer.append('D');
        } else {
            buffer.append('N');
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, row);
        }
    }

    void writeSavedRow(Writer out, DataSet ds, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('O');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
    }

    void writeRemovedRow(Writer out, DataSet ds, int row) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('D');
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = header.getDataType();
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) {
                    buffer.append(this.us);
                    continue;
                }
                buffer.append(this.us);
                String encoded = Base64.encodeBytes(value, 8);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) {
                if (dataType == 2) {
                    buffer.append(this.us).append(this.etx);
                    continue;
                }
                buffer.append(this.us);
                continue;
            }
            buffer.append(this.us);
            buffer.append((String)value);
        }
        this.writeString(out, buffer.toString());
    }

    String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + filename + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    void writeString(Writer out, String str) throws IOException {
        out.write(str);
        out.write(this.rs);
    }

    String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.platformCodec.encode(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

